/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.StringTokenizer;

public class UpdateDigitMapsBin {
    public static void main(String[] args) {
        try {
            File folder = new File(System.getProperty("user.dir"));
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File folder, String name) {
                    return name.startsWith("num-master") && name.endsWith(".txt");
                }
            };
            Object[] names = folder.list(filter);
            if (names.length == 0) {
                return;
            }
            Arrays.sort(names);
            Object name = names[names.length - 1];
            System.out.println("name=" + (String)name);
            File file = new File(folder, (String)name);
            BufferedReader rdr = new BufferedReader(new FileReader(file));
            File outFile = new File(folder, "src");
            outFile = new File(outFile, "main");
            outFile = new File(outFile, "config");
            outFile = new File(outFile, "digitmaps.bin");
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
            String line = null;
            while ((line = rdr.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                while (st.hasMoreTokens()) {
                    int hex = Integer.parseInt(st.nextToken(), 16) & 0xFF;
                    out.write(hex);
                }
            }
            out.close();
            rdr.close();
            File targetFile = new File(folder, "target");
            targetFile = new File(targetFile, "digitmaps.bin");
            Files.copy(outFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            for (Object aName : names) {
                File aFile = new File(folder, (String)aName);
                aFile.delete();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
    }
}

