/*
 * Decompiled with CFR 0.152.
 */
package com.fazecast.jSerialComm;

import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.fazecast.jSerialComm.SerialPortIOException;
import com.fazecast.jSerialComm.SerialPortMessageListener;
import com.fazecast.jSerialComm.SerialPortPacketListener;
import com.fazecast.jSerialComm.SerialPortTimeoutException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;

public final class SerialPort {
    private static volatile boolean isAndroid;
    private static volatile boolean isUnixBased;
    private static volatile boolean isWindows;
    public static final int NO_PARITY = 0;
    public static final int ODD_PARITY = 1;
    public static final int EVEN_PARITY = 2;
    public static final int MARK_PARITY = 3;
    public static final int SPACE_PARITY = 4;
    public static final int ONE_STOP_BIT = 1;
    public static final int ONE_POINT_FIVE_STOP_BITS = 2;
    public static final int TWO_STOP_BITS = 3;
    public static final int FLOW_CONTROL_DISABLED = 0;
    public static final int FLOW_CONTROL_RTS_ENABLED = 1;
    public static final int FLOW_CONTROL_CTS_ENABLED = 16;
    public static final int FLOW_CONTROL_DSR_ENABLED = 256;
    public static final int FLOW_CONTROL_DTR_ENABLED = 4096;
    public static final int FLOW_CONTROL_XONXOFF_IN_ENABLED = 65536;
    public static final int FLOW_CONTROL_XONXOFF_OUT_ENABLED = 0x100000;
    public static final int TIMEOUT_NONBLOCKING = 0;
    public static final int TIMEOUT_READ_SEMI_BLOCKING = 1;
    public static final int TIMEOUT_READ_BLOCKING = 16;
    public static final int TIMEOUT_WRITE_BLOCKING = 256;
    public static final int TIMEOUT_SCANNER = 4096;
    public static final int LISTENING_EVENT_DATA_AVAILABLE = 1;
    public static final int LISTENING_EVENT_DATA_RECEIVED = 16;
    public static final int LISTENING_EVENT_DATA_WRITTEN = 256;
    private volatile long portHandle = -1L;
    private volatile int baudRate = 9600;
    private volatile int dataBits = 8;
    private volatile int stopBits = 1;
    private volatile int parity = 0;
    private volatile int eventFlags = 0;
    private volatile int timeoutMode = 0;
    private volatile int readTimeout = 0;
    private volatile int writeTimeout = 0;
    private volatile int flowControl = 0;
    private volatile int sendDeviceQueueSize = 4096;
    private volatile int receiveDeviceQueueSize = 4096;
    private volatile SerialPortInputStream inputStream = null;
    private volatile SerialPortOutputStream outputStream = null;
    private volatile SerialPortDataListener userDataListener = null;
    private volatile SerialPortEventListener serialEventListener = null;
    private volatile String comPort;
    private volatile String friendlyName;
    private volatile String portDescription;
    private volatile boolean isOpened = false;
    private volatile boolean disableConfig = false;
    private volatile boolean isRtsEnabled = true;
    private volatile boolean isDtrEnabled = true;

    private static boolean isSymbolicLink(File file) throws IOException {
        File canonicalFile = file.getParent() == null ? file : new File(file.getParentFile().getCanonicalFile(), file.getName());
        return !canonicalFile.getCanonicalFile().equals(canonicalFile.getAbsoluteFile());
    }

    public String toString() {
        return this.getPortDescription();
    }

    public static native SerialPort[] getCommPorts();

    public static SerialPort getCommPort(String portDescriptor) {
        try {
            if (portDescriptor.startsWith("~" + File.separator)) {
                portDescriptor = System.getProperty("user.home") + portDescriptor.substring(1);
            }
            if (isWindows) {
                portDescriptor = "\\\\.\\" + portDescriptor.substring(portDescriptor.lastIndexOf(92) + 1);
            } else if (SerialPort.isSymbolicLink(new File(portDescriptor))) {
                portDescriptor = new File(portDescriptor).getCanonicalPath();
            } else if (portDescriptor.contains("/pts/")) {
                portDescriptor = "/dev/pts/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
            } else if (!new File(portDescriptor).exists()) {
                portDescriptor = "/dev/" + portDescriptor.substring(portDescriptor.lastIndexOf(47) + 1);
            }
        }
        catch (Exception e) {
            SerialPort serialPort = new SerialPort();
            serialPort.comPort = "/dev/null";
            serialPort.friendlyName = "Bad Port";
            serialPort.portDescription = "Bad Port";
            return serialPort;
        }
        SerialPort serialPort = new SerialPort();
        serialPort.comPort = portDescriptor;
        serialPort.friendlyName = "User-Specified Port";
        serialPort.portDescription = "User-Specified Port";
        return serialPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean openPort(int safetySleepTime, int deviceSendQueueSize, int deviceReceiveQueueSize) {
        File portFile;
        this.sendDeviceQueueSize = deviceSendQueueSize;
        this.receiveDeviceQueueSize = deviceReceiveQueueSize;
        if (this.isOpened) {
            return this.configPort(this.portHandle);
        }
        if (safetySleepTime > 0) {
            try {
                Thread.sleep(safetySleepTime);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        File file = portFile = isAndroid ? new File(this.comPort) : null;
        if (!(portFile == null || portFile.canRead() && portFile.canWrite())) {
            Process process = null;
            try {
                process = Runtime.getRuntime().exec("su");
                DataOutputStream writer = new DataOutputStream(process.getOutputStream());
                writer.writeBytes("chmod 666 " + this.comPort + "\n");
                writer.writeBytes("exit\n");
                writer.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while (reader.readLine() != null) {
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (process == null) {
                    return false;
                }
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    return false;
                }
                try {
                    process.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getOutputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    process.getErrorStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return false;
                }
            }
        }
        if ((this.portHandle = this.openPortNative()) > 0L) {
            this.inputStream = new SerialPortInputStream();
            this.outputStream = new SerialPortOutputStream();
            if (this.serialEventListener != null) {
                this.serialEventListener.startListening();
            }
        }
        return this.isOpened;
    }

    public final boolean openPort(int safetySleepTime) {
        return this.openPort(safetySleepTime, this.sendDeviceQueueSize, this.receiveDeviceQueueSize);
    }

    public final boolean openPort() {
        return this.openPort(1000);
    }

    public final boolean closePort() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
        }
        if (this.isOpened && this.closePortNative(this.portHandle)) {
            this.inputStream = null;
            this.outputStream = null;
            this.portHandle = -1L;
        }
        return !this.isOpened;
    }

    public final boolean isOpen() {
        return this.isOpened;
    }

    public final void disablePortConfiguration() {
        this.disableConfig = true;
    }

    private static native void initializeLibrary();

    private static native void uninitializeLibrary();

    private final native long openPortNative();

    private final native boolean closePortNative(long var1);

    private final native boolean configPort(long var1);

    private final native boolean configTimeouts(long var1);

    private final native boolean configEventFlags(long var1);

    private final native int waitForEvent(long var1);

    private final native int bytesAvailable(long var1);

    private final native int bytesAwaitingWrite(long var1);

    private final native int readBytes(long var1, byte[] var3, long var4, long var6);

    private final native int writeBytes(long var1, byte[] var3, long var4, long var6);

    private final native boolean setBreak(long var1);

    private final native boolean clearBreak(long var1);

    private final native boolean setRTS(long var1);

    private final native boolean clearRTS(long var1);

    private final native boolean presetRTS();

    private final native boolean preclearRTS();

    private final native boolean setDTR(long var1);

    private final native boolean clearDTR(long var1);

    private final native boolean presetDTR();

    private final native boolean preclearDTR();

    private final native boolean getCTS(long var1);

    private final native boolean getDSR(long var1);

    private final native boolean getDCD(long var1);

    public final int bytesAvailable() {
        return this.bytesAvailable(this.portHandle);
    }

    public final int bytesAwaitingWrite() {
        return this.bytesAwaitingWrite(this.portHandle);
    }

    public final int readBytes(byte[] buffer, long bytesToRead) {
        return this.readBytes(this.portHandle, buffer, bytesToRead, 0L);
    }

    public final int readBytes(byte[] buffer, long bytesToRead, long offset) {
        return this.readBytes(this.portHandle, buffer, bytesToRead, offset);
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite) {
        return this.writeBytes(this.portHandle, buffer, bytesToWrite, 0L);
    }

    public final int writeBytes(byte[] buffer, long bytesToWrite, long offset) {
        return this.writeBytes(this.portHandle, buffer, bytesToWrite, offset);
    }

    public final boolean setBreak() {
        return this.setBreak(this.portHandle);
    }

    public final boolean clearBreak() {
        return this.clearBreak(this.portHandle);
    }

    public final boolean setRTS() {
        this.isRtsEnabled = true;
        return this.isOpened ? this.setRTS(this.portHandle) : this.presetRTS();
    }

    public final boolean clearRTS() {
        this.isRtsEnabled = false;
        return this.isOpened ? this.clearRTS(this.portHandle) : this.preclearRTS();
    }

    public final boolean setDTR() {
        this.isDtrEnabled = true;
        return this.isOpened ? this.setDTR(this.portHandle) : this.presetDTR();
    }

    public final boolean clearDTR() {
        this.isDtrEnabled = false;
        return this.isOpened ? this.clearDTR(this.portHandle) : this.preclearDTR();
    }

    public final boolean getCTS() {
        return this.getCTS(this.portHandle);
    }

    public final boolean getDSR() {
        return this.getDSR(this.portHandle);
    }

    public final boolean getDCD() {
        return this.getDCD(this.portHandle);
    }

    private SerialPort() {
    }

    public final boolean addDataListener(SerialPortDataListener listener) {
        if (this.userDataListener != null) {
            return false;
        }
        this.userDataListener = listener;
        this.serialEventListener = this.userDataListener instanceof SerialPortPacketListener ? new SerialPortEventListener(((SerialPortPacketListener)this.userDataListener).getPacketSize()) : (this.userDataListener instanceof SerialPortMessageListener ? new SerialPortEventListener(((SerialPortMessageListener)this.userDataListener).getMessageDelimiter(), ((SerialPortMessageListener)this.userDataListener).delimiterIndicatesEndOfMessage()) : new SerialPortEventListener());
        this.eventFlags = 0;
        if ((listener.getListeningEvents() & 1) > 0) {
            this.eventFlags |= 1;
        }
        if ((listener.getListeningEvents() & 0x10) > 0) {
            this.eventFlags |= 0x10;
        }
        if ((listener.getListeningEvents() & 0x100) > 0) {
            this.eventFlags |= 0x100;
        }
        if (this.isOpened) {
            this.configEventFlags(this.portHandle);
            this.serialEventListener.startListening();
        }
        return true;
    }

    public final void removeDataListener() {
        if (this.serialEventListener != null) {
            this.serialEventListener.stopListening();
            this.serialEventListener = null;
        }
        this.userDataListener = null;
        this.eventFlags = 0;
        if (this.isOpened) {
            this.configEventFlags(this.portHandle);
        }
    }

    public final InputStream getInputStream() {
        return this.inputStream;
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final void setComPortParameters(int newBaudRate, int newDataBits, int newStopBits, int newParity) {
        this.baudRate = newBaudRate;
        this.dataBits = newDataBits;
        this.stopBits = newStopBits;
        this.parity = newParity;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setComPortTimeouts(int newTimeoutMode, int newReadTimeout, int newWriteTimeout) {
        this.timeoutMode = newTimeoutMode;
        if (isWindows) {
            this.readTimeout = newReadTimeout;
            this.writeTimeout = newWriteTimeout;
        } else {
            this.readTimeout = newReadTimeout > 0 && newReadTimeout <= 100 ? 100 : Math.round((float)newReadTimeout / 100.0f) * 100;
        }
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.configTimeouts(this.portHandle);
        }
    }

    public final void setBaudRate(int newBaudRate) {
        this.baudRate = newBaudRate;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setNumDataBits(int newDataBits) {
        this.dataBits = newDataBits;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setNumStopBits(int newStopBits) {
        this.stopBits = newStopBits;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setFlowControl(int newFlowControlSettings) {
        this.flowControl = newFlowControlSettings;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final void setParity(int newParity) {
        this.parity = newParity;
        if (this.isOpened) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.configPort(this.portHandle);
        }
    }

    public final String getDescriptivePortName() {
        return this.friendlyName.trim();
    }

    public final String getSystemPortName() {
        return isWindows ? this.comPort.substring(this.comPort.lastIndexOf(92) + 1) : this.comPort.substring(this.comPort.lastIndexOf(47) + 1);
    }

    public final String getPortDescription() {
        return this.portDescription.trim();
    }

    public final int getBaudRate() {
        return this.baudRate;
    }

    public final int getNumDataBits() {
        return this.dataBits;
    }

    public final int getNumStopBits() {
        return this.stopBits;
    }

    public final int getParity() {
        return this.parity;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final int getWriteTimeout() {
        return this.writeTimeout;
    }

    public final int getFlowControlSettings() {
        return this.flowControl;
    }

    static {
        block44: {
            File directory;
            isAndroid = false;
            isUnixBased = false;
            isWindows = false;
            String OS2 = System.getProperty("os.name").toLowerCase();
            String libraryPath = "";
            String fileName = "";
            String tempFileDirectory = System.getProperty("java.io.tmpdir");
            if (tempFileDirectory.charAt(tempFileDirectory.length() - 1) != '\\' && tempFileDirectory.charAt(tempFileDirectory.length() - 1) != '/') {
                tempFileDirectory = tempFileDirectory + "/";
            }
            if ((directory = new File(tempFileDirectory)).exists()) {
                File[] directoryListing;
                for (File listing : directoryListing = directory.listFiles()) {
                    if (!listing.isFile() || !listing.toString().contains("jSerialComm")) continue;
                    listing.delete();
                }
            }
            if (System.getProperty("java.vm.vendor").toLowerCase().contains("android")) {
                try {
                    String line;
                    Process getpropProcess = Runtime.getRuntime().exec("getprop");
                    BufferedReader buildProperties = new BufferedReader(new InputStreamReader(getpropProcess.getInputStream()));
                    while ((line = buildProperties.readLine()) != null) {
                        if (!line.contains("[ro.product.cpu.abi]:") && !line.contains("[ro.product.cpu.abi2]:") && !line.contains("[ro.product.cpu.abilist]:") && !line.contains("[ro.product.cpu.abilist64]:") && !line.contains("[ro.product.cpu.abilist32]:")) continue;
                        libraryPath = "Android/" + line.split(":")[1].trim().replace("[", "").replace("]", "").split(",")[0];
                        break;
                    }
                    getpropProcess.waitFor();
                    buildProperties.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (libraryPath.isEmpty()) {
                    libraryPath = "Android/armeabi";
                }
                isAndroid = true;
                fileName = "libjSerialComm.so";
            } else if (OS2.indexOf("win") >= 0) {
                libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "Windows/x86_64" : "Windows/x86";
                isWindows = true;
                fileName = "jSerialComm.dll";
            } else if (OS2.indexOf("mac") >= 0) {
                libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? "OSX/x86_64" : "OSX/x86";
                isUnixBased = true;
                fileName = "libjSerialComm.jnilib";
            } else if (OS2.indexOf("sunos") >= 0 || OS2.indexOf("solaris") >= 0) {
                libraryPath = System.getProperty("os.arch").indexOf("64") >= 0 ? (System.getProperty("os.arch").indexOf("sparc") >= 0 ? "Solaris/sparcv9_64" : "Solaris/x86_64") : (System.getProperty("os.arch").indexOf("sparc") >= 0 ? "Solaris/sparcv8plus_32" : "Solaris/x86");
                isUnixBased = true;
                fileName = "libjSerialComm.so";
            } else if (OS2.indexOf("nix") >= 0 || OS2.indexOf("nux") >= 0 || OS2.indexOf("bsd") >= 0) {
                if (!System.getProperty("os.arch_full", "").isEmpty()) {
                    libraryPath = "Linux/" + System.getProperty("os.arch_full").toLowerCase();
                } else if (System.getProperty("os.arch").indexOf("arm") >= 0) {
                    String line;
                    try {
                        BufferedReader cpuPropertiesFile = new BufferedReader(new FileReader("/proc/cpuinfo"));
                        while ((line = cpuPropertiesFile.readLine()) != null) {
                            if (line.contains("ARMv")) {
                                libraryPath = "Linux/armv" + line.substring(line.indexOf("ARMv") + 4, line.indexOf("ARMv") + 5);
                                break;
                            }
                            if (!line.contains("aarch")) continue;
                            libraryPath = "Linux/armv8";
                            break;
                        }
                        cpuPropertiesFile.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (libraryPath.isEmpty()) {
                        libraryPath = "Linux/armv6";
                    } else if (libraryPath.contains("Linux/armv8")) {
                        libraryPath = libraryPath + (System.getProperty("os.arch").indexOf("64") >= 0 ? "_64" : "_32");
                    } else {
                        try {
                            File linkerFile = new File("/lib/ld-linux-armhf.so.3");
                            if (linkerFile.exists()) {
                                libraryPath = libraryPath + "-hf";
                            } else {
                                ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", "ls /lib/ld-linux*");
                                Process p = pb.start();
                                p.waitFor();
                                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                line = br.readLine();
                                if (line != null && line.contains("armhf")) {
                                    libraryPath = libraryPath + "-hf";
                                } else {
                                    pb = new ProcessBuilder("/bin/sh", "-c", "ldd /usr/bin/ld | grep ld-");
                                    p = pb.start();
                                    p.waitFor();
                                    br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                                    line = br.readLine();
                                    if (line != null && line.contains("armhf")) {
                                        libraryPath = libraryPath + "-hf";
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    libraryPath = System.getProperty("os.arch").indexOf("aarch32") >= 0 ? "Linux/armv8_32" : (System.getProperty("os.arch").indexOf("aarch64") >= 0 ? "Linux/armv8_64" : (System.getProperty("os.arch").indexOf("64") >= 0 ? "Linux/x86_64" : "Linux/x86"));
                }
                isUnixBased = true;
                fileName = "libjSerialComm.so";
            } else {
                System.err.println("This operating system is not supported by the jSerialComm library.");
                System.exit(-1);
            }
            String tempFileName = tempFileDirectory + new Date().getTime() + "-" + fileName;
            File tempNativeLibrary = new File(tempFileName);
            tempNativeLibrary.deleteOnExit();
            try {
                InputStream fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + fileName);
                if (fileContents == null && isAndroid) {
                    libraryPath = libraryPath.replace("Android/", "lib/");
                    fileContents = SerialPort.class.getResourceAsStream("/" + libraryPath + "/" + fileName);
                }
                if (fileContents == null) {
                    System.err.println("Could not locate or access the native jSerialComm shared library.");
                    System.err.println("If you are using multiple projects with interdependencies, you may need to fix your build settings to ensure that library resources are copied properly.");
                    break block44;
                }
                try {
                    int numBytesRead;
                    FileOutputStream destinationFileContents = new FileOutputStream(tempNativeLibrary);
                    byte[] transferBuffer = new byte[4096];
                    while ((numBytesRead = fileContents.read(transferBuffer)) > 0) {
                        destinationFileContents.write(transferBuffer, 0, numBytesRead);
                    }
                    destinationFileContents.close();
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
                fileContents.close();
                System.load(tempNativeLibrary.getAbsolutePath());
                SerialPort.initializeLibrary();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private final class SerialPortOutputStream
    extends OutputStream {
        private byte[] byteBuffer = new byte[1];

        @Override
        public final void write(int b) throws SerialPortIOException, SerialPortTimeoutException {
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            this.byteBuffer[0] = (byte)(b & 0xFF);
            int bytesWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, this.byteBuffer, 1L, 0L);
            if (bytesWritten < 0) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (bytesWritten == 0) {
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }

        @Override
        public final void write(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            this.write(b, 0, b.length);
        }

        @Override
        public final void write(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the write buffer.");
            }
            if (len < 0 || off < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException("The specified write offset plus length extends past the end of the specified buffer.");
            }
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (len == 0) {
                return;
            }
            int numWritten = SerialPort.this.writeBytes(SerialPort.this.portHandle, b, len, off);
            if (numWritten < 0) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (numWritten == 0) {
                throw new SerialPortTimeoutException("The write operation timed out before all data was written.");
            }
        }
    }

    private final class SerialPortInputStream
    extends InputStream {
        private byte[] byteBuffer = new byte[1];

        @Override
        public final int available() throws SerialPortIOException {
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            return SerialPort.this.bytesAvailable(SerialPort.this.portHandle);
        }

        @Override
        public final int read() throws SerialPortIOException, SerialPortTimeoutException {
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, this.byteBuffer, 1L, 0L);
            if (numRead == 0) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead < 0 ? -1 : this.byteBuffer[0] & 0xFF;
        }

        @Override
        public final int read(byte[] b) throws NullPointerException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, b, b.length, 0L);
            if (numRead == 0) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final int read(byte[] b, int off, int len) throws NullPointerException, IndexOutOfBoundsException, SerialPortIOException, SerialPortTimeoutException {
            if (b == null) {
                throw new NullPointerException("A null pointer was passed in for the read buffer.");
            }
            if (len < 0 || off < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException("The specified read offset plus length extends past the end of the specified buffer.");
            }
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            if (b.length == 0 || len == 0) {
                return 0;
            }
            int numRead = SerialPort.this.readBytes(SerialPort.this.portHandle, b, len, off);
            if (numRead == 0) {
                throw new SerialPortTimeoutException("The read operation timed out before any data was returned.");
            }
            return numRead;
        }

        @Override
        public final long skip(long n) throws SerialPortIOException {
            if (!SerialPort.this.isOpened) {
                throw new SerialPortIOException("This port appears to have been shutdown or disconnected.");
            }
            byte[] buffer = new byte[(int)n];
            return SerialPort.this.readBytes(SerialPort.this.portHandle, buffer, n, 0L);
        }
    }

    private final class SerialPortEventListener {
        private volatile boolean isListening = false;
        private final boolean messageEndIsDelimited;
        private final byte[] dataPacket;
        private final byte[] delimiters;
        private volatile ByteArrayOutputStream messageBytes = new ByteArrayOutputStream();
        private volatile int dataPacketIndex = 0;
        private volatile int delimiterIndex = 0;
        private Thread serialEventThread = null;

        public SerialPortEventListener() {
            this.dataPacket = new byte[0];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(int packetSizeToReceive) {
            this.dataPacket = new byte[packetSizeToReceive];
            this.delimiters = new byte[0];
            this.messageEndIsDelimited = true;
        }

        public SerialPortEventListener(byte[] messageDelimiters, boolean delimiterForMessageEnd) {
            this.dataPacket = new byte[0];
            this.delimiters = messageDelimiters;
            this.messageEndIsDelimited = delimiterForMessageEnd;
        }

        public final void startListening() {
            if (this.isListening) {
                return;
            }
            this.isListening = true;
            this.dataPacketIndex = 0;
            this.serialEventThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (SerialPortEventListener.this.isListening && SerialPort.this.isOpened) {
                        try {
                            SerialPortEventListener.this.waitForSerialEvent();
                        }
                        catch (NullPointerException e) {
                            SerialPortEventListener.this.isListening = false;
                        }
                    }
                    SerialPortEventListener.this.isListening = false;
                }
            });
            this.serialEventThread.start();
        }

        public final void stopListening() {
            if (!this.isListening) {
                return;
            }
            this.isListening = false;
            int oldEventFlags = SerialPort.this.eventFlags;
            SerialPort.this.eventFlags = 0;
            SerialPort.this.configEventFlags(SerialPort.this.portHandle);
            try {
                this.serialEventThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.serialEventThread = null;
            SerialPort.this.eventFlags = oldEventFlags;
        }

        public final void waitForSerialEvent() throws NullPointerException {
            switch (SerialPort.this.waitForEvent(SerialPort.this.portHandle)) {
                case 1: {
                    if ((SerialPort.this.eventFlags & 0x10) > 0) {
                        int numBytesAvailable;
                        while ((numBytesAvailable = SerialPort.this.bytesAvailable(SerialPort.this.portHandle)) > 0) {
                            byte[] newBytes = new byte[numBytesAvailable];
                            int newBytesIndex = 0;
                            int bytesRemaining = SerialPort.this.readBytes(SerialPort.this.portHandle, newBytes, newBytes.length, 0L);
                            if (this.delimiters.length > 0) {
                                int startIndex = 0;
                                for (int offset = 0; offset < bytesRemaining; ++offset) {
                                    if (newBytes[offset] == this.delimiters[this.delimiterIndex]) {
                                        byte[] byteArray;
                                        if (++this.delimiterIndex != this.delimiters.length) continue;
                                        this.messageBytes.write(newBytes, startIndex, 1 + offset - startIndex);
                                        byte[] byArray = byteArray = this.messageEndIsDelimited ? this.messageBytes.toByteArray() : Arrays.copyOf(this.messageBytes.toByteArray(), this.messageBytes.size() - this.delimiters.length);
                                        if (byteArray.length > 0 && (this.messageEndIsDelimited || this.delimiters[0] == byteArray[0])) {
                                            SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, byteArray));
                                        }
                                        startIndex = offset + 1;
                                        this.messageBytes.reset();
                                        this.delimiterIndex = 0;
                                        if (this.messageEndIsDelimited) continue;
                                        this.messageBytes.write(this.delimiters, 0, this.delimiters.length);
                                        continue;
                                    }
                                    if (this.delimiterIndex == 0) continue;
                                    this.delimiterIndex = newBytes[offset] == this.delimiters[0] ? 1 : 0;
                                }
                                this.messageBytes.write(newBytes, startIndex, bytesRemaining - startIndex);
                                continue;
                            }
                            if (this.dataPacket.length == 0) {
                                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])newBytes.clone()));
                                continue;
                            }
                            while (bytesRemaining >= this.dataPacket.length - this.dataPacketIndex) {
                                System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, this.dataPacket.length - this.dataPacketIndex);
                                bytesRemaining -= this.dataPacket.length - this.dataPacketIndex;
                                newBytesIndex += this.dataPacket.length - this.dataPacketIndex;
                                this.dataPacketIndex = 0;
                                SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 16, (byte[])this.dataPacket.clone()));
                            }
                            if (bytesRemaining <= 0) continue;
                            System.arraycopy(newBytes, newBytesIndex, this.dataPacket, this.dataPacketIndex, bytesRemaining);
                            this.dataPacketIndex += bytesRemaining;
                        }
                        break;
                    }
                    if ((SerialPort.this.eventFlags & 1) <= 0) break;
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 1));
                    break;
                }
                case 256: {
                    if ((SerialPort.this.eventFlags & 0x100) <= 0) break;
                    SerialPort.this.userDataListener.serialEvent(new SerialPortEvent(SerialPort.this, 256));
                    break;
                }
            }
        }
    }
}

