/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class LibraryLoader {
    protected static HashMap<String, String> libraries = new HashMap();
    protected static File libraryFolder = null;
    protected static int osIndex = -1;
    private static final String[] LIB_NAMES = new String[]{"hidA", "hidB"};
    private static final String[][] SOURCE_NAMES = new String[][]{{"/native/linux/libhidapi-jni-64.so", "/native/linux/libhidapi-jni-32.so", "", "/native/win/hidapi-jni-64.dll", "/native/win/hidapi-jni-32.dll", "/native/mac/libhidapi-jni-64.jnilib", "/native/mac/libhidapi-jni-32.jnilib"}, {"/linux-x86-64/libhidapi.so", "/linux-x86/libhidapi.so", "/linux-arm/libhidapi.so", "/win32-x86-64/hidapi.dll", "/win32-x86/hidapi.dll", "/darwin/libhidapi.dylib", ""}};

    public static String getLibraryFolderName() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            osName = "Windows";
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        return osName + '-' + arch;
    }

    public static void loadLibrary(File folder, String libraryName) throws UnsatisfiedLinkError {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            osName = "Windows";
        }
        if (libraryFolder == null) {
            String arch = System.getProperty("os.arch").toLowerCase();
            String folderName = osName + '-' + arch;
            libraryFolder = new File(folder, folderName);
            System.err.println("libraryFolder=" + libraryFolder.getAbsolutePath());
            if (osName.equals("Windows")) {
                osIndex = arch.equals("amd64") ? 3 : 4;
            } else if (osName.equals("Linux")) {
                osIndex = arch.equals("amd64") ? 0 : (arch.equals("i386") ? 1 : (arch.equals("arm") ? 2 : -1));
            } else if (osName.equals("Mac OS X")) {
                int n = osIndex = arch.equals("x86_64") ? 5 : 6;
            }
        }
        if (libraries.get(libraryName) == null) {
            int dot;
            String mappedName = System.mapLibraryName(libraryName);
            if (osName.equalsIgnoreCase("Mac OS X") && (dot = mappedName.indexOf(46)) >= 0) {
                String base = mappedName.substring(0, dot);
                String extn = mappedName.substring(dot);
                if (extn.equalsIgnoreCase(".dylib")) {
                    mappedName = base + ".jnilib";
                }
            }
            File libraryFile = new File(libraryFolder, mappedName);
            int libIndex = Arrays.asList(LIB_NAMES).indexOf(libraryName);
            if (libIndex >= 0 && !libraryFile.exists() && !SOURCE_NAMES[libIndex][osIndex].isEmpty()) {
                System.err.println("LibraryLoader: Attempting to copy hidapi library to library folder");
                boolean success = LibraryLoader.copyLibrary(libraryFile, SOURCE_NAMES[libIndex]);
                System.err.println("LibraryLoader: Attempt to copy hidapi library " + (success ? "succeeded" : "failed"));
                if (!success) {
                    String title = "Setup error";
                    String message = "RMIR was unable to set up the library required for USB HID communication.\nThis may mean that you have installed RMIR in a read-only folder.  If so,\nsome features of RMIR will not work correctly.  You are strongly advised\nto reinstall it in a folder that is not read-only.";
                    JOptionPane.showMessageDialog(null, message, title, 0);
                }
            }
            System.err.println("LibraryLoader: Attempting to load '" + libraryName + "' from '" + libraryFile.getAbsolutePath() + "'...");
            try {
                String arch;
                String inpoutName;
                File inpoutFile;
                if (osName.equals("Windows") && libraryName.equalsIgnoreCase("jp1parallel") && (inpoutFile = new File(folder, inpoutName = (arch = System.getProperty("os.arch").toLowerCase()).equals("amd64") ? "inpoutx64.dll" : "inpout32.dll")).exists()) {
                    System.load(inpoutFile.getAbsolutePath());
                }
                System.load(libraryFile.getAbsolutePath());
                System.err.println("LibraryLoader: Loaded '" + libraryName + "' successfully from '" + libraryFile.getAbsolutePath() + "'");
                libraries.put(libraryName, mappedName);
            }
            catch (UnsatisfiedLinkError ule) {
                System.err.println("LibraryLoader: Failed to load '" + libraryName + "' from '" + libraryFile.getAbsolutePath() + "'");
                LibraryLoader.loadLibrary(libraryName);
            }
        }
    }

    public static void loadLibrary(String libraryName) throws UnsatisfiedLinkError {
        if (libraries.get(libraryName) == null) {
            System.err.println("LibraryLoader: Attempting to load '" + libraryName + "' from java library path...");
            System.err.println("LibraryLoader: Java library path is '" + System.getProperty("java.library.path") + "'");
            System.loadLibrary(libraryName);
            System.err.println("LibraryLoader: Loaded '" + libraryName + "' successfully from somewhere in java library path.");
            libraries.put(libraryName, libraryName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyLibrary(File libFile, String[] libnames) {
        block9: {
            if (osIndex < 0) {
                return false;
            }
            String path = libnames[osIndex];
            if (path.isEmpty()) {
                return false;
            }
            try {
                InputStream in = LibraryLoader.class.getResourceAsStream(path);
                if (in == null) break block9;
                try {
                    int len;
                    FileOutputStream out = new FileOutputStream(libFile);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((OutputStream)out).close();
                }
                finally {
                    in.close();
                }
            }
            catch (Exception e) {
                return false;
            }
            catch (UnsatisfiedLinkError e) {
                return false;
            }
        }
        return true;
    }

    public static String getLibraryFolder() {
        return libraryFolder.getAbsolutePath();
    }
}

