/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ActivityGroup;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.Segment;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class Activity
extends Highlight {
    public static final String[] assistType = new String[]{"Picture", "Sound", "Power"};
    public static Comparator<Activity> activitySort = new Comparator<Activity>(){

        @Override
        public int compare(Activity a1, Activity a2) {
            Button b1 = a1.getSelector();
            Button b2 = a2.getSelector();
            if (b1 == null && b2 != null) {
                return -1;
            }
            if (b1 != null && b2 == null) {
                return 1;
            }
            if (b1 == null && b2 == null) {
                return 0;
            }
            return Short.valueOf(b1.getKeyCode()).compareTo(b2.getKeyCode());
        }
    };
    private RemoteConfiguration remoteConfig = null;
    private ActivityGroup[] activityGroups = null;
    private LinkedHashMap<Integer, ActivityGroup> groupMap = null;
    private Button button = null;
    private Button selector = null;
    private String selectorName = null;
    private Macro macro = null;
    private int audioHelp = 0;
    private int videoHelp = 0;
    private LinkedHashMap<Integer, List<Assister>> assists = null;
    private int helpSegmentFlags = 255;
    private Segment helpSegment = null;
    private boolean active = false;
    private boolean isNew = false;
    private int profileIndex = -1;

    public Activity(Button button, Remote remote) {
        int i;
        this.button = button;
        this.name = button != null ? button.getName() : null;
        this.setSegmentFlags(255);
        boolean onlyHardButtons = remote.isSSD() && !remote.getButtonGroups().get("Activity").contains(button);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (i = 0; i < remote.getActivityButtonGroups().length; ++i) {
            Button[] btns = remote.getActivityButtonGroups()[i];
            if (btns.length <= 0 || onlyHardButtons && remote.isSoftButton(btns[0])) continue;
            indices.add(i);
        }
        this.activityGroups = new ActivityGroup[indices.size()];
        this.groupMap = new LinkedHashMap();
        for (i = 0; i < this.activityGroups.length; ++i) {
            this.activityGroups[i] = new ActivityGroup((int)((Integer)indices.get(i)), remote);
            this.groupMap.put((Integer)indices.get(i), this.activityGroups[i]);
        }
        if (remote.usesEZRC()) {
            short keyCode = button.getKeyCode();
            this.macro = new Macro(keyCode, null, keyCode, 0, null);
            this.macro.setMacroClass(Macro.MacroClass.REALTIME);
            this.macro.setActivity(this);
            this.macro.setItems(new ArrayList<RemoteConfiguration.KeySpec>());
            this.macro.setAssists(new LinkedHashMap<Integer, List<Assister>>());
            for (int i2 = 0; i2 < 3; ++i2) {
                this.macro.getAssists().put(i2, new ArrayList());
            }
        }
        if (remote.isSSD()) {
            this.icon = new GeneralFunction.RMIcon(5);
        } else if (this.macro != null) {
            this.macro.setSegmentFlags(255);
        }
    }

    public Activity(Properties props, Remote remote) {
        super(props);
        this.active = true;
        String temp = props.getProperty("HelpSegmentFlags");
        if (temp != null) {
            this.helpSegmentFlags = Integer.parseInt(temp);
        }
        if ((temp = props.getProperty("HelpSettings")) != null) {
            ActivityGroup[] hex = new Hex(props.getProperty("HelpSettings"));
            this.audioHelp = hex.getData()[0];
            this.videoHelp = hex.getData()[1];
        }
        this.assists = Assister.load(props);
        this.selectorName = props.getProperty("Selector");
        temp = props.getProperty("ProfileIndex");
        if (temp != null) {
            this.profileIndex = Integer.parseInt(temp);
        }
        this.selectorName = props.getProperty("Selector");
        if (this.selectorName != null) {
            this.selector = remote.getButton(this.selectorName);
        }
        ActivityGroup.parse(props, this);
        this.groupMap = new LinkedHashMap();
        if (this.activityGroups != null) {
            for (ActivityGroup group : this.activityGroups) {
                this.groupMap.put(group.getIndex(), group);
            }
        }
        if (remote.usesEZRC()) {
            int keyCode = this.selector != null ? this.selector.getKeyCode() : remote.getFavKey().getKeyCode();
            this.macro = new Macro(keyCode, null, keyCode, 0, null);
            this.macro.setMacroClass(Macro.MacroClass.REALTIME);
            this.macro.setActivity(this);
            this.macro.setItems(new ArrayList<RemoteConfiguration.KeySpec>());
            this.macro.setAssists(Assister.load(props));
        }
        this.set(remote);
    }

    public void setRemoteConfig(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        this.set(remoteConfig.getRemote());
    }

    public void set(Remote remote) {
        if (this.selectorName != null) {
            this.selector = remote.getButton(this.selectorName);
        }
        Button button = remote.usesEZRC() && this.selector != null ? this.selector : (this.button = this.name != null ? remote.getButton(this.name) : null);
        if (this.activityGroups != null) {
            for (ActivityGroup group : this.activityGroups) {
                group.set(remote);
            }
        }
        if (remote.usesEZRC() && this.selector != null && this.profileIndex < 0 && this.remoteConfig != null) {
            int i;
            Macro m = this.macro;
            this.macro = this.remoteConfig.getActivityMacros().get(this.selector);
            if (this.macro == null) {
                this.macro = m;
                this.remoteConfig.getActivityMacros().put(this.selector, this.macro);
            }
            if (this.assists != null) {
                this.macro.setAssists(this.assists);
            }
            if (this.macro.getAssists() == null || this.macro.getAssists().isEmpty()) {
                this.macro.setAssists(new LinkedHashMap<Integer, List<Assister>>());
                for (i = 0; i < 3; ++i) {
                    this.macro.getAssists().put(i, new ArrayList());
                }
            }
            for (i = 0; i < 3; ++i) {
                List<Assister> a = this.macro.getAssists().get(i);
                for (Assister assist : a) {
                    assist.set(remote);
                }
            }
        }
        if (remote.isSSD()) {
            this.icon = new GeneralFunction.RMIcon(this.profileIndex < 0 ? 5 : 8);
        }
    }

    public ActivityGroup[] getActivityGroups() {
        return this.activityGroups;
    }

    public void setActivityGroups(ActivityGroup[] activityGroups) {
        this.activityGroups = activityGroups;
    }

    public Button getButton() {
        return this.button;
    }

    public void setButton(Button button) {
        this.button = button;
    }

    public Macro getMacro() {
        return this.macro;
    }

    public void setMacro(Macro macro) {
        this.macro = macro;
    }

    public int getAudioHelp() {
        return this.audioHelp;
    }

    public void setAudioHelp(int audioHelp) {
        this.audioHelp = audioHelp;
    }

    public int getVideoHelp() {
        return this.videoHelp;
    }

    public void setVideoHelp(int videoHelp) {
        this.videoHelp = videoHelp;
    }

    @Override
    public void setHighlight(Color color) {
        super.setHighlight(color);
        if (this.macro != null) {
            this.macro.setHighlight(color);
        }
    }

    public Segment getHelpSegment() {
        return this.helpSegment;
    }

    public void setHelpSegment(Segment helpSegment) {
        this.helpSegment = helpSegment;
    }

    public int getHelpSegmentFlags() {
        return this.helpSegmentFlags;
    }

    public void setHelpSegmentFlags(int helpSegmentFlags) {
        this.helpSegmentFlags = helpSegmentFlags;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Button getSelector() {
        return this.selector;
    }

    public void setSelector(Button selector) {
        this.selector = selector;
        this.selectorName = selector == null ? null : selector.getName();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    @Override
    public void store(PropertyWriter pw) {
        if (!this.active && this.profileIndex < 0) {
            return;
        }
        super.store(pw);
        pw.print("HelpSegmentFlags", this.helpSegmentFlags);
        if (this.helpSegment != null && (this.getAssists() == null || this.getAssists().isEmpty())) {
            Hex hex = new Hex(2);
            hex.set((short)this.audioHelp, 0);
            hex.set((short)this.videoHelp, 1);
            pw.print("HelpSettings", hex.toString());
        }
        if (this.macro != null) {
            Assister.store(this.macro.getAssists(), pw);
        }
        if (this.selector != null) {
            pw.print("Selector", this.selector.getName());
        }
        if (this.profileIndex >= 0) {
            pw.print("ProfileIndex", this.profileIndex);
        }
        ActivityGroup.store(pw, this.activityGroups);
    }

    public LinkedHashMap<Integer, List<Assister>> getAssists() {
        return this.macro == null ? null : this.macro.getAssists();
    }

    public int getProfileIndex() {
        return this.profileIndex;
    }

    public void setProfileIndex(int profileIndex) {
        this.profileIndex = profileIndex;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public LinkedHashMap<Integer, ActivityGroup> getGroupMap() {
        return this.groupMap;
    }

    public static class Assister {
        RemoteConfiguration.KeySpec ks = null;
        private String deviceName = null;
        private int buttonCode = -1;

        public static void store(LinkedHashMap<Integer, List<Assister>> assists, PropertyWriter pw) {
            if (assists == null) {
                return;
            }
            for (int i = 0; i < assists.size(); ++i) {
                List<Assister> a = assists.get(i);
                if (a.size() <= 0) continue;
                String aStr = "";
                for (int j = 0; j < a.size(); ++j) {
                    if (a.get(j).toString().isEmpty()) continue;
                    if (j > 0) {
                        aStr = aStr + ", ";
                    }
                    aStr = aStr + a.get(j);
                }
                pw.print("Assist." + assistType[i], aStr);
            }
        }

        public static LinkedHashMap<Integer, List<Assister>> load(Properties props) {
            LinkedHashMap<Integer, List<Assister>> assists = new LinkedHashMap<Integer, List<Assister>>();
            for (int j = 0; j < 3; ++j) {
                assists.put(j, new ArrayList());
            }
            for (int i = 0; i < 3; ++i) {
                String temp = props.getProperty("Assist." + assistType[i]);
                if (temp == null) continue;
                temp = temp.trim();
                List<Assister> aList = assists.get(i);
                StringTokenizer st = new StringTokenizer(temp, ",");
                while (st.hasMoreTokens()) {
                    aList.add(new Assister(st.nextToken()));
                }
            }
            return assists;
        }

        public static void setFunctions(LinkedHashMap<Integer, List<Assister>> assists, Remote remote) {
            if (assists == null) {
                return;
            }
            for (int i = 0; i < assists.size(); ++i) {
                List<Assister> aList = assists.get(i);
                ListIterator<Assister> it = aList.listIterator();
                while (it.hasNext()) {
                    Assister a = it.next();
                    a.set(remote);
                }
            }
        }

        public Assister(DeviceButton device, Button button) {
            this.ks = new RemoteConfiguration.KeySpec(device, button);
            this.deviceName = device.getName();
            this.buttonCode = button.getKeyCode();
            DeviceUpgrade du = device.getUpgrade();
            if (du != null && this.buttonCode > 0) {
                this.ks.fn = du.getGeneralFunction(this.buttonCode, false);
            }
        }

        public Assister(DeviceButton device, GeneralFunction function) {
            this.ks = new RemoteConfiguration.KeySpec(device, function);
            this.deviceName = device.getName();
            if (!function.getUsers().isEmpty()) {
                this.ks.btn = function.getUsers().get((int)0).button;
                this.buttonCode = this.ks.btn.getKeyCode();
            }
        }

        public Assister(String str) {
            this.ks = new RemoteConfiguration.KeySpec();
            str = str.trim();
            int pos = str.indexOf(34, 1);
            pos = str.indexOf(47, pos + 1);
            if (pos != -1) {
                this.deviceName = str.substring(1, pos - 1);
                if (str.charAt(pos + 1) == '/') {
                    this.ks.irSerial = Integer.parseInt(str.substring(pos + 2));
                } else {
                    this.buttonCode = Integer.parseInt(str.substring(pos + 1));
                }
            }
        }

        public String toString() {
            Button b = this.ks.getButton();
            if (b != null) {
                return "\"" + this.ks.db.getName() + "\"/" + b.getKeyCode();
            }
            if (this.ks.db != null && this.ks.fn != null) {
                return "\"" + this.ks.db.getName() + "\"//" + this.ks.fn.serial;
            }
            return "";
        }

        public void set(Remote remote) {
            DeviceUpgrade du;
            for (DeviceButton device : remote.getDeviceButtons()) {
                if (!device.getName().trim().equalsIgnoreCase(this.deviceName.trim())) continue;
                this.ks.db = device;
                break;
            }
            DeviceUpgrade deviceUpgrade = du = this.ks.db != null ? this.ks.db.getUpgrade() : null;
            if (du == null) {
                this.ks.fn = null;
                return;
            }
            if (this.buttonCode > 0) {
                this.ks.btn = remote.getButton(this.buttonCode);
                this.ks.fn = du.getGeneralFunction(this.buttonCode, false);
            }
            if (this.ks.irSerial >= 0) {
                this.ks.fn = du.getFunctionMap().get(this.ks.irSerial);
            }
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDevice(DeviceButton device) {
            this.ks.db = device;
            this.deviceName = device.getName();
        }

        public void setButton(Button button) {
            this.ks.btn = button;
            this.buttonCode = button == null ? -1 : (int)button.getKeyCode();
        }
    }

    public static class Control {
        DeviceButton[][] devices = null;
        DeviceButton[] overrides = null;
        Integer[] maps = null;
    }
}

