/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.CellEditorModel;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ActivityAssistTableModel
extends JP1TableModel<Activity.Assister>
implements CellEditorModel {
    private static final String[] colNames = new String[]{"#", "Device", "Function"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Device Button", "Function Name"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, DeviceButton.class, Function.class};
    private RemoteConfiguration remoteConfig = null;
    private Activity activity = null;
    private JComboBox deviceButtonBox = new JComboBox();
    private JComboBox functionBox = new JComboBox();

    public void set(Button btn, int type, RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            Remote remote = remoteConfig.getRemote();
            this.deviceButtonBox.setModel(new DefaultComboBoxModel<DeviceButton>(remote.usesEZRC() ? remoteConfig.getDeviceButtonList().toArray(new DeviceButton[0]) : remote.getDeviceButtons()));
            this.activity = remoteConfig.getActivities().get(btn);
            this.setData(this.activity.getMacro().getAssists().get(type));
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 0;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col == 0;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        return null;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 1) {
            DefaultCellEditor editor = new DefaultCellEditor(this.deviceButtonBox);
            editor.setClickCountToStart(2);
            return editor;
        }
        if (col == 2) {
            RemoteConfiguration.KeySpec ks = ((Activity.Assister)this.getRow((int)row)).ks;
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(ks.db.getUpgrade().getGeneralFunctionList().toArray());
            this.functionBox.setModel(model);
            DefaultCellEditor editor = new DefaultCellEditor(this.functionBox);
            editor.setClickCountToStart(2);
            return editor;
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Activity.Assister assister = (Activity.Assister)this.getRow(row);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return assister.ks.db;
            }
            case 2: {
                return assister.ks.fn;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Activity.Assister assister = (Activity.Assister)this.getRow(row);
        Remote remote = this.remoteConfig.getRemote();
        if (col == 1) {
            assister.setDevice((DeviceButton)value);
            assister.ks.fn = null;
            assister.setButton(null);
        } else if (col == 2) {
            assister.ks.fn = (GeneralFunction)value;
        }
        assister.set(remote);
        this.fireTableDataChanged();
        this.propertyChangeSupport.firePropertyChange("data", null, null);
    }
}

