/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityGroup;
import com.hifiremote.jp1.ActivityGroupTableModel;
import com.hifiremote.jp1.ActivityPanel;
import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonEnabler;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyCodeRenderer;
import com.hifiremote.jp1.KeyEditor;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.MacroDefinitionBox;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.RMSetterEditor;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.Setting;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ActivityFunctionTableModel
extends JP1TableModel<Activity>
implements ButtonEnabler {
    private static final String[] colNames = new String[]{"#", "Name", "Key", "Power Macro", "Audio Action", "Video Action", "Icon?", "Notes", "<html>Size &amp<br>Color</html>", "Power Dev?"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "Activity Name ___", "Key__", "A power macro with a lot of keys_________", "Audio Action__", "Video Action__", "Icon?_", "A reasonable length note", "Color__", "Power XXXXXXX"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, Integer.class, List.class, String.class, String.class, GeneralFunction.RMIcon.class, String.class, Color.class, Boolean.class};
    private int lastCell = 0;
    private KeyCodeRenderer keyRenderer = new KeyCodeRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, col);
            Color bgColor = ActivityFunctionTableModel.this.isCellEditable(row, col) ? Color.BLACK : Color.GRAY;
            c.setForeground(bgColor);
            return c;
        }
    };
    private RemoteConfiguration remoteConfig = null;
    private KeyEditor keyEditor = new KeyEditor();
    private RMColorEditor colorEditor = null;
    private RMSetterEditor<Object, MacroDefinitionBox> macroEditor = new RMSetterEditor(MacroDefinitionBox.class);
    private SelectAllCellEditor selectAllEditor = new SelectAllCellEditor();
    private DefaultCellEditor comboEditor = new DefaultCellEditor(new JComboBox());
    private RMSetterEditor<GeneralFunction.RMIcon, GeneralFunction.IconPanel> iconEditor = null;
    private GeneralFunction.IconRenderer iconRenderer = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();
    private JComboBox audioHelpSettingBox = new JComboBox();
    private JComboBox videoHelpSettingBox = new JComboBox();
    private String[] helpSetting = null;
    private ActivityGroupTableModel activityGroupModel = null;
    private ActivityPanel panel = null;

    public void set(Button btn, RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            Remote remote = remoteConfig.getRemote();
            this.keyRenderer.setRemote(remote);
            this.keyEditor.setRemote(remote);
            this.macroEditor.setTitle(remote.hasActivityInitialMacro() ? "Activity Macro Editor" : "Power Macro Editor");
            this.macroEditor.setButtonEnabler(this);
            this.macroEditor.setRemoteConfiguration(remoteConfig);
            Activity activity = remoteConfig.getActivities().get(btn);
            this.setData(new Activity[]{activity});
            if (remote.hasActivityControl() && remote.getActivityControl()[0].maps != null) {
                List<Button> activityBtns = remote.getButtonGroups().get("Activity");
                int index = activityBtns.indexOf(btn);
                int limit = remote.getActivityControl()[index].maps.length;
                this.keyEditor.setType(-limit);
            }
            this.setHelpSetting("AudioHelp");
            this.audioHelpSettingBox.setModel(new DefaultComboBoxModel<String>(this.helpSetting));
            this.setHelpSetting("VideoHelp");
            this.videoHelpSettingBox.setModel(new DefaultComboBoxModel<String>(this.helpSetting));
            if (remote.isSSD()) {
                this.iconEditor = new RMSetterEditor(GeneralFunction.IconPanel.class);
                this.iconEditor.setRemoteConfiguration(remoteConfig);
                this.iconRenderer = new GeneralFunction.IconRenderer();
            }
        }
    }

    private void setHelpSetting(String title) {
        Remote remote = this.remoteConfig.getRemote();
        Setting setting = remote.getSetting(title);
        if (setting != null) {
            Object[] options = setting.getOptions(remote);
            this.helpSetting = new String[options.length];
            for (int i = 0; i < options.length; ++i) {
                this.helpSetting[i] = (String)options[i];
            }
        } else {
            this.helpSetting = new String[]{"Off", "On"};
        }
    }

    @Override
    public void enableButtons(Button b, MacroDefinitionBox macroBox) {
        if (this.remoteConfig.getRemote().usesEZRC()) {
            macroBox.add.setEnabled(true);
            macroBox.insert.setEnabled(true);
            macroBox.addShift.setVisible(false);
            macroBox.addXShift.setVisible(false);
            macroBox.insertShift.setVisible(false);
            macroBox.insertXShift.setVisible(false);
            return;
        }
        int limit = 15;
        if (this.remoteConfig.getRemote().getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
            limit = 255;
        }
        boolean canAdd = b != null && macroBox.isMoreRoom(limit);
        macroBox.add.setEnabled(canAdd && b.canAssignToPowerMacro());
        macroBox.insert.setEnabled(canAdd && b.canAssignToPowerMacro());
        macroBox.addShift.setEnabled(canAdd && b.canAssignShiftedToPowerMacro());
        macroBox.insertShift.setEnabled(canAdd && b.canAssignShiftedToPowerMacro());
        boolean xShiftEnabled = this.remoteConfig.getRemote().getXShiftEnabled();
        macroBox.addXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToPowerMacro());
        macroBox.insertXShift.setEnabled(xShiftEnabled && canAdd && b.canAssignXShiftedToPowerMacro());
    }

    @Override
    public boolean isAvailable(Button b) {
        return this.remoteConfig.getRemote().getDistinctButtons().contains(b) && (b.canAssignToPowerMacro() || b.canAssignShiftedToPowerMacro() || b.canAssignXShiftedToPowerMacro());
    }

    private int getEffectiveColumn(int col) {
        if (this.remoteConfig != null) {
            Remote remote = this.remoteConfig.getRemote();
            boolean needsDevCheckBoxes = remote.getSegmentTypes() != null && remote.getSegmentTypes().contains(4);
            int temp = 0;
            if (!remote.usesEZRC() && col > 0) {
                ++col;
            }
            if ((remote.usesEZRC() || remote.usesSimpleset() || !remote.hasActivityControl() && (!remote.hasMasterPowerSupport() || remote.getSegmentTypes().contains(205))) && col > 1) {
                ++col;
            }
            if ((!remote.hasMasterPowerSupport() || needsDevCheckBoxes) && col > 2) {
                ++col;
            }
            if (needsDevCheckBoxes) {
                if (col > 3 + remote.getDeviceButtons().length) {
                    col -= remote.getDeviceButtons().length;
                } else if (col > 3) {
                    temp = col;
                }
            }
            if (remote.getSetting("AudioHelp") == null && col > 3) {
                ++col;
            }
            if (remote.getSetting("VideoHelp") == null && col > 4) {
                ++col;
            }
            if (!remote.isSSD() && col > 5) {
                ++col;
            }
            if (temp > 0) {
                col = colNames.length + temp - 5;
            }
        }
        return col;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        if ((col = this.getEffectiveColumn(col)) > colClasses.length - 1) {
            col = colClasses.length - 1;
        }
        return colClasses[col];
    }

    @Override
    public String getColumnName(int col) {
        col = this.getEffectiveColumn(col);
        if (this.remoteConfig != null) {
            Remote remote = this.remoteConfig.getRemote();
            if (col == 3 && remote.hasActivityInitialMacro()) {
                return "Activity Macro";
            }
            if (col > colClasses.length - 2) {
                String name = "<html>Power";
                name = name + (this.getColumnCount() > 12 ? "<br>" : " ");
                name = name + remote.getDeviceButtons()[col - colClasses.length + 1].getName() + "?</html>";
                return name;
            }
        }
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        if (this.remoteConfig.getRemote().usesEZRC() && col == 2) {
            return "Activity 0__";
        }
        if ((col = this.getEffectiveColumn(col)) == 8 & this.getColumnCount() > 12) {
            return "Color_______";
        }
        if (col > colPrototypeNames.length - 1) {
            col = colPrototypeNames.length - 1;
        }
        return colPrototypeNames[col];
    }

    @Override
    public int getColumnCount() {
        int count = 2;
        if (this.remoteConfig != null) {
            Remote remote = this.remoteConfig.getRemote();
            if (remote.usesEZRC()) {
                ++count;
            }
            if (!remote.usesEZRC() && !remote.usesSimpleset() && (remote.hasActivityControl() || remote.hasMasterPowerSupport() && !remote.getSegmentTypes().contains(205))) {
                ++count;
            }
            if (remote.hasMasterPowerSupport()) {
                count = remote.getSegmentTypes() != null && remote.getSegmentTypes().contains(4) ? (count += remote.getDeviceButtons().length) : ++count;
            }
            if (remote.getSetting("AudioHelp") != null) {
                ++count;
            }
            if (remote.getSetting("VideoHelp") != null) {
                ++count;
            }
            if (remote.isSSD()) {
                ++count;
            }
            if (this.remoteConfig.allowHighlighting()) {
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Remote remote = this.remoteConfig.getRemote();
        if (remote.hasActivityControl() && this.getEffectiveColumn(col) == 2 && remote.getActivityControl()[0].maps == null) {
            return false;
        }
        return col > 0;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return (col = this.getEffectiveColumn(col)) != 1 && col != 3 && col != 7;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        DefaultCellEditor editor = null;
        switch (this.getEffectiveColumn(col)) {
            case 1: 
            case 7: {
                return this.selectAllEditor;
            }
            case 2: {
                Remote remote = this.remoteConfig.getRemote();
                if (remote.usesEZRC() && remote.getButtonGroups() != null && remote.getButtonGroups().keySet().contains("Activity")) {
                    JComboBox cb = (JComboBox)this.comboEditor.getComponent();
                    ArrayList freeBtns = new ArrayList(remote.getButtonGroups().get("Activity"));
                    for (Activity a : this.remoteConfig.getActivities().values()) {
                        if (a == this.getRow(0) || !a.isActive()) continue;
                        freeBtns.remove(a.getSelector());
                    }
                    cb.setModel(new DefaultComboBoxModel<Button>(freeBtns.toArray(new Button[0])));
                    this.comboEditor.setClickCountToStart(2);
                    return this.comboEditor;
                }
                return this.keyEditor;
            }
            case 3: {
                return this.macroEditor;
            }
            case 4: {
                editor = new DefaultCellEditor(this.audioHelpSettingBox);
                editor.setClickCountToStart(2);
                return editor;
            }
            case 5: {
                editor = new DefaultCellEditor(this.videoHelpSettingBox);
                editor.setClickCountToStart(2);
                return editor;
            }
            case 6: {
                return this.iconEditor;
            }
            case 8: {
                return this.colorEditor;
            }
        }
        return null;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if ((col = this.getEffectiveColumn(col)) == 0) {
            return new RowNumberRenderer();
        }
        if (col == 2) {
            return this.keyRenderer;
        }
        if (col == 3) {
            return new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    if (value == null) {
                        super.setValue(null);
                    } else if (value instanceof Hex) {
                        super.setValue(Macro.getValueString((Hex)value, ActivityFunctionTableModel.this.remoteConfig));
                    } else {
                        super.setValue(Macro.getValueString((List)value));
                    }
                }
            };
        }
        if (col == 6) {
            return this.iconRenderer;
        }
        if (col == 8) {
            return this.colorRenderer;
        }
        return null;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Activity activity = (Activity)this.getRow(row);
        Macro macro = activity.getMacro();
        Remote remote = this.remoteConfig.getRemote();
        int rawCol = col;
        col = this.getEffectiveColumn(col);
        switch (col) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return activity.getName();
            }
            case 2: {
                Button selector = activity.getSelector();
                if (remote.getSegmentTypes().contains(205)) {
                    if (selector == null) {
                        this.setValueAt(remote.getButton("0").getKeyCode(), row, rawCol);
                    } else {
                        this.setValueAt(selector.getKeyCode(), row, rawCol);
                    }
                }
                return selector == null ? null : new Integer(activity.getSelector().getKeyCode());
            }
            case 3: {
                return macro == null ? null : macro.getValue();
            }
            case 4: {
                return this.audioHelpSettingBox.getModel().getElementAt(activity.getAudioHelp());
            }
            case 5: {
                return this.videoHelpSettingBox.getModel().getElementAt(activity.getVideoHelp());
            }
            case 6: {
                return activity.icon;
            }
            case 7: {
                return activity.getNotes();
            }
            case 8: {
                return activity.getHighlight();
            }
        }
        DeviceButton db = remote.getDeviceButtons()[col - colNames.length + 1];
        if (macro == null) {
            macro = new Macro(0, new Hex(0), activity.getButton().getKeyCode(), 0, null);
            macro.setMacroClass(Macro.MacroClass.ACTIVITYPOWER);
            macro.setSegmentFlags(255);
            this.remoteConfig.getRemote().correctType04Macro(macro);
            activity.setMacro(macro);
        }
        short[] data = macro.getData().getData();
        int len = data.length;
        ArrayList<DeviceButton> devs = new ArrayList<DeviceButton>();
        for (int i = 0; i < len / 2; ++i) {
            devs.add(remote.getDeviceButton(data[2 * i]));
        }
        return devs.contains(db);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        col = this.getEffectiveColumn(col);
        Activity activity = (Activity)this.getRow(row);
        Macro macro = activity.getMacro();
        Remote remote = this.remoteConfig.getRemote();
        if (col == 1) {
            String name = (String)value;
            activity.setName(name);
            if (activity.getMacro() != null) {
                activity.getMacro().setName(name);
            }
            this.panel.setTabTitle(name, activity);
        }
        if (col == 2) {
            int keyCode;
            Button btn;
            if (remote.usesEZRC()) {
                btn = (Button)value;
                keyCode = btn.getKeyCode();
            } else {
                keyCode = (Integer)value;
                btn = remote.getButton(keyCode);
            }
            if (remote.hasActivityControl() && btn.getName().equals("0")) {
                btn = null;
                if (!remote.getSegmentTypes().contains(205)) {
                    for (ActivityGroup group : activity.getActivityGroups()) {
                        group.setDevice(DeviceButton.noButton);
                    }
                    this.activityGroupModel.fireTableDataChanged();
                }
            }
            activity.setSelector(btn);
            if (remote.hasMasterPowerSupport()) {
                if (macro == null) {
                    macro = new Macro(keyCode, new Hex(0), activity.getButton().getKeyCode(), 0, null);
                    macro.setSegmentFlags(255);
                    macro.setMacroClass(Macro.MacroClass.NORMAL);
                    activity.setMacro(macro);
                    macro.setActivity(activity);
                } else {
                    macro.setKeyCode(keyCode);
                }
            }
            if (remote.hasActivityControl() && (btn != null || remote.getSegmentTypes().contains(205))) {
                int tabIndex = remote.getButtonGroups().get("Activity").indexOf(activity.getButton());
                Activity.Control control = remote.getActivityControl()[tabIndex];
                int index = 0;
                index = btn != null ? Integer.valueOf(btn.getName()) - 1 : (this.remoteConfig.getDefaultActivitySetting(tabIndex) & 0x7F) - 1;
                ActivityGroup[] groups = activity.getActivityGroups();
                int val = control.maps[index];
                DeviceButton[] devBtns = remote.getDeviceButtons();
                for (ActivityGroup group : groups) {
                    group.setDevice(DeviceButton.noButton);
                }
                for (int k = 0; k < devBtns.length; ++k) {
                    if ((val >> k & 1) != 1) continue;
                    DeviceButton devBtn = devBtns[k];
                    for (int j = 0; j < groups.length; ++j) {
                        List<DeviceButton> list = Arrays.asList(control.devices[j]);
                        if (!list.contains(devBtn) || groups[j].getDevice() != null && list.indexOf(devBtn) <= list.indexOf(groups[j].getDevice())) continue;
                        groups[j].setDevice(devBtn);
                    }
                }
                this.activityGroupModel.fireTableDataChanged();
            }
        } else if (col == 3) {
            List items;
            macro.setValue(value);
            if (remote.isSSD() && value instanceof List && !(items = (List)value).isEmpty()) {
                DeviceButton db = ((RemoteConfiguration.KeySpec)items.get((int)0)).db;
                Button b = macro.getActivity().getSelector();
                macro.addReference(db, b);
            }
        } else if (col == 4) {
            activity.setAudioHelp(this.audioHelpSettingBox.getSelectedIndex());
        } else if (col == 5) {
            activity.setVideoHelp(this.videoHelpSettingBox.getSelectedIndex());
        } else if (col == 6) {
            activity.icon = (GeneralFunction.RMIcon)value;
        } else if (col == 7) {
            activity.setNotes((String)value);
        } else if (col == 8) {
            activity.setHighlight((Color)value);
        } else if (col > colNames.length - 2) {
            int dbIndex = col - colNames.length + 1;
            int keyCode = (Boolean)value != false ? remote.getDeviceButtons()[dbIndex].getButtonIndex() : 255;
            macro.getData().set((short)keyCode, 2 * dbIndex);
        }
        this.fireTableRowsUpdated(row, row);
        this.propertyChangeSupport.firePropertyChange(col == 8 ? "highlight" : "data", null, null);
    }

    public void setActivityGroupModel(ActivityGroupTableModel activityGroupModel) {
        this.activityGroupModel = activityGroupModel;
    }

    public void setPanel(ActivityPanel panel) {
        this.panel = panel;
    }

    @Override
    public String getToolTipText(int row, int col) {
        int thisCell = row + (col = this.getEffectiveColumn(col)) * 256;
        if (thisCell == this.lastCell) {
            return null;
        }
        this.lastCell = thisCell;
        if (col == 6) {
            return JTableX.getHtmlToolTip("Double click this column to open Icon Editor to set or<br>remove a system icon from this activity.");
        }
        return null;
    }
}

