/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.Segment;
import java.util.Properties;

public class ActivityGroup
extends Highlight {
    private int index = 0;
    private Button[] buttonGroup = null;
    private DeviceButton device = DeviceButton.noButton;
    private DeviceButton override = null;
    private int deviceIndex = 255;
    private Segment softNamesSegment = null;
    private Macro target = null;
    private int targetKeyCode = 0;

    public static void store(PropertyWriter pw, ActivityGroup[] groups) {
        if (groups == null || groups.length == 0) {
            return;
        }
        if (groups[0].getSegmentFlags() != 0) {
            pw.print("GroupSegmentFlags", groups[0].getSegmentFlags());
        }
        Hex hex = new Hex(groups.length);
        Hex indices = new Hex(groups.length);
        Hex targets = new Hex(groups.length);
        boolean printIndices = false;
        boolean printTargets = false;
        for (int i = 0; i < groups.length; ++i) {
            String notes;
            ActivityGroup group = groups[i];
            hex.set((short)group.getDeviceIndex(), i);
            indices.set((short)group.getIndex(), i);
            int target = group.getTarget() != null ? group.getTarget().getKeyCode() : 0;
            targets.set((short)target, i);
            if (group.getIndex() != i) {
                printIndices = true;
            }
            if (target != 0) {
                printTargets = true;
            }
            if ((notes = group.getNotes()) == null || notes.trim().isEmpty()) continue;
            pw.print("GroupNotes" + i, notes);
        }
        if (printIndices) {
            pw.print("GroupIndices", indices.toString());
        }
        if (printTargets) {
            pw.print("GroupTargets", targets.toString());
        }
        pw.print("GroupSettings", hex.toString());
    }

    public static void parse(Properties props, Activity activity) {
        int groupSegmentFlags = 0;
        String temp = props.getProperty("GroupSegmentFlags");
        if (temp != null) {
            groupSegmentFlags = Integer.parseInt(temp);
        }
        if ((temp = props.getProperty("GroupSettings")) != null) {
            int i;
            Hex hex = new Hex(temp);
            Hex indices = null;
            Hex targets = null;
            temp = props.getProperty("GroupIndices");
            if (temp != null) {
                indices = new Hex(temp);
            } else {
                indices = new Hex(hex.length());
                for (i = 0; i < indices.length(); ++i) {
                    indices.set((short)i, i);
                }
            }
            temp = props.getProperty("GroupTargets");
            if (temp != null) {
                targets = new Hex(temp);
            } else {
                targets = new Hex(hex.length());
                for (i = 0; i < targets.length(); ++i) {
                    targets.set((short)0, i);
                }
            }
            ActivityGroup[] activityGroups = new ActivityGroup[hex.length()];
            for (int i2 = 0; i2 < hex.length(); ++i2) {
                activityGroups[i2] = new ActivityGroup((int)indices.getData()[i2], hex.getData()[i2]);
                activityGroups[i2].setNotes(props.getProperty("GroupNotes" + i2));
                activityGroups[i2].setSegmentFlags(groupSegmentFlags);
                activityGroups[i2].targetKeyCode = targets.getData()[i2];
            }
            activity.setActivityGroups(activityGroups);
        }
    }

    public ActivityGroup(int index, int deviceIndex) {
        this.index = index;
        this.deviceIndex = deviceIndex;
        this.setSegmentFlags(255);
    }

    public ActivityGroup(int index, Remote remote) {
        this.index = index;
        this.device = remote.usesEZRC() ? remote.getDeviceButtons()[0] : DeviceButton.noButton;
        this.deviceIndex = this.device.getButtonIndex() & 0xFF;
        this.buttonGroup = remote.getActivityButtonGroups()[index];
        this.setSegmentFlags(255);
    }

    public void set(Remote remote) {
        this.device = this.deviceIndex == 255 ? DeviceButton.noButton : remote.getDeviceButton(this.deviceIndex);
        this.buttonGroup = remote.getActivityButtonGroups()[this.index];
    }

    public String getButtons() {
        String str = "";
        for (int i = 0; i < this.buttonGroup.length; ++i) {
            if (i > 0) {
                str = str + ", ";
            }
            str = str + this.buttonGroup[i].getName();
        }
        return str;
    }

    public Button[] getButtonGroup() {
        return this.buttonGroup;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public DeviceButton getDevice() {
        return this.device;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(int deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public void setDevice(DeviceButton device) {
        this.device = device;
        this.deviceIndex = device == null ? 255 : device.getButtonIndex() & 0xFF;
    }

    public DeviceButton getOverride() {
        return this.override;
    }

    public void setOverride(DeviceButton override) {
        this.override = override;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Segment getSoftNamesSegment() {
        return this.softNamesSegment;
    }

    public void setSoftNamesSegment(Segment softNamesSegment) {
        this.softNamesSegment = softNamesSegment;
    }

    public int getTargetKeyCode() {
        return this.targetKeyCode;
    }

    public void setTargetKeyCode(int targetKeyCode) {
        this.targetKeyCode = targetKeyCode;
    }

    public Macro getTarget() {
        return this.target;
    }

    public void setTarget(Macro target) {
        this.target = target;
    }
}

