/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityGroup;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.CellEditorModel;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.NoSetup;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ActivityGroupTableModel
extends JP1TableModel<ActivityGroup>
implements CellEditorModel {
    private static final String[] colNames = new String[]{"#", "Button Group", "Device", "Notes", "<html>Size &amp<br>Color</html>"};
    private static final String[] colPrototypeNames = new String[]{" 00 ", "A long list of button names______________________________", "Device Button", "A short note_______", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, String.class, String.class, Color.class};
    private DefaultTableCellRenderer agRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, col);
            Color bgColor = col != 2 || ActivityGroupTableModel.this.isCellEditable(row, col) ? Color.BLACK : Color.GRAY;
            c.setForeground(bgColor);
            return c;
        }
    };
    private RemoteConfiguration remoteConfig = null;
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();
    private SelectAllCellEditor selectAllEditor = new SelectAllCellEditor();
    private DefaultCellEditor comboEditor = new DefaultCellEditor(new JComboBox());
    private DefaultComboBoxModel<Object> comboModel0 = null;
    private DefaultComboBoxModel<Object> comboModel1 = null;
    private DefaultComboBoxModel<Object> comboPowerModel = null;
    private Activity activity = null;
    private NoSetup noSetup = null;
    private int tabIndex = -1;

    public void set(Button btn, RemoteConfiguration remoteConfig, Activity activity) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            Remote remote = remoteConfig.getRemote();
            this.noSetup = remoteConfig.getNoSetup();
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            if (activity == null) {
                activity = remoteConfig.getActivities().get(btn);
            }
            this.activity = activity;
            this.setData(activity.getActivityGroups());
            this.tabIndex = remote.getButtonGroups().get("Activity").indexOf(btn);
            DeviceButton[] dbList = remote.usesEZRC() ? remoteConfig.getDeviceButtonList().toArray(new DeviceButton[0]) : remote.getDeviceButtons();
            Integer[] mode0CodeList = null;
            Integer[] mode1CodeList = null;
            if (this.noSetup != null) {
                mode0CodeList = this.noSetup.getMode0Codes().toArray(new Integer[0]);
                mode1CodeList = this.noSetup.getMode1Codes().toArray(new Integer[0]);
            }
            this.comboModel0 = new DefaultComboBoxModel<DeviceButton>(this.noSetup == null ? dbList : mode0CodeList);
            this.comboModel1 = new DefaultComboBoxModel<Object>(this.noSetup == null ? dbList : mode1CodeList);
            ArrayList<DeviceButton> powerList = new ArrayList<DeviceButton>(Arrays.asList(dbList));
            if (remote.isSSD()) {
                powerList.add((DeviceButton)((Object)"-- Macros --"));
                powerList.addAll(remoteConfig.getTableMacros());
            }
            this.comboPowerModel = new DefaultComboBoxModel<Object>(powerList.toArray());
            if (!remote.usesEZRC() && this.noSetup == null) {
                this.comboModel0.insertElementAt(DeviceButton.noButton.getName(), 0);
                this.comboModel1.insertElementAt(DeviceButton.noButton.getName(), 0);
                this.comboPowerModel.insertElementAt(DeviceButton.noButton.getName(), 0);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public String getColumnName(int col) {
        if (this.remoteConfig != null && this.remoteConfig.getRemote().isSSD() && col == 2) {
            return "Device/Power Macro";
        }
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public int getColumnCount() {
        int count = colNames.length - 1;
        if (this.remoteConfig != null && this.remoteConfig.allowHighlighting()) {
            ++count;
        }
        return count;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Remote remote = this.remoteConfig.getRemote();
        if ((remote.hasActivityControl() || remote.hasActivityAlgorithm()) && col < 3) {
            return false;
        }
        return col > 1;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col == 0;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        if (col == 2) {
            JComboBox cb = (JComboBox)this.comboEditor.getComponent();
            Remote remote = this.remoteConfig.getRemote();
            if (remote.getActivityControl() != null && remote.getActivityControl().length > 0) {
                cb.setModel(new DefaultComboBoxModel<DeviceButton>(remote.getActivityControl()[this.tabIndex].devices[row]));
            } else {
                Button[] btns = ((ActivityGroup)this.getRow(row)).getButtonGroup();
                if (btns.length == 1 && btns[0].getStandardName().equalsIgnoreCase("Power")) {
                    cb.setModel(this.comboPowerModel);
                } else {
                    cb.setModel(row == 0 ? this.comboModel0 : this.comboModel1);
                }
            }
            this.comboEditor.setClickCountToStart(2);
            return this.comboEditor;
        }
        if (col == 3) {
            return this.selectAllEditor;
        }
        if (col == 4) {
            return this.colorEditor;
        }
        return null;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 4) {
            return this.colorRenderer;
        }
        return this.agRenderer;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Remote remote = this.remoteConfig.getRemote();
        ActivityGroup group = (ActivityGroup)this.getRow(row);
        DeviceButton override = null;
        if (remote.hasActivityControl() && this.tabIndex >= 0) {
            Activity.Control ac = remote.getActivityControl()[this.tabIndex];
            DeviceButton dev = ac.overrides[row];
            for (ActivityGroup g : this.activity.getActivityGroups()) {
                if (g.getDevice() != dev) continue;
                override = dev;
                break;
            }
        } else if (remote.hasActivityAlgorithm()) {
            override = group.getOverride();
        }
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return group.getButtons();
            }
            case 2: {
                if (group.getTarget() != null) {
                    return group.getTarget();
                }
                if (this.noSetup == null) {
                    DeviceButton dev = group.getDevice();
                    if (dev != DeviceButton.noButton && override != null && override != dev) {
                        return dev.toString() + "/" + override.toString();
                    }
                    return dev;
                }
                return group.getDeviceIndex();
            }
            case 3: {
                return group.getNotes();
            }
            case 4: {
                return group.getHighlight();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        ActivityGroup group = (ActivityGroup)this.getRow(row);
        if (col == 2) {
            if (value instanceof Macro) {
                Macro macro = (Macro)value;
                group.setDeviceIndex(macro.getDeviceButtonIndex());
                group.setTarget(macro);
            } else if (value instanceof DeviceButton) {
                group.setDevice((DeviceButton)value);
                group.setTarget(null);
            } else if (value instanceof Integer) {
                int serial = (Integer)value;
                int[] serials = this.remoteConfig.getActivitySerials();
                for (int i = group.getIndex(); i < 3; ++i) {
                    ActivityGroup g = this.activity.getActivityGroups()[i];
                    g.setDeviceIndex(serial);
                    if (i == 0) {
                        serials[0] = serial;
                    }
                    serials[i + 1] = serial;
                }
            }
        } else if (col == 3) {
            group.setNotes((String)value);
        } else if (col == 4) {
            if (this.remoteConfig.getRemote().hasActivityControl()) {
                for (ActivityGroup g : this.activity.getActivityGroups()) {
                    g.setHighlight((Color)value);
                }
            } else {
                group.setHighlight((Color)value);
            }
        }
        this.propertyChangeSupport.firePropertyChange(col == 4 ? "highlight" : "data", null, null);
    }
}

