/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.ActivityAssistTableModel;
import com.hifiremote.jp1.ActivityFunctionTableModel;
import com.hifiremote.jp1.ActivityGroup;
import com.hifiremote.jp1.ActivityGroupTableModel;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ActivityPanel
extends RMPanel
implements ChangeListener,
ActionListener,
ListSelectionListener {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private List<Activity> activityList = new ArrayList<Activity>();
    private JPanel grid = new JPanel(new GridLayout(1, 3));
    private JP1Table activityGroupTable = null;
    private ActivityGroupTableModel activityGroupModel = new ActivityGroupTableModel();
    private JPanel activityFunctionPanel = null;
    private JP1Table activityFunctionTable = null;
    private JPanel activityGroupPanel = null;
    private JScrollPane activityFunctionScrollPane = null;
    private ActivityFunctionTableModel activityFunctionModel = new ActivityFunctionTableModel();
    private JP1Table[] activityAssistTables = new JP1Table[]{null, null, null};
    private ActivityAssistTableModel[] activityAssistModels = new ActivityAssistTableModel[]{null, null, null};
    private JPanel tabPanel = null;
    private JTabbedPane tabbedPane = null;
    private RemoteConfiguration remoteConfig = null;
    private int lastIndex = 0;
    private JP1Table activeTable = null;
    private JButton clearActivity = null;
    private JButton newActivity = null;
    private JButton deleteActivity = null;
    private JButton moveRight = null;
    private JButton moveLeft = null;
    private JButton[] newAssist = new JButton[3];
    private JButton[] deleteAssist = new JButton[3];
    private JTextArea messageArea = null;
    private JLabel iconLabel = null;

    public ActivityPanel() {
        JPanel panel;
        this.tabPanel = new JPanel(new BorderLayout());
        this.add((Component)this.tabPanel, "Center");
        this.activityFunctionPanel = new JPanel(new BorderLayout());
        this.activityFunctionPanel.setBorder(BorderFactory.createTitledBorder("Activity Functions"));
        this.activityFunctionTable = new JP1Table(this.activityFunctionModel);
        this.activityFunctionTable.setSelectionMode(1);
        this.activityFunctionTable.getSelectionModel().addListSelectionListener(this);
        this.activityFunctionModel.setPanel(this);
        this.activityFunctionScrollPane = new JScrollPane(this.activityFunctionTable);
        JPanel upper = new JPanel(new BorderLayout());
        upper.add((Component)this.activityFunctionScrollPane, "Center");
        this.messageArea = new JTextArea();
        JLabel label = new JLabel();
        this.messageArea.setFont(label.getFont());
        this.messageArea.setBackground(label.getBackground());
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setEditable(false);
        this.messageArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        upper.add((Component)this.messageArea, "Last");
        this.activityFunctionPanel.add((Component)upper, "Center");
        this.tabPanel.add((Component)this.activityFunctionPanel, "First");
        JPanel inner = new JPanel(new BorderLayout());
        for (int i = 0; i < 3; ++i) {
            panel = new JPanel(new BorderLayout());
            panel.setBorder(BorderFactory.createTitledBorder(Activity.assistType[i] + " Assist"));
            this.activityAssistModels[i] = new ActivityAssistTableModel();
            this.activityAssistTables[i] = new JP1Table(this.activityAssistModels[i]);
            this.activityAssistTables[i].setCellEditorModel(this.activityAssistModels[i]);
            this.activityAssistTables[i].setSelectionMode(0);
            this.activityAssistTables[i].getSelectionModel().addListSelectionListener(this);
            JScrollPane scrollPane = new JScrollPane(this.activityAssistTables[i]);
            panel.add((Component)scrollPane, "Center");
            Dimension dd = this.activityAssistTables[i].getPreferredSize();
            dd.height = 4 * this.activityAssistTables[i].getRowHeight();
            this.activityAssistTables[i].setPreferredScrollableViewportSize(dd);
            this.newAssist[i] = new JButton("New");
            this.newAssist[i].setToolTipText("Add new Assist");
            this.newAssist[i].addActionListener(this);
            this.deleteAssist[i] = new JButton("Delete");
            this.deleteAssist[i].setToolTipText(JTableX.getHtmlToolTip("Delete Assist. &nbsp&nbsp&nbsp Key: DEL<br>(Table must have the focus.)"));
            this.deleteAssist[i].addActionListener(this);
            this.deleteAssist[i].setEnabled(false);
            JPanel btnPanel = new JPanel(new WrapLayout(1));
            btnPanel.add(this.newAssist[i]);
            btnPanel.add(this.deleteAssist[i]);
            panel.add((Component)btnPanel, "Last");
            this.grid.add(panel);
            ActivityPanel.setButtonKeys(this.activityAssistTables[i], this.deleteAssist[i]);
        }
        inner.add((Component)this.grid, "First");
        this.grid.setVisible(false);
        this.activityGroupPanel = new JPanel(new BorderLayout());
        this.activityGroupPanel.setBorder(BorderFactory.createTitledBorder("Activity Group Assignments"));
        this.activityGroupTable = new JP1Table(this.activityGroupModel);
        this.activityGroupTable.setCellEditorModel(this.activityGroupModel);
        this.activityGroupTable.setSelectionMode(1);
        this.activityFunctionModel.setActivityGroupModel(this.activityGroupModel);
        JScrollPane scrollPane = new JScrollPane(this.activityGroupTable);
        this.activityGroupPanel.add((Component)scrollPane, "Center");
        inner.add((Component)this.activityGroupPanel, "Center");
        this.tabPanel.add((Component)inner, "Center");
        panel = new JPanel(new WrapLayout(1, 5, 0));
        this.clearActivity = new JButton("Clear Activity");
        this.clearActivity.addActionListener(this);
        panel.add(this.clearActivity);
        this.deleteActivity = new JButton("Delete Activity");
        this.deleteActivity.addActionListener(this);
        panel.add(this.deleteActivity);
        this.newActivity = new JButton("New Activity");
        this.newActivity.addActionListener(this);
        panel.add(this.newActivity);
        this.moveLeft = new JButton("Move Left");
        this.moveLeft.addActionListener(this);
        panel.add(this.moveLeft);
        this.moveRight = new JButton("Move Right");
        this.moveRight.addActionListener(this);
        panel.add(this.moveRight);
        this.iconLabel = new JLabel("   ");
        this.iconLabel.setPreferredSize(new Dimension(100, 40));
        this.iconLabel.setHorizontalTextPosition(10);
        this.iconLabel.setVisible(false);
        panel.add(Box.createVerticalStrut(this.iconLabel.getPreferredSize().height));
        panel.add(this.iconLabel);
        this.add((Component)panel, "Last");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        this.add((Component)this.tabbedPane, "Center");
        Dimension d = this.activityFunctionTable.getPreferredSize();
        d.height = 2 * this.activityFunctionTable.getRowHeight();
        this.activityFunctionTable.setPreferredScrollableViewportSize(d);
        this.activityFunctionTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ActivityPanel.this.activeTable = ActivityPanel.this.activityFunctionTable;
                ActivityPanel.this.setHighlightAction(ActivityPanel.this.activityFunctionTable);
            }
        });
        this.activityGroupTable.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                ActivityPanel.this.activeTable = ActivityPanel.this.activityGroupTable;
                ActivityPanel.this.setHighlightAction(ActivityPanel.this.activityGroupTable);
            }
        });
        this.activeTable = this.activityFunctionTable;
    }

    private void setHighlightAction(JP1Table table) {
        this.remoteConfig.getOwner().highlightAction.setEnabled(table.getSelectedRowCount() > 0);
    }

    public JP1Table getActiveTable() {
        return this.activeTable;
    }

    @Override
    public void addRMPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            if (this.activityGroupModel != null) {
                this.activityGroupModel.addPropertyChangeListener(listener);
            }
            if (this.activityFunctionModel != null) {
                this.activityFunctionModel.addPropertyChangeListener(listener);
            }
            for (int i = 0; i < 3; ++i) {
                if (this.activityAssistModels[i] == null) continue;
                this.activityAssistModels[i].addPropertyChangeListener(listener);
            }
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        Remote remote = null;
        if (remoteConfig != null && (remote = remoteConfig.getRemote()).getButtonGroups() != null && remote.getButtonGroups().keySet().contains("Activity")) {
            this.activityFunctionScrollPane.setVisible(!remote.hasActivityAlgorithm());
            this.activityGroupPanel.setVisible(remote.getActivityButtonGroups() != null && remote.getActivityButtonGroups().length > 0);
            this.newActivity.setVisible(remote.usesEZRC());
            this.deleteActivity.setVisible(remote.usesEZRC());
            this.moveRight.setVisible(remote.usesEZRC());
            this.moveLeft.setVisible(remote.usesEZRC());
            this.clearActivity.setVisible(!remote.usesEZRC() && remote.getSegmentTypes().contains(220));
            this.iconLabel.setVisible(remote.isSSD());
            this.iconLabel.setIcon(null);
            String startMessage = "Note:  When the activity has been set with the remote, \"Key\" is the number key pressed to select the desired combination for the activity.  If \"Key\" is blank, the activity has not been set.  ";
            if (remote.usesEZRC()) {
                this.messageArea.setText("Note:  Size and highlight color for the Activity Functions includes those of the Activity Assists.");
            } else if (remote.hasMasterPowerSupport() && !remote.usesSimpleset()) {
                if (remote.getSegmentTypes().contains(205)) {
                    this.messageArea.setText("Note:  The Power Macro consists only of the device buttons of the devices which should turn on when the activity button is pressed. It does not contain the Power button explicitly.");
                } else {
                    this.messageArea.setText(startMessage + "The \"Key\" value has no significance when the activity is set with RMIR, but some value has to be set for it before a Power Macro can be entered.");
                }
            } else if (remote.hasActivityControl()) {
                if (remote.getActivityControl()[0].maps == null) {
                    this.messageArea.setText(startMessage + "For this remote the activity group settings are read-only.");
                } else {
                    this.messageArea.setText("Note 1:  \"Key\" is the number key pressed to set the desired combination for the activity.  If \"Key\" is blank, the activity is either not set or set to a default combination, depending on the remote.  Double-click to set or change the selection.  Selecting 0 unsets this activity or sets the default.\nNote 2:  In the group table below, an entry of the form XX/TV means that the device for that group is normally XX but this changes to TV for 10 seconds after the AV button is pressed.");
                }
            } else if (remote.hasActivityAlgorithm()) {
                this.messageArea.setText("This panel is for information only.  The remote does not have selectable activities but instead, devices are assigned to buttons by algorithms in the remote.  The group table below shows the assignment of devices to buttons for the current setup.  An assignment of the form XX/TV means that the device for that group is normally XX but this changes temporarily to TV after the Input button is pressed, remaining so until 10 seconds without a button of this group being pressed.");
            }
            if (remote.hasMasterPowerSupport() || remote.hasActivityControl() || remote.hasActivityAlgorithm()) {
                if (remote.hasActivitySupport() && (remote.getActivityButtonGroups() == null || remote.getActivityButtonGroups().length == 0)) {
                    String msg = this.messageArea.getText();
                    msg = msg + "\n\nThis remote has no Activity Button Groups.  The assignment of buttons to groups is through device punchthrough settings only.";
                    this.messageArea.setText(msg);
                }
                this.messageArea.setVisible(true);
            }
            this.tabbedPane.removeAll();
            this.activityList.clear();
            this.lastIndex = 0;
            int index = 0;
            boolean allowNew = false;
            boolean allowDelete = false;
            for (Button btn : remote.getButtonGroups().get("Activity")) {
                Activity activity = remoteConfig.getActivities().get(btn);
                if (activity == null) continue;
                if (activity.isActive()) {
                    this.activityList.add(activity);
                    this.tabbedPane.addTab(activity.getName(), null);
                    if (activity.isNew()) {
                        this.tabbedPane.setSelectedIndex(index);
                        activity.setNew(false);
                    }
                    allowDelete = true;
                    ++index;
                    continue;
                }
                allowNew = true;
            }
            this.newActivity.setEnabled(allowNew);
            this.deleteActivity.setEnabled(allowDelete);
            this.moveRight.setEnabled(this.activityList.size() > 1);
            this.moveLeft.setEnabled(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabbedPane) {
            int index = this.tabbedPane.getSelectedIndex();
            if (index < 0) {
                return;
            }
            this.tabbedPane.setComponentAt(this.lastIndex, null);
            if (this.tabbedPane.getComponentAt(index) == null) {
                this.tabbedPane.setComponentAt(index, this.tabPanel);
                this.lastIndex = index;
            }
            Activity activity = this.activityList.get(index);
            Button btn = activity.getButton();
            this.finishEditing();
            this.activityFunctionModel.set(btn, this.remoteConfig);
            this.activityFunctionTable.initColumns(this.activityFunctionModel);
            if (this.remoteConfig != null && this.remoteConfig.getRemote().usesEZRC()) {
                this.grid.setVisible(true);
                for (int i = 0; i < 3; ++i) {
                    this.activityAssistModels[i].set(btn, i, this.remoteConfig);
                    this.activityAssistTables[i].initColumns(this.activityAssistModels[i]);
                    if (i >= 2) continue;
                    Activity a = this.activityList.get(index);
                    this.newAssist[i].setEnabled(a.getAssists().size() <= i || a.getAssists().get(i).isEmpty());
                }
                GeneralFunction.RMIcon icon = activity.icon;
                this.iconLabel.setIcon(icon == null ? null : icon.image);
                this.moveRight.setEnabled(index < this.activityList.size() - 1);
                this.moveLeft.setEnabled(index > 0);
            } else {
                this.grid.setVisible(false);
                this.iconLabel.setIcon(null);
            }
            this.activityGroupModel.set(btn, this.remoteConfig, null);
            this.activityGroupTable.initColumns(this.activityGroupModel);
            this.repaint();
        }
    }

    public List<Activity> getActivityList() {
        return this.activityList;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public ActivityGroupTableModel getActivityGroupModel() {
        return this.activityGroupModel;
    }

    public ActivityFunctionTableModel getActivityFunctionModel() {
        return this.activityFunctionModel;
    }

    public void finishEditing() {
        if (this.activityFunctionTable.getCellEditor() != null) {
            this.activityFunctionTable.getCellEditor().stopCellEditing();
        }
        if (this.activityGroupTable.getCellEditor() != null) {
            this.activityGroupTable.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < 3; ++i) {
            if (this.activityAssistTables[i].getCellEditor() == null) continue;
            this.activityAssistTables[i].getCellEditor().stopCellEditing();
        }
    }

    public void setTabTitle(String title, Activity activity) {
        this.tabbedPane.setTitleAt(this.activityList.indexOf(activity), title);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Activity activity;
        this.finishEditing();
        Remote remote = this.remoteConfig.getRemote();
        Object source = e.getSource();
        boolean tabChange = false;
        int index = -1;
        int toIndex = -1;
        int row = -1;
        int col = -1;
        if (source == this.clearActivity || source == this.deleteActivity) {
            activity = (Activity)this.activityFunctionModel.getRow(0);
            activity.setSelector(null);
            activity.setAudioHelp(1);
            activity.setVideoHelp(1);
            activity.setHelpSegment(null);
            for (ActivityGroup group : activity.getActivityGroups()) {
                group.setDevice(DeviceButton.noButton);
            }
            if (activity.getAssists() != null) {
                for (int i = 0; i < activity.getAssists().size(); ++i) {
                    activity.getAssists().get(i).clear();
                }
            }
            if (activity.getMacro() != null) {
                activity.getMacro().setValue(remote.usesEZRC() ? new ArrayList() : new Hex(0));
            }
            if (remote.isSSD()) {
                activity.icon = new GeneralFunction.RMIcon(5);
            }
            if (source == this.deleteActivity) {
                activity.setActive(false);
                if (activity.getMacro() != null) {
                    this.remoteConfig.getMacros().remove(activity.getMacro());
                }
                tabChange = true;
            } else if (!remote.usesEZRC()) {
                activity.setMacro(null);
            }
        } else if (source == this.newActivity) {
            activity = null;
            ArrayList freeBtns = new ArrayList(remote.getButtonGroups().get("Activity"));
            for (Activity a : this.remoteConfig.getActivities().values()) {
                if (a.isActive()) {
                    freeBtns.remove(a.getSelector());
                    continue;
                }
                if (activity != null) continue;
                activity = a;
            }
            activity.setActive(true);
            activity.setNew(true);
            activity.setSelector((Button)freeBtns.get(0));
            List<Macro> macros = this.remoteConfig.getMacros();
            if (!macros.contains(activity.getMacro())) {
                macros.add(activity.getMacro());
                if (remote.isSSD()) {
                    activity.getMacro().setSerial(this.remoteConfig.getNewMacroSerial());
                }
            }
            activity.setName("New Activity");
            activity.getMacro().setName(activity.getName());
            tabChange = true;
        } else if (source == this.moveLeft || source == this.moveRight) {
            index = this.tabbedPane.getSelectedIndex();
            toIndex = source == this.moveLeft ? index - 1 : index + 1;
            Activity activity1 = this.activityList.get(index);
            Activity activity2 = this.activityList.get(toIndex);
            Button b1 = activity1.getButton();
            Button b2 = activity2.getButton();
            activity1.getMacro().setKeyCode(b2.getKeyCode());
            activity2.getMacro().setKeyCode(b1.getKeyCode());
            activity1.setButton(b2);
            activity1.setSelector(b2);
            activity2.setButton(b1);
            activity2.setSelector(b1);
            this.remoteConfig.getActivities().put(b1, activity2);
            this.remoteConfig.getActivities().put(b2, activity1);
            this.tabbedPane.setSelectedIndex(toIndex);
            tabChange = true;
        } else {
            List<Activity.Assister> assists;
            index = Arrays.asList(this.newAssist).indexOf(source);
            if (index >= 0) {
                activity = (Activity)this.activityFunctionModel.getRow(0);
                if (activity.getAssists().isEmpty()) {
                    for (int i = 0; i < 3; ++i) {
                        activity.getAssists().put(i, new ArrayList());
                    }
                    tabChange = true;
                }
                assists = activity.getAssists().get(index);
                DeviceButton dev = remote.getDeviceButtons()[0];
                Button btn = remote.getUpgradeButtons()[0];
                assists.add(new Activity.Assister(dev, btn));
                if (index < 2) {
                    this.newAssist[index].setEnabled(false);
                }
            } else {
                index = Arrays.asList(this.deleteAssist).indexOf(source);
                if (index >= 0) {
                    activity = (Activity)this.activityFunctionModel.getRow(0);
                    assists = activity.getAssists().get(index);
                    row = this.activityAssistTables[index].getSelectedRow();
                    col = this.activityAssistTables[index].getSelectedColumn();
                    assists.remove(row);
                    int n = row = row < assists.size() ? row : assists.size() - 1;
                    if (index < 2) {
                        this.newAssist[index].setEnabled(true);
                    }
                }
            }
        }
        this.activityFunctionModel.fireTableDataChanged();
        this.activityGroupModel.fireTableDataChanged();
        for (int i = 0; i < 3; ++i) {
            this.activityAssistModels[i].fireTableDataChanged();
        }
        this.propertyChangeSupport.firePropertyChange(tabChange ? "tabs" : "data", null, null);
        if (toIndex >= 0) {
            this.tabbedPane.setSelectedIndex(toIndex);
        }
        if (row >= 0) {
            this.activityAssistTables[index].setRowSelectionInterval(row, row);
            this.activityAssistTables[index].setColumnSelectionInterval(col, col);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i;
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object source = e.getSource();
        if (source == this.activityFunctionTable.getSelectionModel()) {
            int index = this.tabbedPane.getSelectedIndex();
            if (index < 0) {
                return;
            }
            Activity activity = this.activityList.get(index);
            GeneralFunction.RMIcon icon = activity.icon;
            this.iconLabel.setIcon(icon == null ? null : icon.image);
            return;
        }
        for (i = 0; i < 3 && this.activityAssistTables[i].getSelectionModel() != source; ++i) {
        }
        if (i == 3) {
            return;
        }
        this.deleteAssist[i].setEnabled(this.activityAssistTables[i].isFocusOwner() && this.activityAssistTables[i].getSelectedRow() >= 0);
    }
}

