/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.StringTokenizer;

public class AddressRange
extends RDFParameter {
    private int start;
    private int end;
    private int freeEnd;
    private int freeStart;
    private int roundTo = 0;

    public AddressRange() {
    }

    public AddressRange(String text, Remote remote) throws Exception {
        this.parse(text, remote);
    }

    public AddressRange(int start, int end) {
        this.start = start;
        this.end = end;
        this.freeStart = start;
        this.freeEnd = end;
    }

    @Override
    public void parse(String text, Remote remote) throws Exception {
        StringTokenizer st = new StringTokenizer(text, ".=/");
        this.start = RDFReader.parseNumber(st.nextToken());
        this.end = RDFReader.parseNumber(st.nextToken());
        if (st.hasMoreTokens()) {
            this.roundTo = RDFReader.parseNumber(st.nextToken());
        }
        this.freeStart = this.start;
        this.freeEnd = this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getFreeStart() {
        return this.freeStart;
    }

    public void setFreeStart(int freeStart) {
        this.freeStart = freeStart;
    }

    public int getFreeEnd() {
        return this.freeEnd;
    }

    public void setFreeEnd(int freeEnd) {
        this.freeEnd = freeEnd;
    }

    public int getRoundTo() {
        return this.roundTo;
    }

    public void setRoundTo(int roundTo) {
        this.roundTo = roundTo;
    }

    public int getSize() {
        return this.end + 1 - this.start;
    }

    public boolean contains(int address) {
        return address >= this.start && address <= this.end;
    }

    public String toString() {
        String str = "$" + Integer.toHexString(this.start) + "..$" + Integer.toHexString(this.end);
        if (this.roundTo > 0) {
            str = str + "/" + this.roundTo;
        }
        return str;
    }
}

