/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.FavKey;
import com.hifiremote.jp1.FavScan;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexReader;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMoveEFC;
import com.hifiremote.jp1.KeyMoveEFC5;
import com.hifiremote.jp1.KeyMoveKey;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.TimedMacro;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;

public abstract class AdvancedCode
extends Highlight {
    protected List<RemoteConfiguration.KeySpec> items = null;

    public static AdvancedCode read(HexReader reader, Remote remote) {
        int typeByte;
        if (reader.available() < 4 || reader.peek() == remote.getSectionTerminator()) {
            return null;
        }
        short keyCode = reader.read();
        int type = typeByte = reader.read();
        int length = 0;
        int boundDeviceIndex = 0;
        boolean isMacro = false;
        boolean isTimedMacro = false;
        boolean isFav = false;
        int sequenceNumber = 0;
        if (remote.getAdvCodeBindFormat() == BindFormat.NORMAL) {
            length = type & 0xF;
            boundDeviceIndex = (type >>= 4) >> 1;
            if (type == 1) {
                isMacro = true;
            } else if (type == 3) {
                isFav = true;
                FavKey favKey = remote.getFavKey();
                if (favKey != null) {
                    length *= favKey.getEntrySize();
                }
            } else {
                length = typeByte & 0x1F;
            }
        } else {
            length = reader.read();
            boundDeviceIndex = type & 0xF;
            type >>= 4;
            if (remote.getMacroCodingType().get_Type() == 2) {
                if (type >= 3) {
                    if ((type & 8) == 8 && remote.hasTimedMacroSupport()) {
                        isTimedMacro = true;
                    } else {
                        isMacro = true;
                        sequenceNumber = type - 3;
                    }
                }
            } else if ((type & 8) == 8) {
                isMacro = true;
                sequenceNumber = type & 7;
            } else if ((type & 3) == 3) {
                isFav = true;
            }
        }
        String message = null;
        System.err.println("length=" + length);
        Hex hex = new Hex(reader.read(length));
        if (remote.getAdvCodeBindFormat() == BindFormat.NORMAL && length > 15) {
            hex = hex.subHex(0, 15);
        }
        if (isMacro) {
            Macro macro = new Macro(keyCode, hex, null);
            macro.setSequenceNumber(sequenceNumber);
            if (boundDeviceIndex == 15 || remote.getAdvCodeBindFormat() == BindFormat.NORMAL) {
                boundDeviceIndex = -1;
            }
            macro.setDeviceButtonIndex(boundDeviceIndex);
            if (remote.getAdvCodeBindFormat() == BindFormat.NORMAL && length > 15) {
                message = "Macro on " + remote.getButtonName(keyCode) + " is overlong and has been\ntruncated to maximum allowed size.";
                AdvancedCode.showMessage(message);
            }
            return macro;
        }
        if (isFav) {
            FavScan favScan = new FavScan(keyCode, hex, null);
            if (boundDeviceIndex == 15 || remote.getAdvCodeBindFormat() == BindFormat.NORMAL) {
                boundDeviceIndex = -1;
            }
            favScan.setDeviceIndex(boundDeviceIndex);
            return favScan;
        }
        if (isTimedMacro) {
            TimedMacro timedMacro = new TimedMacro(keyCode, typeByte, hex, null);
            return timedMacro;
        }
        KeyMove keyMove = null;
        keyMove = (remote.getAdvCodeBindFormat() == BindFormat.LONG || remote.getAdvCodeFormat() == Format.EFC) && length == 3 ? new KeyMoveKey(keyCode, boundDeviceIndex, hex, null) : (remote.getAdvCodeFormat() == Format.HEX ? new KeyMove(keyCode, boundDeviceIndex, hex, null) : (remote.getEFCDigits() == 3 ? new KeyMoveEFC(keyCode, boundDeviceIndex, hex, null) : new KeyMoveEFC5(keyCode, boundDeviceIndex, hex, null)));
        if (remote.getAdvCodeBindFormat() == BindFormat.NORMAL && length > 15) {
            DeviceButton db = remote.getDeviceButton(boundDeviceIndex);
            String keyDesc = db.getName() + "/" + remote.getButtonName(keyCode);
            message = "Key Move or Special Function on " + keyDesc + " is overlong and\nhas been truncated to maximum allowed size.";
            AdvancedCode.showMessage(message);
        }
        return keyMove;
    }

    public AdvancedCode(int keyCode, Hex data, String notes) {
        this.keyCode = keyCode;
        this.data = data;
        this.notes = notes;
    }

    public AdvancedCode(Properties props) {
        super(props);
        String temp = props.getProperty("KeyCode");
        this.keyCode = temp == null ? 0 : Integer.parseInt(temp);
    }

    public int getSize(Remote remote) {
        int size = this.data.length() + 2;
        if (remote.getSegmentTypes() == null) {
            if (remote.getAdvCodeBindFormat() == BindFormat.LONG) {
                ++size;
            }
            if (this instanceof KeyMoveEFC5) {
                --size;
            }
        }
        return size;
    }

    private static void showMessage(String message) {
        String title = "Data Error";
        JOptionPane.showMessageDialog(null, message, title, 2);
    }

    public abstract int store(short[] var1, int var2, Remote var3);

    public abstract String getValueString(RemoteConfiguration var1);

    public void setNotes(String notes) {
        if (!(notes == this.notes || notes != null && notes.equals(this.notes))) {
            this.notes = notes;
        }
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public List<RemoteConfiguration.KeySpec> getItems() {
        return this.items;
    }

    public void setItems(List<RemoteConfiguration.KeySpec> items) {
        this.items = items;
    }

    @Override
    public void store(PropertyWriter pw) {
        super.store(pw);
        pw.print("KeyCode", this.keyCode);
    }

    public static enum BindFormat {
        LONG,
        NORMAL;

    }

    public static enum Format {
        HEX,
        EFC;

    }
}

