/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.AssemblerTableModel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.S3C80Processor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class AssemblerItem {
    public static List<Integer> unlabelled = new ArrayList<Integer>();
    private int address = 0;
    private Hex hex = null;
    private String label = "";
    private String operation = "";
    private String argumentText = "";
    private String comments = "";
    private AssemblerOpCode opCode = null;
    private int errorCode = 0;
    private int type = 0;
    private boolean checked = true;

    public AssemblerItem() {
    }

    public AssemblerItem(int address, String operation, String argumentText) {
        this.address = address;
        this.operation = operation;
        this.argumentText = argumentText;
    }

    public AssemblerItem(int address, Hex hex) {
        this.address = address;
        this.hex = hex;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public Object getElement(int index) {
        switch (index) {
            case 0: {
                if (this.address == 0) {
                    return "";
                }
                String hexStr = Integer.toHexString(this.address);
                hexStr = "0000".substring(hexStr.length()) + hexStr;
                return hexStr.toUpperCase();
            }
            case 1: {
                return this.hex;
            }
            case 2: {
                return this.label;
            }
            case 3: {
                return this.operation;
            }
            case 4: {
                return this.argumentText;
            }
            case 5: {
                int n = this.errorCode;
                return n > 0 ? AssemblerItem.getError(n) : this.comments;
            }
        }
        return null;
    }

    public int disassemble(Processor p, LinkedHashMap<Integer, String> labels, AssemblerTableModel.DisasmState state) {
        int val;
        this.opCode = p.getOpCode(this.hex);
        this.operation = this.opCode.getName();
        AssemblerOpCode.AddressMode mode = this.opCode.getMode();
        if (this.opCode.getLength() + mode.length > this.hex.length()) {
            return 0;
        }
        int length = this.opCode.getLength() + mode.length;
        this.hex = new Hex(this.hex, 0, length);
        short[] data = this.hex.getData();
        Object[] obj = new Object[]{null, null, null, null};
        int argCount = 0;
        int i = 0;
        while (mode.nibbleMap >> i != 0) {
            if ((mode.nibbleMap >> i & 1) == 1) {
                val = data[i / 2];
                val = (i & 1) == 0 ? val >> 4 : val & 0xF;
                obj[argCount++] = val;
            }
            ++i;
        }
        for (i = 0; i < mode.length - mode.nibbleBytes; ++i) {
            val = data[this.opCode.getLength() + mode.nibbleBytes + i];
            obj[argCount++] = val & 0xFF;
        }
        mode = p.disasmModify(mode, obj);
        String format = mode.format;
        if (obj[0] instanceof String && ((String)obj[0]).equals("*")) {
            format = "%s";
        } else {
            Integer val2;
            int argIndex;
            int i2 = 0;
            while (mode.relMap >> i2 != 0) {
                if ((mode.relMap >> i2 & 1) == 1 && mode.nibbleArgs + i2 < argCount) {
                    argIndex = mode.nibbleArgs + i2;
                    int n = (Integer)obj[argIndex];
                    int offset = p.isRelativeToOpStart() ? 0 : this.opCode.getLength() + mode.nibbleBytes + i2 + 1;
                    n -= n > 127 ? 256 : 0;
                    if (p.getName().equals("MAXQNative")) {
                        n += n + 2;
                    }
                    obj[argIndex] = n += this.address + offset;
                    String label = labels.get(n);
                    if (label != null) {
                        format = this.formatForLabel(format, argIndex, false);
                        obj[argIndex] = label;
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (mode.absMap >> i2 != 0) {
                if ((mode.absMap >> i2 & 1) == 1 && mode.nibbleArgs + i2 < argCount - 1) {
                    String label;
                    argIndex = mode.nibbleArgs + i2;
                    int[][] formatStarts = AssemblerOpCode.getFormatStarts(format);
                    boolean twoByte = !p.hasOneByteAbsoluteAddresses() && format.startsWith("02", formatStarts[argIndex][1] + 1);
                    boolean littleEndian = !twoByte || formatStarts[argIndex][0] > formatStarts[argIndex + 1][0];
                    int n = (Integer)obj[argIndex] * (littleEndian ? 1 : 256);
                    if (twoByte) {
                        n += (Integer)obj[argIndex + 1] * (littleEndian ? 256 : 1);
                    }
                    if ((label = p.getAbsLabels().get(n)) != null) {
                        if (!state.absUsed.contains(n)) {
                            state.absUsed.add(n);
                        }
                        if (state.useFunctionConstants) {
                            format = this.formatForLabel(format, argIndex, twoByte);
                            obj[argIndex] = label;
                            if (twoByte) {
                                obj[argIndex + 1] = "";
                            }
                        }
                    } else {
                        label = labels.get(n);
                        if (label != null) {
                            format = this.formatForLabel(format, argIndex, twoByte);
                            obj[argIndex] = label;
                            if (twoByte) {
                                obj[argIndex + 1] = "";
                            }
                        }
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (mode.zeroMap >> i2 != 0) {
                if ((mode.zeroMap >> i2 & 1) == 1 && mode.nibbleArgs + i2 < argCount) {
                    argIndex = mode.nibbleArgs + i2;
                    int n = (Integer)obj[argIndex];
                    if (this.setZeroLabel(p, n, state.zeroUsed, "") && state.useRegisterConstants) {
                        format = this.formatForLabel(format, argIndex, false);
                        obj[argIndex] = this.label;
                    } else if (!unlabelled.contains(n)) {
                        unlabelled.add(n);
                    }
                }
                ++i2;
            }
            i2 = 0;
            while (mode.ccMap >> i2 != 0) {
                if ((mode.ccMap >> i2 & 1) == 1 && i2 < argCount) {
                    obj[i2] = p.getConditionCode((Integer)obj[i2]);
                }
                ++i2;
            }
            if (p instanceof S3C80Processor) {
                if (state.toRC) {
                    for (i2 = 0; i2 < mode.nibbleArgs; ++i2) {
                        if (!(obj[i2] instanceof Integer)) continue;
                        format = this.formatWvRC(format, i2, obj, false);
                    }
                } else if (state.toW) {
                    i2 = 0;
                    while (mode.zeroMap >> i2 != 0) {
                        if ((mode.zeroMap >> i2 & 1) == 1 && mode.nibbleArgs + i2 < argCount && obj[argIndex = mode.nibbleArgs + i2] instanceof Integer) {
                            format = this.formatWvRC(format, argIndex, obj, true);
                        }
                        ++i2;
                    }
                }
            }
            if (mode.modifier == 8 && (val2 = (Integer)obj[2]) != null && val2 < 0) {
                obj[2] = -val2.intValue();
                format = format.replace("#", "#-");
            }
            this.checked = true;
        }
        this.argumentText = String.format(format, obj[0], obj[1], obj[2], obj[3]);
        this.label = labels.get(this.address);
        if (this.label == null) {
            this.label = "";
        } else {
            this.label = this.label + ":";
            if (!state.relUsed.contains(this.address)) {
                state.relUsed.add(this.address);
            }
        }
        return length;
    }

    public void assemble(Processor p, LinkedHashMap<String, String> labels, boolean checkOffset) {
        LinkedHashMap<String, AssemblerOpCode> opMap;
        this.hex = null;
        this.opCode = new AssemblerOpCode();
        this.errorCode = 0;
        String opStr = this.operation.toUpperCase();
        String originalText = this.argumentText;
        if (p instanceof S3C80Processor && opStr.matches("J(P|R)[A-Z]+")) {
            originalText = opStr.substring(2) + "," + originalText;
            opStr = opStr.substring(0, 2);
        }
        if ((opMap = p.getOpMap().get(opStr)) == null) {
            this.errorCode = 1;
            return;
        }
        Set<String> opModes = opMap.keySet();
        int count = 1;
        List<String> argModes = null;
        AssemblerOpCode.OpArg args = null;
        if (p instanceof S3C80Processor) {
            count = 5;
        }
        for (int i = 0; i < count; ++i) {
            String alternateText = p.getAlternateArgument(originalText, i);
            args = p.getArgs(alternateText, labels);
            argModes = p.getAddressModes(args);
            Iterator<String> it = argModes.iterator();
            while (it.hasNext()) {
                if (opModes.contains(it.next())) continue;
                it.remove();
            }
            if (argModes.size() > 0) break;
        }
        if (argModes.size() == 0) {
            this.errorCode = 2;
            return;
        }
        this.opCode = opMap.get(argModes.get(0));
        if (this.opCode.getMode().relMap != 0 && !checkOffset) {
            return;
        }
        AssemblerOpCode.AddressMode mode = this.opCode.getMode();
        Integer[] argMap = mode.argMap;
        int[] obj = new int[]{0, 0, 0, 0};
        for (int i = 0; i < argMap.length && argMap[i] > 0; ++i) {
            AssemblerOpCode.Token t = (AssemblerOpCode.Token)args.get(i);
            if (argMap[i] < 5) {
                int n = argMap[i] - 1;
                int nArg = n - mode.nibbleArgs;
                if (nArg >= 0 && (mode.relMap >> nArg & 1) == 1 && t.type == AssemblerOpCode.TokenType.NUMBER) {
                    t.type = AssemblerOpCode.TokenType.OFFSET;
                    AssemblerOpCode.Token token = t;
                    Integer.valueOf(token.value - (this.address + this.opCode.getLength() + mode.length));
                    token.value = token.value;
                }
                if (t.type == AssemblerOpCode.TokenType.OFFSET && (t.value < -128 || t.value > 127)) {
                    this.errorCode = 3;
                    return;
                }
                obj[n] = t.type == AssemblerOpCode.TokenType.CONDITION_CODE ? p.getConditionIndex(t.text) : t.value.intValue();
                continue;
            }
            if (argMap[i] <= 16) continue;
            if (t.type != AssemblerOpCode.TokenType.NUMBER) {
                this.errorCode = 4;
                return;
            }
            obj[(argMap[i].intValue() >> 4) - 1] = t.value >> 8;
            obj[(argMap[i].intValue() & 0xF) - 1] = t.value & 0xFF;
        }
        p.asmModify(mode.modifier, obj);
        this.hex = new Hex(this.opCode.getHex(), 0, this.opCode.getLength() + mode.length);
        this.checked = true;
        int n = 0;
        int i = 0;
        while (mode.nibbleMap >> i > 0) {
            if ((mode.nibbleMap >> i & 1) == 1) {
                this.hex.set((short)(this.hex.getData()[i / 2] | (obj[n++] & 0xF) << 4 * (1 - i % 2)), i / 2);
            }
            ++i;
        }
        for (i = this.opCode.getLength() + mode.nibbleBytes; i < this.opCode.getLength() + mode.length; ++i) {
            this.hex.set((short)(this.hex.getData()[i] | obj[n++] & 0xFF), i);
        }
    }

    private String replacePart(String s, int start, int end, String insert) {
        return s.substring(0, start) + insert + s.substring(end);
    }

    private String formatForLabel(String format, int argIndex, boolean word) {
        boolean preSymbol;
        boolean littleEndian = false;
        int[][] formatStarts = AssemblerOpCode.getFormatStarts(format);
        if (word) {
            littleEndian = formatStarts[argIndex][0] > formatStarts[argIndex + 1][0];
        }
        int fStart0 = formatStarts[argIndex + (littleEndian ? 1 : 0)][0];
        int fStart1 = formatStarts[argIndex + (littleEndian ? 1 : 0)][1];
        int preLength = 1;
        boolean bl = preSymbol = fStart0 > 0 && (format.substring(fStart0 - 1, fStart0).equals("$") || format.substring(fStart0 - 1, fStart0).equals("R"));
        if (fStart0 > 1 && format.substring(fStart0 - 2, fStart0).equals("RR")) {
            preLength = 2;
        }
        if (word) {
            int fStart3 = formatStarts[argIndex + (littleEndian ? 0 : 1)][1];
            format = this.replacePart(format, fStart3 + 1, fStart3 + (preSymbol ? 4 : 5), "s");
        }
        format = this.replacePart(format, fStart1 + 1, fStart1 + (preSymbol || word ? 4 : 5), "s");
        if (preSymbol) {
            format = this.replacePart(format, fStart0 - preLength, fStart0, "");
        }
        return format;
    }

    private String formatWvRC(String format, int argIndex, Object[] args, boolean toW) {
        int[][] formatStarts = AssemblerOpCode.getFormatStarts(format);
        int fStart0 = formatStarts[argIndex][0];
        int fStart1 = formatStarts[argIndex][1];
        boolean preR = fStart0 > 0 && format.substring(fStart0 - 1, fStart0).equals("R");
        boolean preW = fStart0 > 0 && format.substring(fStart0 - 1, fStart0).equals("W");
        boolean preRR = fStart0 > 1 && format.substring(fStart0 - 2, fStart0).equals("RR");
        boolean preWW = fStart0 > 1 && format.substring(fStart0 - 2, fStart0).equals("WW");
        int arg = (Integer)args[argIndex];
        if (preRR && toW && (arg & 0xF0) == 192) {
            format = this.replacePart(format, fStart0 - 2, fStart0, "WW");
            format = this.replacePart(format, fStart1 + 1, fStart1 + 4, "X");
            args[argIndex] = arg & 0xF;
        } else if (preR && toW && (arg & 0xF0) == 192) {
            format = this.replacePart(format, fStart0 - 1, fStart0, "W");
            format = this.replacePart(format, fStart1 + 1, fStart1 + 4, "X");
            args[argIndex] = arg & 0xF;
        } else if (preWW && !toW) {
            format = this.replacePart(format, fStart0 - 2, fStart0, "RR");
            format = this.replacePart(format, fStart1 + 1, fStart1 + 2, "02X");
            args[argIndex] = arg | 0xC0;
        } else if (preW && !toW) {
            format = this.replacePart(format, fStart0 - 1, fStart0, "R");
            format = this.replacePart(format, fStart1 + 1, fStart1 + 2, "02X");
            args[argIndex] = arg | 0xC0;
        }
        return format;
    }

    public boolean setZeroLabel(Processor p, int address, List<Integer> addrList, String suffix) {
        for (String text : p.getZeroSizes().keySet()) {
            int addr = p.getZeroAddresses().get(text);
            int size = p.getZeroSizes().get(text);
            String[] lblArray = p.getZeroLabels().get(addr);
            String labelBody = lblArray[1];
            int incr = 1;
            if (lblArray.length > 2) {
                incr = Integer.parseInt(lblArray[2]);
            }
            if (address <= addr || address >= addr + size || (address - addr) % incr != 0) continue;
            if (labelBody.length() >= text.length()) {
                if (addrList != null && !addrList.contains(addr)) {
                    addrList.add(addr);
                }
                this.label = labelBody + (address - addr) + suffix;
                return true;
            }
            if (addrList != null && !addrList.contains(address)) {
                addrList.add(address);
            }
            String format = "%0" + (text.length() - labelBody.length()) + "X";
            this.label = labelBody + String.format(format, (address - addr) / incr) + suffix;
            return true;
        }
        if (p.getZeroLabels().get(address) != null) {
            if (addrList != null && !addrList.contains(address)) {
                addrList.add(address);
            }
            this.label = p.getZeroLabels().get(address)[0] + suffix;
            return true;
        }
        return false;
    }

    public int getLength() {
        if (this.opCode == null || this.isCommentedOut()) {
            return 0;
        }
        return this.opCode.getLength() + this.opCode.getMode().length;
    }

    public boolean isCommentedOut() {
        return this.label.startsWith(";");
    }

    public int get_Type() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public Hex getHex() {
        return this.hex;
    }

    public void setHex(Hex hex) {
        this.hex = hex;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getArgumentText() {
        return this.argumentText;
    }

    public void setArgumentText(String argumentText) {
        this.argumentText = argumentText;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public AssemblerOpCode getOpCode() {
        return this.opCode;
    }

    public void setOpCode(AssemblerOpCode opCode) {
        this.opCode = opCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public static String getError(int errorCode) {
        switch (errorCode) {
            case 0: {
                return "";
            }
            case 1: {
                return "Bad op code";
            }
            case 2: {
                return "Bad argument";
            }
            case 3: {
                return "Out of range";
            }
            case 4: {
                return "Assembler error";
            }
            case 5: {
                return "Bad value";
            }
            case 6: {
                return "ERRORS ARE PRESENT";
            }
        }
        return "Unknown error";
    }
}

