/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class AssemblerOpCode
implements Cloneable {
    private String name = "*";
    private AddressMode mode = new AddressMode();
    private int index = 0;
    private Hex hex = new Hex(0);
    private int length = 1;

    public AssemblerOpCode() {
    }

    public AssemblerOpCode(Processor p, String[] parms) {
        this.name = parms[0];
        this.mode = p.getAddressModes().get(parms[1]);
        if (this.mode == null) {
            this.mode = new AddressMode();
        }
        if (parms.length > 2) {
            this.index = Integer.parseInt(parms[2]);
        }
    }

    public static int[][] getFormatStarts(String format) {
        int i;
        int[][] starts = new int[4][3];
        for (i = 0; i < starts.length; ++i) {
            Arrays.fill(starts[i], -1);
        }
        int j = 0;
        for (i = 0; i < format.length(); ++i) {
            int k;
            if (format.charAt(i) != '%') continue;
            int pos = j++;
            int start = i;
            for (k = i + 1; k < format.length() && Character.isDigit(format.charAt(k)); ++k) {
            }
            if (k < format.length() && format.charAt(k) == '$') {
                pos = Integer.parseInt(format.substring(i + 1, k)) - 1;
                start = k;
            }
            starts[pos][0] = i;
            starts[pos][1] = start;
            starts[pos][2] = j - 1;
        }
        return starts;
    }

    public AssemblerOpCode clone() {
        AssemblerOpCode opCode = new AssemblerOpCode();
        opCode.name = this.name;
        opCode.mode = this.mode;
        opCode.index = this.index;
        opCode.length = this.length;
        opCode.hex = new Hex(this.hex);
        return opCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AddressMode getMode() {
        return this.mode;
    }

    public void setMode(AddressMode mode) {
        this.mode = mode;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Hex getHex() {
        return this.hex;
    }

    public void setHex(Hex hex) {
        this.hex = hex;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public static class AddressMode {
        public String name = "";
        public int length = 0;
        public int relMap = 0;
        public int nibbleMap = 0;
        public int ccMap = 0;
        public int absMap = 0;
        public int zeroMap = 0;
        public int modifier = 0;
        public int nibbleBytes = 0;
        public int nibbleArgs = 0;
        public String format = "";
        public String outline = "";
        public Integer[] argMap = new Integer[4];
        public int[] argLimits = new int[4];
        private String[] parms = null;

        public AddressMode() {
        }

        public AddressMode(AddressMode mode) {
            this(mode.parms);
        }

        public AddressMode(String[] parms) {
            int i;
            int n;
            int i2;
            this.parms = parms;
            ArrayList<Integer> keyPositions = new ArrayList<Integer>();
            this.name = parms[0];
            String s = parms[1];
            for (i2 = 0; i2 < s.length(); ++i2) {
                if (Character.isDigit(s.charAt(i2))) continue;
                keyPositions.add(i2);
            }
            keyPositions.add(s.length());
            for (i2 = 0; i2 < keyPositions.size() - 1; ++i2) {
                String key = s.substring((Integer)keyPositions.get(i2), (Integer)keyPositions.get(i2) + 1);
                String val = s.substring((Integer)keyPositions.get(i2) + 1, (Integer)keyPositions.get(i2 + 1));
                if (key.equals("C")) {
                    this.ccMap = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("N")) {
                    this.nibbleMap = Integer.parseInt(val);
                    n = 0;
                    while (this.nibbleMap >> n != 0) {
                        if ((this.nibbleMap >> n & 1) == 1) {
                            ++this.nibbleArgs;
                        }
                        if (n > 1 && (n & 1) == 0) {
                            ++this.nibbleBytes;
                        }
                        ++n;
                    }
                    this.length += this.nibbleBytes;
                    continue;
                }
                if (key.equals("B")) {
                    this.length += Integer.parseInt(val);
                    continue;
                }
                if (key.equals("R")) {
                    this.relMap = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("A")) {
                    this.absMap = Integer.parseInt(val);
                    continue;
                }
                if (key.equals("Z")) {
                    this.zeroMap = Integer.parseInt(val);
                    continue;
                }
                if (!key.equals("M")) continue;
                this.modifier = Integer.parseInt(val);
            }
            this.format = parms[2];
            Arrays.fill((Object[])this.argMap, (Object)0);
            Arrays.fill(this.argLimits, 0);
            int[][] formatStarts = AssemblerOpCode.getFormatStarts(this.format);
            int[][] starts = new int[formatStarts.length][3];
            for (i = 0; i < starts.length; ++i) {
                Arrays.fill(starts[i], -1);
            }
            for (i = 0; i < starts.length; ++i) {
                n = formatStarts[i][2];
                if (n < 0) continue;
                starts[n][0] = formatStarts[i][0];
                starts[n][1] = formatStarts[i][1];
                starts[n][2] = i;
            }
            boolean gap = true;
            int m = 0;
            int n2 = 0;
            for (int i3 = 0; i3 < this.format.length(); ++i3) {
                if (n2 >= starts.length || starts[n2][0] < 0 || i3 <= starts[n2][0]) {
                    char ch = this.format.charAt(i3);
                    if (gap || ch != '%') {
                        this.outline = this.outline + this.format.charAt(i3);
                    }
                    if (ch == '%') continue;
                    gap = true;
                    continue;
                }
                i3 = starts[n2][1] + 1;
                if (this.format.substring(i3).startsWith("02X")) {
                    if (gap) {
                        this.outline = this.outline + "X";
                    } else {
                        --m;
                    }
                    this.argLimits[m] = (this.argLimits[m] << 8) + 255;
                    this.argMap[m] = this.argMap[m] << 4;
                    i3 += 2;
                } else if (this.format.substring(i3).startsWith("04X")) {
                    this.outline = this.outline + "X";
                    this.argLimits[m] = 65535;
                    i3 += 2;
                } else if (this.format.substring(i3).startsWith("X")) {
                    this.outline = this.outline + "X";
                    this.argLimits[m] = 15;
                } else if (this.format.substring(i3).startsWith("d")) {
                    this.outline = this.outline + "X";
                    this.argLimits[m] = 7;
                } else if (this.format.substring(i3).startsWith("s")) {
                    this.outline = this.outline + "s, ";
                }
                Integer[] integerArray = this.argMap;
                int n3 = m++;
                Integer.valueOf(integerArray[n3] + (starts[n2++][2] + 1));
                gap = this.format.substring(i3).startsWith("s");
            }
            this.outline = this.outline.replace("%XH", "%X");
            this.outline = this.outline.replace("$%X", "%X");
        }
    }

    public static class OpArg
    extends ArrayList<Token> {
        public String outline = "";

        public OpArg() {
        }

        public OpArg(String arg, Processor proc, LinkedHashMap<String, String> labels) {
            if (arg == null) {
                return;
            }
            Token t = new Token(arg, proc);
            while ((t = t.nextToken()) != null) {
                if (t.type == TokenType.NULL) continue;
                if (t.type == TokenType.LABEL && labels != null && labels.containsKey(t.text)) {
                    t = new Token(labels.get(t.text) + t.source.substring(t.ndx), proc);
                    continue;
                }
                this.add(t);
            }
            this.doGroup(Arrays.asList(Character.valueOf('('), Character.valueOf(')')));
            Iterator it = this.iterator();
            while (it.hasNext()) {
                t = (Token)it.next();
                switch (t.type.ordinal()) {
                    case 0: {
                        this.outline = this.outline + t.symbol;
                        it.remove();
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.outline = this.outline + t.text;
                        it.remove();
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.outline = this.outline + "%X";
                        break;
                    }
                    case 5: {
                        this.outline = this.outline + "%s";
                    }
                }
            }
        }

        public static OpArg getArgs(String argText, Processor processor, LinkedHashMap<String, String> labels) {
            OpArg args = new OpArg();
            argText = argText.toUpperCase() + ",";
            while (argText.length() > 1) {
                int pos = argText.indexOf(44);
                OpArg arg = new OpArg(argText.substring(0, pos++), processor, labels);
                args.addAll(arg);
                args.outline = args.outline + arg.outline + ", ";
                argText = argText.substring(pos);
            }
            args.outline = args.outline.substring(0, Math.max(args.outline.length() - 2, 0));
            return args;
        }

        private void doGroup(List<Character> brackets) {
            int initSize = 0;
            do {
                int end;
                int start = -1;
                initSize = this.size();
                for (end = 0; end < this.size(); ++end) {
                    int n = brackets.indexOf(((Token)this.get((int)end)).symbol);
                    if (n == 0) {
                        start = end;
                    }
                    if (n == 1) break;
                }
                this.doUnary(Arrays.asList(Character.valueOf('+'), Character.valueOf('-')), start + 1, end);
                this.doCalc(Arrays.asList(Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('%')), start + 1, end + this.size() - initSize);
                this.doCalc(Arrays.asList(Character.valueOf('+'), Character.valueOf('-')), start + 1, end + this.size() - initSize);
                if (start <= 0 && (end -= initSize - this.size()) >= this.size() - 1 || end != start + 2) continue;
                this.remove(end);
                this.remove(start);
            } while (this.size() < initSize);
        }

        private void doCalc(List<Character> ops, int start, int end) {
            for (int i = start + 1; i < end - 1; ++i) {
                Character op = ((Token)this.get((int)i)).symbol;
                if (!ops.contains(op)) continue;
                Integer op1 = ((Token)this.get((int)(i - 1))).value;
                Integer op2 = ((Token)this.get((int)(i + 1))).value;
                if (op1 == null || op2 == null) continue;
                Token t = new Token();
                t.value = op.charValue() == '*' ? op1 * op2 : (op.charValue() == '/' ? op1 / op2 : (op.charValue() == '%' ? op1 % op2 : (op.charValue() == '+' ? op1 + op2 : op1 - op2)));
                t.type = this.resultType(((Token)this.get((int)(i - 1))).type, op, ((Token)this.get((int)(i + 1))).type);
                this.removeRange(i - 1, i + 2);
                this.add(i - 1, t);
                end -= 2;
                --i;
            }
        }

        private void doUnary(List<Character> ops, int start, int end) {
            for (int i = start; i < end - 1; ++i) {
                Character op;
                if (i > 0 && ((Token)this.get((int)(i - 1))).type != TokenType.SYMBOL || !ops.contains(op = ((Token)this.get((int)i)).symbol) || ((Token)this.get((int)(i + 1))).value == null) continue;
                if (op.charValue() == '-') {
                    Token token = (Token)this.get(i + 1);
                    Integer.valueOf(token.value * -1);
                    token.value = token.value;
                    if (((Token)this.get((int)(i + 1))).type == TokenType.OFFSET) {
                        ((Token)this.get((int)(i + 1))).type = TokenType.ERROR;
                    }
                }
                this.remove(i);
                --end;
            }
        }

        private TokenType resultType(TokenType t1, Character op, TokenType t2) {
            if (t1 == TokenType.NUMBER && t2 == TokenType.NUMBER) {
                return TokenType.NUMBER;
            }
            if (t1 == TokenType.OFFSET && t2 == TokenType.NUMBER) {
                return TokenType.OFFSET;
            }
            if (t1 == TokenType.NUMBER && t2 == TokenType.OFFSET && op.charValue() == '+') {
                return TokenType.OFFSET;
            }
            return TokenType.ERROR;
        }
    }

    public static class Token {
        public Character symbol = null;
        public String text = null;
        public Integer value = null;
        public TokenType type = null;
        private String source = null;
        private Processor proc = null;
        private int ndx = 0;

        public Token() {
        }

        public Token(String source, Processor proc) {
            this.source = source;
            this.proc = proc;
        }

        public Token nextToken() {
            Token t = new Token(this.source, this.proc);
            t.ndx = this.ndx;
            Character ch = null;
            String s = "";
            int startNdx = this.ndx;
            while ((ch = this.nextChar()) != null && Character.isLetterOrDigit(ch.charValue())) {
                s = s + ch;
            }
            if (s.isEmpty()) {
                if (this.type == TokenType.SYMBOL && this.symbol.charValue() == '$') {
                    this.type = TokenType.OFFSET;
                    this.value = 0;
                }
                if (ch == null) {
                    this.clean();
                    return null;
                }
                t.symbol = ch;
                t.type = TokenType.SYMBOL;
            } else {
                if (ch != null) {
                    --this.ndx;
                }
                if (this.type == TokenType.SYMBOL && this.symbol.charValue() == '$') {
                    Integer val = this.getValue(s, 16);
                    if (val != null) {
                        this.type = TokenType.NUMBER;
                        this.symbol = null;
                        this.value = val;
                        t.type = TokenType.NULL;
                    }
                } else if (this.type == TokenType.PREFIX) {
                    t.value = this.getValue(s, 16);
                    t.type = TokenType.NUMBER;
                } else if (this.proc != null) {
                    for (String px : this.proc.getHexPrefixes()) {
                        if (!s.startsWith(px) || this.getValue(s.substring(px.length()), 16) == null) continue;
                        t.text = px;
                        t.type = TokenType.PREFIX;
                        this.ndx = startNdx;
                        for (int i = 0; i < px.length(); ++i) {
                            this.nextChar();
                        }
                    }
                }
            }
            if (t.type == null) {
                t.value = this.getValue(s, 10);
                if (t.value != null) {
                    t.type = TokenType.NUMBER;
                } else if (this.proc != null && this.proc.getConditionIndex(s) >= 0) {
                    t.text = s;
                    t.type = TokenType.CONDITION_CODE;
                } else {
                    t.text = s;
                    t.type = TokenType.LABEL;
                }
            }
            t.ndx = this.ndx;
            this.clean();
            return t;
        }

        private Character nextChar() {
            while (this.ndx < this.source.length() && Character.isWhitespace(this.source.charAt(this.ndx))) {
                ++this.ndx;
            }
            if (this.ndx >= this.source.length()) {
                return null;
            }
            return Character.valueOf(this.source.charAt(this.ndx++));
        }

        private Integer getValue(String s, int base) {
            if (base == 10 && s.endsWith("H")) {
                base = 16;
                s = s.substring(0, s.length() - 1);
            }
            if (s.isEmpty()) {
                return null;
            }
            String hexChars = "0123456789ABCDEF";
            int val = 0;
            for (int i = 0; i < s.length(); ++i) {
                int n = hexChars.indexOf(s.charAt(i));
                if (n < 0 || base == 10 && n > 9) {
                    return null;
                }
                val = val * base + n;
            }
            return val;
        }

        private void clean() {
            this.source = null;
            this.ndx = 0;
        }
    }

    public static enum TokenType {
        SYMBOL,
        PREFIX,
        LABEL,
        NUMBER,
        OFFSET,
        CONDITION_CODE,
        NULL,
        ERROR;

    }
}

