/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerItem;
import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.AssemblerTableModel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.ManualCodePanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.PropertyFile;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMProtocolBuilder;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.S3C80Processor;
import com.hifiremote.jp1.assembler.CommonData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class AssemblerPanel
extends JPanel
implements ListSelectionListener,
ItemListener {
    private ManualSettingsPanel settingsPanel = null;
    private ManualCodePanel codePanel = null;
    private AssemblerTableModel assemblerModel = null;
    private JP1Table assemblerTable = null;
    private TitledBorder asmBorder = null;
    private ProtocolDataPanel.DisplayArea noteArea = null;
    private RMProtocolBuilder.PBAction rmpbSaveAsAction = null;
    private JButton dialogSaveButton = null;
    public JPanel optionsPanel = null;
    public JCheckBox useRegisterConstants = new JCheckBox("Registers");
    public JCheckBox useFunctionConstants = new JCheckBox("Functions");
    public JRadioButton asCodeButton = new JRadioButton("As code");
    public JRadioButton rcButton = new JRadioButton("Force RCn");
    public JRadioButton wButton = new JRadioButton("Force Wn");
    public JButton importHexButton = new JButton("Import Hex");
    private JToggleButton[] optionButtons = new JToggleButton[]{this.useRegisterConstants, this.useFunctionConstants, this.asCodeButton, this.rcButton, this.wButton, null, null};
    private boolean assembled = false;
    private Processor processor = null;
    private EditorPanel editorPanel = null;
    private JTableX codeTable = null;
    private Processor[] procs = null;
    private PropertyFile properties = JP1Frame.getProperties();
    private ProtocolDataPanel protDataPanel = null;

    public AssemblerPanel(ManualSettingsPanel settingsPanel) {
        this.settingsPanel = settingsPanel;
        this.assemblerModel = settingsPanel.getAssemblerModel();
        this.codePanel = settingsPanel.getTablePanel();
        this.optionButtons[5] = settingsPanel.useRegisterConstants;
        this.optionButtons[6] = settingsPanel.useFunctionConstants;
        this.codeTable = this.codePanel.getCodeTable();
        this.procs = ManualCodePanel.getProcs();
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.assemblerTable = new JP1Table(this.assemblerModel);
        this.assemblerTable.initColumns(this.assemblerModel);
        this.assemblerTable.setSelectionMode(1);
        this.assemblerTable.getSelectionModel().addListSelectionListener(this);
        String noteText = "To build for an S3F80 processor, select S3C80 and add an instruction ORG FF00H in the Assembler listing before pressing the Build button.";
        this.noteArea = new ProtocolDataPanel.DisplayArea(noteText, null);
        this.noteArea.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        this.add((Component)this.noteArea, "First");
        JScrollPane scrollPane = new JScrollPane(this.assemblerTable);
        this.asmBorder = BorderFactory.createTitledBorder("");
        scrollPane.setBorder(this.asmBorder);
        this.add((Component)scrollPane, "Center");
        this.assemblerTable.setLongToolTipTimeout();
        JPanel lowerRightPanel = new JPanel();
        lowerRightPanel.setLayout(new BoxLayout(lowerRightPanel, 3));
        this.optionsPanel = new JPanel();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 3));
        this.optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Disassembly options"), BorderFactory.createEmptyBorder(0, 10, 0, 10)));
        lowerRightPanel.add(this.optionsPanel);
        this.add((Component)lowerRightPanel, "Last");
        JPanel optionPanel = new JPanel(new FlowLayout(1, 5, 0));
        this.useRegisterConstants.addItemListener(this);
        this.useFunctionConstants.addItemListener(this);
        optionPanel.add(new JLabel("Use predefined constants for: "));
        optionPanel.add(this.useRegisterConstants);
        optionPanel.add(this.useFunctionConstants);
        this.optionsPanel.add(optionPanel);
        optionPanel = new JPanel(new GridLayout(1, 4));
        this.asCodeButton.addItemListener(this);
        this.rcButton.addItemListener(this);
        this.wButton.addItemListener(this);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.asCodeButton);
        grp.add(this.rcButton);
        grp.add(this.wButton);
        this.setOptionButtons();
        optionPanel.add(new JLabel("S3C80 only:"));
        optionPanel.add(this.asCodeButton);
        optionPanel.add(this.rcButton);
        optionPanel.add(this.wButton);
        this.optionsPanel.add(optionPanel);
        this.optionsPanel.setVisible(false);
        this.editorPanel = new EditorPanel();
        lowerRightPanel.add(this.editorPanel);
        this.editorPanel.setAssemblerButtons(true);
    }

    public void saveOptionButtons() {
        int opt = 0;
        for (int i = 0; i < this.optionButtons.length; ++i) {
            opt |= this.optionButtons[i].isSelected() ? 1 << i : 0;
        }
        if ((opt ^= 0x60) == 7) {
            this.properties.remove("AssemblerOptions");
        } else {
            this.properties.setProperty("AssemblerOptions", "" + opt);
        }
    }

    private void setOptionButtons() {
        int opt = 7;
        try {
            opt = Integer.parseInt(this.properties.getProperty("AssemblerOptions", "7"));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        opt ^= 0x60;
        for (int i = 0; i < this.optionButtons.length; ++i) {
            this.optionButtons[i].setSelected((opt >> i & 1) == 1);
        }
    }

    public void stopEditing() {
        if (this.assemblerTable.getCellEditor() != null) {
            this.assemblerTable.getCellEditor().stopCellEditing();
        }
    }

    public boolean isAssembled() {
        return this.assembled;
    }

    public void setAssembled(boolean assembled) {
        this.assembled = assembled;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public EditorPanel getEditorPanel() {
        return this.editorPanel;
    }

    public void setProtDataPanel(ProtocolDataPanel protDataPanel) {
        this.protDataPanel = protDataPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.assemblerTable.getSelectionModel()) {
            this.editorPanel.setAssemblerButtons(false);
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.saveOptionButtons();
        ManualProtocol protocol = this.codePanel.getProtocol();
        if (protocol != null && this.codeTable != null) {
            int row = ManualCodePanel.getProcBox().getSelectedIndex();
            Processor proc = this.procs[row];
            Hex hex = (Hex)this.codePanel.getCodeModel().getValueAt(row, 1);
            this.assemblerModel.disassemble(hex, proc);
        }
    }

    public void setRmpbSaveAsAction(RMProtocolBuilder.PBAction rmpbSaveAsAction) {
        this.rmpbSaveAsAction = rmpbSaveAsAction;
    }

    public void setDialogSaveButton(JButton dialogSaveButton) {
        this.dialogSaveButton = dialogSaveButton;
    }

    public class EditorPanel
    extends JPanel
    implements ActionListener {
        private JButton moveUp = new JButton("Up");
        private JButton moveDown = new JButton("Down");
        private JButton insert = new JButton("Insert");
        private JButton delete = new JButton("Delete");
        private JButton selectAll = new JButton("Select All");
        private JButton copy = new JButton("Copy");
        private JButton cut = new JButton("Cut");
        private JButton paste = new JButton("Paste");
        private JButton assemble = new JButton("Assemble");
        private List<AssemblerItem> cutItems = null;
        public JButton build = new JButton("Build");
        public JButton update = new JButton("Update");

        public EditorPanel() {
            this.setLayout(new GridLayout(3, 5));
            this.setMinimumSize(new Dimension(10, 10));
            this.add(this.insert);
            this.add(this.copy);
            this.add(new JLabel());
            this.add(this.assemble);
            this.add(this.delete);
            this.add(this.cut);
            this.add(new JLabel());
            this.add(this.build);
            this.add(this.selectAll);
            this.add(this.paste);
            this.add(new JLabel());
            this.add(this.update);
            this.moveUp.addActionListener(this);
            this.moveDown.addActionListener(this);
            this.insert.addActionListener(this);
            this.delete.addActionListener(this);
            this.cut.addActionListener(this);
            this.copy.addActionListener(this);
            this.paste.addActionListener(this);
            this.paste.setEnabled(false);
            this.build.addActionListener(this);
            this.update.addActionListener(this);
            this.selectAll.addActionListener(this);
            this.assemble.addActionListener(this);
            AssemblerPanel.this.importHexButton.setToolTipText("Import hex code of selected processors for analysis or editing");
            AssemblerPanel.this.importHexButton.addActionListener(this);
            this.insert.setToolTipText("Inserts above selection a number of rows equal to the number selected.");
            this.delete.setToolTipText("Deletes the rows containing selected cells.");
            this.copy.setToolTipText("Copies to clipboard the rows containing selected cells.");
            this.cut.setToolTipText("Copies to clipboard the rows containing selected cells, then deletes these rows.");
            this.paste.setToolTipText("Inserts rows from clipboard above current selection.");
            this.selectAll.setToolTipText("Selects all the rows of the currently selected listing.");
            this.assemble.setToolTipText("Assembles binary code from assembler listing and updates protocol code with result.");
            this.build.setToolTipText("Builds complete assembler listing for a protocol from data in Protocol Data tab.");
            this.update.setToolTipText("Updates the data section of an assembler listing from Protocol Data tab.");
            JP1Frame frame = RemoteMaster.getFrame();
            this.cutItems = frame instanceof RMIRSetup ? ((RMIRSetup)frame).getClipBoardItems() : (frame instanceof KeyMapMaster ? ((KeyMapMaster)frame).getClipBoardItems() : new ArrayList());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (Arrays.asList(this.insert, this.delete, this.moveUp, this.moveDown, this.copy, this.cut, this.paste).contains(source)) {
                if (AssemblerPanel.this.assemblerTable.getCellEditor() != null) {
                    AssemblerPanel.this.assemblerTable.getCellEditor().stopCellEditing();
                }
                List<AssemblerItem> itemList = AssemblerPanel.this.assemblerModel.getItemList();
                int row = AssemblerPanel.this.assemblerTable.getSelectedRow();
                int col = AssemblerPanel.this.assemblerTable.getSelectedColumn();
                int rowCount = AssemblerPanel.this.assemblerTable.getSelectedRowCount();
                int colCount = AssemblerPanel.this.assemblerTable.getSelectedColumnCount();
                if (source == this.insert) {
                    for (int i = 0; i < rowCount; ++i) {
                        itemList.add(row, new AssemblerItem());
                    }
                    AssemblerPanel.this.assemblerModel.fireTableDataChanged();
                    AssemblerPanel.this.assemblerTable.changeSelection(row + rowCount, col, false, false);
                    AssemblerPanel.this.assemblerTable.changeSelection(row + 2 * rowCount - 1, col + colCount - 1, false, true);
                } else if (source == this.paste) {
                    itemList.addAll(row, this.cutItems);
                    AssemblerPanel.this.assemblerModel.fireTableDataChanged();
                    AssemblerPanel.this.assemblerTable.changeSelection(row, col, false, false);
                    AssemblerPanel.this.assemblerTable.changeSelection(row + this.cutItems.size() - 1, col + colCount - 1, false, true);
                } else if (source == this.delete || source == this.cut || source == this.copy) {
                    int i;
                    if (!AssemblerPanel.this.assemblerModel.testBuildMode(AssemblerPanel.this.processor)) {
                        for (i = 0; i < rowCount; ++i) {
                            String op = (String)AssemblerPanel.this.assemblerModel.getValueAt(row + i, 3);
                            if (!op.equalsIgnoreCase("ORG")) continue;
                            String title = "Assembler edit";
                            String message = "You cannot include an ORG instruction in this operation unless\nin Build mode, which is when the Assemble and Update buttons\nare disabled.";
                            JOptionPane.showMessageDialog(AssemblerPanel.this.settingsPanel.getAssemblerPanel(), message, title, 2);
                            return;
                        }
                    }
                    if (source == this.cut || source == this.copy) {
                        this.cutItems.clear();
                        this.cutItems.addAll(itemList.subList(row, row + rowCount));
                        this.paste.setEnabled(true);
                    }
                    if (source == this.delete || source == this.cut) {
                        for (i = 0; i < rowCount; ++i) {
                            itemList.remove(row);
                        }
                        if (itemList.size() == 0) {
                            itemList.add(new AssemblerItem());
                        }
                        AssemblerPanel.this.assemblerModel.fireTableDataChanged();
                        AssemblerPanel.this.assemblerTable.changeSelection(row, col, false, false);
                        AssemblerPanel.this.assemblerTable.changeSelection(row, col + colCount - 1, false, true);
                    }
                }
                this.setAssemblerButtons(false);
            } else if (source == this.selectAll) {
                AssemblerPanel.this.assemblerTable.changeSelection(0, 0, false, false);
                AssemblerPanel.this.assemblerTable.changeSelection(AssemblerPanel.this.assemblerModel.getItemList().size() - 2, AssemblerPanel.this.assemblerTable.getColumnCount() - 1, false, true);
            } else if (source == this.assemble) {
                int row = ManualCodePanel.getProcBox().getSelectedIndex();
                Processor proc = AssemblerPanel.this.procs[row];
                if (AssemblerPanel.this.assemblerTable.getCellEditor() != null) {
                    AssemblerPanel.this.assemblerTable.getCellEditor().stopCellEditing();
                }
                Hex hex = AssemblerPanel.this.assemblerModel.assemble(proc);
                AssemblerPanel.this.assemblerModel.fireTableDataChanged();
                if (hex != null) {
                    if (AssemblerPanel.this.codePanel.getCodeModel().isCellEditable(row, 1)) {
                        AssemblerPanel.this.assembled = true;
                        AssemblerPanel.this.codePanel.getCodeModel().setValueAt(hex, row, 1);
                        AssemblerPanel.this.assembled = false;
                    } else {
                        String title = "Assemble";
                        String message = "The code for this processor is not editable, so the assembled\nhex code will not be saved in the .rmdu/.rmir file.  You may,\nhowever, use the Save button to save the assembly source as a\nseparate file.";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                    }
                }
            } else if (source == AssemblerPanel.this.importHexButton) {
                ManualProtocol protocol = AssemblerPanel.this.codePanel.getProtocol();
                if (protocol != null) {
                    int[] rows = AssemblerPanel.this.codeTable.getSelectedRows();
                    int firstRow = -1;
                    for (int row : rows) {
                        Hex hex;
                        Processor proc = AssemblerPanel.this.procs[row];
                        if (firstRow < 0) {
                            firstRow = row;
                        }
                        if ((hex = (Hex)AssemblerPanel.this.codePanel.getCodeModel().getValueAt(row, 1)) == null || hex.length() <= 0) continue;
                        ManualCodePanel.getProcBox().setSelectedItem(proc);
                        if (proc.getDataStyle() >= 0) {
                            AssemblerPanel.this.settingsPanel.setMode(ProtocolDataPanel.Mode.ASM);
                            AssemblerTableModel.DisasmState state = null;
                            state = new AssemblerTableModel.DisasmState();
                            state.useFunctionConstants = ((AssemblerPanel)AssemblerPanel.this).settingsPanel.useFunctionConstants.isSelected();
                            state.useRegisterConstants = ((AssemblerPanel)AssemblerPanel.this).settingsPanel.useRegisterConstants.isSelected();
                            AssemblerPanel.this.assemblerModel.disassemble(hex, proc, state);
                        }
                        protocol.setCode(hex, proc);
                    }
                    if (firstRow >= 0) {
                        ManualCodePanel.getProcBox().setSelectedItem(AssemblerPanel.this.procs[firstRow]);
                    }
                    this.setAssemblerButtons(false);
                    AssemblerPanel.this.codePanel.getCodeTable().repaint();
                }
            } else if (source == this.update || source == this.build) {
                AssemblerPanel.this.stopEditing();
                if (source == this.build) {
                    Iterator<AssemblerItem> it = AssemblerPanel.this.assemblerModel.getItemList().iterator();
                    while (it.hasNext()) {
                        if (it.next().getOperation().equalsIgnoreCase("ORG")) continue;
                        it.remove();
                    }
                }
                if (AssemblerPanel.this.processor instanceof S3C80Processor && AssemblerPanel.this.assemblerModel.testBuildMode(AssemblerPanel.this.processor)) {
                    AssemblerPanel.this.processor = ProcessorManager.getProcessor("S3C80");
                }
                int ramAddress = AssemblerPanel.this.processor.getRAMAddress();
                int i = 0;
                boolean hasOrg = false;
                AssemblerItem startItem = null;
                AssemblerItem endItem = null;
                ArrayList<AssemblerItem> newItemList = new ArrayList<AssemblerItem>();
                AssemblerPanel.this.protDataPanel.setShowMessages(false);
                AssemblerPanel.this.protDataPanel.setAssemblerData(!((AssemblerPanel)AssemblerPanel.this).protDataPanel.pfMainPanel.isActive() && !((AssemblerPanel)AssemblerPanel.this).protDataPanel.pdMainPanel.isActive());
                int length = 0;
                int endDirectives = 0;
                int end = 2;
                i = 0;
                for (i = 0; i < AssemblerPanel.this.assemblerModel.getItemList().size(); ++i) {
                    String op;
                    AssemblerItem item = AssemblerPanel.this.assemblerModel.getItemList().get(i);
                    if (item.isCommentedOut()) continue;
                    if (item.getOperation().equalsIgnoreCase("ORG")) {
                        hasOrg = true;
                        for (AssemblerOpCode.Token t : AssemblerOpCode.OpArg.getArgs(item.getArgumentText(), null, null)) {
                            ramAddress = t.value;
                        }
                        if (AssemblerPanel.this.processor instanceof S3C80Processor) {
                            AssemblerPanel.this.processor = ProcessorManager.getProcessor((ramAddress & 0xC000) == 49152 ? "S3F80" : "S3C80");
                            AssemblerPanel.this.settingsPanel.setProcessor(AssemblerPanel.this.processor);
                            ramAddress = AssemblerPanel.this.processor.getRAMAddress();
                        }
                    }
                    if (length == AssemblerPanel.this.processor.getStartOffset() && ((op = item.getOperation()).equals("JR") || op.equals("BRA"))) {
                        int j;
                        end += length;
                        startItem = item;
                        for (j = i + 1; j < AssemblerPanel.this.assemblerModel.getItemList().size(); ++j) {
                            AssemblerItem item2 = AssemblerPanel.this.assemblerModel.getItemList().get(j);
                            if (item2.isCommentedOut()) continue;
                            if (Arrays.asList(item.getArgumentText(), item.getArgumentText() + ":").contains(item2.getLabel())) break;
                            end += item2.getLength();
                        }
                        if (j == AssemblerPanel.this.assemblerModel.getItemList().size()) {
                            end += item.getHex().getData()[1];
                        }
                    }
                    if (!((length += item.getLength()) != 0 || item.getOperation().trim().isEmpty() && item.getArgumentText().trim().isEmpty() && item.getComments().trim().isEmpty())) {
                        newItemList.add(item);
                        endDirectives = newItemList.size();
                    }
                    if (length >= 5) break;
                }
                if (startItem == null) {
                    if (length > AssemblerPanel.this.processor.getStartOffset()) {
                        String message = "Cannot get data as code is not a valid protocol format.\n\nGet Data will only get data from the Protocol Data etc tabs into a protocol that is\nalready properly structured, so if you enter code into the listing grid, assemble it and\nTHEN try to get the data bytes into it, it won't work. Begin with a basic Build. You can\npress Build right at the start. You don't need to put the proper, or even any, values\ninto the Protocol Data tab, it will work with just the defaults and you can change the\ndata later. The basic build will give you only one assembler instruction following the\ndata block, JP XmitIR or the equivalent for other processors. Replace this with whatever\ncode you want.\n\nIf you forget to do the initial build and have already entered assembler code, use Cut and\nPaste. Select it all, Cut, then press Build with the empty assembler grid that results, and\nfinally Paste the cut data at the end of the build. After that, you can change the data and\nuse Get Data as required.";
                        String title = "Update Data";
                        JOptionPane.showMessageDialog(this, message, title, 1);
                        return;
                    }
                    String op = AssemblerPanel.this.processor instanceof S3C80Processor ? "JR" : "BRA";
                    startItem = new AssemblerItem(ramAddress + AssemblerPanel.this.processor.getStartOffset(), op, "L0");
                    op = AssemblerPanel.this.processor instanceof S3C80Processor ? "JP" : "JMP";
                    endItem = new AssemblerItem(0, op, "XmitIR");
                }
                AssemblerTableModel.DisasmState state = new AssemblerTableModel.DisasmState();
                i = AssemblerPanel.this.assemblerModel.getPfCount() + AssemblerPanel.this.assemblerModel.getPdCount();
                List oldItemList = AssemblerPanel.this.assemblerModel.getData();
                AssemblerPanel.this.assemblerModel.setItemList(newItemList);
                AssemblerPanel.this.assemblerModel.dbOut(0, AssemblerPanel.this.processor.getStartOffset(), ramAddress, 0, AssemblerPanel.this.processor);
                newItemList.add(startItem);
                AssemblerPanel.this.assemblerModel.dbOut(AssemblerPanel.this.processor.getStartOffset() + 2, i + 5, ramAddress, 0, AssemblerPanel.this.processor);
                if (endItem == null) {
                    startItem.getHex().set((short)(i + 3 - AssemblerPanel.this.processor.getStartOffset()), 1);
                    length = 0;
                    i += ramAddress + 5;
                    for (AssemblerItem item : oldItemList) {
                        if (length >= end && item.getOpCode() != null) {
                            item.setAddress(i);
                            newItemList.add(item);
                            i += item.getLength();
                        }
                        length += item.getLength();
                    }
                } else {
                    LinkedHashMap<String, String> labels = AssemblerPanel.this.processor.getAsmLabels();
                    labels.put("L0", String.format("%04XH", ramAddress + i + 5));
                    LinkedHashMap<Integer, String> rptLabels = new LinkedHashMap<Integer, String>();
                    rptLabels.put(ramAddress + i + 5, "L0");
                    int rptVal = AssemblerPanel.this.assemblerModel.getForcedRptCount();
                    Hex hx = new Hex(CommonData.forcedRptCode[AssemblerPanel.this.protDataPanel.getDataStyle()]);
                    if (AssemblerPanel.this.protDataPanel.getRptType() == 0 && rptVal > 0) {
                        short rpt = (short)rptVal;
                        switch (AssemblerPanel.this.protDataPanel.getDataStyle()) {
                            case 0: {
                                hx.set(rpt, 2);
                                break;
                            }
                            case 1: 
                            case 2: {
                                hx.set(rpt, 1);
                                break;
                            }
                            case 3: {
                                int op = hx.getData()[0] * 256;
                                hx = new Hex(2 * (rpt - 1));
                                for (int j = 0; j < rpt - 1; ++j) {
                                    hx.put(op + 2 * (rpt - j - 2), 2 * j);
                                }
                                labels.put("L1", String.format("%04XH", ramAddress + i + 5 + hx.length()));
                                rptLabels.put(ramAddress + i + 5 + hx.length(), "L1");
                                break;
                            }
                            case 4: {
                                hx.set((short)(rpt - 1), 1);
                            }
                        }
                        while (hx.length() > 0) {
                            AssemblerItem item = new AssemblerItem(ramAddress + i + 5, hx);
                            int opLen = item.disassemble(AssemblerPanel.this.processor, rptLabels, state);
                            String lbl = rptLabels.get(item.getAddress());
                            if (lbl != null) {
                                item.setLabel(lbl + ":");
                            }
                            newItemList.add(item);
                            hx = hx.subHex(opLen);
                            i += opLen;
                        }
                        if (AssemblerPanel.this.protDataPanel.getDataStyle() != 3) {
                            state.zeroUsed.add(AssemblerPanel.this.processor.getZeroAddresses().get("RPT"));
                        }
                    }
                    endItem.setAddress(ramAddress + i + 5);
                    String lbl = (String)rptLabels.get(endItem.getAddress());
                    if (lbl != null) {
                        endItem.setLabel(lbl + ":");
                    }
                    if (AssemblerPanel.this.protDataPanel.getBurstMidFrame() == 1) {
                        endItem.setArgumentText("XmitSplitIR");
                    }
                    state.absUsed.add(AssemblerPanel.this.processor.getAbsAddresses().get(endItem.getArgumentText()));
                    newItemList.add(endItem);
                    startItem.assemble(AssemblerPanel.this.processor, labels, true);
                    endItem.assemble(AssemblerPanel.this.processor, labels, true);
                    AssemblerPanel.this.assemblerModel.insertEQU(endDirectives, AssemblerPanel.this.processor, state);
                    if (!hasOrg) {
                        AssemblerPanel.this.assemblerModel.insertORG(endDirectives, ramAddress, AssemblerPanel.this.processor);
                    }
                }
                newItemList.add(new AssemblerItem());
                AssemblerPanel.this.assemblerModel.getData().clear();
                AssemblerPanel.this.assemblerModel.getData().addAll(newItemList);
                AssemblerPanel.this.assemblerModel.setItemList(AssemblerPanel.this.assemblerModel.getData());
                AssemblerPanel.this.assemblerModel.setChanged(true);
                this.setAssemblerButtons(false);
                AssemblerPanel.this.protDataPanel.interpretPFPD(false);
                ((AssemblerPanel)AssemblerPanel.this).protDataPanel.pfMainPanel.set();
                ((AssemblerPanel)AssemblerPanel.this).protDataPanel.pdMainPanel.set();
                ((AssemblerPanel)AssemblerPanel.this).protDataPanel.fnMainPanel.set();
                AssemblerPanel.this.protDataPanel.setShowMessages(true);
                AssemblerPanel.this.assemblerModel.fireTableDataChanged();
                this.actionPerformed(new ActionEvent(this.assemble, 1001, ""));
            }
        }

        public void setAssemblerButtons(boolean retitle) {
            if (AssemblerPanel.this.processor == null || AssemblerPanel.this.processor.getDataStyle() < 0) {
                return;
            }
            boolean valid = AssemblerPanel.this.codeTable != null;
            boolean asm = valid && AssemblerPanel.this.settingsPanel.getMode() == ProtocolDataPanel.Mode.ASM;
            boolean sel = valid;
            this.assemble.setEnabled(asm && !AssemblerPanel.this.assemblerModel.testBuildMode(AssemblerPanel.this.processor));
            this.insert.setEnabled(asm && sel);
            this.delete.setEnabled(asm && sel);
            this.build.setEnabled(asm);
            this.update.setEnabled(asm && !AssemblerPanel.this.assemblerModel.testBuildMode(AssemblerPanel.this.processor));
            this.cut.setEnabled(asm && sel);
            this.paste.setEnabled(asm && sel && this.cutItems.size() > 0);
            this.copy.setEnabled(sel);
            this.selectAll.setEnabled(valid);
            if (AssemblerPanel.this.rmpbSaveAsAction != null) {
                AssemblerPanel.this.rmpbSaveAsAction.setEnabled(valid && !AssemblerPanel.this.assemblerModel.testBuildMode(AssemblerPanel.this.processor));
            }
            if (AssemblerPanel.this.dialogSaveButton != null) {
                AssemblerPanel.this.dialogSaveButton.setEnabled(valid && !AssemblerPanel.this.assemblerModel.testBuildMode(AssemblerPanel.this.processor));
            }
            if (retitle) {
                String title = asm ? "Assembler listing (editable)" : "Disassembler listing (not editable)";
                AssemblerPanel.this.asmBorder.setTitle(title);
                AssemblerPanel.this.noteArea.setVisible(asm);
                AssemblerPanel.this.editorPanel.setVisible(asm);
                this.repaint();
            }
        }

        public JButton getAssemble() {
            return this.assemble;
        }
    }
}

