/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AssemblerItem;
import com.hifiremote.jp1.AssemblerOpCode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.ManualSettingsPanel;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.ProtocolDataPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.S3C80Processor;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.assembler.CommonData;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AssemblerTableModel
extends JP1TableModel<AssemblerItem> {
    private Hex hex = null;
    private List<AssemblerItem> itemList = new ArrayList<AssemblerItem>();
    private int pfCount = 0;
    private int pdCount = 0;
    private int codeIndex = 0;
    private int midFrameIndex = 0;
    private int forcedRptCount = 0;
    private Remote remote = null;
    private short[] data = null;
    private static final String[] colNames = new String[]{"Addr", "Code", "Label", "Op", "Op Args", "Comments"};
    private static final String[] colPrototypeNames = new String[]{"0000", "00 00 00 00_", "XMITIR_", "AAAAA", "DCBUF+1, DCBUF+2_", "Carrier OFF: 99.999 uSec"};
    public ManualSettingsPanel settingsPanel = null;
    private AssemblerCellEditor assemblerCellEditor = new AssemblerCellEditor();
    private AssemblerCellRenderer assemblerCellRenderer = new AssemblerCellRenderer();

    public AssemblerTableModel() {
        this.setData(this.itemList);
        this.assemblerCellEditor.setClickCountToStart(1);
    }

    public void setRemote(Remote remote) {
        this.remote = remote;
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col <= 1;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col > 1 && this.settingsPanel.getMode() == ProtocolDataPanel.Mode.ASM;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        return this.assemblerCellEditor;
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        return this.assemblerCellRenderer;
    }

    public void setChanged(boolean changed) {
        this.settingsPanel.setChanged(changed);
    }

    @Override
    public Object getValueAt(int row, int column) {
        AssemblerItem item = (AssemblerItem)this.getRow(row);
        return item.getElement(column);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        this.setChanged(true);
        Processor processor = this.settingsPanel.getAssemblerPanel().getProcessor();
        if (row == this.itemList.size() - 1) {
            this.itemList.add(new AssemblerItem());
        }
        AssemblerItem item = (AssemblerItem)this.getRow(row);
        String text = (String)value;
        switch (column) {
            case 1: {
                item.setHex(new Hex(text));
                return;
            }
            case 2: {
                item.setLabel(text);
                return;
            }
            case 3: {
                String op;
                if (!this.testBuildMode(processor) && (op = (String)this.getValueAt(row, 3)).equalsIgnoreCase("ORG")) {
                    this.showOrgMessage();
                    return;
                }
                item.setOperation(text);
                return;
            }
            case 4: {
                item.setArgumentText(text);
                return;
            }
            case 5: {
                item.setComments(text);
                return;
            }
        }
    }

    public Hex getHex() {
        return this.hex;
    }

    public void setHex(Hex hex) {
        this.hex = hex;
    }

    /*
     * WARNING - void declaration
     */
    public Hex assemble(Processor processor) {
        void var4_7;
        this.pfCount = 0;
        this.pdCount = 0;
        this.codeIndex = 0;
        this.midFrameIndex = 0;
        this.forcedRptCount = 0;
        int addr = processor.getRAMAddress();
        for (AssemblerItem assemblerItem : this.itemList) {
            if (assemblerItem.isCommentedOut() || !assemblerItem.getOperation().equalsIgnoreCase("ORG")) continue;
            for (AssemblerOpCode.Token t : AssemblerOpCode.OpArg.getArgs(assemblerItem.getArgumentText(), null, null)) {
                addr = t.value;
            }
        }
        if (processor instanceof S3C80Processor) {
            processor = ProcessorManager.getProcessor((addr & 0xC000) == 49152 ? "S3F80" : "S3C80");
        }
        this.settingsPanel.setProcessor(processor);
        LinkedHashMap<String, String> asmLabels = processor.getAsmLabels();
        for (AssemblerItem item : this.itemList) {
            if (item.isCommentedOut() || item.getLabel().isEmpty()) continue;
            Object lbl = item.getLabel().trim().toUpperCase();
            String txt = null;
            if (((String)lbl).endsWith(":")) {
                lbl = ((String)lbl).substring(0, ((String)lbl).length() - 1);
            }
            if (item.getOperation().equals("EQU")) {
                txt = item.getArgumentText().toUpperCase();
                AssemblerOpCode opCode = new AssemblerOpCode();
                opCode.setName("EQU");
                opCode.setLength(0);
                item.setOpCode(opCode);
            } else {
                txt = "FFFFH";
            }
            asmLabels.put((String)lbl, txt);
        }
        boolean bl = false;
        AssemblerItem orgItem = null;
        for (AssemblerItem item : this.itemList) {
            if (item.isCommentedOut()) {
                item.setAddress(0);
                item.setHex(new Hex());
                continue;
            }
            String op = item.getOperation().toUpperCase();
            if (op.isEmpty()) continue;
            if (Arrays.asList("DB", "DW", "ORG").contains(op)) {
                item.setErrorCode(0);
                if (op.equals("ORG") && orgItem == null) {
                    orgItem = item;
                }
                AssemblerOpCode.OpArg args = AssemblerOpCode.OpArg.getArgs(item.getArgumentText(), null, asmLabels);
                AssemblerOpCode opCode = new AssemblerOpCode();
                opCode.setName(op);
                opCode.setLength(0);
                AssemblerOpCode.AddressMode mode = opCode.getMode();
                mode.length = op.equals("ORG") ? 0 : (op.equals("DB") ? args.size() : 2 * args.size());
                for (int i = 0; i < args.size() - 1; ++i) {
                    mode.outline = mode.outline + "%X, ";
                }
                if (args.size() > 0) {
                    mode.outline = mode.outline + "%X";
                }
                if (!args.outline.equals(mode.outline) || op.equals("ORG") && args.size() > 1) {
                    item.setErrorCode(2);
                }
                Hex hx = new Hex(mode.length);
                for (AssemblerOpCode.Token t : args) {
                    if (t.value >= 0 && t.value <= (op.equals("DB") ? 255 : 65535)) continue;
                    item.setErrorCode(5);
                }
                int n = 0;
                if (item.getErrorCode() == 0) {
                    for (AssemblerOpCode.Token t : args) {
                        if (op.equals("ORG")) {
                            addr = t.value;
                            continue;
                        }
                        if (op.equals("DB")) {
                            hx.set((short)t.value.intValue(), n++);
                            continue;
                        }
                        hx.put(t.value, n);
                        n += 2;
                    }
                }
                item.setHex(hx);
                item.setOpCode(opCode);
                if (!op.equals("ORG")) {
                    item.setAddress(addr);
                }
            } else if (!op.equals("EQU")) {
                item.setAddress(addr);
                item.assemble(processor, asmLabels, false);
                if (!item.getLabel().isEmpty()) {
                    String txt = item.getLabel().toUpperCase();
                    if (txt.endsWith(":")) {
                        txt = txt.substring(0, txt.length() - 1);
                    }
                    asmLabels.put(txt, Integer.toString(addr));
                }
            }
            addr += item.getLength();
            var4_7 += item.getLength();
        }
        boolean valid = true;
        Hex hexOut = new Hex((int)var4_7);
        int n = 0;
        for (AssemblerItem item : this.itemList) {
            if (item.isCommentedOut() || item.getOpCode() == null) continue;
            if (item.getOpCode().getMode().relMap != 0 || item.getOpCode().getMode().absMap != 0) {
                item.assemble(processor, asmLabels, true);
            }
            boolean bl2 = valid = valid && item.getErrorCode() == 0;
            if (valid && item.getHex() != null) {
                hexOut.put(item.getHex(), n);
                String op = item.getOperation();
                if (n == processor.getStartOffset() && (op.equals("JR") || op.equals("BRA"))) {
                    this.pdCount = item.getHex().getData()[1] + processor.getStartOffset() - 3;
                }
            }
            if (this.pdCount == 0 || n < this.pdCount + 5) {
                ++this.codeIndex;
            }
            n += item.getLength();
        }
        if (valid) {
            if (this.pdCount > 0) {
                this.pfCount = 1;
                while (this.pfCount < this.pdCount && this.pfCount < processor.getZeroSizes().get("PF0") && hexOut.getData()[this.pfCount + 4] >> 7 == 1) {
                    ++this.pfCount;
                }
                this.pdCount -= this.pfCount;
            }
            this.data = hexOut.getData();
            if (orgItem != null) {
                orgItem.setComments("Byte count = " + hexOut.length());
            }
            this.midFrameIndex = this.seekBurstMidFrame(processor);
            this.forcedRptCount = this.seekForcedRepeat(processor);
            return hexOut;
        }
        if (orgItem != null) {
            orgItem.setErrorCode(6);
        }
        this.pdCount = 0;
        return null;
    }

    public void disassemble(Hex hexD, Processor processor) {
        this.disassemble(hexD, processor, null);
    }

    public void disassemble(Hex hexD, Processor processor, DisasmState state) {
        this.itemList.clear();
        if (processor.getDataStyle() < 0) {
            this.fireTableDataChanged();
            return;
        }
        this.hex = hexD == null ? new Hex(0) : new Hex(hexD);
        ArrayList<Integer> labelAddresses = new ArrayList<Integer>();
        Arrays.fill((Object[])this.settingsPanel.getProtDataPanel().getBasicValues(), null);
        Arrays.fill((Object[])this.settingsPanel.getProtDataPanel().getPfValues(), null);
        Arrays.fill((Object[])this.settingsPanel.getProtDataPanel().getPdValues(), null);
        this.pfCount = 0;
        this.pdCount = 0;
        this.codeIndex = 0;
        this.midFrameIndex = 0;
        this.forcedRptCount = 0;
        int addr = processor.getRAMAddress();
        this.settingsPanel.getProtDataPanel().setDataStyle(processor.getDataStyle());
        this.settingsPanel.setProcessor(processor);
        if (state == null) {
            state = new DisasmState();
            state.useFunctionConstants = this.settingsPanel.getAssemblerPanel().useFunctionConstants.isSelected();
            state.useRegisterConstants = this.settingsPanel.getAssemblerPanel().useRegisterConstants.isSelected();
            state.toRC = this.settingsPanel.getAssemblerPanel().rcButton.isSelected();
            state.toW = this.settingsPanel.getAssemblerPanel().wButton.isSelected();
        }
        this.settingsPanel.getFnMainPanel().setAbsUsed(state.absUsed);
        this.settingsPanel.getFnMainPanel().setZeroUsed(state.zeroUsed);
        if (this.hex != null && this.hex.length() > 0) {
            int opLength;
            int index;
            AssemblerOpCode.AddressMode mode;
            AssemblerOpCode oc;
            S3C80Processor.CodeType type;
            if (processor instanceof S3C80Processor && ((type = ((S3C80Processor)processor).testCode(this.hex)) == S3C80Processor.CodeType.NEW || type == S3C80Processor.CodeType.UNKNOWN && this.remote != null && this.remote.getProcessor().getEquivalentName().equals("S3C80") && this.remote.getRAMAddress() == 65280)) {
                addr = 65280;
                processor = ProcessorManager.getProcessor("S3F80");
                this.settingsPanel.setProcessor(processor);
            }
            this.dbOut(0, processor.getStartOffset(), addr, 0, processor);
            Hex pHex = this.hex.subHex(processor.getStartOffset());
            short[] data = pHex.getData();
            addr += processor.getStartOffset();
            for (index = 0; index < pHex.length(); index += oc.getLength() + mode.length) {
                int newAddr;
                int n;
                oc = processor.getOpCode(pHex.subHex(index));
                mode = oc.getMode();
                int i = 0;
                while (mode.relMap >> i != 0) {
                    if ((mode.relMap >> i & 1) == 1 && (n = index + oc.getLength() + mode.nibbleBytes + i) < data.length && !labelAddresses.contains(newAddr = addr + data[n] + n + 1 - (data[n] > 127 ? 256 : 0))) {
                        labelAddresses.add(newAddr);
                    }
                    ++i;
                }
                if (processor instanceof S3C80Processor) {
                    i = 0;
                    while (mode.absMap >> i != 0) {
                        if ((mode.absMap >> i & 1) == 1 && (n = index + oc.getLength() + mode.nibbleBytes + i) < data.length - 1 && (newAddr = (data[n] << 8) + data[n + 1]) >= addr && newAddr < addr + pHex.length() && !labelAddresses.contains(newAddr)) {
                            labelAddresses.add(newAddr);
                        }
                        ++i;
                    }
                }
                if (index != 0 || !oc.getName().equals("JR") && !oc.getName().equals("BRA")) continue;
                index += data[1];
            }
            Collections.sort(labelAddresses);
            LinkedHashMap<Integer, String> labels = new LinkedHashMap<Integer, String>();
            for (int i = 0; i < labelAddresses.size(); ++i) {
                labels.put((Integer)labelAddresses.get(i), "L" + i);
            }
            for (index = 0; index < pHex.length(); index += opLength) {
                AssemblerItem item = new AssemblerItem(addr + index, pHex.subHex(index));
                opLength = item.disassemble(processor, labels, state);
                if (opLength == 0) {
                    this.dbOut(index, pHex.length(), addr, processor.getStartOffset(), processor);
                    break;
                }
                this.itemList.add(item);
                if (index != 0 || !item.getOperation().equals("JR") && !item.getOperation().equals("BRA")) continue;
                short skip = data[1];
                this.pfCount = this.dbOut(index + 2, index + 2 + skip, addr, processor.getStartOffset(), processor);
                this.pdCount = skip + processor.getStartOffset() - this.pfCount - 3;
                this.codeIndex = this.itemList.size();
                this.settingsPanel.interpretPFPD();
                index += data[1];
            }
            int n = 0;
            for (Integer address : labels.keySet()) {
                if (state.relUsed.contains(address)) continue;
                AssemblerItem item = new AssemblerItem();
                item.setLabel(labels.get(address) + ":");
                item.setOperation("EQU");
                String format = processor.getAddressModes().get((Object)"EQU4").format;
                item.setArgumentText(String.format(format, address));
                this.itemList.add(n++, item);
            }
            this.codeIndex += this.insertEQU(0, processor, state) + n;
            this.insertORG(0, processor.getRAMAddress(), processor);
            this.itemList.get(0).setComments("Byte count = " + this.hex.length());
        }
        this.itemList.add(new AssemblerItem());
        this.midFrameIndex = this.seekBurstMidFrame(processor);
        this.forcedRptCount = this.seekForcedRepeat(processor);
        this.fireTableDataChanged();
    }

    public void insertORG(int index, int address, Processor processor) {
        AssemblerItem item = new AssemblerItem();
        item.setOperation("ORG");
        AssemblerOpCode opCode = new AssemblerOpCode();
        opCode.setName("ORG");
        opCode.setLength(0);
        opCode.getMode().length = 0;
        item.setOpCode(opCode);
        String format = processor.getAddressModes().get((Object)"EQU4").format;
        item.setArgumentText(String.format(format, address));
        this.itemList.add(index, item);
    }

    public int insertEQU(int index, Processor processor, DisasmState state) {
        String format;
        AssemblerItem item;
        int count = 0;
        Collections.sort(state.zeroUsed);
        if (state.useRegisterConstants) {
            for (int address : state.zeroUsed) {
                item = new AssemblerItem();
                item.setZeroLabel(processor, address, null, ":");
                item.setOperation("EQU");
                format = null;
                format = processor.getAddressModes().get("EQUR") == null ? processor.getAddressModes().get((Object)"EQU2").format : processor.getAddressModes().get((Object)"EQUR").format;
                item.setArgumentText(String.format(format, address));
                this.itemList.add(index++, item);
                ++count;
            }
        }
        Collections.sort(state.absUsed);
        if (state.useFunctionConstants) {
            for (int address : state.absUsed) {
                item = new AssemblerItem();
                item.setLabel(processor.getAbsLabels().get(address) + ":");
                item.setOperation("EQU");
                format = processor.getAddressModes().get((Object)"EQU4").format;
                item.setArgumentText(String.format(format, address));
                this.itemList.add(index++, item);
                ++count;
            }
        }
        return count;
    }

    public int seekBurstMidFrame(Processor p) {
        for (int index = this.codeIndex; index < this.itemList.size(); ++index) {
            AssemblerItem item = this.itemList.get(index);
            if (item.isCommentedOut() || !Arrays.asList("JP", "CALL", "JMP", "JSR").contains(item.getOperation()) || p.getAbsAddresses().get("XmitSplitIR") == null || p.getAbsAddresses().get("XmitSplitIR").intValue() != item.getHex().get(1)) continue;
            return index;
        }
        return 0;
    }

    public int seekForcedRepeat(Processor p) {
        short[] rptData = CommonData.forcedRptCode[p.getDataStyle()].getData();
        int n = rptData[1] == 0 ? 2 : 1;
        block5: for (int index = this.codeIndex; index < this.itemList.size(); ++index) {
            AssemblerItem item = this.itemList.get(index);
            if (item.isCommentedOut() || item.getHex() == null) continue;
            short[] opData = item.getHex().getData();
            switch (rptData.length) {
                case 3: {
                    if (opData[0] != rptData[0] || opData[n] != rptData[n]) continue block5;
                    return opData[3 - n] - (p.getDataStyle() == 4 ? (short)1 : 0);
                }
                case 4: {
                    short[] opData2;
                    if (opData[0] != rptData[0] || index >= this.itemList.size() - 1 || (opData2 = this.itemList.get(index + 1).getHex().getData())[0] != rptData[2] || opData[1] != rptData[3]) continue block5;
                    return opData[1];
                }
                case 2: {
                    short[] opData2;
                    int i;
                    AssemblerItem item2;
                    int index2;
                    if (opData[0] != rptData[0]) continue block5;
                    int destAddr = item.getAddress() + opData[1] + 2;
                    for (index2 = index + 1; index2 < this.itemList.size() && this.itemList.get(index2).getAddress() > 0 && this.itemList.get(index2).getAddress() <= destAddr; ++index2) {
                    }
                    if ((item2 = this.itemList.get(--index2)) == null || item2.getAddress() != destAddr || !Arrays.asList("JMP", "JSR").contains(item2.getOperation()) || p.getAbsAddresses().get("XmitIR").intValue() != item2.getHex().get(1)) continue block5;
                    for (i = 1; i < index2 - index && (opData2 = this.itemList.get(index + i).getHex().getData())[0] == rptData[0] && opData2[1] == opData[1] - 2 * i; ++i) {
                    }
                    if (i != index2 - index) continue block5;
                    return opData[1] / 2 + 2;
                }
            }
        }
        return 0;
    }

    public int dbOut(int start, int end, int ramAddress, int offset, Processor p) {
        int n;
        ramAddress -= offset;
        end += offset;
        this.data = this.hex.getData();
        int pfIndex = 5;
        int pdIndex = 0;
        for (int i = start += offset; i < end; i += n) {
            AssemblerItem item = new AssemblerItem();
            item.setErrorCode(0);
            AssemblerOpCode opCode = new AssemblerOpCode();
            item.setOpCode(opCode);
            opCode.setLength(0);
            AssemblerOpCode.AddressMode mode = opCode.getMode();
            item.setOperation("DB");
            n = Math.min(4, end - i);
            String comments = null;
            String rp = p.getRegisterPrefix();
            if (i < 5) {
                n = 1;
                double time = 0.0;
                switch (i - (p.getStartOffset() == 0 ? 2 : 0)) {
                    case 0: {
                        this.settingsPanel.getProtDataPanel().getBasicValues()[0] = this.data[i];
                        time = (double)(this.data[i] + p.getCarrierOnOffset()) * 1000000.0 / (double)p.getOscillatorFreq();
                        comments = this.data[i] == 0 ? "Unmodulated" : "Carrier ON: " + String.format("%.3f", time) + "uSec";
                        break;
                    }
                    case 1: {
                        this.settingsPanel.getProtDataPanel().getBasicValues()[1] = this.data[i];
                        time = (double)(this.data[i] + p.getCarrierTotalOffset() - p.getCarrierOnOffset()) * 1000000.0 / (double)p.getOscillatorFreq();
                        comments = this.data[i] == 0 ? "" : "Carrier OFF: " + String.format("%.3f", time) + "uSec";
                        break;
                    }
                    case 2: {
                        this.settingsPanel.getProtDataPanel().getBasicValues()[2] = this.data[i];
                        comments = "dev " + (this.data[i] >> 4) + ", cmd " + (this.data[i] & 0xF) + " bytes";
                    }
                }
            } else if (i == pfIndex) {
                n = 1;
                if (i < this.settingsPanel.getProtDataPanel().getPfValues().length + 5) {
                    this.settingsPanel.getProtDataPanel().getPfValues()[i - 5] = this.data[i];
                }
                comments = String.format("pf%X: %s%02X", i - 5, rp, p.getZeroAddresses().get("PF0") + i - 5);
                if (this.data[i] >> 7 == 1) {
                    ++pfIndex;
                }
                pdIndex = i + 1;
                if (pfIndex > p.getZeroSizes().get("PF0") + 4) {
                    comments = "** Error **";
                    --pfIndex;
                }
            } else if (i == pdIndex) {
                int val = i - pfIndex - 1;
                int za = p.getZeroAddresses().get("PD00");
                int pdLimit = this.settingsPanel.getProtDataPanel().getPdValues().length;
                int pdSize = p.getZeroSizes().get("PD00");
                if (val < pdLimit) {
                    this.settingsPanel.getProtDataPanel().getPdValues()[val] = this.data[i];
                }
                if (val == pdSize - 1 || i == end - 1) {
                    n = 1;
                    if (val < pdSize) {
                        comments = String.format("pd%02X: %s%02X", val, rp, za + val);
                    }
                } else {
                    n = 2;
                    item.setOperation("DW");
                    if (val < pdSize - 1) {
                        comments = String.format("pd%02X/pd%02X: %s%02X/%s%02X", val, val + 1, rp, za + val, rp, za + val + 1);
                    }
                    if (val < pdLimit - 1) {
                        this.settingsPanel.getProtDataPanel().getPdValues()[val + 1] = this.data[i + 1];
                    }
                }
                if ((pdIndex += n) > pfIndex + p.getZeroSizes().get("PD00")) {
                    --pdIndex;
                }
            }
            String argText = "";
            item.setAddress(ramAddress + i);
            item.setHex(this.hex.subHex(i, n));
            item.setComments(comments);
            opCode.setName(item.getOperation());
            if (item.getOperation().equals("DB")) {
                mode.length = 1;
                for (int j = 0; j < n; ++j) {
                    if (j > 0) {
                        argText = argText + ", ";
                    }
                    argText = argText + String.format(p.getAddressModes().get((Object)"EQU2").format, this.data[i + j]);
                }
            } else {
                mode.length = 2;
                argText = String.format(p.getAddressModes().get((Object)"EQU4").format, this.hex.get(i));
            }
            item.setArgumentText(argText);
            this.itemList.add(item);
        }
        return pfIndex - 4;
    }

    public int getPfCount() {
        return this.pfCount;
    }

    public int getPdCount() {
        return this.pdCount;
    }

    public int getMidFrameIndex() {
        return this.midFrameIndex;
    }

    public void setMidFrameIndex(int midFrameIndex) {
        this.midFrameIndex = midFrameIndex;
    }

    public int getForcedRptCount() {
        return this.forcedRptCount;
    }

    public void setForcedRptCount(int forcedRptCount) {
        this.forcedRptCount = forcedRptCount;
    }

    public void setPfCount(int pfCount) {
        this.pfCount = pfCount;
    }

    public void setPdCount(int pdCount) {
        this.pdCount = pdCount;
    }

    public List<AssemblerItem> getItemList() {
        return this.itemList;
    }

    public void setItemList(List<AssemblerItem> itemList) {
        this.itemList = itemList;
    }

    public boolean testBuildMode(Processor processor) {
        int length = 0;
        for (AssemblerItem item : this.itemList) {
            if (item.isCommentedOut() || (length += item.getLength()) <= processor.getStartOffset()) continue;
            return false;
        }
        return true;
    }

    private void showOrgMessage() {
        String title = "Assembler edit";
        String message = "An ORG instruction can only be edited in Build mode, which is\nwhen the Assemble and Update buttons are disabled.";
        JOptionPane.showMessageDialog(this.settingsPanel.getAssemblerPanel(), message, title, 2);
    }

    private class AssemblerCellEditor
    extends SelectAllCellEditor {
        private AssemblerCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String op;
            Processor processor = AssemblerTableModel.this.settingsPanel.getAssemblerPanel().getProcessor();
            if (!AssemblerTableModel.this.testBuildMode(processor) && (op = (String)table.getValueAt(row, 3)).equalsIgnoreCase("ORG")) {
                AssemblerTableModel.this.showOrgMessage();
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private static class AssemblerCellRenderer
    extends DefaultTableCellRenderer {
        private AssemblerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            boolean valid;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
            AssemblerTableModel model = (AssemblerTableModel)table.getModel();
            AssemblerItem item = (AssemblerItem)model.getRow(row);
            boolean bl = valid = item.getErrorCode() == 0 && (item.isChecked() || col != 1);
            c.setForeground(valid ? (isSelected ? Color.WHITE : Color.BLACK) : (isSelected ? Color.YELLOW : Color.RED));
            return c;
        }
    }

    public static class DisasmState {
        public boolean useFunctionConstants = true;
        public boolean useRegisterConstants = true;
        public List<Integer> absUsed = new ArrayList<Integer>();
        public List<Integer> zeroUsed = new ArrayList<Integer>();
        public List<Integer> relUsed = new ArrayList<Integer>();
        public boolean toRC = false;
        public boolean toW = false;
    }
}

