/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.Calendar;
import java.util.StringTokenizer;

public class AutoClockSet
extends RDFParameter {
    private int timeAddress = 0;
    private TimeFormat timeFormat = TimeFormat.HEX;
    private short[] savedTimeBytes = new short[3];

    public void saveTimeBytes(short[] data) {
        for (int i = 0; i < 3; ++i) {
            this.savedTimeBytes[i] = data[this.timeAddress + i];
        }
    }

    public void restoreTimeBytes(short[] data) {
        for (int i = 0; i < 3; ++i) {
            data[this.timeAddress + i] = this.savedTimeBytes[i];
        }
    }

    public void setTimeBytes(short[] data) {
        Calendar now = Calendar.getInstance();
        int minValue = now.get(12);
        int hourValue = now.get(10);
        int pmValue = now.get(9) == 1 ? 1 : 0;
        int dayValue = (now.get(7) + 7 - 2) % 7;
        switch (this.timeFormat.ordinal()) {
            case 0: {
                data[this.timeAddress] = (short)(minValue + 128 * pmValue);
                data[this.timeAddress + 1] = (short)hourValue;
                data[this.timeAddress + 2] = (short)(1 << dayValue);
                break;
            }
            case 1: {
                data[this.timeAddress] = (short)((minValue / 10 << 4) + minValue % 10);
                data[this.timeAddress + 1] = (short)((hourValue / 10 << 4) + hourValue % 10 + (pmValue << 5));
                data[this.timeAddress + 2] = (short)(dayValue + 1);
                break;
            }
            case 2: {
                hourValue = hourValue % 12 + 12 * pmValue;
                data[this.timeAddress] = (short)((minValue / 10 << 4) + minValue % 10);
                data[this.timeAddress + 1] = (short)((hourValue / 10 << 4) + hourValue % 10);
                data[this.timeAddress + 2] = (short)(dayValue + 1);
                break;
            }
        }
        System.err.println("Using AutoClockSet, format " + (Object)((Object)this.timeFormat));
        System.err.println(String.format("Time data %02X, %02X, %02X", data[this.timeAddress], data[this.timeAddress + 1], data[this.timeAddress + 2]));
    }

    @Override
    public void parse(String text, Remote remote) throws Exception {
        StringTokenizer st = new StringTokenizer(text, ", ");
        this.timeAddress = RDFReader.parseNumber(st.nextToken());
        if (st.hasMoreTokens()) {
            this.timeFormat = TimeFormat.valueOf(st.nextToken());
        }
    }

    public static enum TimeFormat {
        HEX,
        BCD12,
        BCD24;

    }
}

