/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AddressRange;
import com.hifiremote.jp1.CheckSum;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Xor16CheckSum;
import com.hifiremote.jp1.XorCheckSum;
import com.hifiremote.jp1.io.CommHID;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class BinAnalyzer {
    protected String signature = null;
    public Hex hex = null;
    protected String procName = null;
    protected boolean blockStruct = false;
    protected boolean omitDigitMapByte = false;
    protected String blockFormat = null;
    protected int codeAddress = 0;
    protected int sigAddress = 0;
    protected int e2Address = 0;
    protected int e2Len = 0;
    protected int irdbAddress = 0;
    protected int infoPtrList = 0;
    protected int execCount = 0;
    protected Processor p = null;
    protected int wordMult = 1;
    protected int fixVarOffset = 2;
    protected int numTable = 0;
    protected int[] setupInfo = null;
    protected LinkedHashMap<Integer, List<Integer>> setupCodeLists = null;
    protected Hex numberTables = null;
    private String[] procNames = null;
    protected char procChar = '\u0000';
    private int[] procMemSizes = null;
    protected String flashSize = null;
    protected Integer[] groupAddrs = null;
    private boolean msbInfoValues = true;
    protected JP1Frame owner = null;
    private List<Integer> keycodeList = null;
    private List<Integer> keycodeBackup = null;
    protected List<Integer> btnMapPtrs = null;
    private List<Integer> segmentTypes = null;
    protected LinkedHashMap<Integer, Integer> btnMapsDistinct = null;
    protected LinkedHashMap<Integer, List<Short>> btnMaps = null;
    protected int btnMapOffset = 0;
    private int data1Address = 0;
    private int data2Address = 0;
    private int numFlashBlocks = 0;
    protected int btnMapPtrPtr = 0;
    private int numberTablesStart = 0;
    private int dataEnd = 0;
    public boolean isReplacement = false;
    protected LinkedHashMap<Integer, SetupAnalysis> analyses = null;
    protected boolean uses16bitSetupCodes = false;
    protected int execAddrOffset = 0;
    private List<Integer> execSetupAddresses = null;
    protected List<Integer> deviceButtons = null;
    protected List<Integer> deviceTypes = null;
    private LinkedHashMap<Integer, Hex> mergedSetupByRow = null;
    private Hex e2Hex = null;
    protected String setupInfoError = null;

    public BinAnalyzer(File binFile, JP1Frame owner, boolean forReplacement) {
        Hex hex;
        this.owner = owner;
        byte[] data = RMIRSetup.readBinary(binFile);
        this.hex = hex = new Hex(data);
        this.keycodeList = new ArrayList<Integer>();
        this.keycodeBackup = new ArrayList<Integer>();
        String errorStr = null;
        errorStr = this.findSigBlockAddress();
        if (errorStr == null && (forReplacement || this.isReplacement)) {
            return;
        }
        errorStr = this.getGroupButtonAddrs();
        if (errorStr == null && this.getSetupInfo() == null) {
            errorStr = this.setupInfoError;
        }
        if (errorStr == null) {
            for (int addr : this.getExecSetupAddresses()) {
                if (this.setupInfo[6] <= this.btnMapOffset || addr < this.setupInfo[6]) continue;
                this.setupInfo[7] = addr;
                break;
            }
            this.numberTables = hex.subHex(this.setupInfo[6], this.setupInfo[7] - this.setupInfo[6]);
            errorStr = this.mergeSetupChains();
        }
        if (errorStr == null) {
            this.makeExtract();
        } else {
            String title = "Extract error";
            JOptionPane.showMessageDialog(owner, errorStr, title, 0, null);
        }
    }

    public BinAnalyzer(String signature) {
        if (signature.length() != 6) {
            return;
        }
        this.signature = signature;
        this.hex = CommHID.getFirmwareFile(signature);
        if (this.hex == null) {
            return;
        }
        this.keycodeList = new ArrayList<Integer>();
        this.keycodeBackup = new ArrayList<Integer>();
        String errorStr = null;
        errorStr = this.findSigBlockAddress();
        if (errorStr == null) {
            errorStr = this.getGroupButtonAddrs();
        }
        if (errorStr == null && this.getSetupInfo() == null) {
            errorStr = this.setupInfoError;
        }
        if (errorStr == null) {
            for (int addr : this.getExecSetupAddresses()) {
                if (this.setupInfo[6] <= this.btnMapOffset || addr < this.setupInfo[6]) continue;
                this.setupInfo[7] = addr;
                break;
            }
            this.numberTables = this.hex.subHex(this.setupInfo[6], this.setupInfo[7] - this.setupInfo[6]);
        }
    }

    public void setOwner(JP1Frame owner) {
        this.owner = owner;
    }

    public void getProcessorInfo(String signature) {
        this.wordMult = 1;
        this.fixVarOffset = 2;
        this.procNames = null;
        this.procMemSizes = null;
        this.procChar = signature.charAt(0);
        if (signature.startsWith("2")) {
            this.procMemSizes = new int[]{65536, 131072};
            this.procNames = new String[]{"MAXQ610", "MAXQ612"};
            this.wordMult = 2;
        } else if (signature.startsWith("3")) {
            this.procMemSizes = new int[]{18432, 32768, 65536};
            this.procNames = new String[]{"S3F80P5X", "S3F80_32K", "S3F80"};
        } else if (signature.startsWith("60")) {
            this.procMemSizes = new int[]{98304, 131072, 262144};
            this.procNames = new String[]{"TI2533", "TI2530", "TI2541"};
            this.fixVarOffset = 4;
        } else if (signature.startsWith("68")) {
            this.procMemSizes = new int[]{65536, 262144};
            this.procNames = new String[]{"GP541", "GP565"};
            this.fixVarOffset = 4;
        }
        if (this.procNames != null && this.e2Address != 0 && this.e2Len != 0) {
            int e2End = this.e2Address + this.e2Len;
            int ndx = -1;
            for (int i = 0; i < this.procMemSizes.length; ++i) {
                if (e2End > this.procMemSizes[i]) continue;
                ndx = i;
                break;
            }
            if (ndx >= 0) {
                this.procName = this.procNames[ndx];
                int procMemSize = this.procMemSizes[ndx];
                if (this.blockFormat != null && this.blockFormat.equals("A")) {
                    this.procName = "MAXQ622";
                }
                this.p = ProcessorManager.getProcessor(this.procName);
                this.flashSize = "" + procMemSize / 1024 + "MB";
            }
        }
    }

    public int getMsbNbyteInt(int addr, int size) {
        int val = 0;
        for (int i = 0; i < size; ++i) {
            val = (val << 8) + this.hex.getData()[addr + i];
        }
        return val;
    }

    public String findSigBlockAddress() {
        int segStart;
        char[] ch = new char[6];
        String s = null;
        int sAddr = 0;
        short val = 0;
        int count = 0;
        int addressLength = 0;
        this.e2Address = 0;
        for (int i = 0; i < this.hex.length() - 6; ++i) {
            int j;
            val = this.hex.getData()[i];
            if ((val < 48 || val > 57) && count < 6) {
                count = 0;
                continue;
            }
            if (val >= 48 && val <= 57 && count == 6) {
                for (j = 0; j < 5; ++j) {
                    ch[j] = ch[j + 1];
                }
                --count;
            }
            if (count < 6) {
                ch[count] = (char)val;
                ++count;
                continue;
            }
            count = 0;
            s = new String(ch);
            sAddr = i - 6;
            this.blockStruct = this.hex.get(sAddr - 4) == 0;
            addressLength = 0;
            if (this.blockStruct) {
                int irdbLen;
                this.sigAddress = sAddr - 6;
                for (j = 1; j < 3; ++j) {
                    int sigAddrFromBlock;
                    addressLength = 2 * j;
                    int formatTest = this.getMsbNbyteInt(this.sigAddress + 67 + 4 * addressLength, 4);
                    if (formatTest == -1) {
                        sigAddrFromBlock = this.getMsbNbyteInt(this.sigAddress + 40 + 3 + 2 * addressLength, addressLength);
                        if (this.sigAddress == sigAddrFromBlock) {
                            this.blockFormat = "A";
                            break;
                        }
                        addressLength = 0;
                    }
                    if (addressLength == 0) continue;
                    sigAddrFromBlock = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + addressLength, addressLength);
                    if (sigAddrFromBlock == this.sigAddress) {
                        this.blockFormat = "B";
                        addressLength = 2 * j;
                        break;
                    }
                    addressLength = 0;
                }
                if (addressLength == 0) continue;
                if (this.blockFormat.equals("A")) {
                    this.numFlashBlocks = this.hex.getData()[this.sigAddress + 40 + 2];
                    this.codeAddress = this.getMsbNbyteInt(this.sigAddress + 40 + 3 + addressLength, addressLength);
                    this.irdbAddress = this.getMsbNbyteInt(this.sigAddress + 40 + 3 + 3 * addressLength, addressLength);
                    this.e2Address = this.getMsbNbyteInt(this.sigAddress + 40 + 3 + 4 * addressLength, addressLength);
                    this.e2Len = this.getMsbNbyteInt(this.e2Address + 2, 4);
                    break;
                }
                this.numFlashBlocks = this.hex.get(this.sigAddress + 40 + 2);
                this.codeAddress = this.getMsbNbyteInt(this.sigAddress + 40 + 4, addressLength);
                this.irdbAddress = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + 2 * addressLength, addressLength);
                this.e2Address = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + 3 * addressLength, addressLength);
                if (this.numFlashBlocks == 6) {
                    this.data1Address = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + 4 * addressLength, addressLength);
                    this.data2Address = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + 5 * addressLength, addressLength);
                }
                if (this.irdbAddress + (irdbLen = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + this.numFlashBlocks * (2 + addressLength) + 8, 4)) != this.e2Address) {
                    System.err.println("E2 address does not match end of IR database");
                    count = 0;
                    continue;
                }
                this.e2Len = this.getMsbNbyteInt(this.sigAddress + 40 + 4 + this.numFlashBlocks * (2 + addressLength) + 12, 4);
                break;
            }
            this.sigAddress = sAddr;
            this.blockFormat = null;
            for (j = 1; j < 3; ++j) {
                addressLength = 2 * j;
                this.codeAddress = this.getMsbNbyteInt(this.sigAddress + 26, addressLength);
                int codeAddressEnd = this.getMsbNbyteInt(this.sigAddress + 26 + addressLength, addressLength) + 1;
                int block2Start = this.getMsbNbyteInt(this.sigAddress + 26 + 2 * addressLength, addressLength);
                int block2End = this.getMsbNbyteInt(this.sigAddress + 26 + 3 * addressLength, addressLength) + 1;
                if (this.sigAddress == block2Start || this.sigAddress == codeAddressEnd) {
                    int sigBlockLen = 26 + (2 * addressLength + 2) * 3;
                    this.irdbAddress = block2Start == this.sigAddress ? block2Start + sigBlockLen : block2Start;
                    this.e2Address = this.getMsbNbyteInt(this.sigAddress + 26 + 4 * addressLength, addressLength);
                    if (this.e2Address != block2End) {
                        System.err.println("E2 address does not match end of IR database");
                        count = 0;
                        continue;
                    }
                    int e2End = this.getMsbNbyteInt(this.sigAddress + 26 + 5 * addressLength, addressLength);
                    this.e2Len = e2End - this.e2Address + 1;
                    break;
                }
                addressLength = 0;
            }
            if (addressLength != 0) break;
        }
        if (this.e2Address == 0) {
            this.signature = null;
            return "Failed to find signature block.";
        }
        this.signature = s;
        this.getProcessorInfo(this.signature);
        if (this.p.getAddressLength() != addressLength) {
            return "Mismatch on address length for signature " + this.signature + " and processor " + this.p.getName() + ".";
        }
        this.e2Hex = this.hex.subHex(this.e2Address, this.e2Len);
        short[] e2Data = this.e2Hex.getData();
        int pos = segStart = this.blockStruct ? 20 : 2;
        int segLength = this.e2Hex.get(pos);
        this.segmentTypes = new ArrayList<Integer>();
        while (segLength != 65535 && segLength != 0) {
            short segType = e2Data[pos + 2];
            if (!this.segmentTypes.contains(segType)) {
                this.segmentTypes.add(Integer.valueOf(segType));
            }
            short segFlags = e2Data[pos + 3];
            if (segType == 0 && segFlags == 255) {
                if (this.deviceButtons == null) {
                    this.deviceButtons = new ArrayList<Integer>();
                }
                if (this.deviceTypes == null) {
                    this.deviceTypes = new ArrayList<Integer>();
                }
                short devBtnNum = e2Data[pos + 4];
                short devBtnType = e2Data[pos + 6];
                this.deviceButtons.add(Integer.valueOf(devBtnNum));
                this.deviceTypes.add(Integer.valueOf(devBtnType));
                Collections.sort(this.deviceTypes);
            } else if (segType == 27 || segType == 205 && segLength > 18) {
                this.isReplacement = true;
            }
            if (pos + segLength > this.e2Len) {
                return String.format("Segment at $%04X exceeds end of E2 area.", pos);
            }
            segLength = Hex.get(e2Data, pos += segLength);
        }
        this.dataEnd = pos;
        return null;
    }

    public List<Integer> getExecSetupAddresses() {
        if (this.execSetupAddresses != null) {
            return this.execSetupAddresses;
        }
        ArrayList<Integer> addrList = new ArrayList<Integer>();
        this.execAddrOffset = this.wordMult == 2 ? this.setupInfo[1] : (this.btnMapOffset > 0 ? this.btnMapOffset : 0);
        int setupStart = this.setupInfo[4];
        if (this.setupInfo.length > 10 && this.setupInfo[13] != this.setupInfo[11]) {
            int activityGroup2Count = (this.setupInfo[5] - this.setupInfo[4]) / 2;
            int audioSetupCount = this.hex.get(this.setupInfo[15]) - activityGroup2Count;
            for (int i = 0; i < audioSetupCount; ++i) {
                addrList.add(this.hex.get(this.setupInfo[14] + 2 * i));
            }
        }
        for (int i = setupStart; i < this.setupInfo[5]; i += 2) {
            int vec = this.p.getInt(this.hex.getData(), i) + this.execAddrOffset;
            if (vec < this.setupInfo[5]) continue;
            addrList.add(vec);
        }
        Collections.sort(addrList);
        int setupAddrMin = (Integer)addrList.get(0);
        int setupAddrMax = (Integer)addrList.get(addrList.size() - 1);
        int execPIDsPtr = this.getSetupInfo()[0];
        this.execCount = this.p.getInt(this.hex.getData(), execPIDsPtr);
        for (int i = 0; i < this.execCount; ++i) {
            int execAddrPtr = execPIDsPtr + 2 + 2 * i + 2 * this.execCount;
            int execAddr = this.execAddrOffset + this.p.getInt(this.hex.getData(), execAddrPtr);
            if (execAddr > setupAddrMin && execAddr < setupAddrMax) {
                this.execCount = i;
                break;
            }
            addrList.add(execAddr);
        }
        addrList.add(this.setupInfo[8]);
        if (this.setupInfo.length > 10) {
            addrList.add(this.setupInfo[10]);
            addrList.add(this.setupInfo[11]);
        } else {
            addrList.add(this.setupInfo[3]);
            addrList.add(this.setupInfo[4]);
        }
        int dataEnd = 0;
        for (int i = this.e2Address - 3; i > this.irdbAddress; --i) {
            if (this.hex.getData()[i] == 255) continue;
            dataEnd = i + 1;
            addrList.add(dataEnd);
            break;
        }
        Collections.sort(addrList);
        this.execSetupAddresses = addrList;
        return addrList;
    }

    private int getInfoValue(int addr) {
        if (this.btnMapOffset == 0 && this.msbInfoValues) {
            return this.hex.get(addr);
        }
        return this.p.getInt(this.hex.getData(), addr);
    }

    protected int setupStart(int ndx) {
        return this.p.getInt(this.hex.getData(), this.setupInfo[8] + 2 * ndx) * this.wordMult + this.btnMapOffset;
    }

    public int[] getSetupInfo() {
        try {
            int endNdx;
            if (this.setupInfo != null) {
                return this.setupInfo;
            }
            this.numberTablesStart = this.getInfoValue(this.infoPtrList) * this.wordMult + this.btnMapOffset;
            int setupStarts = this.getInfoValue(this.infoPtrList + 6) * this.wordMult + this.btnMapOffset;
            int setupCodeIndex = this.getInfoValue(this.infoPtrList + 2) * this.wordMult + this.btnMapOffset;
            int setupCodeVectorsPtr = this.getInfoValue(this.infoPtrList + 4) * this.wordMult + this.btnMapOffset;
            int execPIDsPtr = this.getInfoValue(this.infoPtrList + 8) * this.wordMult + this.btnMapOffset;
            int execVectorsPtr = this.getInfoValue(this.infoPtrList + 10) * this.wordMult + this.btnMapOffset;
            int execsStart = this.getInfoValue(this.infoPtrList + 14) * this.wordMult + this.btnMapOffset;
            this.setupInfo = new int[10];
            this.setupInfo[0] = execPIDsPtr;
            this.setupInfo[1] = execsStart;
            this.setupInfo[2] = this.p.getInt(this.hex.getData(), setupCodeIndex);
            this.setupInfo[3] = setupCodeIndex;
            this.setupInfo[4] = setupCodeVectorsPtr;
            this.setupInfo[5] = this.setupInfo[4] + 2 * this.setupInfo[2];
            this.setupInfo[6] = this.numberTablesStart;
            this.setupInfo[8] = setupStarts;
            this.setupInfo[9] = this.setupStart(0);
            boolean uses12bitsetupcodes = true;
            for (endNdx = 0; this.setupInfo[8] + 2 * endNdx < this.e2Address && endNdx < 20 && !this.getExecSetupAddresses().contains(this.setupStart(endNdx)); ++endNdx) {
            }
            if (this.setupInfo[8] + 2 * endNdx >= this.e2Address || endNdx == 20) {
                this.setupInfoError = "Failed to find valid device types.";
                return null;
            }
            this.setupCodeLists = new LinkedHashMap();
            int devNdx = 0;
            for (devNdx = 0; devNdx < endNdx; ++devNdx) {
                ArrayList<Integer> codes = new ArrayList<Integer>();
                this.setupCodeLists.put(devNdx, codes);
                for (int addr = this.setupStart(devNdx); addr < this.setupStart(devNdx + 1); addr += 2) {
                    int code = this.p.getInt(this.hex.getData(), addr);
                    if (code >> 12 != devNdx && code >> 12 != 0) {
                        uses12bitsetupcodes = false;
                    }
                    codes.add(code);
                }
            }
            this.uses16bitSetupCodes = this.setupInfo[9] == this.setupInfo[3] + 2 && !uses12bitsetupcodes;
        }
        catch (Exception e) {
            return null;
        }
        return this.setupInfo;
    }

    private int getBtnMapNdx(int devType) {
        int btnMapPtr = this.btnMapPtrs.get(devType % this.btnMapPtrs.size());
        return Arrays.asList(this.btnMapsDistinct.keySet().toArray(new Integer[0])).indexOf(btnMapPtr);
    }

    private boolean keycodeFilter(int code, boolean doAdd) {
        if (code > 0 && code != 255 && !this.keycodeList.contains(code)) {
            if (doAdd) {
                this.keycodeList.add(code);
            }
            return true;
        }
        return false;
    }

    public String getGroupButtonAddrs() {
        int j;
        this.groupAddrs = new Integer[3];
        Arrays.fill((Object[])this.groupAddrs, (Object)0);
        int index = 0;
        boolean start = false;
        int count = 0;
        int lastCode = 255;
        int code = 255;
        boolean isFirst = false;
        int begin = this.codeAddress;
        int end = this.sigAddress;
        int possVolGroup = 0;
        int zCount = 0;
        if (this.numFlashBlocks == 6) {
            begin = this.data1Address;
            end = this.data2Address;
        }
        for (int i = begin; i < end; ++i) {
            lastCode = code;
            code = this.hex.getData()[i];
            if (this.numFlashBlocks == 6 && code == 0) {
                ++zCount;
                count = 0;
                continue;
            }
            if (code == 255) {
                if (code == 255 && lastCode == 255) {
                    this.groupAddrs[0] = 0;
                    index = 0;
                    count = 0;
                    this.keycodeList.clear();
                    this.keycodeBackup.clear();
                    continue;
                }
                if (index == 0 && (count == 10 || count == 12) || index == 1 && count == 3) {
                    if (index == 1 && i > this.groupAddrs[0] + 30 + zCount) {
                        index = 0;
                        count = 0;
                        this.keycodeList.clear();
                        this.keycodeBackup.clear();
                        i = this.groupAddrs[0] + 10;
                        continue;
                    }
                    if (index == 0) {
                        zCount = 0;
                    }
                    if (count == 12) {
                        this.groupAddrs[2] = i - count;
                        this.groupAddrs[0] = this.groupAddrs[2] + 2;
                        if (this.hex.get(this.groupAddrs[2]) != this.hex.get(this.groupAddrs[2] - 3)) {
                            i = this.groupAddrs[0] + 10;
                            this.groupAddrs[0] = 0;
                            this.groupAddrs[2] = 0;
                            index = 0;
                            count = 0;
                            this.keycodeList.clear();
                            this.keycodeBackup.clear();
                            continue;
                        }
                    } else {
                        this.groupAddrs[index] = i - count;
                    }
                    this.keycodeBackup.clear();
                    this.keycodeBackup.addAll(this.keycodeList);
                    count = 0;
                    if (++index != 2) continue;
                    break;
                }
                if (index == 0 && count == 3) {
                    possVolGroup = i - 3;
                    count = 0;
                    continue;
                }
                this.keycodeList.clear();
                this.keycodeList.addAll(this.keycodeBackup);
                start = true;
                count = 0;
                continue;
            }
            if (start && this.keycodeFilter(code, true)) {
                ++count;
                continue;
            }
            count = 0;
            start = false;
            this.keycodeList.clear();
            this.keycodeList.addAll(this.keycodeBackup);
        }
        if (this.groupAddrs[0] == 0 && possVolGroup > 0) {
            this.groupAddrs[1] = possVolGroup;
        }
        if (this.groupAddrs[0] == 0 && this.groupAddrs[1] == 0) {
            return "Failed to find digit and/or volume buttons.";
        }
        int startAddr = this.groupAddrs[0];
        if (startAddr > 0) {
            for (j = 2; j < 20; ++j) {
                int test = this.hex.get(this.groupAddrs[0] - j);
                if (test != 65535) continue;
                startAddr = this.groupAddrs[0] - j + 2;
                break;
            }
        }
        if (startAddr <= this.groupAddrs[0] - 3 && this.hex.getData()[this.groupAddrs[0] - 1] == 255) {
            if (this.testBtnMap(this.groupAddrs[0] - 3) == this.groupAddrs[0] - 1) {
                this.groupAddrs[2] = this.groupAddrs[0] - 3;
                for (j = 0; j < 2; ++j) {
                    this.keycodeFilter(this.hex.getData()[this.groupAddrs[2] + j], true);
                }
            }
        } else if (this.groupAddrs[2] == 0) {
            int group2len = 0;
            this.groupAddrs[2] = this.groupAddrs[1] + 4;
            while (group2len != 2) {
                int end2;
                if (this.numFlashBlocks == 6) {
                    while (this.hex.getData()[this.groupAddrs[2]] == 0) {
                        Integer[] test = this.groupAddrs;
                        Integer n = test[2];
                        test[2] = test[2] + 1;
                    }
                }
                if ((end2 = this.testBtnMap(this.groupAddrs[2])) == -1 || end2 != this.groupAddrs[2] + 2) {
                    int n = this.groupAddrs[2];
                    while (this.hex.getData()[n] != 255) {
                        ++n;
                    }
                    if (this.hex.getData()[n + 1] == 255) break;
                    this.groupAddrs[2] = n + 1;
                    group2len = 0;
                    continue;
                }
                group2len = 2;
                for (int j2 = 0; j2 < 2; ++j2) {
                    this.keycodeFilter(this.hex.getData()[this.groupAddrs[2] + j2], true);
                }
            }
            if (group2len != 2 && this.testBtnMap(this.groupAddrs[0] - 3) == this.groupAddrs[0] - 1) {
                this.groupAddrs[2] = this.groupAddrs[0] - 3;
                group2len = 2;
                for (int j3 = 0; j3 < 2; ++j3) {
                    this.keycodeFilter(this.hex.getData()[this.groupAddrs[2] + j3], true);
                }
            }
            if (group2len != 2) {
                this.keycodeList.clear();
                this.keycodeList.addAll(this.keycodeBackup);
                return "Failed to find channel buttons.";
            }
            this.keycodeBackup.clear();
            this.keycodeBackup.addAll(this.keycodeList);
        }
        start = false;
        count = 0;
        this.btnMapPtrs = new ArrayList<Integer>();
        this.btnMapPtrPtr = 0;
        int n = this.infoPtrList = this.blockStruct ? this.irdbAddress + 20 : this.irdbAddress;
        if (this.getMsbNbyteInt(this.infoPtrList, 4) == this.irdbAddress) {
            this.infoPtrList += 4;
            this.btnMapOffset = this.irdbAddress;
        }
        if (this.wordMult == 2 && this.btnMapOffset == 0) {
            if (this.getSetupInfo() == null) {
                this.wordMult = 1;
                this.setupInfo = null;
            }
            if (this.getSetupInfo() == null) {
                this.msbInfoValues = false;
                this.setupInfo = null;
            }
            if (this.getSetupInfo() == null) {
                this.wordMult = 2;
                this.setupInfo = null;
            }
            if (this.getSetupInfo() == null) {
                this.setupInfo = null;
                return "Unable to interpret IR Database.";
            }
            this.setupInfo = null;
        }
        int btnMapPtr = 0;
        startAddr = this.infoPtrList + 14;
        int endAddr = this.e2Address;
        block8: for (int loop = 0; loop < 2; ++loop) {
            if (loop == 1) {
                startAddr = this.codeAddress;
                endAddr = this.irdbAddress;
            }
            for (int i = startAddr; i < endAddr; ++i) {
                code = this.hex.getData()[i];
                if (this.p.getInt(this.hex.getData(), i) == i + 2) {
                    code = this.hex.getData()[i += 2];
                    start = true;
                    isFirst = true;
                    count = 0;
                }
                if (code == 255) {
                    if (count > 0) {
                        int k;
                        this.btnMapPtrs.clear();
                        btnMapPtr = i - count;
                        if (loop == 0) {
                            int ptrAddr = 0;
                            this.btnMapPtrPtr = 0;
                            for (int j4 = this.infoPtrList + 14; j4 < btnMapPtr; ++j4) {
                                int ptr2 = this.p.getInt(this.hex.getData(), j4);
                                if (ptr2 != btnMapPtr - this.btnMapOffset) continue;
                                if (isFirst) {
                                    ptrAddr = j4;
                                } else {
                                    int nSkip = 1;
                                    while (this.p.getInt(this.hex.getData(), j4 - 2 * nSkip) == btnMapPtr - this.btnMapOffset - nSkip || this.p.getInt(this.hex.getData(), j4 - 2 * (nSkip + 1)) == this.p.getInt(this.hex.getData(), j4 - 2 * nSkip)) {
                                        ++nSkip;
                                    }
                                    ptrAddr = j4 - 2 * nSkip;
                                    int ptr1 = this.p.getInt(this.hex.getData(), ptrAddr) + this.btnMapOffset;
                                    if (this.testBtnMap(ptr1) == -1 || this.testBtnMap(ptr1) + 1 != this.p.getInt(this.hex.getData(), ptrAddr + 2 * nSkip) + this.btnMapOffset) {
                                        ptrAddr = 0;
                                        continue;
                                    }
                                }
                                this.btnMapPtrs.clear();
                                this.btnMapPtrPtr = ptrAddr;
                                if (this.btnMapPtrPtr > this.infoPtrList + 50) {
                                    ptrAddr = 0;
                                    continue;
                                }
                                int firstBtnMapAddr = this.p.getInt(this.hex.getData(), ptrAddr) + this.btnMapOffset;
                                k = 0;
                                while (this.btnMapPtrPtr + 2 * k < firstBtnMapAddr) {
                                    this.btnMapPtrs.add(this.p.getInt(this.hex.getData(), this.btnMapPtrPtr + 2 * k) + this.btnMapOffset);
                                    ++k;
                                }
                                break;
                            }
                            if (ptrAddr == 0) {
                                count = 0;
                                continue;
                            }
                            if (!this.btnMapPtrs.isEmpty()) {
                                loop = 2;
                                continue block8;
                            }
                        }
                        if (loop == 1) {
                            if (btnMapPtr < this.groupAddrs[0] - 800) continue;
                            block13: for (int j5 = this.groupAddrs[1] + 6; this.p.getInt(this.hex.getData(), j5) != this.groupAddrs[0].intValue() && j5 < this.groupAddrs[1] + 800; ++j5) {
                                if (btnMapPtr != this.p.getInt(this.hex.getData(), j5)) continue;
                                int ptrAddr = j5 - (isFirst ? 0 : 2);
                                if (this.hex.getData()[j5 - 1] == 255) {
                                    ptrAddr = j5;
                                }
                                this.btnMapPtrPtr = ptrAddr;
                                for (int ptrx = ptrAddr; ptrx != this.p.getInt(this.hex.getData(), ptrAddr) && ptrx < this.irdbAddress; ptrx += 2) {
                                    int newPtr = this.p.getInt(this.hex.getData(), ptrx);
                                    if (this.hex.getData()[newPtr] == 255 || Arrays.asList(this.groupAddrs).contains(newPtr)) break block13;
                                    for (k = this.btnMapPtrs.size() - 1; k >= 0 && this.btnMapPtrs.get(k) == newPtr; --k) {
                                    }
                                    int ndx = this.btnMapPtrs.indexOf(newPtr);
                                    if (ndx >= 0 && ndx < k) break block13;
                                    this.btnMapPtrs.add(newPtr);
                                }
                                break;
                            }
                            if (!this.btnMapPtrs.isEmpty()) continue block8;
                            count = 0;
                            continue;
                        }
                    }
                    start = true;
                    isFirst = false;
                    count = 0;
                    continue;
                }
                if (start && this.keycodeFilter(code, false)) {
                    ++count;
                    continue;
                }
                count = 0;
                start = false;
            }
        }
        if (this.btnMapPtrs.isEmpty()) {
            return "Failed to find any button maps.";
        }
        this.btnMapsDistinct = new LinkedHashMap();
        for (int bmp : this.btnMapPtrs) {
            if (this.btnMapsDistinct.containsKey(bmp)) {
                this.btnMapsDistinct.put(bmp, this.btnMapsDistinct.get(bmp) + 1);
                continue;
            }
            this.btnMapsDistinct.put(bmp, 0);
        }
        int ndx = 0;
        this.btnMaps = new LinkedHashMap();
        for (int bmp : this.btnMapsDistinct.keySet()) {
            ArrayList<Short> mapBtns = new ArrayList<Short>();
            this.btnMaps.put(ndx++, mapBtns);
            int len = 0;
            while (this.hex.getData()[bmp + len] != 255) {
                ++len;
            }
            for (int i = 0; i < len; ++i) {
                mapBtns.add(this.hex.getData()[bmp + i]);
            }
        }
        return null;
    }

    private int testBtnMap(int addr) {
        short val = 0;
        int end = 0;
        int i = 0;
        while ((val = this.hex.getData()[addr + i]) != 255) {
            end = addr + i + 1;
            if (!this.keycodeFilter(val, false)) {
                return -1;
            }
            ++i;
        }
        return end;
    }

    private String mergeAnalyses(int row) {
        SetupAnalysis sa = this.analyses.get(row);
        while (sa.numNulls > 0) {
            int linkMode = sa.link >> 12;
            int linkRow = sa.link & 0xFFF;
            SetupAnalysis linkSa = this.analyses.get(linkRow);
            if (sa.numVar != linkSa.numVar) {
                return "Mismatch in var length in chain for row " + row + ", link row " + linkRow;
            }
            for (short keyCode : sa.setupState.keySet()) {
                Short[] val = sa.setupState.get(keyCode);
                Short[] linkVal = linkSa.setupState.get(keyCode);
                if (linkVal == null) continue;
                for (int i = 0; i < val.length && i < linkVal.length; ++i) {
                    if (val[i] != null || linkVal[i] == null) continue;
                    val[i] = linkVal[i];
                    --sa.numNulls;
                }
            }
            sa.link = linkSa.link;
        }
        return null;
    }

    protected String mergeSetupChains() {
        int row = 1;
        this.analyses = new LinkedHashMap();
        ArrayList<Integer> removalList = null;
        for (int key : this.setupCodeLists.keySet()) {
            if (removalList != null) {
                removalList.add(key);
                continue;
            }
            int address = 0;
            List<Integer> codeList = this.setupCodeLists.get(key);
            Iterator<Integer> iterator = codeList.iterator();
            while (iterator.hasNext()) {
                Hex data;
                int code = iterator.next();
                int addressPtrStart = this.setupInfo.length > 10 ? this.setupInfo[14] : this.setupInfo[4];
                address = this.p.getInt(this.hex.getData(), addressPtrStart + 2 * (row - 1)) + this.execAddrOffset;
                int endAddr = 0;
                for (int addr : this.getExecSetupAddresses()) {
                    if (addr <= address) continue;
                    endAddr = addr;
                    break;
                }
                if ((data = this.hex.subHex(address, endAddr - address)) == null) {
                    if (removalList == null) {
                        removalList = new ArrayList<Integer>();
                    }
                    removalList.add(key);
                    continue;
                }
                SetupAnalysis setupAnalysis = null;
                try {
                    setupAnalysis = new SetupAnalysis(key, code, data);
                    if (setupAnalysis.errorMsg != null) {
                        return setupAnalysis.errorMsg;
                    }
                }
                catch (Exception e) {
                    return "Setup Analysis error for device type " + key + ", setup code " + code;
                }
                this.analyses.put(row, setupAnalysis);
                ++row;
            }
        }
        if (removalList != null) {
            for (int key : removalList) {
                this.setupCodeLists.remove(key);
            }
        }
        this.mergedSetupByRow = new LinkedHashMap();
        for (int i = 1; i < row; ++i) {
            String mergeError = this.mergeAnalyses(i);
            if (mergeError != null) {
                return mergeError;
            }
            ArrayList<Short> valList = new ArrayList<Short>();
            for (Short[] val : this.analyses.get((Object)Integer.valueOf((int)i)).setupState.values()) {
                for (int j = 0; j < val.length; ++j) {
                    valList.add(val[j]);
                }
            }
            Hex mergeHex = new Hex(valList.toArray(new Short[0]));
            this.mergedSetupByRow.put(i, mergeHex);
        }
        return null;
    }

    private int getCarrierFreq(Processor proc, Hex procHex) {
        int oscillatorFreq = proc.getOscillatorFreq();
        if (proc.getEquivalentName().equals("S3C80")) {
            short onTime = procHex.getData()[0];
            short offTime = procHex.getData()[1];
            return oscillatorFreq / (onTime + offTime + proc.getCarrierTotalOffset());
        }
        int[] carrierData = proc.getCarrierData(procHex);
        return oscillatorFreq / carrierData[0];
    }

    public StringBuilder makeProtocols(StringBuilder sb) {
        String ls = System.lineSeparator();
        StringBuilder execSB = new StringBuilder();
        int execPIDsPtr = this.getSetupInfo()[0];
        int originalExecCount = this.p.getInt(this.hex.getData(), execPIDsPtr);
        sb.append("[Protocols]");
        sb.append(ls + "#Version information determined from protocols.ini");
        for (int i = 0; i < this.execCount; ++i) {
            execSB.append("" + i + ", ");
            int execAddrPtr = execPIDsPtr + 2 + 2 * i + 2 * originalExecCount;
            int pidVal = this.p.getInt(this.hex.getData(), execPIDsPtr + 2 * i + 2);
            int execAddr = this.execAddrOffset + this.p.getInt(this.hex.getData(), execAddrPtr);
            int execEnd = 0;
            for (int addr : this.getExecSetupAddresses()) {
                if (addr <= execAddr) continue;
                execEnd = addr;
                break;
            }
            Hex execHex = Hex.subHex(this.hex.getData(), execAddr, execEnd - execAddr);
            short[] pidData = new short[]{(short)(pidVal >> 8), (short)(pidVal & 0xFF)};
            Hex pid = new Hex(pidData);
            List<Protocol> protocols = ProtocolManager.getProtocolManager().findByPID(pid);
            if (protocols == null || protocols.isEmpty()) {
                System.err.println("An entry for PID = " + pid + " in protocols.ini is missing.  It needs:");
                System.err.println("  Processor = " + this.p.getEquivalentName());
                System.err.println("  Code = " + execHex);
            }
            Protocol protocol = null;
            int firstDiff = -1;
            Protocol provProt = null;
            String equivName = null;
            Processor equivProc = null;
            ArrayList<Protocol> matchList = new ArrayList<Protocol>();
            for (Protocol prot : protocols) {
                int execFreq;
                if (prot.getVariantName().startsWith("JP") || prot.getVariantName().equals("slingbox")) continue;
                short fixVar = 0;
                int carrierFreq = 0;
                String[] procs = prot.getCode().keySet().toArray(new String[0]);
                if (procs == null || procs.length == 0) continue;
                for (String procName : procs) {
                    Processor proc = ProcessorManager.getProcessor(procName);
                    equivName = proc.getEquivalentName();
                    if (!equivName.equals("S3C80") && !equivName.equals("MAXQ610") && !equivName.equals("TI2541")) continue;
                    equivProc = ProcessorManager.getProcessor(equivName);
                    Hex procHex = prot.getCode().get(equivName);
                    fixVar = procHex.getData()[proc.getProtocolHeaderSize() - 1];
                    carrierFreq = this.getCarrierFreq(equivProc, procHex);
                    break;
                }
                if (execHex.getData()[this.fixVarOffset] != fixVar || (double)(execFreq = this.getCarrierFreq(equivProc = ProcessorManager.getProcessor(equivName = this.p.getEquivalentName()), execHex)) < 0.9 * (double)carrierFreq || (double)execFreq > 1.1 * (double)carrierFreq) continue;
                if (prot.getCode().get(this.p.getEquivalentName()) == null) {
                    provProt = prot;
                    continue;
                }
                Hex test = prot.getCode().get(this.p.getEquivalentName());
                boolean hasDiff = false;
                for (int j = this.fixVarOffset; j < execHex.length() && j < test.length(); ++j) {
                    if (execHex.getData()[j] == test.getData()[j]) continue;
                    hasDiff = true;
                    if (j > firstDiff) {
                        firstDiff = j;
                        matchList.clear();
                        matchList.add(prot);
                        break;
                    }
                    if (j != firstDiff) break;
                    matchList.add(prot);
                    break;
                }
                if (hasDiff) continue;
                protocol = prot;
                break;
            }
            String variant = null;
            Protocol protNoVariant = null;
            if (protocol == null && !matchList.isEmpty()) {
                for (Protocol prot : matchList) {
                    variant = prot.getVariantName();
                    if (variant == null || variant.isEmpty()) {
                        protNoVariant = prot;
                        continue;
                    }
                    protocol = prot;
                    break;
                }
                if (protocol == null) {
                    protocol = protNoVariant;
                }
            }
            if (protocol == null && !protocols.isEmpty()) {
                protocol = provProt;
                System.err.println("No match found for PID " + pid + " for processor " + this.p.getEquivalentName() + ":");
                System.err.println("  code = " + execHex);
                if (protocol != null && protocol.getVariantName() != null && !protocol.getVariantName().isEmpty()) {
                    variant = protocol.getVariantName();
                    System.err.println("  variant = " + variant);
                }
            } else if (protocol != null) {
                variant = protocol.getVariantName();
            }
            execSB.append(String.format("%04X, ", execAddr));
            execSB.append(String.format("%04X, ", pidVal));
            execSB.append(execHex.toString() + ls);
            if (i % 10 == 0) {
                sb.append(ls + "    ");
            }
            sb.append(String.format("%04X", pidVal));
            if (variant != null && !variant.isEmpty()) {
                sb.append(":" + variant);
            }
            if (i >= this.execCount - 1) continue;
            sb.append(", ");
        }
        return execSB;
    }

    public void makeSetupData(StringBuilder sb, StringBuilder sbcsv, int maxDevType) {
        String ls = System.lineSeparator();
        sb.append(ls + ls + "[SetupData]");
        sb.append(ls + "Row number, device type, Setup code, address, type, pid, numberTable, fixed data, map bytes, hex data, link row");
        for (int row : this.analyses.keySet()) {
            SetupAnalysis sa = this.analyses.get(row);
            if (sa.devType > maxDevType) continue;
            int address = this.p.getInt(this.hex.getData(), this.setupInfo[4] + 2 * (row - 1)) + this.execAddrOffset;
            ArrayList<Short> valList = new ArrayList<Short>();
            for (Short[] val : sa.setupState.values()) {
                for (int i = 0; i < val.length; ++i) {
                    valList.add(val[i]);
                }
            }
            Hex mergeHex = new Hex(valList.toArray(new Short[0]));
            if (sa.firstLink == null) {
                sa.firstLink = 0;
            }
            if (sa.numTable == null) {
                sa.numTable = 0;
            }
            int mask = this.uses16bitSetupCodes ? 65535 : 4095;
            sb.append(ls + String.format("%03d, %d, %04d, %05X, %d, %s, %02X, %s, %s, %s%s, %d", row, sa.devType, sa.setupCode & mask, address, sa.type, sa.pid, sa.numTable, sa.fixedData, sa.mapBytes, sa.numHex == null ? "" : sa.numHex + " ", mergeHex, sa.firstLink & 0xFFF));
            if (sbcsv == null) continue;
            sbcsv.append(String.format("%s,%d,%04d,%04X,", this.signature, sa.devType, sa.setupCode & mask, sa.pid.get(0)));
            sbcsv.append(String.format("%s %02X %s %s%s", sa.pid, sa.numTable, sa.mapBytes, sa.fixedData == null || sa.fixedData.length() == 0 ? "" : sa.fixedData + " ", mergeHex) + ls);
        }
    }

    public void makeExtract() {
        try {
            int i;
            String ls = System.lineSeparator();
            StringBuilder sb = new StringBuilder();
            StringBuilder sbcsv = new StringBuilder();
            String remoteName = "No RDF";
            List<Remote> remoteList = RemoteManager.getRemoteManager().findRemoteBySignature(this.signature);
            if (remoteList != null && !remoteList.isEmpty()) {
                remoteName = remoteList.get(0).getName();
            }
            String gextName = this.signature + " (" + remoteName + ").gext";
            String gcsvName = this.signature + " (" + remoteName + ").csv";
            File gextFile = new File(RemoteMaster.getWorkDir(), gextName);
            File gcsvFile = new File(RemoteMaster.getWorkDir(), gcsvName);
            FileWriter fw = new FileWriter(gextFile);
            PrintWriter pw = new PrintWriter(fw);
            FileWriter fwcsv = new FileWriter(gcsvFile);
            PrintWriter pwcsv = new PrintWriter(fwcsv);
            sb.append("Signature: " + this.signature + ls);
            sb.append("Processor: " + this.p.getName() + ls);
            sb.append("Flash size: " + this.flashSize + ls);
            Collections.sort(this.segmentTypes);
            sb.append("Segment types:");
            for (int segType : this.segmentTypes) {
                sb.append(String.format(" $%02X", segType));
            }
            sb.append(ls);
            sb.append("Has block format: " + (this.blockStruct ? "Y" : "N") + ls);
            sb.append("Uses 16-bit setup codes: " + (this.uses16bitSetupCodes ? "Y" : "N") + ls);
            if (this.omitDigitMapByte) {
                sb.append("OmitDigitMapByte: Y" + ls);
            }
            sb.append(String.format("Code area: %04X", this.codeAddress) + ls);
            sb.append(String.format("Signature area: %04X", this.sigAddress) + ls);
            sb.append(String.format("IR Database address: %04X", this.irdbAddress) + ls);
            sb.append(String.format("E2 area: %04X to %04X", this.e2Address, this.e2Address + this.e2Len - 1) + ls);
            sb.append(String.format("Ptr to number tables: %04X", this.numberTablesStart) + ls);
            sb.append(String.format("Ptr to digit btn grp: %04X", this.groupAddrs[0]) + ls);
            sb.append(String.format("Ptr to vol btn grp: %04X", this.groupAddrs[1]) + ls);
            sb.append(String.format("Ptr to ch btn grp: %04X", this.groupAddrs[2]) + ls);
            if (this.btnMapPtrPtr > 0) {
                sb.append(String.format("Ptr to btn map ptrs: %04X", this.btnMapPtrPtr) + ls);
            }
            int n = 0;
            for (int btnMapPtr : this.btnMapsDistinct.keySet()) {
                int ndx = this.btnMapsDistinct.get(btnMapPtr);
                if (ndx == 0) {
                    sb.append("Ptr to btn map " + n++ + String.format(": %04X", btnMapPtr) + ls);
                    continue;
                }
                for (int i2 = 0; i2 <= ndx; ++i2) {
                    sb.append("Ptr " + i2 + " to btn map " + n + String.format(": %04X", btnMapPtr) + ls);
                }
                ++n;
            }
            short[] e2Data = this.e2Hex.getData();
            String actualCheckSum = String.format("  %04X", this.e2Hex.get(0));
            AddressRange range = new AddressRange(2, this.dataEnd - 1);
            range.setRoundTo(1);
            CheckSum cs = new XorCheckSum(0, range, false);
            String checkXOR = String.format("  %04X", cs.getCheckSum(e2Data));
            range.setRoundTo(2);
            cs = new Xor16CheckSum(0, range, false);
            String check2XOR16 = String.format("  %04X", cs.getCheckSum(e2Data));
            range.setRoundTo(4);
            cs = new Xor16CheckSum(0, range, false);
            String check4XOR16 = String.format("  %04X", cs.getCheckSum(e2Data));
            sb.append(ls + "[Checksums]");
            sb.append(ls + "$0000:$0002..$" + String.format("%04X", this.e2Len - 1));
            sb.append(ls + " addr    read    ^    */2   */4");
            sb.append(ls + "E2 area" + actualCheckSum + checkXOR + check2XOR16 + check4XOR16);
            sb.append(ls);
            int maxDevType = this.btnMapPtrs.size() - 1;
            for (int row : this.analyses.keySet()) {
                SetupAnalysis sa = this.analyses.get(row);
                if (sa.devType <= maxDevType || sa.fixedData == null && sa.mapBytes == null && (sa.data == null || sa.data.getData().length <= 0)) continue;
                maxDevType = sa.devType;
            }
            sb.append(ls + "[DeviceTypes]");
            for (i = 0; i < this.setupCodeLists.size() && i <= maxDevType; ++i) {
                int btnMapPtr = this.btnMapPtrs.get(i % this.btnMapPtrs.size());
                ArrayList<Integer> distinctKeys = new ArrayList<Integer>(this.btnMapsDistinct.keySet());
                int mapNum = distinctKeys.indexOf(btnMapPtr);
                sb.append(ls + "DevType" + i + " = " + mapNum + ", " + i);
            }
            sb.append(ls);
            sb.append(ls + "[DeviceButtons]");
            for (i = 0; i < this.deviceButtons.size(); ++i) {
                sb.append(ls + String.format("Dev%d = $%02X 0", i, this.deviceButtons.get(i)));
            }
            sb.append(ls);
            sb.append(ls + "[Digit Tables]");
            for (i = 0; i < this.setupInfo[7] - this.setupInfo[6]; ++i) {
                if (i % 10 == 0) {
                    sb.append(ls + "    ");
                }
                sb.append(String.format("%02X ", this.hex.getData()[this.setupInfo[6] + i]));
            }
            sb.append(ls + ls);
            sb.append("[ButtonMaps]" + ls);
            for (int btnMapNdx : this.btnMaps.keySet()) {
                sb.append(btnMapNdx + " = ");
                for (int i3 = 0; i3 < 3; ++i3) {
                    sb.append("(");
                    int addr = this.groupAddrs[i3];
                    if (addr == 0) {
                        sb.append("), ");
                        continue;
                    }
                    int groupLen = i3 == 0 ? 10 : (i3 == 1 ? 3 : 2);
                    for (int j = 0; j < groupLen; ++j) {
                        sb.append(String.format("$%02X", this.hex.getData()[addr + j]));
                        sb.append(j == groupLen - 1 ? (i3 == 2 ? ")" : "), ") : ", ");
                    }
                }
                List<Short> btnCodes = this.btnMaps.get(btnMapNdx);
                int len = btnCodes.size();
                if (len == 0) {
                    sb.append(ls);
                    continue;
                }
                sb.append(", " + ls + "    ");
                for (int i4 = 1; i4 <= len; ++i4) {
                    sb.append(String.format("$%02X", btnCodes.get(i4 - 1)));
                    sb.append(i4 == len ? ls : (i4 % 16 == 0 ? "," + ls + "    " : ", "));
                }
            }
            sb.append(ls);
            StringBuilder execSB = this.makeProtocols(sb);
            sb.append(ls + ls + "[ProtocolCode]");
            sb.append(ls + "Row number, address, PID, Executor");
            sb.append(ls + execSB.toString());
            sb.append(ls + "[SetupCodes]");
            for (int key : this.setupCodeLists.keySet()) {
                ArrayList<Integer> codeList = new ArrayList<Integer>();
                int mask = this.uses16bitSetupCodes ? 65535 : 4095;
                for (int code : this.setupCodeLists.get(key)) {
                    codeList.add(code & mask);
                }
                Collections.sort(codeList);
                sb.append(ls + key + " = ");
                for (int i5 = 0; i5 < codeList.size(); ++i5) {
                    sb.append(String.format("%04d", codeList.get(i5)));
                    sb.append(i5 < codeList.size() - 1 ? "," : "");
                    if ((i5 + 1) % 16 != 0 || i5 == codeList.size() - 1) continue;
                    sb.append(ls + "    ");
                }
            }
            this.makeSetupData(sb, sbcsv, maxDevType);
            pw.print(sb.toString());
            pw.close();
            pwcsv.print(sbcsv.toString());
            pwcsv.close();
            fw.close();
            fwcsv.close();
            String title = "Graham's extract creator";
            String message = "Extract and CSV files \"" + gextName + "\" and \"" + gcsvName + "\"\n have been written to your RMIR installation folder";
            JOptionPane.showMessageDialog(this.owner, message, title, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class SetupAnalysis {
        int devType = 0;
        int setupCode = 0;
        int type = 0;
        Hex pid = null;
        Hex data = null;
        Integer numTable = null;
        Hex numHex = null;
        Hex mapBytes = null;
        Hex fixedData = null;
        Integer link = null;
        Integer firstLink = null;
        String errorMsg = null;
        Hex diffBytes = null;
        int numFix = 0;
        int numVar = 0;
        int numDataBytes = 0;
        int numNulls = 0;
        LinkedHashMap<Short, Short[]> setupState = null;

        public SetupAnalysis(int devType, int setupCode, Hex data) {
            int i;
            boolean skipNumTbl;
            this.devType = devType;
            this.setupCode = setupCode;
            this.data = data;
            int pos = 0;
            this.pid = data.subHex(pos, 2);
            this.type = this.pid.getData()[0] >> 4;
            short[] sArray = this.pid.getData();
            sArray[0] = (short)(sArray[0] & 0xF);
            boolean bl = skipNumTbl = (this.type & 1) == 1;
            if (!BinAnalyzer.this.omitDigitMapByte && !skipNumTbl && BinAnalyzer.this.setupInfo[6] == BinAnalyzer.this.setupInfo[7] && data.getData()[pos += 2] != 0) {
                BinAnalyzer.this.omitDigitMapByte = true;
            }
            if (!skipNumTbl && !BinAnalyzer.this.omitDigitMapByte) {
                this.numTable = data.getData()[pos++];
            }
            short bitMapByte = 0;
            int btnCount = 0;
            int mask = 128;
            int n = 0;
            int ndx = 0;
            this.setupState = new LinkedHashMap();
            int execCount = BinAnalyzer.this.p.getInt(BinAnalyzer.this.hex.getData(), BinAnalyzer.this.setupInfo[0]);
            int execAddrPtr = 0;
            for (int i2 = 0; i2 < execCount; ++i2) {
                if (BinAnalyzer.this.p.getInt(BinAnalyzer.this.hex.getData(), BinAnalyzer.this.setupInfo[0] + 2 + 2 * i2) != this.pid.get(0)) continue;
                execAddrPtr = BinAnalyzer.this.setupInfo[0] + 2 + 2 * i2 + 2 * execCount;
                break;
            }
            int execAddr = BinAnalyzer.this.execAddrOffset + BinAnalyzer.this.p.getInt(BinAnalyzer.this.hex.getData(), execAddrPtr);
            short fixVar = BinAnalyzer.this.hex.getData()[execAddr + BinAnalyzer.this.fixVarOffset];
            this.numFix = fixVar >> 4;
            this.numVar = fixVar & 0xF;
            if (this.numTable != null && this.numTable > 0) {
                this.numHex = BinAnalyzer.this.numberTables.subHex((this.numTable - 1) * 10, this.numVar * 10);
            }
            do {
                bitMapByte = data.getData()[pos + n];
                int btnMapNum = BinAnalyzer.this.getBtnMapNdx(devType);
                for (int i3 = 0; i3 < 7; ++i3) {
                    if ((bitMapByte << i3 & mask) == mask) {
                        if (n == 0 && i3 < 3) {
                            btnCount += this.addGroup(i3);
                        } else {
                            short key = 0;
                            String addrStr = "";
                            for (int mapAddr : BinAnalyzer.this.btnMapPtrs) {
                                addrStr = addrStr + String.format("%05x ", mapAddr);
                            }
                            try {
                                key = BinAnalyzer.this.btnMaps.get(btnMapNum).get(ndx - 3);
                                this.setupState.put(key, new Short[this.numVar]);
                                ++btnCount;
                            }
                            catch (Exception e) {
                                this.errorMsg = "Button map reference error:\nMapPtrs " + addrStr + "\nMap Number " + btnMapNum + ", position " + (ndx - 3);
                                return;
                            }
                        }
                    }
                    ++ndx;
                }
                ++n;
            } while ((bitMapByte & 1) == 0);
            this.mapBytes = data.subHex(pos, n);
            this.fixedData = data.subHex(pos += n, this.numFix);
            pos += fixVar >> 4;
            this.numDataBytes = btnCount * this.numVar;
            ndx = 0;
            if ((this.type & 4) == 4) {
                this.firstLink = this.link = Integer.valueOf(data.getData()[pos] + (data.getData()[pos + 1] << 8));
                this.diffBytes = data.subHex(pos += 2, (int)Math.ceil((double)this.numDataBytes / 8.0));
                pos += this.diffBytes.length();
                this.numNulls = 0;
                for (i = 0; i < this.numDataBytes; ++i) {
                    short diffMapByte = this.diffBytes.getData()[i / 8];
                    int diffBit = diffMapByte >> 7 - i % 8 & 1;
                    this.numNulls += diffBit;
                    if (diffBit != 0) continue;
                    short key = this.setupState.keySet().toArray(new Short[0])[i / this.numVar];
                    this.setupState.get((Object)Short.valueOf((short)key))[i % this.numVar] = data.getData()[pos + ndx++];
                }
                this.numDataBytes -= this.numNulls;
            } else {
                for (i = 0; i < this.numDataBytes; ++i) {
                    short key = this.setupState.keySet().toArray(new Short[0])[i / this.numVar];
                    if (pos + i >= data.length()) continue;
                    this.setupState.get((Object)Short.valueOf((short)key))[i % this.numVar] = data.getData()[pos + i];
                }
                int numKeyData = data.subHex(pos).length() / this.numVar;
                Short[] setupKeys = this.setupState.keySet().toArray(new Short[0]);
                for (int i4 = numKeyData; i4 < setupKeys.length; ++i4) {
                    Short key = setupKeys[i4];
                    this.setupState.remove(key);
                }
            }
        }

        private int addGroup(int ndx) {
            int num = ndx == 0 ? 10 : (ndx == 1 ? 3 : 2);
            int addr = BinAnalyzer.this.groupAddrs[ndx];
            for (int i = 0; i < num; ++i) {
                this.setupState.put(BinAnalyzer.this.hex.getData()[addr + i], new Short[this.numVar]);
            }
            return num;
        }
    }
}

