/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EncrypterDecrypter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;

public class BinaryUpgradeReader {
    private Remote remote = null;
    private DataInputStream dis = null;
    private int setupCode = 0;
    private int deviceIndex = 0;
    private Hex pid = null;
    private Hex code = null;
    private Hex pCode = null;

    public BinaryUpgradeReader(File file) throws IOException {
        String name = file.getName();
        int underscore = name.lastIndexOf(95);
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            dot = name.length();
        }
        String tag = null;
        if (underscore != -1 && dot != -1 && underscore < dot) {
            tag = name.substring(underscore + 1, dot);
            List<Remote> remotes = RemoteManager.getRemoteManager().findRemoteBySignature("BIN" + tag.toUpperCase());
            if (remotes.size() == 0) {
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The binary file \"" + name + "\" isn't a supported binary upgrade file.", "Invalid binary file", 0);
                return;
            }
            if (remotes.size() == 1) {
                this.remote = remotes.get(0);
            } else {
                Object[] choices = new Remote[remotes.size()];
                choices = remotes.toArray(choices);
                this.remote = (Remote)JOptionPane.showInputDialog(RemoteMaster.getFrame(), "The selected binary upgrade can be used for multiple remotes.  Please select the desired remote.", "Select a remote", 3, null, choices, choices[0]);
                if (this.remote == null) {
                    return;
                }
            }
        }
        EncrypterDecrypter encdec = this.remote.getEncrypterDecrypter();
        this.dis = new DataInputStream(new FileInputStream(file));
        int upgradeLength = 0;
        upgradeLength = tag.equals("OBJ") ? (int)file.length() : (int)this.readUnsignedByte(encdec);
        short protocolOffset = this.readUnsignedByte(encdec);
        short temp1 = this.readUnsignedByte(encdec);
        short temp2 = this.readUnsignedByte(encdec);
        this.deviceIndex = temp1 >> 4;
        this.setupCode = (temp1 & 7) << 8 | temp2;
        boolean pidGreaterThanFF = (temp1 & 8) != 0;
        int deviceUpgradeLength = upgradeLength - 3;
        int protocolUpradeLength = 0;
        if (protocolOffset != 0) {
            deviceUpgradeLength = protocolOffset - 3;
            protocolUpradeLength = upgradeLength - protocolOffset;
        }
        short[] upgradeCode = new short[deviceUpgradeLength];
        for (int i = 0; i < deviceUpgradeLength; ++i) {
            upgradeCode[i] = this.readUnsignedByte(encdec);
        }
        this.code = new Hex(upgradeCode);
        short[] temp = new short[]{(short)(pidGreaterThanFF ? 1 : 0), upgradeCode[0]};
        this.pid = new Hex(temp);
        short[] protocolCode = null;
        if (protocolOffset != 0) {
            protocolCode = new short[protocolUpradeLength];
            for (int i = 0; i < protocolUpradeLength; ++i) {
                protocolCode[i] = this.readUnsignedByte(encdec);
            }
            this.pCode = new Hex(protocolCode);
        }
    }

    private short readUnsignedByte(EncrypterDecrypter encdec) throws IOException {
        short val = (short)this.dis.readUnsignedByte();
        if (encdec != null) {
            val = encdec.decrypt(val);
        }
        return val;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public int getSetupCode() {
        return this.setupCode;
    }

    public int getDeviceIndex() {
        return this.deviceIndex;
    }

    public Hex getPid() {
        return this.pid;
    }

    public Hex getCode() {
        return this.code;
    }

    public Hex getProtocolCode() {
        return this.pCode;
    }
}

