/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AdvancedCode;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.EFC5;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.MultiMacro;
import com.hifiremote.jp1.Remote;
import javax.swing.JCheckBox;

public class Button {
    public static final Button noButton = new Button("<none>", "<none>", 0, null);
    private String name;
    private String standardName;
    private short keyCode;
    private Remote remote;
    private MultiMacro multiMacro = null;
    private boolean legacyMulti = false;
    private Button baseButton = null;
    private Button shiftedButton = null;
    private Button xShiftedButton = null;
    private boolean isShifted = false;
    private boolean isXShifted = false;
    private int restrictions = 0;
    private int buttonMaps = 0;
    private boolean hasShape = false;
    public static final int NORMAL_STATE = 0;
    public static final int SHIFTED_STATE = 1;
    public static final int XSHIFTED_STATE = 2;
    public static int MOVE_BIND = 1;
    public static int SHIFT_MOVE_BIND = 2;
    public static int XSHIFT_MOVE_BIND = 4;
    public static int ALL_MOVE_BIND = MOVE_BIND | SHIFT_MOVE_BIND | XSHIFT_MOVE_BIND;
    public static int MACRO_BIND = 8;
    public static int SHIFT_MACRO_BIND = 16;
    public static int XSHIFT_MACRO_BIND = 32;
    public static int ALL_MACRO_BIND = MACRO_BIND | SHIFT_MACRO_BIND | XSHIFT_MACRO_BIND;
    public static int LEARN_BIND = 64;
    public static int SHIFT_LEARN_BIND = 128;
    public static int XSHIFT_LEARN_BIND = 256;
    public static int ALL_LEARN_BIND = LEARN_BIND | SHIFT_LEARN_BIND | XSHIFT_LEARN_BIND;
    public static int MACRO_DATA = 512;
    public static int SHIFT_MACRO_DATA = 1024;
    public static int XSHIFT_MACRO_DATA = 2048;
    public static int ALL_MACRO_DATA = MACRO_DATA | SHIFT_MACRO_DATA | XSHIFT_MACRO_DATA;
    public static int TMACRO_DATA = 4096;
    public static int SHIFT_TMACRO_DATA = 8192;
    public static int XSHIFT_TMACRO_DATA = 16384;
    public static int ALL_TMACRO_DATA = TMACRO_DATA | SHIFT_TMACRO_DATA | XSHIFT_TMACRO_DATA;
    public static int FAV_DATA = 32768;
    public static int SHIFT_FAV_DATA = 65536;
    public static int XSHIFT_FAV_DATA = 131072;
    public static int CONTROLLED_MACRO_BIND = 262144;
    public static int ALL_FAV_DATA = FAV_DATA | SHIFT_FAV_DATA | XSHIFT_FAV_DATA;
    public static int PWRMACRO_DATA = 262144;
    public static int SHIFT_PWRMACRO_DATA = 524288;
    public static int XSHIFT_PWRMACRO_DATA = 0x100000;
    public static int ALL_PWRMACRO_DATA = PWRMACRO_DATA | SHIFT_PWRMACRO_DATA | XSHIFT_PWRMACRO_DATA;
    public static int BIND = MOVE_BIND | MACRO_BIND | LEARN_BIND;
    public static int SHIFT_BIND = SHIFT_MOVE_BIND | SHIFT_MACRO_BIND | SHIFT_LEARN_BIND;
    public static int XSHIFT_BIND = XSHIFT_MOVE_BIND | XSHIFT_MACRO_BIND | XSHIFT_LEARN_BIND;
    public static int ALL_BIND = ALL_MOVE_BIND | ALL_MACRO_BIND | ALL_LEARN_BIND;
    public static int DATA = MACRO_DATA | TMACRO_DATA | FAV_DATA | PWRMACRO_DATA;
    public static int SHIFT_DATA = SHIFT_MACRO_DATA | SHIFT_TMACRO_DATA | SHIFT_FAV_DATA | SHIFT_PWRMACRO_DATA;
    public static int XSHIFT_DATA = XSHIFT_MACRO_DATA | XSHIFT_TMACRO_DATA | XSHIFT_FAV_DATA | XSHIFT_PWRMACRO_DATA;
    public static int ALL_DATA = ALL_MACRO_DATA | ALL_TMACRO_DATA | ALL_FAV_DATA | ALL_PWRMACRO_DATA;
    public static int SHIFT = SHIFT_BIND | SHIFT_DATA;
    public static int XSHIFT = XSHIFT_BIND | XSHIFT_DATA;
    public static int ALL = ALL_DATA | ALL_BIND;

    public Button(String standardName, String name, short code, Remote r) {
        this.standardName = standardName.toLowerCase();
        this.name = name;
        this.keyCode = code;
        this.remote = r;
        if (this.remote == null) {
            return;
        }
        int maskedCode = code & 0xC0;
        if (maskedCode == r.getShiftMask() && r.getShiftEnabled()) {
            this.setIsShifted(true);
        } else if (maskedCode == r.getXShiftMask() && r.getXShiftEnabled()) {
            this.setIsXShifted(true);
        } else if (maskedCode != 0 && (r.getXShiftEnabled() || (maskedCode & r.getShiftMask()) != 0)) {
            this.restrictions |= SHIFT | XSHIFT;
        }
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShiftedName() {
        if (this.isShifted) {
            return this.name;
        }
        if (this.shiftedButton != null) {
            return this.shiftedButton.getName();
        }
        return this.remote.getShiftLabel() + '-' + this.name;
    }

    public String getXShiftedName() {
        if (this.isXShifted) {
            return this.name;
        }
        if (this.xShiftedButton != null) {
            return this.xShiftedButton.getName();
        }
        return this.remote.getXShiftLabel() + '-' + this.name;
    }

    public String getName(int state) {
        if (state == 1) {
            return this.getShiftedName();
        }
        if (state == 2) {
            return this.getXShiftedName();
        }
        return this.getName();
    }

    public String getStandardName() {
        return this.standardName;
    }

    public void setStandardName(String name) {
        this.standardName = name.toLowerCase();
    }

    public short getKeyCode() {
        return this.keyCode;
    }

    public short getShiftedKeyCode() {
        return (short)(this.keyCode | this.remote.getShiftMask());
    }

    public short getXShiftedKeyCode() {
        return (short)(this.keyCode | this.remote.getXShiftMask());
    }

    public short getKeyCode(int state) {
        if (state == 1) {
            return this.getShiftedKeyCode();
        }
        if (state == 2) {
            return this.getXShiftedKeyCode();
        }
        return this.getKeyCode();
    }

    public MultiMacro getMultiMacro() {
        return this.multiMacro;
    }

    public void setMultiMacro(MultiMacro multiMacro) {
        this.multiMacro = multiMacro;
    }

    public boolean isLegacyMulti() {
        return this.legacyMulti;
    }

    public void setLegacyMulti(boolean legacyMulti) {
        this.legacyMulti = legacyMulti;
    }

    public void setBaseButton(Button button) {
        this.baseButton = button;
        if (this.isShifted && !this.allowsKeyMove()) {
            this.baseButton.addRestrictions(SHIFT_MOVE_BIND);
        }
        if (this.isXShifted && !this.allowsKeyMove()) {
            this.baseButton.addRestrictions(XSHIFT_MOVE_BIND);
        }
    }

    public Button getBaseButton() {
        return this.baseButton;
    }

    public Button getShiftedButton() {
        return this.shiftedButton;
    }

    public void setShiftedButton(Button button) {
        this.shiftedButton = button;
    }

    public void setXShiftedButton(Button button) {
        this.xShiftedButton = button;
    }

    public Button getXShiftedButton() {
        return this.xShiftedButton;
    }

    public boolean getIsNormal() {
        return !this.isShifted && !this.isXShifted;
    }

    public void setIsShifted(boolean flag) {
        this.isShifted = flag;
        if (this.isShifted) {
            this.restrictions |= SHIFT | XSHIFT;
        }
    }

    public boolean getIsShifted() {
        return this.isShifted;
    }

    public void setIsXShifted(boolean flag) {
        this.isXShifted = flag;
        if (this.isXShifted) {
            this.restrictions |= SHIFT | XSHIFT;
        }
    }

    public boolean getIsXShifted() {
        return this.isXShifted;
    }

    public int getState() {
        if (this.getIsShifted()) {
            return 1;
        }
        if (this.getIsXShifted()) {
            return 2;
        }
        return 0;
    }

    public int getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(int restrictions) {
        this.restrictions = restrictions;
    }

    public void addRestrictions(int restrictions) {
        this.restrictions |= restrictions;
    }

    public boolean forbidsKeyMoves() {
        return (this.restrictions & ALL_BIND) == ALL_BIND;
    }

    public boolean allowsKeyMove() {
        return (this.restrictions & MOVE_BIND) == 0;
    }

    public boolean allowsShiftedKeyMove() {
        if (this.isShifted || this.isXShifted || this.remote == null || !this.remote.getShiftEnabled()) {
            return false;
        }
        return (this.restrictions & SHIFT_MOVE_BIND) == 0;
    }

    public boolean allowsXShiftedKeyMove() {
        if (this.isShifted || this.isXShifted || this.remote == null || !this.remote.getXShiftEnabled()) {
            return false;
        }
        return (this.restrictions & XSHIFT_MOVE_BIND) == 0;
    }

    public boolean allowsKeyMove(int state) {
        if (state == 1) {
            return this.allowsShiftedKeyMove();
        }
        if (state == 2) {
            return this.allowsXShiftedKeyMove();
        }
        return this.allowsKeyMove();
    }

    public boolean allowsMacro() {
        return (this.restrictions & MACRO_BIND) == 0;
    }

    public boolean allowsControlledMacro() {
        return (this.restrictions & CONTROLLED_MACRO_BIND) == 0;
    }

    public boolean allowsShiftedMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & SHIFT_MACRO_BIND) == 0;
    }

    public boolean allowsXShiftedMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & XSHIFT_MACRO_BIND) == 0;
    }

    public boolean allowsMacro(int state) {
        if (state == 1) {
            return this.allowsShiftedMacro();
        }
        if (state == 2) {
            return this.allowsXShiftedMacro();
        }
        return this.allowsMacro();
    }

    public boolean canAssignToMacro() {
        return (this.restrictions & MACRO_DATA) == 0;
    }

    public boolean canAssignShiftedToMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & SHIFT_MACRO_DATA) == 0;
    }

    public boolean canAssignXShiftedToMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & XSHIFT_MACRO_DATA) == 0;
    }

    public boolean canAssignToFav() {
        return (this.restrictions & FAV_DATA) == 0;
    }

    public boolean canAssignShiftedToFav() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & SHIFT_FAV_DATA) == 0;
    }

    public boolean canAssignXShiftedToFav() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & XSHIFT_FAV_DATA) == 0;
    }

    public boolean canAssignToTimedMacro() {
        return (this.restrictions & TMACRO_DATA) == 0;
    }

    public boolean canAssignShiftedToTimedMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & SHIFT_TMACRO_DATA) == 0;
    }

    public boolean canAssignXShiftedToTimedMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & XSHIFT_TMACRO_DATA) == 0;
    }

    public boolean canAssignToPowerMacro() {
        return (this.restrictions & PWRMACRO_DATA) == 0;
    }

    public boolean canAssignShiftedToPowerMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & SHIFT_PWRMACRO_DATA) == 0;
    }

    public boolean canAssignXShiftedToPowerMacro() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & XSHIFT_PWRMACRO_DATA) == 0;
    }

    public boolean allowsLearnedSignal() {
        return (this.restrictions & LEARN_BIND) == 0;
    }

    public boolean allowsShiftedLearnedSignal() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & SHIFT_LEARN_BIND) == 0;
    }

    public boolean allowsXShiftedLearnedSignal() {
        if (this.isShifted || this.isXShifted) {
            return false;
        }
        return (this.restrictions & XSHIFT_LEARN_BIND) == 0;
    }

    public boolean allowsLearnedSignal(int state) {
        if (state == 1) {
            return this.allowsShiftedLearnedSignal();
        }
        if (state == 2) {
            return this.allowsXShiftedLearnedSignal();
        }
        return this.allowsLearnedSignal();
    }

    public boolean allowed(int type, int state) {
        if (type == MOVE_BIND) {
            return this.allowsKeyMove(state);
        }
        if (type == MACRO_BIND) {
            return this.allowsMacro(state);
        }
        if (type == LEARN_BIND) {
            return this.allowsLearnedSignal(state);
        }
        return false;
    }

    public void setShiftBoxes(int type, JCheckBox shiftBox, JCheckBox xShiftBox) {
        int stateCount = 0;
        if (this.allowed(type, 0)) {
            ++stateCount;
        }
        if (this.remote.getShiftEnabled() && this.allowed(type, 1)) {
            ++stateCount;
        }
        if (this.remote.getXShiftEnabled() && this.allowed(type, 2)) {
            ++stateCount;
        }
        if (stateCount == 1) {
            if (this.remote.getShiftEnabled()) {
                shiftBox.setEnabled(false);
                shiftBox.setSelected(this.allowed(type, 1));
            }
            if (this.remote.getXShiftEnabled()) {
                xShiftBox.setEnabled(false);
                xShiftBox.setSelected(this.allowed(type, 2));
            }
        } else if (stateCount == 2 && !this.allowed(type, 0)) {
            shiftBox.setEnabled(true);
            xShiftBox.setEnabled(true);
            if (!shiftBox.isSelected() && !xShiftBox.isSelected()) {
                shiftBox.setSelected(true);
            }
        } else {
            if (this.remote.getShiftEnabled()) {
                shiftBox.setEnabled(this.allowed(type, 1));
            }
            if (this.remote.getXShiftEnabled()) {
                xShiftBox.setEnabled(this.allowed(type, 2));
            }
        }
    }

    public boolean needsShift(int type) {
        return this.remote.getXShiftEnabled() && this.allowed(type, 1) && this.allowed(type, 2) && !this.allowed(type, 0);
    }

    public void addButtonMap(int mapIndex) {
        this.buttonMaps |= 1 << mapIndex;
    }

    public boolean inButtonMap(int mapIndex) {
        int mask = 1 << mapIndex;
        return (this.buttonMaps & mask) != 0;
    }

    public int getButtonMaps() {
        return this.buttonMaps;
    }

    public KeyMove getKeyMove(Function f, int mask, int setupCode, DeviceType devType, Remote remote, boolean keyMovesOnly) {
        if (!remote.hasKeyMoveSupport()) {
            return null;
        }
        Highlight rc = null;
        if (f != null && f.getHex() != null) {
            Hex hex = f.getHex();
            if (f.isExternal()) {
                ExternalFunction ef = (ExternalFunction)f;
                devType = remote.getDeviceTypeByAliasName(ef.getDeviceTypeAliasName());
                setupCode = ef.getSetupCode() - remote.getDeviceCodeOffset();
            }
            if (f.isExternal() || mask != 0 || !devType.isMapped(this) || keyMovesOnly) {
                StringBuilder sb = new StringBuilder(f.getName());
                String notes = f.getNotes();
                if (notes != null && notes.length() != 0) {
                    sb.append(": ");
                    sb.append(notes);
                }
                rc = remote.createKeyMove(this.keyCode | mask, -1, devType.getNumber(), setupCode, hex, sb.toString());
            }
        }
        if (rc != null && remote.getSegmentTypes() != null) {
            rc.setSegmentFlags(255);
        }
        return rc;
    }

    public short[] getKeyMove(Function f, int mask, short[] deviceCode, DeviceType devType, Remote remote, boolean keyMovesOnly) {
        if (!remote.hasKeyMoveSupport()) {
            return null;
        }
        short[] rc = new short[]{};
        if (f != null && f.getHex() != null) {
            int len = 0;
            Hex hex = f.getHex();
            if (f.isExternal()) {
                ExternalFunction ef = (ExternalFunction)f;
                devType = remote.getDeviceTypeByAliasName(ef.getDeviceTypeAliasName());
                short temp = (short)(devType.getNumber() * 4096);
                temp = (short)(temp + (short)ef.getSetupCode());
                temp = (short)(temp - (short)remote.getDeviceCodeOffset());
                deviceCode = new short[]{(short)(temp >> 8), temp};
            }
            if (remote.getAdvCodeFormat() == AdvancedCode.Format.EFC) {
                short[] data;
                if (hex.length() == 1 && remote.getEFCDigits() == 3) {
                    data = new short[]{0, (short)(EFC.parseHex(hex, 0) & 0xFF)};
                    hex = new Hex(data);
                } else {
                    data = new short[3];
                    int value = EFC5.parseHex(hex);
                    data[0] = (short)(value >> 16 & 0xFF);
                    data[1] = (short)(value >> 8 & 0xFF);
                    data[2] = (short)(value & 0xFF);
                    hex = new Hex(data);
                }
            } else if (hex.length() == 1 && remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
                short efc;
                short[] newData = new short[2];
                newData[0] = efc = hex.getData()[0];
                hex = new Hex(newData);
                newData[1] = (short)(EFC.parseHex(efc) & 0xFF);
            }
            if (f.isExternal() || mask != 0 || !devType.isMapped(this) || keyMovesOnly) {
                len = 4 + hex.length();
            }
            if (len != 0) {
                if (remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.LONG) {
                    ++len;
                }
                rc = new short[len];
                int index = 0;
                rc[index] = (short)(this.keyCode | mask);
                rc[++index] = 240;
                if (remote.getAdvCodeBindFormat() == AdvancedCode.BindFormat.NORMAL) {
                    int n = index;
                    rc[n] = (short)(rc[n] + (short)(2 + hex.length()));
                } else {
                    rc[++index] = (short)(2 + hex.length());
                }
                System.arraycopy(deviceCode, 0, rc, ++index, 2);
                System.arraycopy(hex.getData(), 0, rc, index + 2, hex.length());
            }
        }
        return rc;
    }

    public void setHasShape(boolean flag) {
        if (this.shiftedButton != null) {
            this.shiftedButton.hasShape = flag;
        }
        if (this.xShiftedButton != null) {
            this.xShiftedButton.hasShape = flag;
        }
        this.hasShape = flag;
    }

    public boolean getHasShape() {
        return this.hasShape;
    }
}

