/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonAssignment;
import com.hifiremote.jp1.ButtonAssignmentTableModel;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.LocalObjectTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;

public class ButtonAssignmentTable
extends JTable {
    private ButtonAssignmentTableModel model = new ButtonAssignmentTableModel();

    public ButtonAssignmentTable() {
        this.setModel(this.model);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(0);
        this.setSurrendersFocusOnKeystroke(true);
        ((DefaultTableCellRenderer)this.getDefaultRenderer(Button.class)).setHorizontalAlignment(0);
        this.getTableHeader().setReorderingAllowed(false);
        ((DefaultTableCellRenderer)this.getDefaultRenderer(Function.class)).setToolTipText("Drag or double-click a function to set the functions for a button, or use the popup menu of available functions.");
        TransferHandler th = new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                boolean rc = false;
                for (int i = 0; i < flavors.length; ++i) {
                    if (flavors[i] != LocalObjectTransferable.getFlavor()) continue;
                    rc = true;
                    break;
                }
                return rc;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                boolean rc = false;
                ButtonAssignmentTable table = (ButtonAssignmentTable)c;
                int row = table.getSelectedRow();
                int col = table.getSelectedColumn();
                if (col != 0) {
                    try {
                        Function f = (Function)t.getTransferData(LocalObjectTransferable.getFlavor());
                        ButtonAssignmentTable.this.model.setValueAt(f, row, col);
                        ButtonAssignmentTable.this.model.fireTableCellUpdated(row, col);
                    }
                    catch (Exception e) {
                        rc = false;
                        e.printStackTrace(System.err);
                    }
                } else {
                    rc = false;
                }
                return rc;
            }
        };
        this.setTransferHandler(th);
    }

    public void setAssignments(ButtonAssignment[] assignments) {
        this.model.setAssignments(assignments);
    }
}

