/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import java.util.Iterator;

public class ButtonAssignments {
    private Function[] assignedFunctions = new Function[256];

    public void clear() {
        for (int i = 0; i < this.assignedFunctions.length; ++i) {
            Function f = this.assignedFunctions[i];
            if (f == null) continue;
            Iterator<GeneralFunction.User> it = f.getUsers().iterator();
            while (it.hasNext()) {
                it.next();
                it.remove();
            }
            this.assignedFunctions[i] = null;
        }
    }

    public void assign(Button b, Function f) {
        this.assign(b, f, 0);
    }

    public void assign(Button b, Function f, int state) {
        DeviceButton db;
        short keyCode = b.getKeyCode(state);
        Function oldFunction = this.assignedFunctions[keyCode];
        if (oldFunction != null && oldFunction == f) {
            return;
        }
        if (oldFunction != null) {
            DeviceButton deviceButton = db = oldFunction.upgrade == null ? null : oldFunction.upgrade.getButtonRestriction();
            if (db == null || db == DeviceButton.noButton) {
                oldFunction.removeReference(b, state);
            } else {
                oldFunction.removeReference(db, b);
            }
        }
        this.assignedFunctions[keyCode] = f;
        if (f != null) {
            DeviceButton deviceButton = db = f.upgrade == null ? null : f.upgrade.getButtonRestriction();
            if (db == null || db == DeviceButton.noButton) {
                f.addReference(b, state);
            } else if (f.upgrade.getLearnedMap() != null && f.upgrade.getLearnedMap().get(b.getKeyCode()) == null) {
                f.addReference(db, b);
            }
        }
    }

    public Function getAssignment(Button b) {
        return this.getAssignment(b, 0);
    }

    public Function getAssignment(Button b, int state) {
        if (b.getIsNormal() && state != 0 && !b.allowsKeyMove(state)) {
            return null;
        }
        if (!b.getIsNormal() && state != 0) {
            return null;
        }
        return this.assignedFunctions[b.getKeyCode(state)];
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.assignedFunctions.length; ++i) {
            if (this.assignedFunctions[i] == null) continue;
            return false;
        }
        return true;
    }

    public Function[] getAssignedFunctions() {
        return this.assignedFunctions;
    }
}

