/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonAssignments;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.Remote;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ButtonMap {
    public Comparator<Button> mapSort = new Comparator<Button>(){

        @Override
        public int compare(Button b1, Button b2) {
            int index = 0;
            index = ButtonMap.this.keyCodeSingleList.indexOf(b1.getKeyCode());
            Integer i1 = index == -1 ? 256 : index;
            index = ButtonMap.this.keyCodeSingleList.indexOf(b2.getKeyCode());
            Integer i2 = index == -1 ? 256 : index;
            return i1.compareTo(i2);
        }
    };
    private int number;
    private int size = 0;
    private short[][] keyCodeList;
    private Button[][] buttons;
    private Remote remote = null;
    private short[] indexList = null;
    private Button[] buttonList = null;
    public List<Short> keyCodeSingleList;

    public ButtonMap(int num, short[][] keyCodes) {
        this.number = num;
        this.keyCodeList = keyCodes;
        this.keyCodeSingleList = new ArrayList<Short>();
        for (int i = 0; i < keyCodes.length; ++i) {
            for (int j = 0; j < keyCodes[i].length; ++j) {
                this.keyCodeSingleList.add(keyCodes[i][j]);
            }
        }
    }

    public List<Short> getKeyCodeSingleList() {
        return this.keyCodeSingleList;
    }

    public int getNumber() {
        return this.number;
    }

    public short[][] getKeyCodeList() {
        return this.keyCodeList;
    }

    public ButtonMap setButtons(Remote remote) {
        this.remote = remote;
        this.size = 0;
        this.buttons = new Button[this.keyCodeList.length][];
        for (int i = 0; i < this.keyCodeList.length; ++i) {
            short[] keyCodes = this.keyCodeList[i];
            Button[] inner = new Button[keyCodes.length];
            this.buttons[i] = inner;
            this.size += keyCodes.length;
            for (int j = 0; j < keyCodes.length; ++j) {
                short keyCode = keyCodes[j];
                Button button = remote.getButton(keyCode);
                if (button == null) {
                    Button baseButton;
                    String name;
                    if (!Remote.prelimLoad) {
                        System.err.println("ERROR: ButtonMap " + this.number + " includes unknown keycode $" + Integer.toHexString(keyCode & 0xFF) + ", Creating button!");
                    }
                    if ((button = new Button(name = "button" + Integer.toHexString(keyCode & 0xFF).toUpperCase(), name, keyCode, remote)).getIsShifted()) {
                        baseButton = remote.getButton(keyCode & 0x3F);
                        if (baseButton != null) {
                            button.setName(baseButton.getShiftedName());
                            button.setStandardName(baseButton.getShiftedName());
                            button.setBaseButton(baseButton);
                            baseButton.setShiftedButton(button);
                        }
                    } else if (button.getIsXShifted() && (baseButton = remote.getButton(keyCode & 0x3F)) != null) {
                        button.setName(baseButton.getXShiftedName());
                        button.setStandardName(baseButton.getXShiftedName());
                        button.setBaseButton(baseButton);
                        baseButton.setXShiftedButton(button);
                    }
                    remote.addButton(button);
                }
                button.addButtonMap(this.number);
                inner[j] = button;
            }
        }
        return this;
    }

    public boolean isPresent(Button b) {
        if (b == null) {
            return false;
        }
        return b.inButtonMap(this.number);
    }

    public Button get(int index) {
        Button rc = null;
        int offset = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            Button[] inner = this.buttons[i];
            if (index < offset + inner.length) {
                rc = inner[index - offset];
                break;
            }
            offset += inner.length;
        }
        return rc;
    }

    public int size() {
        return this.size;
    }

    public List<Button> parseBitMap(short[] bitMap, int offset, boolean digitMapUsed) {
        ArrayList<Button> rc = new ArrayList<Button>();
        int mask = 128;
        for (int i = 0; i < this.buttons.length; ++i) {
            boolean useIt;
            boolean bl = useIt = (bitMap[offset] & mask) != 0;
            if (useIt) {
                Button[] inner = this.buttons[i];
                for (int j = 0; j < inner.length; ++j) {
                    rc.add(inner[j]);
                }
            }
            if ((mask >>= 1) != 1) continue;
            if ((bitMap[offset] & mask) == 1) {
                return rc;
            }
            mask = 128;
            ++offset;
        }
        return rc;
    }

    public short[] toBitMap(boolean digitMapUsed, boolean keyMovesOnly, ButtonAssignments assignments) {
        int len = (this.buttons.length + 6) / 7;
        if (len == 0) {
            return new short[0];
        }
        short[] rc = new short[len];
        int index = 0;
        int temp = 128;
        int limit = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            Button[] inner = this.buttons[i];
            for (int j = 0; j < inner.length; ++j) {
                Function func = null;
                if (inner[j] != null) {
                    func = assignments.getAssignment(inner[j], 0);
                }
                if (digitMapUsed && i == 0) {
                    func = null;
                }
                if (keyMovesOnly) {
                    func = null;
                }
                if (func == null || func.isExternal() || func.getHex() == null) continue;
                int n = index;
                rc[n] = (short)(rc[n] | temp);
                limit = index;
                break;
            }
            if ((temp = (int)((short)(temp >> 1))) != 1) continue;
            temp = 128;
            ++index;
        }
        int n = limit++;
        rc[n] = (short)(rc[n] | 1);
        short[] result = new short[limit];
        System.arraycopy(rc, 0, result, 0, limit);
        return result;
    }

    public short[] toCommandList(boolean digitMapUsed, boolean keyMovesOnly, ButtonAssignments assignments) {
        int count = 0;
        int funcLen = 0;
        boolean[] flags = new boolean[this.buttons.length];
        ArrayList<Button> btns = new ArrayList<Button>();
        block0: for (int i = 0; i < this.buttons.length; ++i) {
            Button[] inner = this.buttons[i];
            flags[i] = false;
            for (int j = 0; j < inner.length; ++j) {
                Function func = assignments.getAssignment(inner[j], 0);
                if (digitMapUsed && i == 0) {
                    func = null;
                }
                if (keyMovesOnly) {
                    func = null;
                }
                if (func == null || func.getClass() == ExternalFunction.class || func.getHex() == null) continue;
                funcLen = func.getHex().length();
                flags[i] = true;
                count += inner.length * funcLen;
                continue block0;
            }
        }
        short[] rc = new short[count];
        this.indexList = new short[funcLen == 0 ? 0 : 2 * count / funcLen];
        Arrays.fill(this.indexList, (short)0);
        short[] zeros = new short[funcLen];
        int index = 0;
        for (int i = 0; i < this.buttons.length; ++i) {
            Button[] inner = this.buttons[i];
            if (!flags[i]) continue;
            for (int j = 0; j < inner.length; ++j) {
                short[] hex = null;
                btns.add(inner[j]);
                Function func = assignments.getAssignment(inner[j], 0);
                if (digitMapUsed && i == 0) {
                    func = null;
                }
                if (keyMovesOnly) {
                    func = null;
                }
                if (func == null || func.getClass() == ExternalFunction.class || func.getHex() == null) {
                    hex = zeros;
                } else {
                    hex = func.getHex().getData();
                    if (funcLen > 0) {
                        Integer funcIndex = func.getGid() == null ? 0 : func.getGid();
                        int k = 2 * index / funcLen;
                        this.indexList[k] = (short)(funcIndex >> 8 & 0xFF);
                        this.indexList[k + 1] = (short)(funcIndex & 0xFF);
                    }
                }
                System.arraycopy(hex, 0, rc, index, funcLen);
                index += funcLen;
            }
        }
        Collections.sort(btns, new Comparator<Button>(){

            @Override
            public int compare(Button b1, Button b2) {
                return new Short(b1.getKeyCode()).compareTo(new Short(b2.getKeyCode()));
            }
        });
        this.buttonList = btns.toArray(new Button[0]);
        return rc;
    }

    public short[] getIndexList() {
        return this.indexList;
    }

    public Button[] getButtonList() {
        return this.buttonList;
    }
}

