/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonTableModel;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionLabel;
import com.hifiremote.jp1.FunctionRenderer;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LocalObjectTransferable;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.PopupEditor;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.RMSetterEditor;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.WrapLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;

public class ButtonPanel
extends KMPanel
implements ActionListener,
ListSelectionListener {
    private JTableX table = null;
    private ButtonTableModel model = null;
    private JPanel functionPanel = null;
    private DoubleClickListener doubleClickListener = new DoubleClickListener();
    private JButton autoAssign = null;
    private AbstractAction deleteAction = null;
    private PopupEditor popupEditor = new PopupEditor();
    private FunctionRenderer renderer = null;
    private int popupRow = 0;
    private int popupCol = 0;
    protected JPopupMenu popup = null;
    private JMenuItem deleteItem = null;
    private JMenuItem copyItem = null;
    private JMenuItem pasteItem = null;
    private SelectionPanel selector = null;
    private RMSetterEditor<GeneralFunction.RMIcon, GeneralFunction.IconPanel> iconEditor = null;
    private JLabel iconLabel = null;
    private JP1Frame frame = null;
    private JScrollPane functionScroll = null;
    private int rowHeight = 0;

    public ButtonPanel(DeviceUpgrade devUpgrade) {
        super("Buttons", devUpgrade);
        this.setLayout(new BorderLayout());
        this.frame = RemoteMaster.getFrame();
        this.model = new ButtonTableModel(devUpgrade);
        this.model.setPanel(this);
        this.table = new JTableX(this.model){

            @Override
            public String getToolTipText(MouseEvent e) {
                Remote remote = ButtonPanel.this.model.getDeviceUpgrade().getRemote();
                if (!remote.usesEZRC() || ButtonPanel.this.frame instanceof KeyMapMaster) {
                    return super.getToolTipText(e);
                }
                String tip = null;
                Point p = e.getPoint();
                int row = this.rowAtPoint(p);
                int rawCol = this.columnAtPoint(p);
                boolean editable = ButtonPanel.this.model.isCellEditable(row, rawCol);
                int col = ButtonPanel.this.model.getEffectiveColumn(rawCol);
                if (col == 2 && !editable) {
                    GeneralFunction gf = (GeneralFunction)this.getValueAt(row, rawCol);
                    String tab = gf instanceof Macro ? "Macros" : "Learned Signals";
                    tip = gf.getDisplayName(remote) + "<br>To change this assignment, first delete the corresponding<br>assignment on the " + tab + " tab.";
                } else if (col == 5) {
                    Macro macro = null;
                    if (this.getValueAt(row, rawCol) instanceof Macro) {
                        macro = (Macro)this.getValueAt(row, rawCol);
                    }
                    tip = macro != null ? macro.toString() + "<br>" : "";
                    tip = tip + "An alias is a display name for a function that is different <br>from the function name.<br>";
                    tip = editable ? tip + "Edit this value to change the alias." : tip + "This assignment does not permit an alias.";
                }
                return tip == null ? super.getToolTipText(e) : JTableX.getHtmlToolTip(tip);
            }
        };
        this.iconEditor = new RMSetterEditor(GeneralFunction.IconPanel.class);
        this.iconEditor.setRemoteConfiguration(devUpgrade.getRemoteConfig());
        this.iconEditor.setTitle("Icon Editor");
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setSelectionMode(2);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSurrendersFocusOnKeystroke(true);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.table.setAutoResizeMode(3);
        this.table.setDefaultEditor(Function.class, this.popupEditor);
        this.table.setDefaultEditor(Macro.class, new SelectAllCellEditor());
        this.table.setDefaultEditor(GeneralFunction.RMIcon.class, this.iconEditor);
        this.table.setDefaultRenderer(GeneralFunction.RMIcon.class, new BPIconRenderer());
        this.table.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ButtonPanel.this.selectionChanged();
            }

            @Override
            public void focusGained(FocusEvent e) {
                ButtonPanel.this.selectionChanged();
            }
        });
        this.deleteAction = new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] cols = ButtonPanel.this.table.getSelectedColumns();
                int[] rows = ButtonPanel.this.table.getSelectedRows();
                for (int c = 0; c < cols.length; ++c) {
                    for (int r = 0; r < rows.length; ++r) {
                        ButtonPanel.this.setFunctionAt(null, rows[r], cols[c]);
                    }
                }
            }
        };
        this.deleteAction.setEnabled(false);
        this.deleteAction.putValue("ShortDescription", "Remove the assigned function from the button.");
        this.table.getActionMap().put("delete", this.deleteAction);
        this.renderer = new FunctionRenderer(this.deviceUpgrade);
        this.table.setDefaultRenderer(Button.class, this.renderer);
        this.table.setDefaultRenderer(DeviceButton.class, new DefaultTableCellRenderer());
        this.table.setDefaultRenderer(GeneralFunction.class, new DefaultTableCellRenderer(){
            Font baseFont = this.getFont();
            Font boldFont = this.baseFont.deriveFont(1);

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                GeneralFunction gf = (GeneralFunction)value;
                String name = gf != null ? gf.getDisplayName(ButtonPanel.this.deviceUpgrade.getRemote()) : "";
                Component component = super.getTableCellRendererComponent(table, name, isSelected, false, row, col);
                component.setFont(table.isCellEditable(row, col) ? this.baseFont : this.boldFont);
                return component;
            }
        });
        this.table.setDefaultRenderer(Macro.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
                Component component = super.getTableCellRendererComponent(table, value, value == null ? false : isSelected, false, row, col);
                Color color = value == null ? Color.LIGHT_GRAY : (isSelected ? UIManager.getColor("Table.selectionBackground") : Color.WHITE);
                this.setBackground(color);
                return component;
            }
        });
        this.table.getTableHeader().setReorderingAllowed(false);
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ButtonPanel.this.selectionChanged();
            }
        };
        this.table.getSelectionModel().addListSelectionListener(lsl);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(lsl);
        TransferHandler th = new TransferHandler(){

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                for (int i = 0; i < flavors.length; ++i) {
                    if (flavors[i] != DataFlavor.stringFlavor && flavors[i] != LocalObjectTransferable.getFlavor()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean importData(JComponent c, Transferable t) {
                boolean rc = false;
                JTable table = (JTable)c;
                int row = table.getSelectedRow();
                int col = table.getSelectedColumn();
                if (col != 0) {
                    if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        try {
                            String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                            BufferedReader in = new BufferedReader(new StringReader(s));
                            int colCount = table.getModel().getColumnCount();
                            int workRow = row;
                            String line = in.readLine();
                            while (line != null && row != ButtonPanel.this.model.getRowCount()) {
                                StringTokenizer st = new StringTokenizer(line, "\t", true);
                                int workCol = col;
                                boolean done = false;
                                String token = null;
                                String prevToken = null;
                                while (!done && workCol != colCount) {
                                    token = st.hasMoreTokens() ? st.nextToken() : null;
                                    if (token == null) {
                                        done = true;
                                        if (prevToken != null) {
                                            break;
                                        }
                                    } else if (token.equals("\t")) {
                                        if (prevToken == null) {
                                            token = null;
                                        } else {
                                            prevToken = null;
                                            continue;
                                        }
                                    }
                                    prevToken = token;
                                    if (token != null) {
                                        ButtonPanel.this.model.setValueAt(ButtonPanel.this.deviceUpgrade.getFunction(token), workRow, workCol);
                                    }
                                    ++workCol;
                                }
                                ++workRow;
                                line = in.readLine();
                            }
                            ButtonPanel.this.model.fireTableRowsUpdated(row, workRow - 1);
                        }
                        catch (Exception ex) {
                            String message = ex.getMessage();
                            if (message == null) {
                                message = ex.toString();
                            }
                            ex.printStackTrace(System.err);
                        }
                    } else if (t.isDataFlavorSupported(LocalObjectTransferable.getFlavor())) {
                        try {
                            GeneralFunction f = (GeneralFunction)t.getTransferData(LocalObjectTransferable.getFlavor());
                            ButtonPanel.this.setFunctionAt(f, row, col);
                        }
                        catch (Exception e) {
                            rc = false;
                            System.err.println("ButtonPanel.importData() caught an exception!");
                            e.printStackTrace(System.err);
                        }
                    }
                }
                return rc;
            }

            @Override
            public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
                JTable table = (JTable)comp;
                int[] selectedRows = table.getSelectedRows();
                int[] selectedCols = table.getSelectedColumns();
                StringBuilder buff = new StringBuilder(200);
                for (int rowNum = 0; rowNum < selectedRows.length; ++rowNum) {
                    if (rowNum != 0) {
                        buff.append("\n");
                    }
                    for (int colNum = 0; colNum < selectedCols.length; ++colNum) {
                        if (colNum != 0) {
                            buff.append("\t");
                        }
                        int selRow = selectedRows[rowNum];
                        int selCol = selectedCols[colNum];
                        int convertedCol = table.convertColumnIndexToModel(selCol);
                        Object value = table.getValueAt(selRow, selCol);
                        if (value == null) continue;
                        DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)table.getColumnModel().getColumn(selCol).getCellRenderer();
                        if (cellRenderer != null) {
                            cellRenderer.getTableCellRendererComponent(table, value, false, false, selRow, convertedCol);
                            value = cellRenderer.getText();
                        }
                        buff.append(value.toString());
                    }
                }
                StringSelection data = new StringSelection(buff.toString());
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(data, data);
            }
        };
        this.table.setTransferHandler(th);
        try {
            this.table.getDropTarget().addDropTargetListener(new DropTargetAdapter(){

                @Override
                public void dragOver(DropTargetDragEvent dte) {
                    int col = ButtonPanel.this.table.getSelectedColumn();
                    int row = ButtonPanel.this.table.getSelectedRow();
                    if (ButtonPanel.this.canAssign(row, col)) {
                        dte.acceptDrag(dte.getDropAction());
                    } else {
                        dte.rejectDrag();
                    }
                }

                @Override
                public void drop(DropTargetDropEvent dte) {
                }
            });
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
        }
        this.popup = new JPopupMenu();
        this.deleteItem = new JMenuItem(this.deleteAction);
        this.popup.add(this.deleteItem);
        this.popup.add(new JSeparator());
        this.copyItem = new JMenuItem("Copy");
        this.copyItem.setToolTipText("Copy the selection to the clipboard.");
        this.copyItem.addActionListener(this);
        this.popup.add(this.copyItem);
        this.pasteItem = new JMenuItem("Paste");
        this.pasteItem.setToolTipText("Paste from the clipboard into the selection.");
        this.pasteItem.addActionListener(this);
        this.popup.add(this.pasteItem);
        MouseAdapter mh = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopup(e);
            }

            private void finishEditing() {
                TableCellEditor editor;
                int editRow = ButtonPanel.this.table.getEditingRow();
                if (editRow != -1 && !(editor = ButtonPanel.this.table.getCellEditor(editRow, ButtonPanel.this.table.getEditingColumn())).stopCellEditing()) {
                    editor.cancelCellEditing();
                }
            }

            private boolean showPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.finishEditing();
                    ButtonPanel.this.popupRow = ButtonPanel.this.table.rowAtPoint(e.getPoint());
                    ButtonPanel.this.popupCol = ButtonPanel.this.table.columnAtPoint(e.getPoint());
                    if (ButtonPanel.this.popupCol == 0) {
                        return false;
                    }
                    ButtonPanel.this.deleteItem.setEnabled(ButtonPanel.this.table.getValueAt(ButtonPanel.this.popupRow, ButtonPanel.this.popupCol) != null);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    Transferable clipData = clipboard.getContents(clipboard);
                    boolean flag = clipData != null && clipData.isDataFlavorSupported(DataFlavor.stringFlavor) && ButtonPanel.this.popupCol != 0;
                    ButtonPanel.this.pasteItem.setEnabled(flag);
                    ButtonPanel.this.copyItem.setEnabled(ButtonPanel.this.table.getSelectedRowCount() > 0);
                    ButtonPanel.this.popup.show(ButtonPanel.this.table, e.getX(), e.getY());
                    return true;
                }
                return false;
            }
        };
        this.table.addMouseListener(mh);
        MouseMotionAdapter mmh = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int tableCol = ButtonPanel.this.table.columnAtPoint(e.getPoint());
                int modelCol = ButtonPanel.this.table.convertColumnIndexToModel(tableCol);
                if (modelCol == 0) {
                    ButtonPanel.this.table.getTransferHandler().exportAsDrag(ButtonPanel.this.table, e, 2);
                }
            }
        };
        this.table.addMouseMotionListener(mmh);
        JPanel selectionPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel("Available Functions:");
        label.setBorder(BorderFactory.createEmptyBorder(2, 2, 3, 2));
        selectionPanel.add((Component)label, "Last");
        panel.add((Component)selectionPanel, "North");
        this.add((Component)panel, "East");
        JPanel outerPanel = new JPanel(new BorderLayout());
        this.functionPanel = new JPanel(new GridLayout(0, 3));
        outerPanel.add((Component)this.functionPanel, "North");
        this.functionScroll = new JScrollPane(outerPanel);
        panel.add((Component)this.functionScroll, "Center");
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.table), panel);
        splitPane.setResizeWeight(0.3);
        Remote remote = devUpgrade.getRemote();
        this.selector = new SelectionPanel(this, this);
        if (this.deviceUpgrade.getRemoteConfig() != null && remote.usesEZRC()) {
            selectionPanel.add((Component)this.selector, "Center");
            this.selector.deviceBox.setSelectedItem(this.deviceUpgrade.getButtonRestriction());
        }
        this.add((Component)splitPane, "Center");
        panel = new JPanel(new WrapLayout(1));
        this.autoAssign = new JButton("Auto assign");
        this.autoAssign.setToolTipText("Assign functions to buttons of the same name that don't have a functon.");
        this.autoAssign.addActionListener(this);
        panel.add(this.autoAssign);
        JButton button = new JButton(this.deleteAction);
        button.setToolTipText(JTableX.getHtmlToolTip("Remove the assigned function from the button.&nbsp&nbsp&nbsp  Key: DEL<br>(Table must have the focus.)"));
        panel.add(button);
        RemoteConfiguration remoteConfig = devUpgrade.getRemoteConfig();
        this.iconLabel = new JLabel("   ");
        this.iconLabel.setPreferredSize(new Dimension(100, 40));
        this.iconLabel.setHorizontalTextPosition(10);
        this.iconLabel.setVisible(remote.isSSD() && remoteConfig != null);
        panel.add(Box.createVerticalStrut(this.iconLabel.getPreferredSize().height));
        panel.add(this.iconLabel);
        this.add((Component)panel, "South");
        RMPanel.setButtonKeys(this.table, button);
    }

    private void selectionChanged() {
        boolean enableDelete = false;
        int[] rows = this.table.getSelectedRows();
        int[] cols = this.table.getSelectedColumns();
        for (int r = 0; r < rows.length && !enableDelete; ++r) {
            int row = rows[r];
            Button b = (Button)this.model.getValueAt(row, 0);
            short keyCode = b.getKeyCode();
            for (int c = 0; c < cols.length && !enableDelete; ++c) {
                int col = this.model.getEffectiveColumn(cols[c]);
                if (col <= 0) continue;
                if (col == 2) {
                    boolean bl = enableDelete = this.deviceUpgrade.getFunction(b, 0) != null;
                    if (!this.deviceUpgrade.getRemote().usesEZRC()) continue;
                    enableDelete = enableDelete || this.deviceUpgrade.getMacroMap().get(keyCode) != null || this.deviceUpgrade.getLearnedMap().get(keyCode) != null;
                    enableDelete = enableDelete && this.model.isCellEditable(row, cols[c]);
                    continue;
                }
                if (col == 3) {
                    enableDelete = this.deviceUpgrade.getFunction(b, 1) != null;
                    continue;
                }
                if (col != 4) continue;
                enableDelete = this.deviceUpgrade.getFunction(b, 2) != null;
            }
        }
        this.deleteAction.setEnabled(this.table.isFocusOwner() && enableDelete);
    }

    private void finishEditing() {
        TableCellEditor editor;
        int editRow = this.table.getEditingRow();
        if (editRow != -1 && !(editor = this.table.getCellEditor(editRow, this.table.getEditingColumn())).stopCellEditing()) {
            editor.cancelCellEditing();
        }
    }

    @Override
    public void commit() {
        this.finishEditing();
    }

    @Override
    public void update() {
        this.model.setDeviceUpgrade(this.deviceUpgrade);
        this.renderer.setDeviceUpgrade(this.deviceUpgrade);
        if (this.deviceUpgrade != null) {
            Remote remote = this.deviceUpgrade.getRemote();
            RemoteConfiguration config = this.deviceUpgrade.getRemoteConfig();
            this.setButtons(remote.getUpgradeButtons());
            this.setFunctions();
            this.iconEditor.setRemoteConfiguration(config);
            this.iconLabel.setVisible(remote.isSSD() && config != null);
        } else {
            this.iconEditor.setRemoteConfiguration(null);
            this.iconLabel.setVisible(false);
        }
    }

    private void setButtons(Button[] buttons) {
        this.model.setButtons();
    }

    @Override
    public void addFunction(GeneralFunction f) {
        if (f == null || f.hasData() && f.getName() != null && f.getName().length() > 0) {
            if (f != null && !f.accept(true)) {
                return;
            }
            FunctionLabel l = f == null ? new FunctionLabel(null) : f.getLabel();
            l.addMouseListener(this.doubleClickListener);
            l.showAssigned(this.deviceUpgrade.getButtonRestriction());
            this.functionPanel.add(l);
            if (this.rowHeight == 0) {
                GridLayout grid = (GridLayout)this.functionPanel.getLayout();
                this.rowHeight = grid.preferredLayoutSize((Container)this.functionPanel).height;
                if (this.rowHeight > 0) {
                    this.functionScroll.getVerticalScrollBar().setUnitIncrement(this.rowHeight);
                    this.functionScroll.getVerticalScrollBar().setBlockIncrement(3 * this.rowHeight);
                }
            }
            this.popupEditor.addObject(f);
        }
    }

    private void setFunctions() {
        this.popupEditor.removeAll();
        this.functionPanel.removeAll();
        this.selector.addFunctions();
        this.functionPanel.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.autoAssign) {
            this.deviceUpgrade.autoAssignFunctions();
            this.model.setButtons();
        } else if (source == this.copyItem) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            this.table.getTransferHandler().exportToClipboard(this.table, clipboard, 1);
        } else if (source == this.pasteItem) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(clipboard);
            if (clipData != null) {
                this.table.getTransferHandler().importData(this.table, clipboard.getContents(clipboard));
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (source == this.selector.deviceBox || source instanceof JRadioButton) {
            this.setFunctions();
            this.functionPanel.revalidate();
            this.functionPanel.repaint();
        }
        this.deviceUpgrade.checkSize();
    }

    private boolean canAssign(int row, int col) {
        return this.model.isCellEditable(row, col);
    }

    private void setFunctionAt(GeneralFunction function, int row, int col) {
        int[] rows = null;
        int[] cols = null;
        if (this.table.isCellSelected(row, col)) {
            rows = this.table.getSelectedRows();
            cols = this.table.getSelectedColumns();
        } else {
            rows = new int[]{row};
            cols = new int[]{col};
        }
        int firstRow = row;
        for (int r = 0; r < rows.length; ++r) {
            row = rows[r];
            if (r == 0) {
                firstRow = row;
            }
            for (int c = 0; c < cols.length; ++c) {
                col = cols[c];
                if (col <= 0 || row == -1) continue;
                this.model.setValueAt(function, row, col);
            }
            this.model.fireTableRowsUpdated(firstRow, row);
        }
        this.selectionChanged();
    }

    @Override
    public void setFont(Font aFont) {
        super.setFont(aFont);
        if (aFont == null || this.table == null) {
            return;
        }
        this.table.setRowHeight(aFont.getSize() + 2);
    }

    @Override
    public void revalidateFunctions() {
        this.functionPanel.revalidate();
    }

    public JTableX getTable() {
        return this.table;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Remote remote = this.deviceUpgrade.getRemote();
        if (this.frame instanceof RMIRSetup && remote.isSSD() && !e.getValueIsAdjusting()) {
            if (this.table.getSelectedRowCount() == 1) {
                GeneralFunction.RMIcon icon = null;
                int row = this.table.getSelectedRow();
                Button b = remote.getBaseUpgradeButtons()[row];
                GeneralFunction gf = this.deviceUpgrade.getButtonRestriction().getGeneralFunction(b);
                icon = gf.icon;
                this.iconLabel.setIcon(icon == null ? null : icon.image);
            } else {
                this.iconLabel.setIcon(null);
            }
        }
    }

    class DoubleClickListener
    extends MouseAdapter {
        DoubleClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            FunctionLabel label = (FunctionLabel)e.getSource();
            if (e.getClickCount() == 2) {
                int col = ButtonPanel.this.table.getSelectedColumn();
                int row = ButtonPanel.this.table.getSelectedRow();
                if (ButtonPanel.this.canAssign(row, col)) {
                    ButtonPanel.this.setFunctionAt(label.getFunction(), row, col);
                    ButtonPanel.this.deviceUpgrade.checkSize();
                }
            }
        }
    }

    public static class SelectionPanel
    extends JPanel {
        protected JRadioButton functionButton = new JRadioButton("Functions for device:");
        protected JRadioButton macroButton = new JRadioButton("Macros");
        protected JRadioButton learnedButton = new JRadioButton("Learned");
        protected JComboBox deviceBox = new JComboBox();
        private KMPanel panel = null;

        public SelectionPanel(KMPanel panel, ActionListener al) {
            this.panel = panel;
            this.setLayout(new BorderLayout());
            JPanel inner = new JPanel(new WrapLayout(0));
            this.setBorder(BorderFactory.createTitledBorder(" Select items to show: "));
            inner.add(this.functionButton);
            this.add((Component)inner, "First");
            Remote remote = panel.deviceUpgrade.getRemote();
            DeviceButton[] allDB = remote.getDeviceButtons();
            ArrayList<DeviceButton> dbList = new ArrayList<DeviceButton>();
            for (DeviceButton db : allDB) {
                if (db.getUpgrade() == null) continue;
                dbList.add(db);
            }
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(dbList.toArray());
            this.deviceBox.setModel(comboModel);
            Dimension d = this.deviceBox.getPreferredSize();
            d.width = 100;
            this.deviceBox.setPreferredSize(d);
            this.deviceBox.addActionListener(al);
            inner.add(this.deviceBox);
            inner.add(Box.createHorizontalStrut(20));
            inner.add(this.macroButton);
            ButtonGroup grp = new ButtonGroup();
            grp.add(this.functionButton);
            grp.add(this.learnedButton);
            grp.add(this.macroButton);
            this.functionButton.setSelected(true);
            this.functionButton.addActionListener(al);
            this.learnedButton.addActionListener(al);
            this.macroButton.addActionListener(al);
            this.macroButton.setEnabled(remote.isSSD());
        }

        protected void addFunctions() {
            block6: {
                block7: {
                    block5: {
                        DeviceUpgrade du;
                        if (!this.functionButton.isSelected()) break block5;
                        DeviceButton db = (DeviceButton)this.deviceBox.getSelectedItem();
                        DeviceUpgrade deviceUpgrade = du = db == null ? null : db.getUpgrade();
                        if (du == null || du.getButtonRestriction() == this.panel.deviceUpgrade.getButtonRestriction()) {
                            du = this.panel.deviceUpgrade;
                        }
                        for (Function function : du.getFunctionList()) {
                            this.panel.addFunction(function);
                        }
                        for (ExternalFunction externalFunction : du.getExternalFunctions()) {
                            this.panel.addFunction(externalFunction);
                        }
                        break block6;
                    }
                    if (!this.macroButton.isSelected()) break block7;
                    for (Macro macro : this.panel.deviceUpgrade.getRemoteConfig().getAllMacros(false)) {
                        this.panel.addFunction(macro);
                    }
                    break block6;
                }
                if (!this.learnedButton.isSelected()) break block6;
                for (LearnedSignal ls : this.panel.deviceUpgrade.getRemoteConfig().getLearnedSignals()) {
                    this.panel.addFunction(ls);
                }
            }
        }
    }

    public static class BPIconRenderer
    extends GeneralFunction.IconRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component component = super.getTableCellRendererComponent(table, value, value == null ? false : isSelected, false, row, col);
            if (component instanceof JLabel) {
                component.setBackground(Color.LIGHT_GRAY);
                ((JLabel)component).setOpaque(true);
            }
            return component;
        }
    }
}

