/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.ButtonPanel;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

public class ButtonTableModel
extends AbstractTableModel {
    private Button[] buttons = null;
    private DeviceUpgrade deviceUpgrade = null;
    private ButtonPanel panel = null;
    private static final int buttonCol = 0;
    private static final int deviceCol = 1;
    public static final int functionCol = 2;
    private static final int shiftedCol = 3;
    private static final int xShiftedCol = 4;
    public static final int aliasCol = 5;
    public static final int iconCol = 6;
    private static String[] columnNames = new String[]{"Button", "Device", "Function", "", "", "Alias", "Icon?"};
    private static final String[] colPrototypeNames = new String[]{"Button", "Device", "Function", "Function", "Function", "Alias", "Icon?"};
    private static final Class<?>[] columnClasses = new Class[]{Button.class, String.class, GeneralFunction.class, Function.class, Function.class, Macro.class, GeneralFunction.RMIcon.class};

    public void setPanel(ButtonPanel panel) {
        this.panel = panel;
    }

    public ButtonTableModel(DeviceUpgrade deviceUpgrade) {
        this.deviceUpgrade = deviceUpgrade;
    }

    public void setDeviceUpgrade(DeviceUpgrade deviceUpgrade) {
        this.deviceUpgrade = deviceUpgrade;
        this.fireTableDataChanged();
    }

    public DeviceUpgrade getDeviceUpgrade() {
        return this.deviceUpgrade;
    }

    public void setButtons() {
        if (this.deviceUpgrade == null) {
            return;
        }
        Remote remote = this.deviceUpgrade.getRemote();
        Button[] baseButtons = remote.getBaseUpgradeButtons();
        if (remote.hasKeyMoveSupport()) {
            this.buttons = baseButtons;
        } else {
            ArrayList<Button> btnList = new ArrayList<Button>();
            DeviceType devType = this.deviceUpgrade.getDeviceType();
            ButtonMap map = devType.getButtonMap();
            for (Button b : baseButtons) {
                if (map == null || !map.isPresent(b)) continue;
                btnList.add(b);
            }
            this.buttons = btnList.toArray(new Button[0]);
        }
        ButtonTableModel.columnNames[3] = remote.getShiftLabel();
        ButtonTableModel.columnNames[4] = remote.getXShiftLabel();
        this.fireTableStructureChanged();
        int cols = this.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            int col = this.getEffectiveColumn(i);
            this.panel.getTable().setColumnWidth(i, this.getColumnPrototypeName(i), col == 6, 0);
        }
    }

    @Override
    public int getRowCount() {
        if (this.buttons == null) {
            return 0;
        }
        return this.buttons.length;
    }

    @Override
    public int getColumnCount() {
        int count = 3;
        if (this.deviceUpgrade != null) {
            Remote remote = this.deviceUpgrade.getRemote();
            if (remote != null && remote.getXShiftEnabled()) {
                ++count;
            }
            if (remote != null && !remote.getShiftEnabled()) {
                --count;
            }
            if (remote.usesEZRC() && this.deviceUpgrade.getRemoteConfig() != null) {
                count += remote.isSSD() ? 3 : 2;
            }
        }
        return count;
    }

    public int getEffectiveColumn(int col) {
        Remote remote = this.deviceUpgrade.getRemote();
        if (!(remote.usesEZRC() && this.deviceUpgrade.getRemoteConfig() != null || col <= 0)) {
            ++col;
        } else if (remote.usesEZRC() && col > 2) {
            col += 2;
        }
        return col;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (this.deviceUpgrade == null) {
            return false;
        }
        if (row < 0) {
            return false;
        }
        if ((col = this.getEffectiveColumn(col)) == 0 || col == 1) {
            return false;
        }
        Button b = this.buttons[row];
        DeviceType devType = this.deviceUpgrade.getDeviceType();
        ButtonMap map = devType.getButtonMap();
        Object obj = this.getValueAt(row, 2);
        if (b == null) {
            return false;
        }
        if (col == 2) {
            return b.allowsKeyMove() || map.isPresent(b);
        }
        if (col == 3) {
            return b.allowsShiftedKeyMove();
        }
        if (col == 4) {
            return b.allowsXShiftedKeyMove();
        }
        if (col == 5) {
            return obj != null && obj instanceof Function;
        }
        if (col == 6) {
            return obj != null;
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row < 0) {
            return null;
        }
        Button button = this.buttons[row];
        Remote remote = this.deviceUpgrade.getRemote();
        DeviceButton dev = this.deviceUpgrade.getButtonRestriction();
        col = this.getEffectiveColumn(col);
        Macro macro = null;
        GeneralFunction gf = null;
        Activity activity = null;
        if (remote.usesEZRC()) {
            macro = this.deviceUpgrade.getMacroMap().get(button.getKeyCode());
            activity = macro != null ? macro.getActivity() : null;
            LearnedSignal ls = this.deviceUpgrade.getLearnedMap().get(button.getKeyCode());
            if (ls != null) {
                gf = ls;
                macro = null;
            } else if (macro != null) {
                if (macro.isSystemMacro()) {
                    gf = macro.getItems().get(0).getGeneralFunction();
                } else {
                    gf = macro;
                    macro = null;
                }
            }
        }
        if (gf == null) {
            gf = this.deviceUpgrade.getFunction(button, 0);
        }
        switch (col) {
            case 0: {
                return button;
            }
            case 1: {
                DeviceUpgrade upg;
                if (gf == null) {
                    return null;
                }
                if (macro != null) {
                    return macro.getItems().get((int)0).db;
                }
                Object devb = null;
                DeviceUpgrade deviceUpgrade = upg = gf == null ? null : gf.getUpgrade(remote);
                if (activity != null) {
                    return "Activity: " + activity;
                }
                if (upg != null) {
                    return upg.getButtonRestriction();
                }
                return null;
            }
            case 2: {
                return gf;
            }
            case 3: {
                return this.deviceUpgrade.getFunction(button, 1);
            }
            case 4: {
                return this.deviceUpgrade.getFunction(button, 2);
            }
            case 5: {
                if (gf != null && gf instanceof Function && dev != null) {
                    String name = dev.getGeneralFunction(button).getName();
                    if (name == null) {
                        dev.getGeneralFunction(button).setName(gf.getName());
                        return "";
                    }
                    return name.equals(gf.getName()) ? "" : name;
                }
                return null;
            }
            case 6: {
                GeneralFunction.RMIcon icon = this.deviceUpgrade.getButtonRestriction().getGeneralFunction((Button)button).icon;
                return gf != null ? icon : null;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Button button = this.buttons[row];
        Button relatedButton = null;
        switch (this.getEffectiveColumn(col)) {
            case 0: {
                break;
            }
            case 2: {
                GeneralFunction gf = (GeneralFunction)value;
                GeneralFunction current = (GeneralFunction)this.getValueAt(row, col);
                ButtonTableModel.setFunction(this.deviceUpgrade, button, current, gf, this.panel);
                relatedButton = button.getBaseButton();
                break;
            }
            case 3: {
                this.deviceUpgrade.setFunction(button, (Function)value, 1);
                relatedButton = button.getShiftedButton();
                break;
            }
            case 4: {
                this.deviceUpgrade.setFunction(button, (Function)value, 2);
                relatedButton = button.getXShiftedButton();
                break;
            }
            case 5: {
                Object obj = this.getValueAt(row, 2);
                if (!(obj instanceof Function) || this.deviceUpgrade.getButtonRestriction() == null) break;
                String name = (String)value;
                if (name.isEmpty()) {
                    name = ((Function)obj).getName();
                }
                this.deviceUpgrade.getButtonRestriction().getGeneralFunction(button).setName(name);
                break;
            }
            case 6: {
                GeneralFunction gfn = this.deviceUpgrade.getButtonRestriction().getGeneralFunction(button);
                gfn.icon = (GeneralFunction.RMIcon)value;
                break;
            }
        }
        int otherRow = row;
        if (relatedButton != null) {
            for (int i = 0; i < this.buttons.length; ++i) {
                if (this.buttons[i] != relatedButton) continue;
                otherRow = i;
                break;
            }
        }
        if (row <= otherRow) {
            this.fireTableRowsUpdated(row, otherRow);
        } else {
            this.fireTableRowsUpdated(otherRow, row);
        }
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[this.getEffectiveColumn(col)];
    }

    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[this.getEffectiveColumn(col)];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return columnClasses[this.getEffectiveColumn(col)];
    }

    public static void setFunction(DeviceUpgrade deviceUpgrade, Button button, GeneralFunction old, GeneralFunction gf, KMPanel panel) {
        DeviceButton db = deviceUpgrade.getButtonRestriction();
        Remote remote = deviceUpgrade.getRemote();
        if (gf == null) {
            if (old instanceof Function) {
                DeviceUpgrade fnUpg = old.getUpgrade(remote);
                if (fnUpg != null && fnUpg == deviceUpgrade || fnUpg == null) {
                    deviceUpgrade.getAssignments().assign(button, null);
                    old.removeReference(db, button);
                } else {
                    Macro macro = deviceUpgrade.getMacroMap().get(button.getKeyCode());
                    if (macro.isSystemMacro() && macro.getItems().get((int)0).fn == old) {
                        macro.removeReference(db, button, deviceUpgrade);
                        old.removeReference(db, button);
                    }
                }
            } else if (old instanceof Highlight) {
                old.removeReference(db, button, deviceUpgrade);
            }
        } else if (gf instanceof Function) {
            DeviceUpgrade fnUpg = gf.getUpgrade(remote);
            if (fnUpg != null && fnUpg == deviceUpgrade || fnUpg == null) {
                deviceUpgrade.getAssignments().assign(button, (Function)gf);
                if (old != null) {
                    old.removeReference(db, button);
                }
                gf.addReference(db, button);
            } else {
                RemoteConfiguration remoteConfig = deviceUpgrade.getRemoteConfig();
                Macro macro = new Macro(button.getKeyCode(), null, null);
                deviceUpgrade.backupReferences(macro);
                remoteConfig.getMacros().add(macro);
                macro.setName(gf.getName());
                macro.setSystemMacro(true);
                int serial = remoteConfig.getNewMacroSerial();
                macro.setSerial(serial);
                ArrayList<RemoteConfiguration.KeySpec> items = new ArrayList<RemoteConfiguration.KeySpec>();
                RemoteConfiguration.KeySpec ks = null;
                ks = new RemoteConfiguration.KeySpec(fnUpg.getButtonRestriction(), gf);
                macro.setSegmentFlags(255);
                ks.duration = 0;
                ks.delay = 3;
                items.add(ks);
                macro.setItems(items);
                macro.setDeviceButtonIndex(db.getButtonIndex());
                macro.addReference(db, button, deviceUpgrade);
            }
        } else if (gf instanceof Highlight) {
            deviceUpgrade.backupReferences(gf);
            gf.setKeyCode(button.getKeyCode());
            gf.setDeviceButtonIndex(db.getButtonIndex());
            gf.addReference(db, button, deviceUpgrade);
        }
    }
}

