/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.Parameter;
import com.hifiremote.jp1.SelectAllCellEditor;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JTable;
import javax.swing.JTextField;

public class ByteEditor
extends SelectAllCellEditor {
    private int min;
    private int max;
    private Parameter parm = null;
    private int base = 10;

    public ByteEditor(Parameter parm) {
        this(8, parm);
    }

    public ByteEditor(int bits, Parameter parm) {
        this(0, (1 << bits) - 1, parm);
    }

    public ByteEditor(int min, int max, Parameter parm) {
        this.setClickCountToStart(2);
        ((JTextField)this.getComponent()).setHorizontalAlignment(0);
        this.min = min;
        this.max = max;
        this.parm = parm;
    }

    public void setBits(int bits) {
        this.max = (1 << bits) - 1;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        JTextField tf = (JTextField)super.getTableCellEditorComponent(table, value, isSelected, row, col);
        if (value == null) {
            tf.setText("");
        } else {
            tf.setText(Integer.toString((Integer)value, this.base));
        }
        return tf;
    }

    @Override
    public Object getCellEditorValue() {
        Integer rc = null;
        JTextField tf = (JTextField)this.getComponent();
        String str = tf.getText().trim();
        if (str != null && str.length() != 0) {
            try {
                int temp = Integer.parseInt(str, this.base);
                if (temp < this.min || temp > this.max) {
                    String msg = "Value entered must be between " + this.min + " and " + this.max + '.';
                    KeyMapMaster.showMessage(msg, tf);
                } else {
                    KeyMapMaster.clearMessage(tf);
                    rc = new Integer(temp);
                }
            }
            catch (NumberFormatException nfe) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        if (this.parm != null) {
            this.parm.setValue(rc);
        }
        return rc;
    }

    public void setBase(int base) {
        this.base = base;
    }

    public int getBase() {
        return this.base;
    }
}

