/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.AddressRange;

public abstract class CheckSum {
    protected int checkSumAddress;
    protected AddressRange addressRange;
    protected boolean complement = false;

    public int getCheckSumAddress() {
        return this.checkSumAddress;
    }

    public AddressRange getAddressRange() {
        return this.addressRange;
    }

    public CheckSum(int sumAddr, AddressRange addrRange, boolean comp) {
        this.checkSumAddress = sumAddr;
        this.addressRange = addrRange;
        this.complement = comp;
    }

    protected abstract short calculateCheckSum(short[] var1, int var2, int var3);

    public void setCheckSum(short[] data) {
        short sum = this.calculateCheckSum(data, this.addressRange.getStart(), this.addressRange.getEnd());
        if (this.complement) {
            sum = (short)(~sum & 0xFF);
        }
        data[this.checkSumAddress] = sum;
        data[this.checkSumAddress + 1] = (short)(~sum & 0xFF);
    }

    public int getCheckSum(short[] data) {
        short sum = this.calculateCheckSum(data, this.addressRange.getStart(), this.addressRange.getEnd());
        if (this.complement) {
            sum = (short)(~sum & 0xFF);
        }
        return sum << 8 | ~sum & 0xFF;
    }

    public String toString() {
        return "$" + Integer.toHexString(this.checkSumAddress) + ":" + this.addressRange;
    }
}

