/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.ChoiceEditor;
import com.hifiremote.jp1.ChoiceRenderer;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DefaultValue;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ChoiceCmdParm
extends CmdParameter {
    private DefaultCellEditor editor = null;
    private DefaultTableCellRenderer renderer = null;
    private Choice[] choices = null;

    public ChoiceCmdParm(String name, DefaultValue defaultValue, List<String> textChoices) {
        super(name, defaultValue);
        int numChoices = 0;
        for (String str : textChoices) {
            if (str == null) continue;
            ++numChoices;
        }
        this.choices = new Choice[numChoices];
        int index = 0;
        int i = 0;
        for (String str : textChoices) {
            if (str != null) {
                this.choices[i++] = new Choice(index, str);
            }
            ++index;
        }
        this.editor = new ChoiceEditor(this.choices);
        this.renderer = new ChoiceRenderer(this.choices);
        this.renderer.setHorizontalAlignment(0);
    }

    @Override
    public String getDescription() {
        return "Choice";
    }

    @Override
    public TableCellEditor getEditor() {
        return this.editor;
    }

    @Override
    public TableCellRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public Class<?> getValueClass() {
        return Choice.class;
    }

    @Override
    public Object getValue() {
        return null;
    }

    public Object getValue(Integer val) {
        int i = val;
        for (int j = 0; j < this.choices.length; ++j) {
            if (this.choices[j].getIndex() != i) continue;
            return this.choices[j];
        }
        return null;
    }

    @Override
    public Object convertValue(Object value) {
        Object rc = null;
        Class<?> c = value.getClass();
        if (c == Choice.class) {
            rc = new Integer(((Choice)value).getIndex());
        } else if (c == Integer.class) {
            rc = value;
        } else {
            String str = (String)value;
            for (int i = 0; i < this.choices.length; ++i) {
                if (!str.equals(this.choices[i].getText())) continue;
                rc = new Integer(i);
                break;
            }
        }
        return rc;
    }

    @Override
    public void setValue(Object value) {
    }

    public Choice[] getChoices() {
        return this.choices;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name);
        buff.append(':');
        for (int i = 0; i < this.choices.length; ++i) {
            if (i > 0) {
                buff.append('|');
            }
            buff.append(this.choices[i].getText());
        }
        if (this.defaultValue != null) {
            buff.append('=');
            buff.append(this.defaultValue);
        }
        return buff.toString();
    }
}

