/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DeviceParameter;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class ChoiceDeviceParm
extends DeviceParameter {
    private JComboBox comboBox = null;
    private String[] choices = null;
    private boolean allowNull = false;

    public ChoiceDeviceParm(String name, DefaultValue defaultValue, String[] choices) {
        super(name, defaultValue);
        this.choices = choices;
        if (choices[0].equals("")) {
            this.allowNull = true;
        }
        this.comboBox = new JComboBox<String>(choices);
        String helpText = "Select a value from the list.  The default value is " + choices[(Integer)this.getDefaultValue().value() + 1] + '.';
        this.comboBox.setToolTipText(helpText);
    }

    @Override
    public JComponent getComponent() {
        return this.comboBox;
    }

    @Override
    public void addListener(EventListener l) {
        this.comboBox.addActionListener((ActionListener)l);
    }

    @Override
    public void removeListener(EventListener l) {
        this.comboBox.removeActionListener((ActionListener)l);
    }

    @Override
    public Object getValue() {
        Integer rc = null;
        int index = this.comboBox.getSelectedIndex();
        if (this.allowNull) {
            if (index != 0) {
                rc = new Integer(index - 1);
            }
        } else {
            rc = new Integer(index);
        }
        return rc;
    }

    @Override
    public void setValue(Object val) {
        if (val == null) {
            this.comboBox.setSelectedIndex(0);
        } else {
            Class<?> c = val.getClass();
            if (c == Integer.class) {
                int index = (Integer)val;
                if (this.allowNull) {
                    ++index;
                }
                this.comboBox.setSelectedIndex(index);
            } else if (c == String.class) {
                this.comboBox.setSelectedItem(val);
            } else {
                this.comboBox.setSelectedIndex(0);
            }
        }
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.name);
        buff.append(':');
        for (int i = 1; i < this.choices.length; ++i) {
            if (i > 0) {
                buff.append('|');
            }
            buff.append(this.choices[i]);
        }
        if (this.defaultValue != null) {
            buff.append('=');
            buff.append(this.defaultValue);
        }
        return buff.toString();
    }

    @Override
    public String getDescription() {
        return "Choice";
    }
}

