/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.FunctionTableModel;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.TableSorter;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTable;

public class ChoiceEditor
extends DefaultCellEditor {
    private JComboBox comboBox = null;
    private Choice[] choices = null;
    private int adjust;

    public ChoiceEditor(Choice[] choices) {
        this(choices, true);
    }

    public ChoiceEditor(Choice[] choices, boolean allowNull) {
        super(new JComboBox());
        this.setClickCountToStart(2);
        this.choices = choices;
        if (allowNull) {
            this.adjust = 1;
        }
        this.comboBox = (JComboBox)this.getComponent();
        this.initialize();
    }

    public void initialize() {
        int visibleCount = 0;
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.choices[i].isHidden()) continue;
            ++visibleCount;
        }
        Choice[] temp = new Choice[visibleCount += this.adjust];
        int tempIndex = 0;
        if (this.adjust != 0) {
            temp[0] = new Choice(-1, "");
            tempIndex = 1;
        }
        for (int i = 0; i < this.choices.length; ++i) {
            if (this.choices[i].isHidden()) continue;
            temp[tempIndex++] = this.choices[i];
        }
        this.comboBox.setModel(new DefaultComboBoxModel<Choice>(temp));
    }

    @Override
    public Object getCellEditorValue() {
        Choice temp = (Choice)super.getCellEditorValue();
        if (temp.getIndex() == -1) {
            return null;
        }
        return temp;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        System.err.println("ChoiceEditor.getTableCellEditorComponent(), value=" + value + ", row=" + row);
        if (value != null) {
            Class<?> c;
            FunctionTableModel model;
            Protocol protocol;
            TableSorter sorter;
            if (table.getModel() instanceof TableSorter && (sorter = (TableSorter)table.getModel()).getTableModel() instanceof FunctionTableModel && (protocol = (model = (FunctionTableModel)sorter.getTableModel()).getProtocol()) != null && protocol.getModifier() != null) {
                protocol.modifyParms(model, row);
                this.initialize();
            }
            if ((c = value.getClass()) == String.class) {
                for (int i = 0; i < this.choices.length; ++i) {
                    Choice choice = this.choices[i];
                    if (!choice.getText().equals(value)) continue;
                    this.comboBox.setSelectedItem(choice);
                }
            } else if (c == Choice.class) {
                this.comboBox.setSelectedItem(value);
            } else if (c == Integer.class) {
                for (int i = 0; i < this.comboBox.getModel().getSize(); ++i) {
                    Object obj = this.comboBox.getModel().getElementAt(i);
                    if (!(obj instanceof Choice) || ((Choice)obj).getIndex() != ((Integer)value).intValue()) continue;
                    this.comboBox.setSelectedIndex(i);
                    break;
                }
            }
        } else {
            this.comboBox.setSelectedIndex(0);
        }
        return this.comboBox;
    }
}

