/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CodeEditorPanel;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Set;

public class CodeEditorNode
extends ProtocolEditorNode {
    private static CodeEditorPanel editorPanel = null;
    private HashMap<String, Hex> codes = new HashMap(6);

    public CodeEditorNode() {
        super("Protocol Code", false);
    }

    @Override
    public ProtocolEditorPanel getEditingPanel() {
        if (editorPanel == null) {
            editorPanel = new CodeEditorPanel();
        }
        return editorPanel;
    }

    @Override
    public void print(PrintWriter pw) {
        for (String key : this.getKeys()) {
            Hex hex = this.getCode(key);
            if (hex == null || hex.length() == 0) continue;
            pw.println("Code." + key + '=' + hex);
        }
    }

    public Set<String> getKeys() {
        return this.codes.keySet();
    }

    public void addCode(String processor, Hex code) {
        this.codes.put(processor, code);
    }

    public Hex getCode(String processor) {
        return this.codes.get(processor);
    }

    public void removeCode(String processor) {
        this.codes.remove(processor);
    }
}

