/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CodeEditorNode;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.HexEditor;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.ProtocolEditorNode;
import com.hifiremote.jp1.ProtocolEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;

public class CodeEditorPanel
extends ProtocolEditorPanel
implements ActionListener {
    private CodeEditorNode node = null;
    private JButton importButton = null;
    private TableModel tableModel = null;
    private JTableX table = null;
    private static String[] colNames = new String[]{"Processor", "Protocol Code"};
    private static Class<?>[] classes = new Class[]{String.class, Hex.class};
    private static String[] procNames = new String[]{"S3C80", "740", "6805-C9", "6805-RC16/18", "S3F80"};

    public CodeEditorPanel() {
        super("Protocol Code");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "Center");
        this.tableModel = new TableModel();
        this.table = new JTableX(this.tableModel);
        DefaultTableCellRenderer r = (DefaultTableCellRenderer)this.table.getDefaultRenderer(String.class);
        r.setHorizontalAlignment(0);
        this.table.setDefaultEditor(Hex.class, new HexEditor());
        panel.add((Component)new JScrollPane(this.table), "Center");
        JLabel l = new JLabel(colNames[0]);
        l.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        int width = l.getPreferredSize().width;
        for (int i = 0; i < procNames.length; ++i) {
            l.setText(procNames[i]);
            width = Math.max(width, l.getPreferredSize().width);
            column.setMaxWidth(width);
            column.setPreferredWidth(width);
        }
        this.table.doLayout();
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        panel.add((Component)buttonPanel, "South");
        this.importButton = new JButton("Import from clipboard");
        this.importButton.addActionListener(this);
        this.importButton.setToolTipText("Import protocol code from the clipboard");
        buttonPanel.add(this.importButton);
        this.setText("Enter the requested information about the protocol.  Fields with names in red are required.");
    }

    @Override
    public void commit() {
    }

    @Override
    public void update(ProtocolEditorNode newNode) {
        this.node = (CodeEditorNode)newNode;
    }

    public void docChanged(DocumentEvent e) {
        Document doc = e.getDocument();
    }

    public void changedUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    public void insertUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.docChanged(e);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.importButton) {
            System.err.println("importButton pressed");
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable clipData = clipboard.getContents(clipboard);
            if (clipData != null) {
                try {
                    if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String s = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                        System.err.println("text is " + s);
                        this.importProtocolCode(s);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    private void importProtocolCode(String string) {
        StringTokenizer st = new StringTokenizer(string, "\n");
        String text = null;
        String processor = null;
        while (st.hasMoreTokens()) {
            String temp;
            while (st.hasMoreTokens()) {
                text = st.nextToken().toUpperCase();
                System.err.println("got '" + text);
                if (!text.startsWith("UPGRADE PROTOCOL 0 =")) continue;
                int pos = text.indexOf(40);
                int pos2 = text.indexOf(41, pos);
                processor = text.substring(pos + 1, pos2);
                System.err.println("processorName is " + processor);
                if (!processor.startsWith("S3C8")) break;
                processor = "S3C80";
                break;
            }
            if (!st.hasMoreTokens()) continue;
            text = st.nextToken();
            while (st.hasMoreTokens() && !(temp = st.nextToken()).equals("End")) {
                text = text + ' ' + temp;
            }
            System.err.println("getting processor with name " + processor);
            Processor p = ProcessorManager.getProcessor(processor);
            if (p != null) {
                processor = p.getFullName();
            }
            System.err.println("Adding code for processor " + processor);
            System.err.println("Code is " + text);
            this.node.addCode(processor, new Hex(text));
            for (int i = 0; i < procNames.length; ++i) {
                if (!procNames[i].equals(processor)) continue;
                this.tableModel.fireTableRowsUpdated(i, i);
            }
        }
    }

    public class TableModel
    extends AbstractTableModel {
        @Override
        public int getRowCount() {
            return procNames.length;
        }

        @Override
        public int getColumnCount() {
            return colNames.length;
        }

        @Override
        public String getColumnName(int col) {
            return colNames[col];
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return classes[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return procNames[row];
            }
            return CodeEditorPanel.this.node.getCode(procNames[row]);
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 1) {
                if (value != null) {
                    CodeEditorPanel.this.node.addCode(procNames[row], (Hex)value);
                } else {
                    CodeEditorPanel.this.node.removeCode(procNames[row]);
                }
                CodeEditorPanel.this.tableModel.fireTableRowsUpdated(row, row);
            }
        }
    }
}

