/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.DeviceUpgradePanel;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JP1Table;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.RFSelectorTableModel;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.io.IO;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;

public class CodeSelectorDialog
extends JDialog
implements ActionListener {
    public static String okString = null;
    private JP1Frame frame = null;
    private boolean importing = false;
    private HashMap<Integer, HashMap<Integer, Integer>> setupCodes = null;
    private HashMap<Integer, HashMap<Integer, Integer>> rfSetupCodes = null;
    private JComboBox deviceComboBox = null;
    private int deviceIndex = 0;
    private JTextArea internalArea = null;
    private JTextArea upgradeArea = null;
    private JScrollPane internalPane = null;
    private String selectedCode = "";
    private static RMIRSetup owner = null;
    private RemoteConfiguration remoteConfig = null;
    private Remote remote = null;
    private DeviceUpgrade deviceUpgrade = null;
    private boolean canAssign = true;
    private JRadioButton irButton = new JRadioButton("IR");
    private JRadioButton rfButton = new JRadioButton("RF");
    private JLabel selectedLabel = new JLabel();
    private JButton assignButton = new JButton("Assign");
    private JButton refreshButton = new JButton("Refresh");
    private JButton connectButton = null;
    private static JP1Table deviceButtonTable = null;
    private static JP1Table rfSelectorTable = null;
    private static CodeSelectorDialog selector = null;
    private JTextField category = null;
    private JTextField brand = null;
    private JTextField position = null;
    private JPanel locationPanel = null;
    private JPanel connectionPanel = null;
    private JPanel buttonPanel = null;
    private JPanel bottomPanel = null;

    private CodeSelectorDialog(JP1Frame rm, boolean importing) {
        super(rm);
        this.frame = rm;
        this.importing = importing;
        if (rm instanceof RMIRSetup) {
            owner = (RMIRSetup)rm;
            this.remoteConfig = owner.getRemoteConfiguration();
            this.remote = this.remoteConfig.getRemote();
        }
        if (importing) {
            if (rm instanceof KeyMapMaster) {
                this.deviceUpgrade = ((KeyMapMaster)rm).getDeviceUpgrade();
                this.remote = this.deviceUpgrade.getRemote();
            }
            this.assignButton = new JButton("Import");
            this.refreshButton = new JButton("Cancel");
        } else {
            this.assignButton.setToolTipText("Assigns selected device type and code to selected device button");
            this.refreshButton.setToolTipText("Set selected device type to that of selected device button|");
        }
        this.setTitle("Code Selector");
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                int start;
                JTextArea textArea = (JTextArea)event.getSource();
                Point p = event.getPoint();
                int end = start + 1;
                try {
                    for (start = textArea.viewToModel(p); start >= 0 && !textArea.getText(start, 1).equals(" "); --start) {
                    }
                    while (end < textArea.getText().length() && !textArea.getText(end, 1).equals(" ")) {
                        ++end;
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
                textArea.select(start + 1, end);
                CodeSelectorDialog.this.setSelectedCode(textArea.getSelectedText());
                if (CodeSelectorDialog.this.assignButton.isEnabled() && event.getClickCount() == 2) {
                    CodeSelectorDialog.this.assignButton.doClick();
                }
            }
        };
        JPanel devicePanel = new JPanel(new FlowLayout(1));
        devicePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(0, 15, 5, 15)), " Device Type: "));
        this.remote.load();
        this.deviceComboBox = new JComboBox<DeviceType>(this.remote.getExtractSetupCodes() == null ? this.remote.getDeviceTypes() : this.remote.getExtractDeviceTypes());
        this.deviceComboBox.addActionListener(this);
        Dimension d = this.deviceComboBox.getPreferredSize();
        d.width = 100;
        this.deviceComboBox.setPreferredSize(d);
        devicePanel.add(this.deviceComboBox);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.irButton);
        bg.add(this.rfButton);
        this.irButton.setSelected(true);
        this.irButton.addActionListener(this);
        this.rfButton.addActionListener(this);
        this.irButton.setVisible(this.remote.hasRf4ceSupport());
        this.rfButton.setVisible(this.remote.hasRf4ceSupport());
        devicePanel.add(this.irButton);
        devicePanel.add(this.rfButton);
        Box buttonBox = Box.createHorizontalBox();
        this.assignButton.addActionListener(this);
        buttonBox.add(this.assignButton);
        this.refreshButton.addActionListener(this);
        buttonBox.add(this.refreshButton);
        JPanel selectedPanel = new JPanel(new FlowLayout(0));
        selectedPanel.add(this.selectedLabel);
        Box actionBox = Box.createVerticalBox();
        actionBox.add(buttonBox);
        actionBox.add(Box.createVerticalGlue());
        actionBox.add(selectedPanel);
        int width = this.assignButton.getPreferredSize().width;
        actionBox.add(Box.createHorizontalStrut(width += this.refreshButton.getPreferredSize().width));
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.add((Component)devicePanel, "Before");
        actionPanel.add((Component)new JLabel(), "Center");
        actionPanel.add((Component)actionBox, "After");
        this.internalArea = new JTextArea(10, 50);
        this.internalArea.setLineWrap(true);
        this.internalArea.setWrapStyleWord(true);
        this.internalArea.setEditable(false);
        this.internalArea.addMouseListener(mouseAdapter);
        this.internalPane = new JScrollPane(this.internalArea);
        this.internalPane.setVerticalScrollBarPolicy(22);
        Box labelBox1 = Box.createHorizontalBox();
        labelBox1.add(new JLabel("Internal:"));
        labelBox1.add(Box.createHorizontalGlue());
        Box internalBox = Box.createVerticalBox();
        internalBox.add(labelBox1);
        internalBox.add(Box.createVerticalStrut(5));
        internalBox.add(this.internalPane);
        this.upgradeArea = new JTextArea(3, 50);
        this.upgradeArea.setLineWrap(true);
        this.upgradeArea.setWrapStyleWord(true);
        this.upgradeArea.setEditable(false);
        this.upgradeArea.addMouseListener(mouseAdapter);
        JScrollPane upgradePane = new JScrollPane(this.upgradeArea);
        upgradePane.setVerticalScrollBarPolicy(22);
        Box labelBox2 = Box.createHorizontalBox();
        labelBox2.add(new JLabel("Upgrade:"));
        labelBox2.add(Box.createHorizontalGlue());
        Box upgradeBox = Box.createVerticalBox();
        upgradeBox.add(Box.createVerticalStrut(5));
        upgradeBox.add(labelBox2);
        upgradeBox.add(Box.createVerticalStrut(5));
        upgradeBox.add(upgradePane);
        upgradeBox.setVisible(!importing);
        JPanel notePanel = new JPanel(new FlowLayout(0));
        JLabel note = new JLabel("Click on a code to select, double-click to select and " + this.assignButton.getText().toLowerCase() + ".");
        notePanel.add(note);
        JPanel codesPanel = new JPanel(new BorderLayout());
        codesPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)), " Valid Device Codes: "));
        codesPanel.add((Component)notePanel, "First");
        codesPanel.add((Component)internalBox, "Center");
        codesPanel.add((Component)upgradeBox, "Last");
        JComponent contentPane = (JComponent)this.getContentPane();
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)actionPanel, "First");
        contentPane.add((Component)codesPanel, "Center");
        if (owner != null && this.remote.usesEZRC()) {
            double b = 5.0;
            double c = 10.0;
            double pr = -2.0;
            double pf = -1.0;
            double[][] size = new double[][]{{b, pr, c, pf, b}, {b, pr, b, pr, b, pr, b, pr, b}};
            this.assignButton.setVisible(false);
            this.refreshButton.setVisible(false);
            upgradeBox.setVisible(false);
            this.bottomPanel = new JPanel(new CardLayout());
            this.locationPanel = new JPanel(new TableLayout(size));
            this.locationPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY), BorderFactory.createEmptyBorder(0, 5, 0, 5)), " Location: "));
            this.bottomPanel.add((Component)this.locationPanel, "ON");
            contentPane.add((Component)this.bottomPanel, "Last");
            this.category = new JTextField();
            this.brand = new JTextField();
            this.position = new JTextField();
            JTextArea locationArea = new JTextArea();
            JLabel label = new JLabel();
            locationArea.setFont(label.getFont());
            locationArea.setBackground(label.getBackground());
            locationArea.setLineWrap(true);
            locationArea.setWrapStyleWord(true);
            locationArea.setEditable(false);
            String message = "\nUse this location information to add the selected setup code using the Settings facility of the remote.  You may use RMIR afterwards to change the brand name if this is unsuitable.";
            locationArea.setText(message);
            this.locationPanel.add((Component)new JLabel("Category:"), "1, 1");
            this.locationPanel.add((Component)this.category, "3, 1");
            this.locationPanel.add((Component)new JLabel("Brand:"), "1, 3");
            this.locationPanel.add((Component)this.brand, "3, 3");
            this.locationPanel.add((Component)new JLabel("Position:"), "1, 5");
            this.locationPanel.add((Component)this.position, "3, 5");
            this.locationPanel.add((Component)locationArea, "1, 7, 3, 7");
            this.connectionPanel = new JPanel(new BorderLayout());
            JTextArea messageArea = new JTextArea();
            messageArea.setFont(label.getFont());
            messageArea.setBackground(label.getBackground());
            messageArea.setLineWrap(true);
            messageArea.setWrapStyleWord(true);
            messageArea.setEditable(false);
            message = "\nTo add a new internal setup code, please use the Settings facility of the remote.  If you know the code for your device, this Code Selector can tell you the brand to select and which setup within that brand to use.  To enable this capability, please connect your remote to the PC and press the Connect button below.  Once the Location panel appears, you may disconnect the remote.\n\nTo add a new setup with a device upgrade, use the Device Upgrade tab to add the upgrade.  This will automatically add the upgrade as a new Device.";
            messageArea.setText(message);
            this.connectionPanel.add((Component)messageArea, "Center");
            this.buttonPanel = new JPanel(new CardLayout());
            this.connectButton = new JButton("Connect");
            this.connectButton.addActionListener(this);
            JPanel panel = new JPanel();
            panel.add(this.connectButton);
            this.buttonPanel.add((Component)panel, "OFF");
            panel = new JPanel(new FlowLayout(0, 0, 5));
            label = new JLabel("READING DATA...   ");
            Font font = label.getFont();
            Font boldfont = font.deriveFont(1);
            label.setFont(boldfont);
            panel.add(label);
            label = new JLabel("This may take up to a minute");
            panel.add(label);
            this.buttonPanel.add((Component)panel, "ON");
            label = new JLabel("CONNECTION FAILED");
            label.setFont(boldfont);
            label.setForeground(Color.RED);
            panel = new JPanel(new FlowLayout(0, 0, 5));
            panel.add(label);
            this.buttonPanel.add((Component)panel, "FAIL");
            CardLayout cl = (CardLayout)this.buttonPanel.getLayout();
            cl.show(this.buttonPanel, "OFF");
            this.connectionPanel.add((Component)this.buttonPanel, "Last");
            this.bottomPanel.add((Component)this.connectionPanel, "OFF");
            cl = (CardLayout)this.bottomPanel.getLayout();
            cl.show(this.bottomPanel, this.remoteConfig.getDeviceCategories() == null ? "OFF" : "ON");
        }
        this.setSelectedCode("");
        if (owner != null) {
            this.rfSetupCodes = this.remote.getRfSetupCodes();
            deviceButtonTable = owner.getGeneralPanel().getDeviceButtonTable();
            rfSelectorTable = owner.getGeneralPanel().getRfSelectorTable();
        }
    }

    public static CodeSelectorDialog showDialog(JP1Frame rm, boolean importing) {
        okString = "fail";
        selector = new CodeSelectorDialog(rm, importing);
        selector.pack();
        if (importing) {
            selector.setLocationRelativeTo(rm);
            int index = selector.getDeviceComboBox().getSelectedIndex();
            selector.getDeviceComboBox().setSelectedIndex(index < 0 ? 0 : index);
        }
        selector.setVisible(true);
        if (!importing) {
            CodeSelectorDialog.selector.refreshButton.doClick();
        }
        okString = "success";
        return selector;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JP1Table activeTable = null;
        if (!this.importing && (activeTable = owner.getGeneralPanel().getActiveTable()) != deviceButtonTable && activeTable != rfSelectorTable) {
            return;
        }
        int row = activeTable != null ? activeTable.getSelectedRow() : -1;
        Object source = event.getSource();
        DeviceType deviceType = (DeviceType)this.deviceComboBox.getSelectedItem();
        this.deviceIndex = deviceType.getNumber();
        if (source == this.deviceComboBox || source == this.irButton || source == this.rfButton) {
            if (source == this.irButton && !this.irButton.isSelected() || source == this.rfButton && !this.rfButton.isSelected()) {
                return;
            }
            this.setupCodes = this.remote.getExtractSetupCodes() == null ? this.remote.getSetupCodes() : this.remote.getExtractSetupCodes();
            HashMap<Integer, Integer> typeCodes = this.irButton.isSelected() ? this.setupCodes.get(deviceType.getNumber()) : this.rfSetupCodes.get(deviceType.getNumber());
            ArrayList<Integer> codes = new ArrayList<Integer>();
            if (typeCodes != null) {
                codes.addAll(typeCodes.values());
            }
            this.internalArea.setText(this.getCodeText(codes));
            codes = new ArrayList();
            if (owner != null) {
                for (DeviceUpgrade devUpgrade : this.remoteConfig.getDeviceUpgrades()) {
                    if (devUpgrade.hasSerial() || deviceType.getNumber() != devUpgrade.getDeviceType().getNumber() || this.irButton.isSelected() != !devUpgrade.isRfUpgrade() || !devUpgrade.getButtonIndependent().booleanValue() && (row < 0 || this.remote.getDeviceButtons()[row].getButtonIndex() != devUpgrade.getButtonRestriction().getButtonIndex())) continue;
                    codes.add(devUpgrade.getSetupCode());
                }
            }
            this.upgradeArea.setText(this.getCodeText(codes));
            this.setSelectedCode("");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeSelectorDialog.this.internalPane.getVerticalScrollBar().setValue(0);
                }
            });
        } else if (source == this.assignButton) {
            if (deviceType == null || this.selectedCode.isEmpty() || !this.importing && row == -1) {
                String message = "Nowhere selected for assignment.";
                String title = "Code Selector";
                JOptionPane.showMessageDialog(this, message, title, 0);
                return;
            }
            if (activeTable != null && activeTable == deviceButtonTable) {
                deviceButtonTable.setValueAt(deviceType, row, 2);
                deviceButtonTable.setValueAt(this.selectedCode, row, 3);
                DeviceButtonTableModel model = (DeviceButtonTableModel)deviceButtonTable.getModel();
                model.fireTableRowsUpdated(row, row);
            } else if (activeTable != null && activeTable == rfSelectorTable) {
                int devCol = this.rfButton.isSelected() ? 4 : 2;
                rfSelectorTable.setValueAt(deviceType, row, devCol);
                rfSelectorTable.setValueAt(this.selectedCode, row, devCol + 1);
                RFSelectorTableModel model = (RFSelectorTableModel)rfSelectorTable.getModel();
                model.fireTableRowsUpdated(row, row);
            } else if (this.importing) {
                if (this.frame instanceof KeyMapMaster) {
                    this.deviceUpgrade.setSelectedDeviceIndex(this.deviceIndex);
                    this.deviceUpgrade.setSelectedSetupCode(this.selectedCode);
                    KeyMapMaster km = (KeyMapMaster)this.frame;
                    this.remote.load();
                    String alias = this.remote.getDeviceTypeAlias(this.remote.getDeviceTypeByIndex(this.deviceIndex));
                    km.getEditorPanel().getDeviceTypeList().setSelectedItem(alias);
                    KeyMapMaster.createUpgrade(this, km.getEditorPanel());
                } else if (this.frame instanceof RMIRSetup) {
                    RMIRSetup rm = (RMIRSetup)this.frame;
                    DeviceUpgradePanel dup = rm.getDeviceUpgradePanel();
                    this.remote.load();
                    this.deviceUpgrade = new DeviceUpgrade();
                    this.deviceUpgrade.setRemote(this.remote);
                    this.deviceUpgrade.setRemoteConfig(rm.getRemoteConfiguration());
                    this.deviceUpgrade.setSelectedDeviceIndex(this.deviceIndex);
                    this.deviceUpgrade.setSelectedSetupCode(this.selectedCode);
                    this.deviceUpgrade.setSetupCode(Integer.parseInt(this.selectedCode));
                    this.deviceUpgrade.setDeviceTypeAliasName(this.remote.getDeviceTypeAlias(this.remote.getDeviceTypeByIndex(this.deviceIndex)));
                    KeyMapMaster.createUpgrade(this, null);
                    ArrayList<Remote> remotes = new ArrayList<Remote>(1);
                    remotes.add(this.remoteConfig.getRemote());
                    new DeviceUpgradeEditor(this.remoteConfig.getOwner(), this.deviceUpgrade, remotes, null, dup);
                }
            }
        } else if (source == this.refreshButton) {
            if (!this.importing) {
                if (row >= 0) {
                    DeviceType rowType = (DeviceType)deviceButtonTable.getValueAt(row, 2);
                    if (rowType == null) {
                        CodeSelectorDialog.selector.deviceComboBox.setSelectedIndex(0);
                    } else {
                        CodeSelectorDialog.selector.deviceComboBox.setSelectedItem(rowType);
                    }
                } else if (CodeSelectorDialog.selector.deviceComboBox.getItemCount() > 0) {
                    CodeSelectorDialog.selector.deviceComboBox.setSelectedIndex(0);
                }
                this.setSelectedCode("");
            } else {
                this.dispose();
            }
        } else if (source == this.connectButton) {
            ((CardLayout)this.buttonPanel.getLayout()).show(this.buttonPanel, "ON");
            new ConnectTask().execute();
        }
    }

    private void setSelectedCode(String code) {
        this.selectedCode = code;
        if (this.selectedCode.length() != 4) {
            this.selectedCode = "";
        }
        this.selectedLabel.setText("Selected code:  " + this.selectedCode);
        this.assignButton.setEnabled(this.canAssign && !this.selectedCode.isEmpty());
        if (this.category != null && this.remoteConfig.getDeviceCategories() != null) {
            if (code == null || code.isEmpty()) {
                this.category.setText("");
                this.brand.setText("");
                this.position.setText("");
                return;
            }
            DeviceType deviceType = (DeviceType)this.deviceComboBox.getSelectedItem();
            int type = deviceType.getNumber();
            int setupCode = type << 16 | Integer.parseInt(code);
            Integer location = this.remoteConfig.getCodeLocations().get(setupCode);
            if (location == null) {
                this.category.setText("Not available in " + this.remoteConfig.getRegion());
                this.brand.setText(null);
                this.position.setText(null);
                return;
            }
            int categoryIndex = location >> 24;
            int brandIndex = location >> 16 & 0xFF;
            int positionIndex = location >> 8 & 0xFF;
            int length = location & 0xFF;
            String categoryValue = this.remoteConfig.getDeviceCategories().get(categoryIndex);
            String brandValue = this.remoteConfig.getCategoryBrands().get(categoryIndex).get(brandIndex);
            String positionValue = String.format("%02d/%02d", positionIndex, length);
            this.category.setText(categoryValue);
            this.brand.setText(brandValue);
            this.position.setText(positionValue);
        }
    }

    private String getCodeText(ArrayList<Integer> codes) {
        Collections.sort(codes);
        StringBuilder sb = new StringBuilder();
        for (Integer code : codes) {
            sb.append(SetupCode.toString(code));
            sb.append(" ");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void enableAssign(boolean enable) {
        this.canAssign = enable;
        this.assignButton.setEnabled(this.canAssign && !this.selectedCode.isEmpty());
    }

    public JComboBox getDeviceComboBox() {
        return this.deviceComboBox;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public DeviceUpgrade getDeviceUpgrade() {
        return this.deviceUpgrade;
    }

    public void setImporting(boolean importing) {
        this.importing = importing;
    }

    private class ConnectTask
    extends SwingWorker<Void, Void> {
        private ConnectTask() {
        }

        @Override
        protected Void doInBackground() throws Exception {
            boolean done = false;
            if (CodeSelectorDialog.this.remote.isSSD()) {
                done = CodeSelectorDialog.this.remoteConfig.setDeviceCategories();
            } else {
                IO hid = null;
                for (IO temp : owner.getInterfaces()) {
                    short[] buffer;
                    String tempName = temp.getInterfaceName();
                    if (!tempName.equals("CommHID")) continue;
                    IO iO = hid = temp.openRemote("UPG").equals("UPG") ? temp : null;
                    if (hid == null || hid.readRemote(131072, buffer = new short[48], 48) != 48) break;
                    int irAddress = buffer[24] << 24 | buffer[25] << 16 | buffer[26] << 8 | buffer[27];
                    int textAddress = buffer[36] << 24 | buffer[37] << 16 | buffer[38] << 8 | buffer[39];
                    if (hid.readRemote(irAddress + 20, buffer, 48) != 48) break;
                    int categoryAddress = (buffer[16] << 8 | buffer[17]) + irAddress;
                    CodeSelectorDialog.this.remoteConfig.setDeviceCategories(hid, textAddress, categoryAddress);
                    done = true;
                    break;
                }
                if (hid != null) {
                    hid.closeRemote();
                }
            }
            owner.setInterfaceState(null);
            if (done) {
                ((CardLayout)CodeSelectorDialog.this.bottomPanel.getLayout()).show(CodeSelectorDialog.this.bottomPanel, "ON");
            } else {
                ((CardLayout)CodeSelectorDialog.this.buttonPanel.getLayout()).show(CodeSelectorDialog.this.buttonPanel, "FAIL");
            }
            return null;
        }
    }
}

