/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.Value;
import java.util.StringTokenizer;

public class CombinerDevice {
    private Protocol protocol = null;
    private Value[] values = null;
    private String notes = null;

    public CombinerDevice(Protocol p, Value[] values, String notes) {
        this.protocol = p;
        if (values == null) {
            values = new Value[]{};
        }
        this.values = values;
        this.notes = notes;
    }

    public CombinerDevice(Protocol p, Value[] values) {
        this(p, values, null);
    }

    public CombinerDevice(CombinerDevice dev) {
        this.protocol = dev.protocol;
        if (this.protocol.getClass() == ManualProtocol.class) {
            this.protocol = new ManualProtocol((ManualProtocol)this.protocol);
        }
        this.values = new Value[dev.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = dev.values[i];
        }
        this.notes = dev.notes;
    }

    public CombinerDevice(String text, Remote remote) {
        StringTokenizer st = new StringTokenizer(text, ":.");
        String token = st.nextToken();
        this.protocol = ProtocolManager.getProtocolManager().findProtocolForRemote(remote, token);
        int count = st.countTokens();
        this.values = new Value[count];
        DeviceParameter[] parms = this.protocol.getDeviceParameters();
        for (int i = 0; i < count; ++i) {
            parms[i].setValue(st.nextToken());
        }
        this.values = this.protocol.getDeviceParmValues();
    }

    public CombinerDevice(Protocol p, Hex fixedData) {
        this.protocol = p;
        this.values = p.importFixedData(fixedData);
    }

    public void setProtocol(Protocol p) {
        this.protocol = p;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setValues(Value[] values) {
        this.values = values;
    }

    public Value[] getValues() {
        return this.values;
    }

    public Hex getFixedData() {
        return this.protocol.getFixedData(this.values);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String text) {
        this.notes = text;
    }

    public String toString() {
        if (this.notes != null && this.notes.length() > 0) {
            return this.notes;
        }
        StringBuilder buff = new StringBuilder();
        buff.append(this.protocol.getName());
        if (this.values != null && this.values.length != 0) {
            buff.append(':');
            buff.append(DeviceUpgrade.valueArrayToString(this.values));
        }
        return buff.toString();
    }
}

