/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CombinerDevice;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.TextPopupMenu;
import com.hifiremote.jp1.Value;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class CombinerDeviceDialog
extends JDialog
implements ActionListener,
ItemListener,
DocumentListener {
    private CombinerDevice device = null;
    private Remote remote = null;
    private JPanel mainPanel = null;
    private JPanel protocolHolder = null;
    private JComboBox protocolList = null;
    private JTextField deviceNotes = null;
    private JTextField protocolID = null;
    private JTextField fixedData = null;
    private JTextArea protocolNotes = null;
    private TableLayout tl = null;
    private DeviceParameter[] parameters = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private int userAction = 2;

    public CombinerDeviceDialog(JFrame owner, CombinerDevice dev, Remote r) {
        super(owner, "Combiner Device", true);
        this.createGui(owner, dev, r);
    }

    public CombinerDeviceDialog(JDialog owner, CombinerDevice dev, Remote r) {
        super(owner, "Combiner Device", true);
        this.createGui(owner, dev, r);
    }

    private void createGui(Component owner, CombinerDevice dev, Remote r) {
        this.setLocationRelativeTo(owner);
        Container contentPane = this.getContentPane();
        this.remote = r;
        this.protocolHolder = new JPanel(new BorderLayout());
        this.protocolHolder.setBorder(BorderFactory.createTitledBorder("Protocol Parameters"));
        Insets insets = this.protocolHolder.getInsets();
        double bt = insets.top;
        double bl = insets.left + 10;
        double br = insets.right;
        double bb = insets.bottom;
        double b = 10.0;
        double i = 5.0;
        double v = 20.0;
        double f = -1.0;
        double p = -2.0;
        double[][] size = new double[][]{{b, bl, p, b, p, br, b, f, b}, {b, p, i, p, v, bt, p, bb, i, f, b}};
        this.tl = new TableLayout(size);
        this.mainPanel = new JPanel(this.tl);
        contentPane.add((Component)this.mainPanel, "Center");
        JLabel label = new JLabel("Protocol:", 4);
        this.mainPanel.add((Component)label, "2, 1");
        boolean allowUpgrades = r.getProcessor().getEquivalentName().equals("S3C80");
        List<Protocol> allProtocols = ProtocolManager.getProtocolManager().getProtocolsForRemote(r, allowUpgrades);
        ArrayList<Protocol> protocols = new ArrayList<Protocol>();
        if (allowUpgrades) {
            protocols.add(new ManualProtocol(null, null));
        }
        for (Protocol protocol : allProtocols) {
            if (protocol.getDefaultCmdLength() != 1) continue;
            protocols.add(protocol);
        }
        this.device = dev == null ? new CombinerDevice((Protocol)protocols.get(1), new Value[0]) : new CombinerDevice(dev);
        this.device.getProtocol().reset();
        this.protocolList = new JComboBox<Object>(protocols.toArray());
        this.protocolList.addActionListener(this);
        label.setLabelFor(this.protocolList);
        this.protocolList.setToolTipText("Select the protocol to be used for this device upgrade from the drop-down list.");
        this.mainPanel.add((Component)this.protocolList, "4, 1");
        this.deviceNotes = new JTextField();
        new TextPopupMenu(this.deviceNotes);
        this.deviceNotes.getDocument().addDocumentListener(this);
        JPanel temp = new JPanel(new BorderLayout());
        temp.add((Component)this.deviceNotes, "Center");
        temp.setBorder(BorderFactory.createTitledBorder("Notes"));
        this.mainPanel.add((Component)temp, "7, 1, 7, 3");
        label = new JLabel("Protocol ID:", 4);
        this.mainPanel.add((Component)label, "2, 3");
        this.protocolID = new JTextField();
        label.setLabelFor(this.protocolID);
        this.protocolID.setEditable(false);
        this.protocolID.setToolTipText("This is the protocol ID that corresponds to the selected protocol.");
        this.mainPanel.add((Component)this.protocolID, "4, 3");
        label = new JLabel("Fixed Data:", 4);
        this.mainPanel.add((Component)label, "2, 6");
        this.fixedData = new JTextField(" ");
        this.fixedData.setEditable(false);
        this.mainPanel.add((Component)this.fixedData, "4, 6");
        boolean flag = this.device.getProtocol().getClass() == ManualProtocol.class;
        this.fixedData.setEditable(flag);
        this.protocolID.setEditable(flag);
        this.mainPanel.add((Component)this.protocolHolder, "1, 5, 5, 7");
        this.protocolNotes = new JTextArea(15, 60);
        this.protocolNotes.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.protocolNotes.setText(((Protocol)protocols.get(0)).getNotes());
        this.protocolNotes.setBackground(label.getBackground());
        this.protocolNotes.setToolTipText("Notes about the selected protocol.");
        this.protocolNotes.setEditable(false);
        this.protocolNotes.setLineWrap(true);
        this.protocolNotes.setWrapStyleWord(true);
        JScrollPane scrollPane = new JScrollPane(this.protocolNotes);
        scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Protocol Notes"), scrollPane.getBorder()));
        this.mainPanel.add((Component)scrollPane, "1, 9, 7, 9");
        JPanel panel = new JPanel(new FlowLayout(2));
        contentPane.add((Component)panel, "South");
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        panel.add(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
        this.update();
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    public void update() {
        Protocol p = this.device.getProtocol();
        p.setDeviceParms(this.device.getValues());
        this.updateParameters();
        this.protocolList.setSelectedItem(p);
        if (this.protocolList.getSelectedItem() != p) {
            this.protocolList.addItem(p);
            this.protocolList.setSelectedItem(p);
        }
        this.fixedData.getDocument().removeDocumentListener(this);
        this.protocolID.getDocument().removeDocumentListener(this);
        this.deviceNotes.getDocument().removeDocumentListener(this);
        this.fixedData.setText(this.device.getFixedData().toString());
        Hex id = p.getID(this.remote);
        if (id != null) {
            this.protocolID.setText(id.toString());
        } else {
            this.protocolID.setText(null);
        }
        this.deviceNotes.setText(this.device.getNotes());
        this.fixedData.getDocument().addDocumentListener(this);
        this.protocolID.getDocument().addDocumentListener(this);
        this.deviceNotes.getDocument().addDocumentListener(this);
        this.protocolNotes.setText(p.getNotes());
        this.protocolNotes.setCaretPosition(0);
    }

    public void updateParameters() {
        DeviceParameter[] newParameters = this.device.getProtocol().getDeviceParameters();
        if (this.parameters != newParameters) {
            this.removeParameters(this.parameters);
            this.parameters = newParameters;
            this.addParameters(this.parameters);
        }
    }

    private void removeParameters(DeviceParameter[] parameters) {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i].removeListener(this);
                this.mainPanel.remove(parameters[i].getLabel());
                this.mainPanel.remove(parameters[i].getComponent());
                this.tl.deleteRow(6);
                this.tl.deleteRow(6);
            }
        }
    }

    private void addParameters(DeviceParameter[] parameters) {
        if (parameters != null) {
            int row = 6;
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i].addListener(this);
                this.tl.insertRow(row, -2.0);
                this.mainPanel.add((Component)parameters[i].getLabel(), "2, " + row);
                this.mainPanel.add((Component)parameters[i].getComponent(), "4, " + row);
                int n = ++row;
                ++row;
                this.tl.insertRow(n, 5.0);
            }
            TableLayoutConstraints tlc = this.tl.getConstraints(this.protocolHolder);
            this.mainPanel.remove(this.protocolHolder);
            this.mainPanel.add((Component)this.protocolHolder, tlc);
        }
    }

    public void updateFixedData() {
        Protocol p = this.device.getProtocol();
        this.device.setValues(p.getDeviceParmValues());
        this.fixedData.getDocument().removeDocumentListener(this);
        this.fixedData.setText(this.device.getFixedData().toString());
        this.fixedData.getDocument().addDocumentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Protocol oldProtocol;
        Protocol newProtocol;
        Object source = e.getSource();
        if (source == this.protocolList && (newProtocol = (Protocol)this.protocolList.getSelectedItem()) != (oldProtocol = this.device.getProtocol())) {
            oldProtocol.reset();
            this.protocolID.getDocument().removeDocumentListener(this);
            Hex id = newProtocol.getID(this.remote);
            if (id != null) {
                this.protocolID.setText(id.toString());
            } else {
                this.protocolID.setText(null);
            }
            this.protocolID.getDocument().addDocumentListener(this);
            this.device.setProtocol(newProtocol);
            this.updateParameters();
            this.fixedData.getDocument().removeDocumentListener(this);
            this.fixedData.setText(newProtocol.getFixedData(newProtocol.getDeviceParmValues()).toString());
            this.fixedData.getDocument().addDocumentListener(this);
            boolean flag = newProtocol.getClass() == ManualProtocol.class;
            this.fixedData.setEditable(flag);
            this.protocolID.setEditable(flag);
            this.validate();
            this.protocolNotes.setText(newProtocol.getNotes());
            this.protocolNotes.setCaretPosition(0);
            this.protocolNotes.revalidate();
        }
        if (source == this.cancelButton) {
            this.userAction = 2;
            this.setVisible(false);
            this.removeParameters(this.parameters);
            this.device.getProtocol().reset();
            this.dispose();
        } else if (source == this.okButton) {
            this.userAction = 0;
            this.setVisible(false);
            this.removeParameters(this.parameters);
            this.device.getProtocol().reset();
            this.dispose();
        } else {
            this.updateFixedData();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.docUpdated(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.docUpdated(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.docUpdated(e);
    }

    private void docUpdated(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.protocolID.getDocument()) {
            ((ManualProtocol)this.device.getProtocol()).setID(new Hex(this.protocolID.getText()));
        } else if (doc == this.fixedData.getDocument()) {
            ((ManualProtocol)this.device.getProtocol()).setRawHex(new Hex(this.fixedData.getText()));
        } else if (doc == this.deviceNotes.getDocument()) {
            this.device.setNotes(this.deviceNotes.getText());
        } else {
            this.updateFixedData();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.updateFixedData();
    }

    public int getUserAction() {
        return this.userAction;
    }

    public CombinerDevice getCombinerDevice() {
        return this.device;
    }
}

