/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CustomNameDialog
extends JDialog
implements ActionListener {
    private JTextArea textArea = null;
    private JButton getButtonNames = null;
    private JButton ok = null;
    private JButton cancel = null;
    private int userAction = 2;

    public CustomNameDialog(JFrame owner, String[] customNames) {
        super(owner, "Custom Function Names", true);
        this.createGui(owner, customNames);
    }

    public CustomNameDialog(JDialog owner, String[] customNames) {
        super(owner, "Custom Function Names", true);
        this.createGui(owner, customNames);
    }

    private void createGui(Component owner, String[] customNames) {
        this.setLocationRelativeTo(owner);
        this.textArea = new JTextArea(20, 20);
        new TextPopupMenu(this.textArea);
        if (customNames != null) {
            for (int i = 0; i < customNames.length; ++i) {
                if (i != 0) {
                    this.textArea.append("\n");
                }
                this.textArea.append(customNames[i]);
            }
        }
        Container contentPane = this.getContentPane();
        JLabel instructions = new JLabel("Enter the desired default functions names, one on each line.");
        instructions.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add((Component)instructions, "North");
        JScrollPane scroll = new JScrollPane(this.textArea);
        scroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), scroll.getBorder()));
        contentPane.add((Component)scroll, "Center");
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getButtonNames = new JButton("Get Button Names");
        this.getButtonNames.setToolTipText("Add the names of the buttons on the current remote.");
        this.getButtonNames.addActionListener(this);
        buttonPanel.add(this.getButtonNames);
        buttonPanel.add(Box.createHorizontalGlue());
        this.ok = new JButton("OK");
        this.ok.addActionListener(this);
        buttonPanel.add(this.ok);
        buttonPanel.add(Box.createHorizontalStrut(5));
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        buttonPanel.add(this.cancel);
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        Rectangle rect = this.getBounds();
        int x = rect.x - rect.width / 2;
        int y = rect.y - rect.height / 2;
        this.setLocation(x, y);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cancel) {
            this.userAction = 2;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.ok) {
            this.userAction = 0;
            this.setVisible(false);
            this.dispose();
        } else if (source == this.getButtonNames) {
            Button[] buttons = KeyMapMaster.getRemote().getUpgradeButtons();
            for (int i = 0; i < buttons.length; ++i) {
                if (i > 0) {
                    this.textArea.append("\n");
                }
                this.textArea.append(buttons[i].getName());
            }
        }
    }

    public String[] getCustomNames() {
        StringTokenizer st = new StringTokenizer(this.textArea.getText().trim(), "\r\n");
        int count = st.countTokens();
        if (count == 0) {
            return null;
        }
        String[] customNames = new String[count];
        int i = 0;
        while (st.hasMoreTokens()) {
            customNames[i++] = st.nextToken();
        }
        return customNames;
    }

    public int getUserAction() {
        return this.userAction;
    }
}

