/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.SpecialFunctionDialog;
import com.hifiremote.jp1.SpecialProtocolFunction;
import java.util.Properties;

public class DSMFunction
extends SpecialProtocolFunction {
    public DSMFunction(KeyMove keyMove) {
        super(keyMove);
    }

    public DSMFunction(Macro macro) {
        super(macro);
    }

    public DSMFunction(int keyCode, int deviceButtonIndex, int deviceType, int setupCode, Hex cmd, String notes) {
        super(keyCode, deviceButtonIndex, deviceType, setupCode, cmd, notes);
    }

    public DSMFunction(Properties props, Remote remote) {
        super(props, remote);
    }

    @Override
    public String get_Type(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public String getDisplayType(RemoteConfiguration remoteConfig) {
        return this.getUserFunctions(remoteConfig)[0];
    }

    @Override
    public Hex getCmd() {
        if (this.getMacro() != null && this.getMacro().getItems() != null) {
            return this.getMacro().getItemData(false);
        }
        return super.getCmd();
    }

    @Override
    public String getValueString(RemoteConfiguration remoteConfig) {
        if (this.getMacro() != null && this.getMacro().getItems() != null) {
            return this.getMacro().getValueString(remoteConfig);
        }
        Remote remote = remoteConfig.getRemote();
        StringBuilder buff = new StringBuilder();
        short[] keys = this.getCmd().getData();
        for (int i = 0; i < keys.length; ++i) {
            if (i != 0) {
                buff.append(';');
            }
            buff.append(remote.getButtonName(keys[i]));
        }
        return buff.toString();
    }

    @Override
    public void update(SpecialFunctionDialog dlg) {
        short[] keys = this.getCmd().getData();
        Integer[] temp = new Integer[keys.length];
        for (int i = 0; i < temp.length; ++i) {
            temp[i] = new Integer(keys[i]);
        }
        dlg.setFirstMacroButtons(temp);
    }

    public static Hex createHex(SpecialFunctionDialog dlg) {
        Integer[] temp = dlg.getFirstMacroButtons();
        short[] data = new short[temp.length];
        for (int i = 0; i < temp.length; ++i) {
            data[i] = temp[i].shortValue();
        }
        return new Hex(data);
    }
}

