/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

public class DaySchedule {
    private static final int DAY0 = 2;
    private static final String[] dayNames = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private int map = 0;

    public DaySchedule() {
        this.map = 0;
    }

    public DaySchedule(int map) {
        this.map = map;
    }

    private int dayIndex(int day) {
        return (day - 2 + 7) % 7;
    }

    public boolean isSet(int day) {
        return (this.map >> this.dayIndex(day) & 1) == 1;
    }

    public boolean isSet7Days() {
        return (this.map & 0x7F) == 127;
    }

    public void set(int day, boolean setSelected) {
        int mask = 1 << this.dayIndex(day);
        this.map = setSelected ? (this.map |= mask) : (this.map &= 0xFF ^ mask);
    }

    public void set7Days() {
        this.map |= 0x7F;
    }

    public void setWeeklyRepeat(boolean weekly) {
        this.map &= 0x7F;
        if (weekly) {
            this.map |= 0x80;
        }
    }

    public boolean isWeeklyRepeat() {
        return (this.map & 0x80) == 128;
    }

    public boolean isDaily() {
        return this.map == 255;
    }

    public int getFirstDay() {
        int index;
        int days = this.map & 0x7F;
        for (index = 0; index < 7 && (days & 1) == 0; ++index) {
            days >>= 1;
        }
        return 2 + index;
    }

    public void clear() {
        this.map = 0;
    }

    public String toString() {
        if (this.map == 255) {
            return "Daily";
        }
        StringBuilder buff = new StringBuilder();
        if (this.isWeeklyRepeat()) {
            buff.append("Every ");
        } else {
            buff.append("Next ");
        }
        boolean first = true;
        for (int i = 0; i < 7; ++i) {
            int mask = 1 << i;
            if ((this.map & mask) <= 0) continue;
            buff.append(first ? dayNames[i] : ";" + dayNames[i]);
            first = false;
        }
        return buff.toString();
    }

    public int getMap() {
        return this.map;
    }

    public void setMap(int map) {
        this.map = map;
    }
}

