/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DaySchedule;
import com.hifiremote.jp1.MacroCodingType;
import com.hifiremote.jp1.RMSetter;
import com.hifiremote.jp1.RemoteConfiguration;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class DayScheduleBox
extends Box
implements ItemListener,
RMSetter<DaySchedule> {
    private JToggleButton mon = null;
    private JToggleButton tue = null;
    private JToggleButton wed = null;
    private JToggleButton thu = null;
    private JToggleButton fri = null;
    private JToggleButton sat = null;
    private JToggleButton sun = null;
    private JToggleButton dly = null;
    private JToggleButton one = null;
    private JToggleButton rpt = null;
    public static MacroCodingType macroCodingType = null;

    public DayScheduleBox() {
        super(0);
        JPanel daySetting = new JPanel();
        daySetting.setBorder(BorderFactory.createTitledBorder("Day Setting"));
        this.add(daySetting);
        JPanel repeatSetting = new JPanel(new GridLayout(3, 1, 0, 0));
        repeatSetting.setBorder(BorderFactory.createTitledBorder("Repeat"));
        ButtonGroup grpRpt = new ButtonGroup();
        if (macroCodingType.hasTimedMacros()) {
            this.mon = new JRadioButton("Mon");
            this.tue = new JRadioButton("Tue");
            this.wed = new JRadioButton("Wed");
            this.thu = new JRadioButton("Thu");
            this.fri = new JRadioButton("Fri");
            this.sat = new JRadioButton("Sat");
            this.sun = new JRadioButton("Sun");
            ButtonGroup grpDay = new ButtonGroup();
            grpDay.add(this.mon);
            grpDay.add(this.tue);
            grpDay.add(this.wed);
            grpDay.add(this.thu);
            grpDay.add(this.fri);
            grpDay.add(this.sat);
            grpDay.add(this.sun);
            daySetting.setLayout(new GridLayout(4, 2, 0, -5));
            daySetting.add(this.mon);
            daySetting.add(this.fri);
            daySetting.add(this.tue);
            daySetting.add(this.sat);
            daySetting.add(this.wed);
            daySetting.add(this.sun);
            daySetting.add(this.thu);
            this.one = new JRadioButton("Once");
            this.rpt = new JRadioButton("Weekly");
            this.dly = new JRadioButton("Daily");
            this.dly.addItemListener(this);
            grpRpt.add(this.one);
            grpRpt.add(this.rpt);
            grpRpt.add(this.dly);
            repeatSetting.add(this.one);
            repeatSetting.add(this.rpt);
            repeatSetting.add(this.dly);
            this.add(repeatSetting);
        } else {
            this.mon = new JCheckBox("Mon");
            this.tue = new JCheckBox("Tue");
            this.wed = new JCheckBox("Wed");
            this.thu = new JCheckBox("Thu");
            this.fri = new JCheckBox("Fri");
            this.sat = new JCheckBox("Sat");
            this.sun = new JCheckBox("Sun");
            daySetting.setLayout(new GridLayout(3, 3, 0, -5));
            this.one = new JRadioButton("One-time");
            this.rpt = new JRadioButton("Repeating");
            this.dly = new JCheckBox();
            grpRpt.add(this.one);
            grpRpt.add(this.rpt);
            daySetting.add(this.mon);
            daySetting.add(this.thu);
            daySetting.add(this.sun);
            daySetting.add(this.tue);
            daySetting.add(this.fri);
            daySetting.add(this.one);
            daySetting.add(this.wed);
            daySetting.add(this.sat);
            daySetting.add(this.rpt);
        }
    }

    @Override
    public void setValue(DaySchedule daySchedule) {
        if (macroCodingType.hasTimedMacros() && daySchedule.isSet7Days() && daySchedule.isWeeklyRepeat()) {
            this.dly.setSelected(true);
        } else {
            this.mon.setSelected(daySchedule.isSet(2));
            this.tue.setSelected(daySchedule.isSet(3));
            this.wed.setSelected(daySchedule.isSet(4));
            this.thu.setSelected(daySchedule.isSet(5));
            this.fri.setSelected(daySchedule.isSet(6));
            this.sat.setSelected(daySchedule.isSet(7));
            this.sun.setSelected(daySchedule.isSet(1));
            this.one.setSelected(!daySchedule.isWeeklyRepeat());
            this.rpt.setSelected(daySchedule.isWeeklyRepeat());
        }
    }

    @Override
    public DaySchedule getValue() {
        DaySchedule daySchedule = new DaySchedule();
        if (this.dly.isSelected()) {
            daySchedule.set7Days();
            daySchedule.setWeeklyRepeat(true);
        } else {
            daySchedule.set(2, this.mon.isSelected());
            daySchedule.set(3, this.tue.isSelected());
            daySchedule.set(4, this.wed.isSelected());
            daySchedule.set(5, this.thu.isSelected());
            daySchedule.set(6, this.fri.isSelected());
            daySchedule.set(7, this.sat.isSelected());
            daySchedule.set(1, this.sun.isSelected());
            daySchedule.setWeeklyRepeat(this.rpt.isSelected());
        }
        return daySchedule;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean b = !this.dly.isSelected();
        this.mon.setEnabled(b);
        this.tue.setEnabled(b);
        this.wed.setEnabled(b);
        this.thu.setEnabled(b);
        this.fri.setEnabled(b);
        this.sat.setEnabled(b);
        this.sun.setEnabled(b);
    }

    @Override
    public void setRemoteConfiguration(RemoteConfiguration config) {
    }
}

