/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.RowNumberRenderer;
import javax.swing.table.TableCellRenderer;

public class DecodeTableModel
extends JP1TableModel<LearnedSignalDecode> {
    private static final String[] colNames = new String[]{"#", "Protocol", "Device", "<html>Sub<br>Device</html>", "OBC", "Hex Cmd", "EFC", "Misc", "Ignore"};
    private static String[] colPrototypeNames = new String[]{" 00 ", "Protocol Name", "Device", "Device", "OBC", "Hex Cmd", "EFC", "Miscellaneous", "Ignore"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, Integer.class, Integer.class, Integer.class, Integer.class, String.class, String.class, Boolean.class};

    public void set(LearnedSignal learnedSignal) {
        this.setData(learnedSignal.getDecodes(true));
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int col) {
        return colNames[col];
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnPrototypeName(int col) {
        return colPrototypeNames[col];
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return col != 1 && col != 7;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[col];
    }

    @Override
    public Object getValueAt(int row, int column) {
        LearnedSignalDecode decode = (LearnedSignalDecode)this.getRow(row);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return decode.protocolName;
            }
            case 2: {
                if (decode.device == -1) {
                    return null;
                }
                return new Integer(decode.device);
            }
            case 3: {
                if (decode.subDevice == -1) {
                    return null;
                }
                return new Integer(decode.subDevice);
            }
            case 4: {
                if (decode.obc == -1) {
                    return null;
                }
                return new Integer(decode.obc);
            }
            case 5: {
                return Hex.toString(decode.hex);
            }
            case 6: {
                short[] temp = new short[decode.hex.length];
                if (temp.length == 0) {
                    return null;
                }
                for (int i = 0; i < temp.length; ++i) {
                    temp[i] = (short)decode.hex[i];
                }
                Hex hex = new Hex(temp);
                EFC efc = new EFC(hex);
                return efc.toString();
            }
            case 7: {
                return decode.miscMessage;
            }
            case 8: {
                return decode.ignore;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 8;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 8) {
            ((LearnedSignalDecode)this.getRow((int)row)).ignore = (Boolean)value;
        }
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        if (col == 0) {
            return new RowNumberRenderer();
        }
        return null;
    }
}

