/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SetupCode;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;

public class DeviceButton
extends Highlight {
    public static final int nullIndex = -1;
    public static final DeviceButton noButton = new DeviceButton("<none>", 0, 0, 0, 0, -1, 0);
    private String defaultName = null;
    private int highAddress = 0;
    private int lowAddress = 0;
    private int typeAddress = 0;
    private boolean internal = false;
    private int defaultSetupCode = 0;
    private int deviceCodeOffset = 0;
    private int buttonIndex = 0;
    private int colorIndex = -1;
    private int[] colorParams = null;
    private boolean colorEditable = false;
    private DeviceButton volumePT = noButton;
    private DeviceButton transportPT = noButton;
    private DeviceButton channelPT = noButton;
    private DeviceButton xPT = noButton;
    private DeviceButton inputPT = noButton;
    private DeviceButton zPT = noButton;
    private int favoriteWidth = 0;
    private Button favFinalKey = Button.noButton;
    private int vpt = 0;
    private boolean constructed = false;
    private short[] ptDefaults = null;
    private boolean rf = false;
    private HashMap<Button, GeneralFunction> buttonGeneralFunctionMap = null;
    private Remote.RFSelector[] rfSelectors = null;
    private DeviceUpgrade upgrade = null;
    private DeviceUpgrade convertedUpgrade = null;

    public DeviceButton(String name, int hiAddr, int lowAddr, int typeAddr, int setupCode, int index, int offset) {
        this.name = name;
        this.defaultName = name;
        this.highAddress = hiAddr;
        this.lowAddress = lowAddr;
        this.typeAddress = typeAddr;
        this.defaultSetupCode = setupCode + offset;
        this.deviceCodeOffset = offset;
        this.buttonIndex = index;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setDefaultName() {
        this.name = this.defaultName;
    }

    public int getDefaultSetupCode() {
        return this.defaultSetupCode;
    }

    public boolean isRf() {
        return this.rf;
    }

    public void setRf(boolean rf) {
        this.rf = rf;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int getDeviceTypeIndex(short[] data) {
        return this.highAddress > 0 ? data[this.highAddress] >> 4 : data[2];
    }

    public void setDeviceTypeIndex(short index, short[] data) {
        if (this.highAddress > 0) {
            if (index == 255) {
                data[this.highAddress] = 255;
                data[this.lowAddress] = 255;
            } else {
                int n = this.highAddress;
                data[n] = (short)(data[n] & 0xF);
                index = (short)(index << 4);
                int n2 = this.highAddress;
                data[n2] = (short)(data[n2] | index);
            }
        } else {
            data[2] = index;
            if (index == 255) {
                data[3] = 255;
                data[4] = 255;
                data[5] = 255;
                this.volumePT = noButton;
                this.transportPT = noButton;
                this.channelPT = noButton;
                this.xPT = noButton;
                this.inputPT = noButton;
                this.zPT = noButton;
            }
        }
    }

    public int getDeviceGroup(short[] data) {
        if (this.typeAddress > 0) {
            return data[this.typeAddress];
        }
        return -1;
    }

    public void setDeviceGroup(short group, short[] data) {
        if (this.typeAddress > 0) {
            data[this.typeAddress] = group;
        }
    }

    public short getSetupCode(short[] data) {
        short setupCode;
        if (data == null) {
            return -1;
        }
        short s = setupCode = this.highAddress > 0 ? data[this.highAddress] : data[3];
        if (this.highAddress > 0) {
            int mask = SetupCode.getMax() >> 8;
            setupCode = (short)(setupCode & mask);
        }
        setupCode = (short)(setupCode << 8);
        setupCode = (short)(setupCode | (this.lowAddress > 0 ? data[this.lowAddress] : data[4]));
        setupCode = (short)(setupCode + this.deviceCodeOffset);
        return setupCode;
    }

    public boolean getSetupLock(short[] data) {
        return (data[5] & 0x80) == 0;
    }

    public boolean getRfPaired(short[] data) {
        return (data[5] & 1) == 0;
    }

    public boolean getRFVendorProfile(short[] data) {
        return (data[5] & 2) == 0;
    }

    public void setSetupCode(short setupCode, short[] data) {
        if (this.highAddress > 0) {
            if (setupCode > SetupCode.getMax()) {
                throw new NumberFormatException("Setup codes must be between 0 and " + SetupCode.getMax());
            }
            int val = setupCode - this.deviceCodeOffset;
            short temp = (short)val;
            temp = (short)(temp >> 8);
            int mask = 248;
            if (SetupCode.getMax() > 2047) {
                mask = 240;
            }
            int n = this.highAddress;
            data[n] = (short)(data[n] & mask);
            int n2 = this.highAddress;
            data[n2] = (short)(data[n2] | temp);
            data[this.lowAddress] = (short)(val & 0xFF);
        } else {
            Hex.put(setupCode, data, 3);
        }
    }

    public void setSetupLock(boolean lock, short[] data) {
        data[5] = (short)(lock ? data[5] & 0x7F : data[5] | 0x80);
    }

    public void setRfPaired(boolean paired, short[] data) {
        data[5] = (short)(paired ? data[5] & 0xFE : data[5] | 3);
    }

    public void setRfVendorProfile(boolean vendor, short[] data) {
        data[5] = (short)(vendor ? data[5] & 0xFD : data[5] | 2);
    }

    public int getDeviceSlot(short[] data) {
        if (this.highAddress == 0) {
            return data[2] << 8 | data[3];
        }
        return data[this.highAddress] << 8 | data[this.lowAddress];
    }

    public void setDeviceSlot(int value, short[] data) {
        data[this.highAddress] = (short)(value >> 8);
        data[this.lowAddress] = (short)(value & 0xFF);
    }

    public void zeroDeviceSlot(short[] data) {
        if (this.highAddress > 0) {
            data[this.highAddress] = 0;
            data[this.lowAddress] = 0;
        } else {
            data[3] = 0;
            data[4] = 0;
        }
    }

    public int getButtonIndex() {
        return this.buttonIndex;
    }

    public short[] getPTdefaults() {
        return this.ptDefaults;
    }

    public void setPTdefaults(short[] ptDefaults) {
        this.ptDefaults = ptDefaults;
    }

    public DeviceButton getVolumePT() {
        return this.volumePT;
    }

    public void setVolumePT(DeviceButton volumePT) {
        this.volumePT = volumePT;
    }

    public DeviceButton getTransportPT() {
        return this.transportPT;
    }

    public void setTransportPT(DeviceButton transportPT) {
        this.transportPT = transportPT;
    }

    public DeviceButton getChannelPT() {
        return this.channelPT;
    }

    public void setChannelPT(DeviceButton channelPT) {
        this.channelPT = channelPT;
    }

    public DeviceButton getxPT() {
        return this.xPT;
    }

    public void setxPT(DeviceButton xPT) {
        this.xPT = xPT;
    }

    public DeviceButton getInputPT() {
        return this.inputPT;
    }

    public void setInputPT(DeviceButton inputPT) {
        this.inputPT = inputPT;
    }

    public DeviceButton getzPT() {
        return this.zPT;
    }

    public void setzPT(DeviceButton zPT) {
        this.zPT = zPT;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public boolean isConstructed() {
        return this.constructed;
    }

    public void setConstructed(boolean constructed) {
        this.constructed = constructed;
    }

    public DeviceUpgrade getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(DeviceUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    public DeviceUpgrade getConvertedUpgrade() {
        return this.convertedUpgrade;
    }

    public void setConvertedUpgrade(DeviceUpgrade convertedUpgrade) {
        this.convertedUpgrade = convertedUpgrade;
    }

    public GeneralFunction getGeneralFunction(Button btn) {
        if (this.buttonGeneralFunctionMap == null) {
            return null;
        }
        GeneralFunction gf = this.buttonGeneralFunctionMap.get(btn);
        if (gf == null) {
            gf = new GeneralFunction();
            gf.icon = new GeneralFunction.RMIcon(9);
            this.buttonGeneralFunctionMap.put(btn, gf);
        }
        return gf;
    }

    public void setButtonGeneralFunctionMap(HashMap<Button, GeneralFunction> buttonGeneralFunctionMap) {
        this.buttonGeneralFunctionMap = buttonGeneralFunctionMap;
    }

    public HashMap<Button, GeneralFunction> getButtonGeneralFunctionMap() {
        return this.buttonGeneralFunctionMap;
    }

    public int getFavoriteWidth() {
        return this.favoriteWidth;
    }

    public void setFavoritewidth(int favoriteWidth) {
        this.favoriteWidth = favoriteWidth;
    }

    public Button getFavFinalKey() {
        return this.favFinalKey;
    }

    public void setFavFinalKey(Button favFinalKey) {
        this.favFinalKey = favFinalKey;
    }

    public int getVpt() {
        return this.vpt;
    }

    public void setVpt(int vpt) {
        this.vpt = vpt;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public boolean isColorEditable() {
        return this.colorEditable;
    }

    public void setColorEditable(boolean colorEditable) {
        this.colorEditable = colorEditable;
    }

    public int[] getColorParams() {
        return this.colorParams;
    }

    public void setColorParams(int[] colorParams) {
        this.colorParams = colorParams;
    }

    public Remote.RFSelector[] getRfSelectors() {
        return this.rfSelectors;
    }

    public void setRfSelectors(Remote.RFSelector[] rfSelectors) {
        this.rfSelectors = rfSelectors;
    }

    public void doHighlight(Color[] highlight) {
        if (this.highAddress > 0) {
            highlight[this.highAddress] = this.getHighlight();
            highlight[this.lowAddress] = this.getHighlight();
            if (this.typeAddress > 0) {
                highlight[this.typeAddress] = this.getHighlight();
            }
            this.setMemoryUsage(this.typeAddress > 0 ? 3 : 2);
        } else if (this.getSegment() != null) {
            int address = this.getSegment().getAddress();
            int size = this.getSegment().getHex().length() + 4;
            for (int i = 3; i < size; ++i) {
                highlight[address + i] = this.getHighlight();
            }
            this.setMemoryUsage(size - 3);
        }
    }

    public void store(Remote remote) {
        Hex hex = null;
        if (this.getSegment() != null) {
            hex = this.getSegment().getHex();
        } else if (remote.getSegmentTypes() != null) {
            hex = new Hex(12);
            Arrays.fill(hex.getData(), (short)255);
            hex.set((short)this.buttonIndex, 0);
            hex.set((short)0, 1);
            this.setSegment(new Segment(0, 255, hex));
        } else {
            return;
        }
        int ptDefLen = this.ptDefaults == null ? 0 : this.ptDefaults.length;
        for (int i = 0; i < 6; ++i) {
            hex.set((short)(i < ptDefLen ? this.ptDefaults[i] : (i < 3 ? 0 : 255)), i + 6);
        }
        String pt = remote.getPunchThru();
        if (pt.indexOf(86) >= 0 && this.volumePT != noButton) {
            hex.set((short)(hex.getData()[2] == 255 ? 255 : this.volumePT.getButtonIndex()), 6);
        }
        if (pt.indexOf(84) >= 0 && this.transportPT != noButton) {
            hex.set((short)(hex.getData()[2] == 255 ? 255 : this.transportPT.getButtonIndex()), 7);
        }
        if (pt.indexOf(67) >= 0 && this.channelPT != noButton) {
            hex.set((short)(hex.getData()[2] == 255 ? 255 : this.channelPT.getButtonIndex()), 8);
        }
        if (pt.indexOf(88) >= 0 && this.xPT != noButton) {
            hex.set((short)(hex.getData()[2] == 255 ? 255 : this.xPT.getButtonIndex()), 9);
        }
        if (pt.indexOf(89) >= 0 && this.inputPT != noButton) {
            hex.set((short)(hex.getData()[2] == 255 ? 255 : this.inputPT.getButtonIndex()), 10);
        }
        if (pt.indexOf(90) >= 0 && this.zPT != noButton) {
            hex.set((short)(hex.getData()[2] == 255 ? 255 : this.zPT.getButtonIndex()), 11);
        }
    }

    @Override
    public void store(PropertyWriter pw) {
        if (this.rfSelectors == null || this.rfSelectors.length == 0) {
            return;
        }
        pw.print("DeviceIndex", this.buttonIndex);
        for (int i = 0; i < this.rfSelectors.length; ++i) {
            Remote.RFSelector rfSel = this.rfSelectors[i];
            String value = rfSel.btn.getKeyCode() + "|" + rfSel.irDevType.getName() + "|" + rfSel.irCode + "|" + rfSel.rfDevType.getName() + "|" + rfSel.rfCode;
            pw.print("Selector." + i, value);
        }
    }
}

