/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceLabels;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceTypeEditor;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1TableModel;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.RMColorEditor;
import com.hifiremote.jp1.RMColorRenderer;
import com.hifiremote.jp1.RMSetterEditor;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RowNumberRenderer;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SelectAllCellEditor;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SetupCodeEditor;
import com.hifiremote.jp1.SetupCodeRenderer;
import com.hifiremote.jp1.SoftDevices;
import com.hifiremote.jp1.SoftHomeTheater;
import com.hifiremote.jp1.SpinnerCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class DeviceButtonTableModel
extends JP1TableModel<DeviceButton> {
    private static final String[] colNames = new String[]{"#", "Device Button", "Type", "<html>Setup<br>Code</html>", "<html>Setup<br>Lock</html>", "<html>RF<br>Paired</html>", "<html>RF<br>Profile</html>", "<html>Volume<br>PunchThrough</html>", "<html>Transport<br>PunchThrough</html>", "<html>Channel<br>PunchThrough</html>", "<html>X<br>PunchThrough</html>", "<html>Input<br>PunchThrough</html>", "<html>Z<br>PunchThrough</html>", "<html>Volume<br>Lock</html>", "<html>Ring<br>Color</html>", "Note", "", "", "", "Icon?", "Seq", "<html>Size &amp<br>Color</html>"};
    private static String[] colPrototypeNames = new String[]{" 00 ", "Device Button  ", "__VCR/DVD__", "Setup   ", "Setup   ", "Paired", "Profile", "PunchThrough_", "PunchThrough_", "PunchThrough_", "PunchThrough_", "PunchThrough_", "PunchThrough_", "Master_", "Color_", "A Meaningful, Reasonable Note", "Label", "Model", "Remote", "Icon?_", "Seq", "Color_"};
    private static final Class<?>[] colClasses = new Class[]{Integer.class, String.class, DeviceType.class, SetupCode.class, Boolean.class, Boolean.class, String.class, DeviceButton.class, DeviceButton.class, DeviceButton.class, DeviceButton.class, DeviceButton.class, DeviceButton.class, String.class, Integer.class, String.class, String.class, String.class, String.class, Integer.class, GeneralFunction.RMIcon.class, Color.class};
    private int lastCell = 0;
    private RemoteConfiguration remoteConfig = null;
    private DefaultCellEditor deviceTypeEditor = null;
    private JComboBox deviceTypeBox = new JComboBox();
    private JButton editButton = null;
    private DefaultCellEditor punchThroughEditor = null;
    private JComboBox deviceButtonBox = new JComboBox();
    private DefaultCellEditor deviceLockEditor = null;
    private DefaultCellEditor rfProfileEditor = null;
    private String[] lockStates = new String[]{"Off", "On", "Master"};
    private String[] rfProfiles = new String[]{"ZRC", "Vendor"};
    private JComboBox<String> deviceLockBox = new JComboBox<String>(this.lockStates);
    private JComboBox<String> rfProfileBox = new JComboBox<String>(this.rfProfiles);
    private SpinnerCellEditor spinnerEditor = null;
    private SelectAllCellEditor selectAllEditor = new SelectAllCellEditor();
    private RMSetterEditor<GeneralFunction.RMIcon, GeneralFunction.IconPanel> iconEditor = null;
    private SetupCodeRenderer setupCodeRenderer = null;
    private SetupCodeEditor setupCodeEditor = null;
    private RMColorEditor colorEditor = null;
    private RMColorRenderer colorRenderer = new RMColorRenderer();
    private DeviceNameRenderer nameRenderer = new DeviceNameRenderer();
    private GeneralFunction.IconRenderer iconRenderer = null;
    private DefaultCellEditor sequenceEditor = null;
    private JComboBox sequenceBox = new JComboBox();
    private boolean editable = true;
    private SoftHomeTheater softHT = new SoftHomeTheater();

    public DeviceButtonTableModel() {
        this.deviceTypeEditor = new DeviceTypeEditor(this.deviceTypeBox, this.softHT);
        this.deviceTypeEditor.setClickCountToStart(2);
        this.punchThroughEditor = new DefaultCellEditor(this.deviceButtonBox);
        this.punchThroughEditor.setClickCountToStart(2);
        this.sequenceEditor = new DefaultCellEditor(this.sequenceBox);
        this.sequenceEditor.setClickCountToStart(2);
        this.deviceLockEditor = new DefaultCellEditor(this.deviceLockBox);
        this.deviceLockEditor.setClickCountToStart(2);
        this.rfProfileEditor = new DefaultCellEditor(this.rfProfileBox);
        this.rfProfileEditor.setClickCountToStart(2);
    }

    public void set(RemoteConfiguration remoteConfig) {
        this.remoteConfig = remoteConfig;
        if (remoteConfig != null) {
            this.colorEditor = new RMColorEditor(remoteConfig.getOwner());
            Remote remote = remoteConfig.getRemote();
            if (remote.usesEZRC()) {
                this.setData(remoteConfig.getDeviceButtonList());
            } else {
                this.setData(remote.getDeviceButtons());
            }
            SoftDevices softDevices = remote.getSoftDevices();
            if (remote.getSoftHomeTheaterType() >= 0) {
                this.softHT.setUse(true);
                this.softHT.setDeviceType(remote.getSoftHomeTheaterType());
                this.softHT.setDeviceCode(remote.getSoftHomeTheaterCode());
            }
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<DeviceType>(remote.getAllDeviceTypes());
            if (softDevices != null && softDevices.inUse() && !softDevices.isSetupCodesOnly()) {
                comboModel.addElement(new DeviceType("", 0, 65535));
            }
            this.deviceTypeBox.setModel(comboModel);
            comboModel = new DefaultComboBoxModel<DeviceButton>(remote.getDeviceButtons());
            comboModel.insertElementAt((DeviceType)((Object)DeviceButton.noButton), 0);
            this.deviceButtonBox.setModel(comboModel);
            if (softDevices != null && softDevices.usesSequence()) {
                this.adjustSequenceRange();
            }
            this.setupCodeRenderer = new SetupCodeRenderer(remoteConfig);
            this.setupCodeEditor = new SetupCodeEditor(this.setupCodeRenderer);
            if (remote.isSSD()) {
                this.iconEditor = new RMSetterEditor(GeneralFunction.IconPanel.class);
                this.iconEditor.setRemoteConfiguration(remoteConfig);
                this.iconEditor.setTitle("Icon Editor");
                this.iconRenderer = new GeneralFunction.IconRenderer();
            }
            if (remote.usesLedColor()) {
                int max = Remote.colorHex.getData().length / 3;
                this.spinnerEditor = new SpinnerCellEditor(1, max, 1);
                this.spinnerEditor.setColorHex(Remote.colorHex);
            }
        }
    }

    public void setEditButton(JButton editButton) {
        this.editButton = editButton;
    }

    public void setEditButtonState(DeviceButton db) {
        if (this.remoteConfig.isReplacement) {
            this.remoteConfig.resetDeviceUpgrades();
        }
        this.editButton.setEnabled(this.remoteConfig.getAssignedDeviceUpgrade(db) != null || db.getConvertedUpgrade() != null);
    }

    private void setConvertedUpgrade(DeviceButton db, short[] data, int value) {
        DeviceUpgrade upgrade = null;
        try {
            Collection<Integer> extractCodes;
            Remote remote = this.remoteConfig.getRemote();
            remote.load();
            remote.setExtract();
            remote.setExtractData();
            int index = db.getDeviceTypeIndex(data);
            int group = db.getDeviceGroup(data);
            DeviceType deviceType = remote.getDeviceTypeByIndexAndGroup(index, group);
            if (Arrays.asList(remote.getExtractDeviceTypes()).contains(deviceType) && (extractCodes = remote.getExtractSetupCodes().get(deviceType.getNumber()).values()).contains(value)) {
                upgrade = new DeviceUpgrade();
                upgrade.setRemote(remote);
                upgrade.setSelectedSetupCode(String.format("%04d", value));
                upgrade.setSelectedDeviceIndex(index);
            }
            db.setConvertedUpgrade(upgrade);
        }
        catch (Exception e) {
            return;
        }
    }

    private int getDeviceCount() {
        int len = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.getExtendedTypeIndex(i) == 255) continue;
            ++len;
        }
        return len;
    }

    private void adjustSequenceRange() {
        int len = this.getDeviceCount();
        Integer[] values = new Integer[len];
        for (int i = 0; i < len; ++i) {
            values[i] = i + 1;
        }
        this.sequenceBox.setModel(new DefaultComboBoxModel<Integer>(values));
    }

    public void setEditable(boolean flag) {
        this.editable = flag;
    }

    @Override
    public int getColumnCount() {
        int count = 5;
        if (this.remoteConfig != null) {
            SoftDevices softDevices;
            Remote remote = this.remoteConfig.getRemote();
            DeviceLabels labels = remote.getDeviceLabels();
            if (labels != null) {
                for (int i = 0; i < 3; ++i) {
                    count += labels.columnNames[i] != null ? 1 : 0;
                }
            }
            if ((softDevices = remote.getSoftDevices()) != null && softDevices.usesSequence()) {
                ++count;
            }
            if (this.remoteConfig.hasSegments()) {
                if (remote.isSSD()) {
                    ++count;
                } else {
                    ++count;
                    String pt = remote.getPunchThru();
                    for (int i = 0; i < 6; ++i) {
                        if (pt.indexOf("VTCXYZ".charAt(i)) < 0) continue;
                        ++count;
                    }
                    if (remote.hasRf4ceSupport()) {
                        count += 2;
                    }
                }
            }
            if (remote.usesIcons()) {
                ++count;
            }
            if (remote.usesLedColor()) {
                ++count;
            }
            if (this.remoteConfig.allowHighlighting()) {
                ++count;
            }
        }
        return count;
    }

    public int getEffectiveColumn(int col) {
        if (this.remoteConfig != null) {
            SoftDevices softDevices;
            Remote remote = this.remoteConfig.getRemote();
            DeviceLabels labels = remote.getDeviceLabels();
            if (col > 3) {
                if (remote.isSSD() || !this.remoteConfig.hasSegments()) {
                    col += 9;
                } else if (col > 4) {
                    String pt;
                    if (!remote.hasRf4ceSupport()) {
                        col += 2;
                    }
                    if ((pt = remote.getPunchThru()).indexOf(86) < 0) {
                        ++col;
                    }
                    if (col > 7 && pt.indexOf(84) < 0) {
                        ++col;
                    }
                    if (col > 8 && pt.indexOf(67) < 0) {
                        ++col;
                    }
                    if (col > 9 && pt.indexOf(88) < 0) {
                        ++col;
                    }
                    if (col > 10 && pt.indexOf(89) < 0) {
                        ++col;
                    }
                    if (col > 11 && pt.indexOf(90) < 0) {
                        ++col;
                    }
                }
            }
            if (!remote.isSSD() && col > 12) {
                ++col;
            }
            if (col > 13 && !remote.usesLedColor()) {
                ++col;
            }
            for (int i = 0; i < 3; ++i) {
                col += col >= i + 16 && (labels == null || labels.columnNames[i] == null) ? 1 : 0;
            }
            if (!remote.usesIcons() && col >= 19) {
                ++col;
            }
            if (!((softDevices = remote.getSoftDevices()) != null && softDevices.usesSequence() || col < 20)) {
                ++col;
            }
        } else if (col > 3) {
            col += 11;
        }
        return col;
    }

    public int getExtendedTypeIndex(int row) {
        short[] data = this.getData(row);
        DeviceButton db = (DeviceButton)this.getRow(row);
        if (data == null) {
            return 255;
        }
        Remote remote = this.remoteConfig.getRemote();
        SoftDevices softDevices = remote.getSoftDevices();
        if (softDevices == null || softDevices.isSetupCodesOnly() || db.getDeviceSlot(data) != 65535) {
            return db.getDeviceTypeIndex(data);
        }
        return 255;
    }

    @Override
    public String getColumnName(int col) {
        DeviceLabels labels = this.remoteConfig != null ? this.remoteConfig.getRemote().getDeviceLabels() : null;
        if ((col = this.getEffectiveColumn(col)) >= 16 && col <= 18) {
            return labels.columnNames[col - 16];
        }
        if (col == 4 && this.remoteConfig != null && this.remoteConfig.isReplacement) {
            return "Active?";
        }
        return colNames[col];
    }

    @Override
    public String getColumnPrototypeName(int col) {
        if (((col = this.getEffectiveColumn(col)) == 16 || col == 17 || col == 18) && this.remoteConfig.getRemote().usesEZRC()) {
            return "Long Label___";
        }
        return colPrototypeNames[col];
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return colClasses[this.getEffectiveColumn(col)];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        SoftDevices softDevices = this.remoteConfig.getRemote().getSoftDevices();
        Remote remote = this.remoteConfig.getRemote();
        DeviceButton db = (DeviceButton)this.getRow(row);
        boolean ezrc = remote.usesEZRC();
        col = this.getEffectiveColumn(col);
        return !(!this.editable || col <= 0 || col <= 1 && !ezrc || col >= 2 && col <= 3 && (ezrc || db.isRf()) || col != 2 && col != 13 && this.getExtendedTypeIndex(row) == 255 || col == 3 && (softDevices == null || !softDevices.isSetupCodesOnly()) && this.getValueAt(row, col) == null || col == 14 && !((DeviceButton)this.getRow(row)).isColorEditable() || col == 5 && db.getRfSelectors() == null || col == 6 && (Boolean)this.getValueAt(row, 5) == false);
    }

    @Override
    public boolean isColumnWidthFixed(int col) {
        return (col = this.getEffectiveColumn(col)) < 5;
    }

    public short[] getData(int row) {
        Segment seg;
        short[] data = null;
        data = this.remoteConfig.hasSegments() ? ((seg = ((DeviceButton)this.getRow(row)).getSegment()) != null ? seg.getHex().getData() : null) : this.remoteConfig.getData();
        return data;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Remote remote = this.remoteConfig.getRemote();
        DeviceButton db = (DeviceButton)this.getRow(row);
        int typeIndex = this.getExtendedTypeIndex(row);
        column = this.getEffectiveColumn(column);
        if (typeIndex == 255 && column > 1 && (column < 7 || remote.isSSD())) {
            return null;
        }
        short[] data = this.getData(row);
        int group = db.getDeviceGroup(data);
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return db.getName();
            }
            case 2: {
                return remote.getDeviceTypeByIndexAndGroup(typeIndex, group);
            }
            case 3: {
                if (this.softHT.inUse() && typeIndex == this.softHT.getDeviceType()) {
                    return null;
                }
                short value = db.getSetupCode(data);
                SetupCode sc = value < 0 ? null : new SetupCode(value);
                this.setConvertedUpgrade(db, data, value);
                return sc;
            }
            case 4: {
                if (!this.remoteConfig.isReplacement) {
                    return db.getSetupLock(data);
                }
                Segment internalSegment = this.remoteConfig.getInternalSegment();
                short status = internalSegment.getHex().getData()[2];
                return status == 255;
            }
            case 5: {
                return db.getRfPaired(data);
            }
            case 6: {
                return db.getRfPaired(data) ? this.rfProfiles[db.getRFVendorProfile(data) ? 1 : 0] : null;
            }
            case 7: {
                return db.getVolumePT();
            }
            case 8: {
                return db.getTransportPT();
            }
            case 9: {
                return db.getChannelPT();
            }
            case 10: {
                return db.getxPT();
            }
            case 11: {
                return db.getInputPT();
            }
            case 12: {
                return db.getzPT();
            }
            case 13: {
                return this.lockStates[db.getVpt()];
            }
            case 14: {
                return Math.abs(db.getColorIndex());
            }
            case 15: {
                DeviceUpgrade deviceUpgrade;
                String[] notes = this.remoteConfig.getDeviceButtonNotes();
                String note = null;
                if (notes != null) {
                    note = notes[row];
                }
                if (note == null && (deviceUpgrade = this.remoteConfig.getAssignedDeviceUpgrade(db)) != null) {
                    note = deviceUpgrade.getDescription();
                }
                if (note == null) {
                    return "";
                }
                return note;
            }
            case 16: {
                DeviceLabels labels = remote.getDeviceLabels();
                return labels.getText(data, row);
            }
            case 17: 
            case 18: {
                DeviceLabels labels = remote.getDeviceLabels();
                return labels.getText2(data, column - 15);
            }
            case 19: {
                return db.icon;
            }
            case 20: {
                SoftDevices softDevices = remote.getSoftDevices();
                int seq = softDevices.getSequencePosition(row, this.getRowCount(), data);
                if (seq == -1) {
                    return null;
                }
                return seq + 1;
            }
            case 21: {
                return db.getHighlight();
            }
        }
        return null;
    }

    public int hasInvalidCodes() {
        int result = 0;
        Remote remote = this.remoteConfig.getRemote();
        for (int i = 0; i < this.getRowCount(); ++i) {
            DeviceButton deviceButton = (DeviceButton)this.getRow(i);
            DeviceType deviceType = (DeviceType)this.getValueAt(i, 2);
            SetupCode setupCode = (SetupCode)this.getValueAt(i, 3);
            if (deviceType == null || setupCode == null) continue;
            this.setupCodeRenderer.setDeviceButton(deviceButton);
            this.setupCodeRenderer.setDeviceType(deviceType);
            if (!this.setupCodeRenderer.isValid(setupCode.getValue())) {
                result |= 1;
            }
            if (setupCode.getValue() > SetupCode.getMax()) {
                result |= 2;
            }
            if (!remote.usesEZRC() || deviceButton.isConstructed() || deviceButton.getUpgrade() != null) continue;
            result |= 4;
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        short[] data = this.getData(row);
        Remote remote = this.remoteConfig.getRemote();
        DeviceButton db = (DeviceButton)this.getRow(row);
        SoftDevices softDevices = remote.getSoftDevices();
        DeviceType oldDevType = null;
        SetupCode oldSetupCode = null;
        if ((col = this.getEffectiveColumn(col)) == 2 || col == 3) {
            oldDevType = (DeviceType)this.getValueAt(row, 2);
            oldSetupCode = (SetupCode)this.getValueAt(row, 3);
        }
        if (col == 1) {
            db.setName((String)value);
        } else if (col == 2) {
            DeviceType newDevType = (DeviceType)value;
            if (!this.isValidDevice(row, newDevType, oldSetupCode)) {
                return;
            }
            int newIndex = newDevType.getNumber();
            int newGroup = newDevType.getGroup();
            int oldIndex = this.getExtendedTypeIndex(row);
            int oldGroup = db.getDeviceGroup(data);
            DeviceLabels labels = remote.getDeviceLabels();
            if (oldIndex == newIndex && (oldGroup == -1 || oldGroup == newGroup)) {
                return;
            }
            if (this.remoteConfig.isUpgradeWithKeymoves(row, oldDevType, oldSetupCode, true)) {
                this.preserveKeyMoves(row, oldDevType, oldSetupCode);
            }
            if (this.softHT.inUse() && newIndex == this.softHT.getDeviceType()) {
                db.zeroDeviceSlot(data);
                db.setDeviceTypeIndex((short)newIndex, data);
                db.setSetupCode((short)this.softHT.getDeviceCode(), data);
            } else {
                if (oldIndex == 255) {
                    db.zeroDeviceSlot(data);
                }
                if (this.remoteConfig.hasSegments()) {
                    if (newIndex == 255) {
                        db.setDefaultName();
                    }
                    int fillValue = remote.usesEZRC() && newIndex != 255 ? 0 : 255;
                    Arrays.fill(db.getSegment().getHex().getData(), 9, 12, (short)fillValue);
                }
                db.setDeviceTypeIndex((short)newIndex, data);
                db.setDeviceGroup((short)newGroup, data);
            }
            if (labels != null) {
                if (this.remoteConfig.hasSegments()) {
                    if (newIndex == 255) {
                        Hex hex = new Hex(db.getSegment().getHex(), 0, 12);
                        data = hex.getData();
                        db.getSegment().setHex(hex);
                        remote.getDeviceLabels().setText("", 0, data);
                    }
                } else {
                    String name = newIndex == 255 ? "" : remote.getDeviceTypeByIndex(newIndex).getName();
                    labels.setText(name, row, data);
                    if (labels.usesDefaultLabels()) {
                        labels.setDefaultText(name, row, data);
                    }
                }
            }
            if (softDevices != null && softDevices.usesFilledSlotCount()) {
                softDevices.setFilledSlotCount(this.getDeviceCount(), data);
            }
            if (softDevices != null && softDevices.usesSequence()) {
                this.adjustSequenceRange();
                if (oldIndex == 255) {
                    softDevices.setSequenceIndex(row, this.sequenceBox.getItemCount() - 1, data);
                } else if (newIndex == 255) {
                    softDevices.deleteSequenceIndex(row, this.getRowCount(), data);
                }
            }
            this.fireTableRowsUpdated(row, row);
            if (oldSetupCode != null) {
                this.setConvertedUpgrade(db, data, oldSetupCode.getValue());
            }
            this.setEditButtonState(db);
        } else if (col == 3) {
            SetupCode newSetupCode = null;
            newSetupCode = value.getClass() == String.class ? new SetupCode((String)value, softDevices != null && softDevices.isSetupCodesOnly()) : (SetupCode)value;
            if (oldSetupCode != null) {
                if (newSetupCode.getValue() == oldSetupCode.getValue() || !this.isValidDevice(row, oldDevType, newSetupCode)) {
                    return;
                }
                if (this.remoteConfig.isUpgradeWithKeymoves(row, oldDevType, oldSetupCode, true)) {
                    this.preserveKeyMoves(row, oldDevType, oldSetupCode);
                }
            }
            db.setSetupCode((short)newSetupCode.getValue(), data);
            this.setConvertedUpgrade(db, data, newSetupCode.getValue());
            this.setEditButtonState(db);
        } else if (col == 4) {
            if (!this.remoteConfig.isReplacement) {
                db.setSetupLock((Boolean)value, data);
            } else {
                Segment internalSegment = this.remoteConfig.getInternalSegment();
                boolean active = (Boolean)value;
                internalSegment.getHex().getData()[2] = (short)(active ? 255 : 254);
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
        } else if (col == 5) {
            db.setRfPaired((Boolean)value, data);
        } else if (col == 6) {
            int index = Arrays.asList(this.rfProfiles).indexOf((String)value);
            db.setRfVendorProfile(index == 1, data);
        } else if (col == 7) {
            db.setVolumePT((DeviceButton)value);
        } else if (col == 8) {
            db.setTransportPT((DeviceButton)value);
        } else if (col == 9) {
            db.setChannelPT((DeviceButton)value);
        } else if (col == 10) {
            db.setxPT((DeviceButton)value);
        } else if (col == 11) {
            db.setInputPT((DeviceButton)value);
        } else if (col == 12) {
            db.setzPT((DeviceButton)value);
        } else if (col == 13) {
            int vpt = Arrays.asList(this.lockStates).indexOf((String)value);
            db.setVpt(vpt);
            if (vpt == 2) {
                for (DeviceButton dev : remote.getDeviceButtons()) {
                    if (dev == db || dev.getVpt() != 2) continue;
                    dev.setVpt(1);
                    this.fireTableDataChanged();
                }
            }
        } else if (col == 14) {
            int ndx = db.getColorIndex();
            int val = (Integer)value;
            if (ndx >= 0 && val > 0) {
                ndx = val - 1;
                db.setColorIndex(val);
                int[] params = new int[3];
                for (int i = 0; i < 3; ++i) {
                    params[i] = Remote.colorHex.getData()[3 * ndx + i];
                }
                db.setColorParams(params);
            } else if (ndx < 0) {
                db.setColorIndex(-ndx);
            }
        } else if (col == 15) {
            String strValue = ((String)value).trim();
            if ("".equals(strValue)) {
                strValue = null;
            }
            this.remoteConfig.getDeviceButtonNotes()[row] = strValue;
        } else if (col == 16 || col == 17 || col == 18) {
            String text = (String)value;
            if (this.remoteConfig.hasSegments()) {
                Hex hex = db.getSegment().getHex();
                DeviceLabels lbls = remote.getDeviceLabels();
                String[] texts = new String[3];
                int hexLen = remote.isSSD() ? 15 : 14;
                for (int i = 0; i < 3; ++i) {
                    String s = lbls.getText2(data, i + 1);
                    texts[i] = i == col - 16 ? text : (s == null ? "" : s);
                    hexLen += texts[i].length();
                }
                int lenMod = hexLen & remote.getForceModulus() - 1;
                hex = new Hex(db.getSegment().getHex().subHex(0, 12), 0, hexLen += remote.doForceEvenStarts() && lenMod != 0 ? remote.getForceModulus() - lenMod : 0);
                data = hex.getData();
                data[hexLen - 1] = 0;
                for (int i = 0; i < 3; ++i) {
                    lbls.setText2(texts[i], data, i + 1);
                }
                db.getSegment().setHex(hex);
            } else {
                remote.getDeviceLabels().setText(text, row, data);
            }
        } else if (col == 19) {
            db.icon = (GeneralFunction.RMIcon)value;
        } else if (col == 20) {
            int oldSeq;
            int rows = this.getRowCount();
            int newSeq = (Integer)value - 1;
            if (newSeq == (oldSeq = softDevices.getSequencePosition(row, rows, data))) {
                return;
            }
            softDevices.deleteSequenceIndex(row, rows, data);
            softDevices.insertSequenceIndex(row, newSeq, rows, data);
            this.fireTableDataChanged();
        } else if (col == 21) {
            db.setHighlight((Color)value);
        }
        this.propertyChangeSupport.firePropertyChange(col == 19 ? "highlight" : "value", null, null);
    }

    public boolean isValidDevice(int row, DeviceType devType, SetupCode setupCode) {
        DeviceButton db = (DeviceButton)this.getRow(row);
        RemoteConfiguration.ShareType share = this.remoteConfig.shareType(db, devType, setupCode);
        this.setupCodeRenderer.setDeviceButton(db);
        this.setupCodeRenderer.setDeviceType(devType);
        if (setupCode == null || !this.setupCodeRenderer.isValid(setupCode.getValue())) {
            return true;
        }
        if (share == RemoteConfiguration.ShareType.UNSHARED) {
            return true;
        }
        List<DeviceButton> devBtns = Arrays.asList(this.remoteConfig.getRemote().getDeviceButtons());
        int index = devBtns.indexOf(db);
        DeviceButton sharedDB = devBtns.get(index - 8);
        if (share == RemoteConfiguration.ShareType.SHARED) {
            String message = "Device " + devType.getName() + " " + setupCode.getValue() + " cannot be assigned to button " + db.getName() + "\nas it is an upgrade with key moves that would appear\nalso on device button " + sharedDB.getName() + ".";
            String title = "Device Button Assignment";
            JOptionPane.showMessageDialog(null, message, title, 0);
            return false;
        }
        if (share == RemoteConfiguration.ShareType.SHAREABLE) {
            String message = "Please be aware that device " + devType.getName() + " " + setupCode.getValue() + " on button " + db.getName() + "\nwill share key moves with the device on button " + sharedDB.getName() + ", which\nwill override the functions assigned by this device to the\nbuttons concerned.";
            String title = "Device Button Assignment";
            JOptionPane.showMessageDialog(null, message, title, 2);
            return true;
        }
        return true;
    }

    private void preserveKeyMoves(int devButtonIndex, DeviceType devType, SetupCode setupCode) {
        if (devType == null || setupCode == null) {
            return;
        }
        DeviceUpgrade du = this.remoteConfig.findDeviceUpgrade(devType.getNumber(), setupCode.getValue());
        if (du == null) {
            return;
        }
        for (KeyMove keyMove : du.getKeyMoves(devButtonIndex)) {
            DeviceButton db = this.remoteConfig.getRemote().getDeviceButtons()[devButtonIndex];
            keyMove.setDeviceButtonIndex(db.getButtonIndex());
            this.remoteConfig.getKeyMoves().add(keyMove);
        }
    }

    @Override
    public TableCellRenderer getColumnRenderer(int col) {
        Remote remote;
        col = this.getEffectiveColumn(col);
        Remote remote2 = remote = this.remoteConfig == null ? null : this.remoteConfig.getRemote();
        if (col == 0) {
            return new RowNumberRenderer();
        }
        if (col == 1) {
            return remote != null && remote.usesEZRC() ? this.nameRenderer : null;
        }
        if (col == 3) {
            return this.setupCodeRenderer;
        }
        if (col == 19) {
            return this.iconRenderer;
        }
        if (col == 21 || col == 14) {
            return this.colorRenderer;
        }
        return null;
    }

    @Override
    public TableCellEditor getColumnEditor(int col) {
        if (!this.editable) {
            return null;
        }
        switch (this.getEffectiveColumn(col)) {
            case 2: {
                return this.deviceTypeEditor;
            }
            case 3: {
                return this.setupCodeEditor;
            }
            case 6: {
                return this.rfProfileEditor;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return this.punchThroughEditor;
            }
            case 13: {
                return this.deviceLockEditor;
            }
            case 14: {
                return this.spinnerEditor;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return this.selectAllEditor;
            }
            case 19: {
                return this.iconEditor;
            }
            case 20: {
                return this.sequenceEditor;
            }
            case 21: {
                return this.colorEditor;
            }
        }
        return null;
    }

    @Override
    public String getToolTipText(int row, int col) {
        int thisCell = row + (col = this.getEffectiveColumn(col)) * 256;
        if (thisCell == this.lastCell) {
            return null;
        }
        this.lastCell = thisCell;
        if (col == 17) {
            return JTableX.getHtmlToolTip("Double click this column to open Icon Editor to set or<br>remove a system icon from this device.");
        }
        return null;
    }

    private class DeviceNameRenderer
    extends DefaultTableCellRenderer {
        DeviceType deviceType = null;

        private DeviceNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, false, row, col);
            this.deviceType = (DeviceType)DeviceButtonTableModel.this.getValueAt(row, 2);
            DeviceButton db = (DeviceButton)DeviceButtonTableModel.this.getRow(row);
            c.setForeground(this.getTextColor(db, isSelected));
            return c;
        }

        public Color getTextColor(DeviceButton db, boolean isSelected) {
            if (this.deviceType == null || db.isConstructed() || db.getUpgrade() != null) {
                return isSelected ? Color.WHITE : Color.BLACK;
            }
            return isSelected ? Color.YELLOW : Color.RED;
        }
    }
}

