/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Choice;
import com.hifiremote.jp1.CombinerDevice;
import com.hifiremote.jp1.CombinerDeviceDialog;
import com.hifiremote.jp1.DeviceCombiner;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionImportDialog;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.TextPopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class DeviceCombinerPanel
extends KMPanel
implements ListSelectionListener {
    private static String[] titles = new String[]{"#", "Protocol", "PID", "Fixed Data", "Notes"};
    private static Class<?>[] classes = new Class[]{Integer.class, String.class, Hex.class, Hex.class, String.class};
    private AbstractTableModel model = null;
    private JTableX table = null;
    private JButton addButton = null;
    private JButton importButton = null;
    private JButton editButton = null;
    private JButton removeButton = null;

    public DeviceCombinerPanel(DeviceUpgrade devUpgrade) {
        super("Device Combiner", devUpgrade);
        this.setToolTipText("Combine multiple devices into a single upgrade");
        this.setLayout(new BorderLayout());
        System.err.println("DeviceCombinerPanel ctor: deviceCount = " + ((DeviceCombiner)this.deviceUpgrade.getProtocol()).getDevices().size());
        this.model = new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return titles[col];
            }

            @Override
            public Class<?> getColumnClass(int col) {
                return classes[col];
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 4;
            }

            @Override
            public int getColumnCount() {
                return titles.length;
            }

            @Override
            public int getRowCount() {
                DeviceCombiner deviceCombiner = (DeviceCombiner)DeviceCombinerPanel.this.deviceUpgrade.getProtocol();
                int rows = deviceCombiner.getDevices().size();
                System.err.println("DeviceCombinerPanel.TableModel.getRowCount: rows=" + rows);
                return rows;
            }

            @Override
            public Object getValueAt(int row, int col) {
                DeviceCombiner deviceCombiner = (DeviceCombiner)DeviceCombinerPanel.this.deviceUpgrade.getProtocol();
                CombinerDevice device = deviceCombiner.getDevices().get(row);
                if (device == null) {
                    return null;
                }
                if (device.getProtocol() == null) {
                    return null;
                }
                if (col == 0) {
                    return new Integer(row + 1);
                }
                if (col == 1) {
                    return device.getProtocol().getName();
                }
                if (col == 2) {
                    return device.getProtocol().getID(DeviceCombinerPanel.this.deviceUpgrade.getRemote());
                }
                if (col == 3) {
                    return device.getFixedData();
                }
                if (col == 4) {
                    return device.getNotes();
                }
                return null;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
                if (col == 4) {
                    DeviceCombiner deviceCombiner = (DeviceCombiner)DeviceCombinerPanel.this.deviceUpgrade.getProtocol();
                    CombinerDevice device = deviceCombiner.getDevices().get(row);
                    device.setNotes((String)value);
                }
            }
        };
        this.table = new JTableX(this.model);
        this.table.getSelectionModel().addListSelectionListener(this);
        DefaultCellEditor e = (DefaultCellEditor)this.table.getDefaultEditor(String.class);
        new TextPopupMenu((JTextComponent)e.getComponent());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() < 2) {
                    e.consume();
                } else {
                    DeviceCombinerPanel.this.editDevice();
                }
            }
        });
        this.add((Component)new JScrollPane(this.table), "Center");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == DeviceCombinerPanel.this.addButton) {
                    CombinerDeviceDialog d = new CombinerDeviceDialog(RemoteMaster.getFrame(), null, DeviceCombinerPanel.this.deviceUpgrade.getRemote());
                    d.setVisible(true);
                    if (d.getUserAction() == 0) {
                        DeviceCombiner combiner = (DeviceCombiner)DeviceCombinerPanel.this.deviceUpgrade.getProtocol();
                        List<CombinerDevice> devices = combiner.getDevices();
                        int newRow = devices.size();
                        CombinerDevice device = d.getCombinerDevice();
                        devices.add(device);
                        DeviceCombinerPanel.this.model.fireTableRowsInserted(newRow, newRow);
                    }
                } else if (source == DeviceCombinerPanel.this.importButton) {
                    File file = KeyMapMaster.promptForUpgradeFile(null);
                    if (file == null) {
                        return;
                    }
                    DeviceUpgrade importedUpgrade = new DeviceUpgrade();
                    try {
                        importedUpgrade.load(file, false);
                        Remote remote = DeviceCombinerPanel.this.deviceUpgrade.getRemote();
                        importedUpgrade.setRemote(remote);
                        Protocol importedProtocol = importedUpgrade.getProtocol();
                        if (!remote.getProcessor().getName().equals("S3C80") && remote.supportsVariant(importedProtocol.getID(), importedProtocol.getVariantName())) {
                            JOptionPane.showMessageDialog(null, "Device Combiner can only combine protocol that are built into the remote. The device upgrade you tried to import uses the '" + importedProtocol.getName() + "' protocol, which is not built into the " + remote.getName() + " remote.", "Incompatible Upgrade", 0);
                            return;
                        }
                        if (importedProtocol.getDefaultCmdLength() > 1) {
                            JOptionPane.showMessageDialog(null, "Device Combiner can only combine protocol that use 1-byte commands.  The device upgrade you tried to import uses the '" + importedProtocol.getName() + "' protocol, which uses " + importedProtocol.getDefaultCmdLength() + "-byte commands.", "Incompatible Upgrade", 0);
                            return;
                        }
                        FunctionImportDialog d = new FunctionImportDialog(null, importedUpgrade);
                        d.setVisible(true);
                        if (d.getUserAction() == 0) {
                            CombinerDevice device = new CombinerDevice(importedProtocol, importedUpgrade.getParmValues());
                            DeviceCombiner combiner = (DeviceCombiner)DeviceCombinerPanel.this.deviceUpgrade.getProtocol();
                            List<CombinerDevice> devices = combiner.getDevices();
                            int index = devices.size();
                            Integer indexInt = new Integer(index);
                            devices.add(device);
                            List<Function> importedFunctions = d.getSelectedFunctions();
                            if (importedFunctions.size() > 0) {
                                List<Function> functions = DeviceCombinerPanel.this.deviceUpgrade.getFunctions();
                                for (Function f : importedFunctions) {
                                    Function newF = new Function();
                                    Hex hex = combiner.getDefaultCmd();
                                    combiner.setValueAt(0, hex, indexInt);
                                    short efc = (short)(EFC.parseHex(f.getHex(), importedProtocol.getCmdIndex()) & 0xFF);
                                    EFC.toHex(efc, hex, combiner.getCmdIndex());
                                    newF.setHex(hex);
                                    newF.setName(f.getName());
                                    newF.setNotes(f.getNotes());
                                    functions.add(newF);
                                }
                            }
                            DeviceCombinerPanel.this.model.fireTableRowsInserted(index, index);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                        JOptionPane.showMessageDialog(null, "An error occurred loading the device upgrade from " + file.getName() + ".  Please see rmaster.err for more details.", "Device Upgrade Load Error", 0);
                    }
                } else if (source == DeviceCombinerPanel.this.editButton) {
                    DeviceCombinerPanel.this.editDevice();
                } else if (source == DeviceCombinerPanel.this.removeButton) {
                    int row = DeviceCombinerPanel.this.table.getSelectedRow();
                    DeviceCombiner combiner = (DeviceCombiner)DeviceCombinerPanel.this.deviceUpgrade.getProtocol();
                    List<CombinerDevice> devices = combiner.getDevices();
                    List<Function> functions = DeviceCombinerPanel.this.deviceUpgrade.getFunctions();
                    for (Function f : functions) {
                        int i;
                        Hex hex = f.getHex();
                        if (hex == null || (i = ((Choice)combiner.getValueAt(0, hex)).getIndex()) <= row) continue;
                        if (--i < 0) {
                            i = 0;
                        }
                        combiner.setValueAt(0, hex, new Integer(i));
                    }
                    devices.remove(row);
                    DeviceCombinerPanel.this.model.fireTableRowsDeleted(row, row);
                }
                DeviceCombinerPanel.this.update();
            }
        };
        JPanel panel = new JPanel();
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(al);
        panel.add(this.addButton);
        this.importButton = new JButton("Import");
        this.importButton.addActionListener(al);
        panel.add(this.importButton);
        this.editButton = new JButton("Edit");
        this.editButton.addActionListener(al);
        panel.add(this.editButton);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(al);
        panel.add(this.removeButton);
        this.add((Component)panel, "South");
        this.initColumns(this.table);
    }

    private void editDevice() {
        DeviceCombiner combiner = (DeviceCombiner)this.deviceUpgrade.getProtocol();
        List<CombinerDevice> devices = combiner.getDevices();
        int row = this.table.getSelectedRow();
        CombinerDevice device = devices.get(row);
        CombinerDeviceDialog d = new CombinerDeviceDialog(RemoteMaster.getFrame(), device, this.deviceUpgrade.getRemote());
        d.setVisible(true);
        if (d.getUserAction() == 0) {
            devices.set(row, d.getCombinerDevice());
            this.model.fireTableRowsUpdated(row, row);
        }
    }

    protected void setColumnWidth(JTable table, int col, String text) {
        JLabel l = (JLabel)table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, text, false, false, 0, col);
        int width = l.getPreferredSize().width + 2;
        TableColumn column = table.getColumnModel().getColumn(col);
        column.setMinWidth(width / 2);
        column.setPreferredWidth(width);
        column.setMaxWidth(width * 3 / 2);
    }

    protected void initColumns(JTable table) {
        this.setColumnWidth(table, 0, "16");
        this.setColumnWidth(table, 2, "FF FF");
        table.doLayout();
    }

    @Override
    public void update() {
        DeviceCombiner combiner = (DeviceCombiner)this.deviceUpgrade.getProtocol();
        boolean flag = combiner.getDevices().size() < 16;
        this.addButton.setEnabled(flag);
        this.importButton.setEnabled(flag);
        int row = this.table.getSelectedRow();
        flag = row != -1;
        this.editButton.setEnabled(flag);
        if (flag) {
            for (Function f : this.deviceUpgrade.getFunctions()) {
                if (f.getHex() == null) continue;
                int temp = 0;
                Object val = combiner.getValueAt(0, f.getHex());
                if (val instanceof Choice) {
                    temp = ((Choice)val).getIndex();
                } else if (val instanceof Number) {
                    temp = ((Number)val).intValue();
                }
                if (temp != row) continue;
                flag = false;
                break;
            }
        }
        this.removeButton.setEnabled(flag);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int row = this.table.getSelectedRow();
            boolean flag = row != -1;
            this.editButton.setEnabled(flag);
            if (flag) {
                DeviceCombiner combiner = (DeviceCombiner)this.deviceUpgrade.getProtocol();
                List<Function> functions = this.deviceUpgrade.getFunctions();
                for (Function f : functions) {
                    if (f.getHex() == null) continue;
                    Object value = combiner.getValueAt(0, f.getHex());
                    int temp = 0;
                    temp = value instanceof Choice ? ((Choice)value).getIndex() : ((Integer)value).intValue();
                    if (temp != row) continue;
                    flag = false;
                    break;
                }
            }
            this.removeButton.setEnabled(flag);
        }
    }
}

