/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.ButtonPanel;
import com.hifiremote.jp1.CodeSelectorDialog;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.ExternalFunctionPanel;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.FunctionPanel;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.KMPanel;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.KeyMapPanel;
import com.hifiremote.jp1.LayoutPanel;
import com.hifiremote.jp1.OutputPanel;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RFVendorPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.SetupCodeFilter;
import com.hifiremote.jp1.SetupPanel;
import com.hifiremote.jp1.TextPopupMenu;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.SwingPropertyChangeSupport;

public class DeviceEditorPanel
extends JPanel
implements ActionListener,
ChangeListener,
DocumentListener,
PropertyChangeListener {
    private JFrame owner = null;
    private JTextField description = null;
    private JButton importBtn = null;
    private CodeSelectorDialog selector = null;
    private DefaultListCellRenderer remoteRenderer = null;
    private JComboBox<Remote> remoteList = null;
    private ArrayList<Remote> remotesArray = null;
    private RemoteManager mgr = null;
    private JComboBox deviceTypeList = null;
    private JComboBox<String> sortOrderList = null;
    protected JTabbedPane tabbedPane = null;
    private SetupPanel setupPanel = null;
    private FunctionPanel functionPanel = null;
    private ExternalFunctionPanel externalFunctionPanel = null;
    private ButtonPanel buttonPanel = null;
    private LayoutPanel layoutPanel = null;
    private OutputPanel outputPanel = null;
    private KeyMapPanel keyMapPanel = null;
    private RFVendorPanel vendorPanel = null;
    private DeviceUpgrade deviceUpgrade = null;
    private List<String> remoteExtract = null;
    private SwingPropertyChangeSupport propertyChangeSupport = null;
    public static final int ACTION_EXIT = 1;
    public static final int ACTION_LOAD = 2;
    private KMPanel currPanel = null;
    private Remote oldRemote = null;
    private Protocol oldProtocol = null;

    public DeviceEditorPanel(JFrame owner, DeviceUpgrade upgrade, Collection<Remote> remotes) {
        super(new BorderLayout());
        this.owner = owner;
        this.mgr = RemoteManager.getRemoteManager();
        this.remotesArray = new ArrayList<Remote>(remotes);
        this.propertyChangeSupport = new SwingPropertyChangeSupport(this);
        this.deviceUpgrade = upgrade;
        upgrade.addPropertyChangeListener("protocol", this);
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        double b = 10.0;
        double i = 5.0;
        double f = -1.0;
        double p = -2.0;
        double[][] size = new double[][]{{b, p, b, f, b, p, b, p, b, p, b, p, b}, {b, p, i, p, b}};
        TableLayout tl = new TableLayout(size);
        JPanel panel = new JPanel(tl);
        JLabel label = new JLabel("Remote:");
        panel.add((Component)label, "1, 1");
        this.remoteList = this.mgr.getRemotesBox(null, 0);
        label.setLabelFor(this.remoteList);
        this.remoteList.setMaximumRowCount(16);
        this.remoteList.setToolTipText("Choose the remote for the upgrade being created.");
        panel.add(this.remoteList, "3, 1");
        label = new JLabel("Sort by:");
        panel.add((Component)label, "5, 1");
        this.sortOrderList = new JComboBox<String>(new String[]{"Name", "Signature"});
        label.setLabelFor(this.sortOrderList);
        this.sortOrderList.setPrototypeDisplayValue("A Sort Order XXX");
        this.sortOrderList.setToolTipText("Choose the sort order for the list of remotes.");
        this.sortOrderList.addActionListener(this);
        panel.add(this.sortOrderList, "7, 1");
        label = new JLabel("Device Type:");
        panel.add((Component)label, "9, 1");
        this.deviceTypeList = new JComboBox();
        label.setLabelFor(this.deviceTypeList);
        this.deviceTypeList.setPrototypeDisplayValue("A Device Type");
        this.deviceTypeList.setToolTipText("Choose the device type for the upgrade being created.");
        panel.add((Component)this.deviceTypeList, "11, 1");
        label = new JLabel("Description:");
        panel.add((Component)label, "1, 3");
        this.description = new JTextField(50);
        this.description.setToolTipText("Enter a short description for the upgrade being created.");
        label.setLabelFor(this.description);
        this.description.getDocument().addDocumentListener(this);
        new TextPopupMenu(this.description);
        this.importBtn = new JButton("Import built-in setup");
        if (owner instanceof KeyMapMaster) {
            this.importBtn.setVisible(true);
            panel.add((Component)this.importBtn, "11, 3");
            panel.add((Component)this.description, "3, 3, 9, 3");
        } else {
            this.importBtn.setVisible(false);
            panel.add((Component)this.description, "3, 3, 11, 3");
        }
        this.add((Component)panel, "North");
        this.setupPanel = new SetupPanel(this, this.deviceUpgrade);
        this.setupPanel.setToolTipText("Enter general information about the upgrade.");
        this.currPanel = this.setupPanel;
        this.addPanel(this.setupPanel);
        this.functionPanel = new FunctionPanel(this.deviceUpgrade);
        this.functionPanel.setToolTipText("Define function names and parameters.");
        this.vendorPanel = new RFVendorPanel(this.deviceUpgrade);
        this.vendorPanel.setToolTipText("Show/edit RF Vendor data");
        if (this.deviceUpgrade.getProtocol() != null) {
            this.addPanel(this.functionPanel);
            if (this.deviceUpgrade.isRfUpgrade()) {
                this.addPanel(this.vendorPanel);
            }
        }
        this.externalFunctionPanel = new ExternalFunctionPanel(this.deviceUpgrade);
        this.externalFunctionPanel.setToolTipText("Define functions from other device codes.");
        this.addPanel(this.externalFunctionPanel);
        this.buttonPanel = new ButtonPanel(this.deviceUpgrade);
        this.buttonPanel.setToolTipText("Assign functions to buttons.");
        this.addPanel(this.buttonPanel);
        this.layoutPanel = new LayoutPanel(this.deviceUpgrade);
        this.layoutPanel.setToolTipText("Button Layout information.");
        this.addPanel(this.layoutPanel);
        this.keyMapPanel = new KeyMapPanel(this.deviceUpgrade);
        this.keyMapPanel.setToolTipText("Printable list of buttons and their assigned functions");
        this.addPanel(this.keyMapPanel);
        this.outputPanel = new OutputPanel(this.deviceUpgrade);
        this.outputPanel.setToolTipText("The output to copy-n-paste into IR.");
        this.addPanel(this.outputPanel);
        this.setRemote(this.deviceUpgrade.getRemote());
        this.remoteList.addActionListener(this);
        this.deviceTypeList.addActionListener(this);
        this.tabbedPane.addChangeListener(this);
        this.refresh();
    }

    public JComboBox getDeviceTypeList() {
        return this.deviceTypeList;
    }

    public void setAltPIDReason() {
        this.setupPanel.setAltPIDReason();
    }

    public void setRemotes(Collection<Remote> remotes) {
        Remote r = (Remote)this.remoteList.getSelectedItem();
        Remote[] array = remotes.toArray(new Remote[remotes.size()]);
        this.remoteList.removeActionListener(this);
        this.remoteList.setModel(new DefaultComboBoxModel<Remote>(array));
        if (r != null) {
            this.remoteList.setSelectedItem(r);
        } else {
            this.remoteList.setSelectedIndex(0);
        }
        this.remoteList.addActionListener(this);
    }

    public void addPanel(KMPanel panel) {
        this.tabbedPane.addTab(panel.getName(), null, panel, panel.getToolTipText());
    }

    public void addPanel(KMPanel panel, int index) {
        System.err.println("KeyMapMaster.addPanel()" + panel);
        this.tabbedPane.insertTab(panel.getName(), null, panel, panel.getToolTipText(), index);
    }

    public void removePanel(KMPanel panel) {
        System.err.println("KeyMapMaster.removePanel()" + panel);
        this.tabbedPane.remove(panel);
        this.tabbedPane.validate();
    }

    public void addPropertyChangeListener(PropertyChangeListener l, String propertyName) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, l);
    }

    public void setRemote(Remote remote) {
        if (this.remoteList != null) {
            try {
                Object[] aliasNames = remote.getDeviceTypeAliasNames();
                String alias = this.deviceUpgrade.getDeviceTypeAliasName();
                this.deviceTypeList.removeActionListener(this);
                this.deviceTypeList.setModel(new DefaultComboBoxModel<String>(aliasNames));
                this.deviceTypeList.setMaximumRowCount(aliasNames.length);
                int index = 0;
                for (index = 0; index < aliasNames.length && !aliasNames[index].equals(alias); ++index) {
                }
                while (index == aliasNames.length) {
                    String msg = "Remote \"" + remote.getName() + "\" does not support the device type " + alias + ".  Please select one of the supported device types below to use instead.\n";
                    String rc = (String)JOptionPane.showInputDialog(null, msg, "Unsupported Device Type", 0, null, aliasNames, null);
                    for (index = 0; index < aliasNames.length && !((String)aliasNames[index]).equals(rc); ++index) {
                    }
                }
                this.deviceTypeList.setSelectedIndex(index);
                this.deviceUpgrade.setRemote(remote);
                this.deviceUpgrade.setDeviceTypeAliasName(aliasNames[index]);
                this.deviceTypeList.addActionListener(this);
                this.deviceUpgrade.checkSize();
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.flush();
                pw.close();
                JOptionPane.showMessageDialog(null, sw.toString(), "Remote Load Error", 0);
                System.err.println(sw.toString());
            }
        }
    }

    public void setDeviceTypeName(String aliasName) {
        if (this.deviceTypeList != null && !aliasName.equals(this.deviceUpgrade.getDeviceTypeAliasName())) {
            this.deviceUpgrade.setDeviceTypeAliasName(aliasName);
            this.deviceTypeList.setSelectedItem(aliasName);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            SetupCodeFilter.setSkipCheck(true);
            Remote remote = (Remote)this.remoteList.getSelectedItem();
            Object source = e.getSource();
            if (source == this.remoteList) {
                Remote oldRemote = this.deviceUpgrade.getRemote();
                this.setRemote(remote);
                this.currPanel.update();
                this.validateUpgrade();
                this.propertyChangeSupport.firePropertyChange("remote", oldRemote, remote);
                this.refresh();
            } else if (source == this.deviceTypeList) {
                String typeName = (String)this.deviceTypeList.getSelectedItem();
                this.setDeviceTypeName(typeName);
                this.currPanel.update();
            } else if (source == this.sortOrderList) {
                Remote rr = (Remote)this.remoteList.getSelectedItem();
                JComboBox<Remote> box = this.mgr.getRemotesBox(null, this.sortOrderList.getSelectedIndex());
                this.remoteList.setModel(box.getModel());
                this.remoteList.setRenderer(box.getRenderer());
                this.remoteList.setSelectedItem(rr);
            } else if (source == this.importBtn) {
                remote.load();
                this.deviceUpgrade.reset();
                this.deviceUpgrade.setRemote(remote);
                remote.setExtract();
                if (remote.getSetupCodes().isEmpty()) {
                    remote.setExtractData();
                } else {
                    remote.setExtractSetupCodes(null);
                }
                if (this.owner instanceof KeyMapMaster) {
                    this.selector = CodeSelectorDialog.showDialog((KeyMapMaster)this.owner, true);
                } else if (this.owner instanceof DeviceUpgradeEditor) {
                    this.selector = CodeSelectorDialog.showDialog(((DeviceUpgradeEditor)this.owner).getOwner(), true);
                }
                this.selector.setImporting(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        SetupCodeFilter.setSkipCheck(false);
    }

    private void removeListeners() {
        this.description.getDocument().removeDocumentListener(this);
        this.remoteList.removeActionListener(this);
        this.deviceTypeList.removeActionListener(this);
        this.importBtn.removeActionListener(this);
    }

    private void addListeners() {
        this.description.getDocument().addDocumentListener(this);
        this.remoteList.addActionListener(this);
        this.deviceTypeList.addActionListener(this);
        this.importBtn.addActionListener(this);
    }

    public void refresh() {
        this.removeListeners();
        this.description.setText(this.deviceUpgrade.getDescription());
        String savedTypeName = this.deviceUpgrade.getDeviceTypeAliasName();
        Remote r = this.deviceUpgrade.getRemote();
        this.remoteList.setSelectedItem(r);
        if (this.remoteList.getSelectedItem() != r) {
            this.remoteList.addItem(r);
            this.remoteList.setSelectedItem(r);
        }
        r.setExtract();
        this.remoteExtract = r.getExtract();
        if (this.owner instanceof KeyMapMaster) {
            this.importBtn.setVisible(true);
            this.importBtn.setEnabled(this.remoteExtract != null && !r.usesEZRC());
        }
        this.deviceTypeList.setSelectedItem(savedTypeName);
        this.addListeners();
        Protocol p = this.deviceUpgrade.getProtocol();
        this.resetTabPanels(p);
        this.currPanel.update();
        this.validateUpgrade();
    }

    public void commit() {
        this.currPanel.commit();
    }

    public KMPanel getCurrPanel() {
        return this.currPanel;
    }

    public JComboBox<Remote> getRemoteList() {
        return this.remoteList;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JP1Frame.clearMessage(this.currPanel);
        this.currPanel.commit();
        this.currPanel = (KMPanel)((JTabbedPane)e.getSource()).getSelectedComponent();
        this.currPanel.update();
        this.validateUpgrade();
    }

    public void validateUpgrade() {
        Remote r = this.deviceUpgrade.getRemote();
        Protocol p = this.deviceUpgrade.getProtocol();
        if (p == null || this.oldRemote == r && this.oldProtocol == p) {
            return;
        }
        this.oldRemote = r;
        this.oldProtocol = p;
        List<Protocol> protocols = ProtocolManager.getProtocolManager().getProtocolsForRemote(r);
        if (!protocols.contains(p) && !p.hasCode(r)) {
            System.err.println("DeviceEditorPanel.validateUpgrade(), protocol " + p.getDiagnosticName() + "is not compatible with remote " + r.getName());
            Protocol match = null;
            String name = p.getName();
            for (Protocol p2 : protocols) {
                if (!p2.getName().equals(name)) continue;
                match = p2;
                System.err.println("\tFound one with the same name: " + p2.getDiagnosticName());
                break;
            }
            if (match != null) {
                this.deviceUpgrade.setProtocol(match);
            } else {
                JOptionPane.showMessageDialog(this, "The selected protocol " + p.getDiagnosticName() + "\nis not compatible with the selected remote.\nThis upgrade will NOT function correctly.\nPlease choose a different protocol.", "Error", 0);
            }
        }
        if (r.usesEZRC()) {
            LinkedHashMap<Integer, Function> keyGidMap = this.deviceUpgrade.getKeyGidMap();
            for (Function f : this.deviceUpgrade.getFunctions()) {
                if (f.getGid() != null) {
                    Function ff = keyGidMap.get(f.getGid());
                    if (f.getGid() == 0 || ff != null && (f.getHex() != null || ff.getHex() != null) && !f.getHex().equals(ff.getHex())) {
                        int newGID = this.deviceUpgrade.getGidForName(f.getName());
                        f.setGid(newGID);
                        continue;
                    }
                    keyGidMap.put(f.getGid(), f);
                    continue;
                }
                f.setGid(this.deviceUpgrade.getGidForName(f.getName()));
            }
        }
    }

    private void updateDescription() {
        this.deviceUpgrade.setDescription(this.description.getText());
        this.currPanel.update();
    }

    public DeviceUpgrade getDeviceUpgrade() {
        return this.deviceUpgrade;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateDescription();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateDescription();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateDescription();
    }

    private int getTabIndex(Component c) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (!this.tabbedPane.getComponentAt(i).equals(c)) continue;
            return i;
        }
        return -1;
    }

    private int checkTabbedPane(String name, Component c, boolean test, int index) {
        if (c == null) {
            return index;
        }
        int tabIndex = this.getTabIndex(c);
        if (test) {
            if (tabIndex < 0) {
                this.tabbedPane.insertTab(name, null, c, null, index);
            }
            ++index;
        } else if (tabIndex > 0) {
            this.tabbedPane.remove(index);
        }
        return index;
    }

    private void resetTabPanels(Protocol p) {
        int index = 1;
        if (p != null) {
            index = this.checkTabbedPane("Device Combiner", p.getPanel(this.deviceUpgrade), true, index);
            index = this.checkTabbedPane("Functions", this.functionPanel, p != null, index);
            index = this.checkTabbedPane("RF Vendor Data", this.vendorPanel, DeviceUpgrade.isRfPid(p.getID()), index);
        }
        index = this.checkTabbedPane("External Functions", this.externalFunctionPanel, this.deviceUpgrade.getRemote().hasKeyMoveSupport(), index);
        index = this.checkTabbedPane("Buttons", this.buttonPanel, true, index);
        index = this.checkTabbedPane("Layout", this.layoutPanel, true, index);
        index = this.checkTabbedPane("Key Map", this.keyMapPanel, true, index);
        index = this.checkTabbedPane("Output", this.outputPanel, true, index);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        KMPanel panel;
        Protocol protocol = (Protocol)evt.getOldValue();
        String name = protocol == null ? "NULL" : protocol.getDiagnosticName();
        System.err.print("DeviceEditorPanel.propertyChange( " + name + ", ");
        KMPanel kMPanel = panel = protocol == null ? null : protocol.getPanel(this.deviceUpgrade);
        if (panel != null) {
            this.removePanel(panel);
        }
        name = (protocol = (Protocol)evt.getNewValue()) == null ? "NULL" : protocol.getDiagnosticName();
        System.err.println(name);
        this.resetTabPanels(protocol);
    }

    public void setShowRemoteSignature(boolean showRemoteSignature) {
        this.remoteList.setVisible(false);
        this.remoteList.setVisible(true);
    }

    public void releasePanels() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            KMPanel panel = (KMPanel)this.tabbedPane.getComponentAt(i);
            panel.release();
        }
    }

    public JFrame getOwner() {
        return this.owner;
    }

    public SetupPanel getSetupPanel() {
        return this.setupPanel;
    }
}

