/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ParameterTokenizer;
import com.hifiremote.jp1.RDFParameter;
import com.hifiremote.jp1.RDFReader;
import com.hifiremote.jp1.Remote;
import java.util.List;
import javax.swing.JOptionPane;

public class DeviceLabels
extends RDFParameter {
    private int addr = 0;
    private int length = 0;
    private short fill = (short)32;
    private int defaultsAddr = 0;
    public String[] columnNames = new String[]{"Label", null, null};

    @Override
    public void parse(String text, Remote remote) throws Exception {
        String token;
        List<String> settings = ParameterTokenizer.getTokens(text);
        this.addr = RDFReader.parseNumber(settings.get(0));
        this.length = RDFReader.parseNumber(settings.get(1));
        if (settings.size() > 2 && (token = settings.get(2)) != null) {
            this.fill = (short)(RDFReader.parseNumber(token) & 0xFF);
        }
        if (settings.size() > 3 && (token = settings.get(3)) != null) {
            this.defaultsAddr = RDFReader.parseNumber(token);
        }
        if (settings.size() > 4) {
            int j = 0;
            this.columnNames[0] = null;
            for (int i = 4; i < Math.min(settings.size(), 7); ++i) {
                String token2 = settings.get(i);
                if (token2 == null) continue;
                this.columnNames[j++] = token2;
            }
        }
    }

    public int getAddr() {
        return this.addr;
    }

    public int getLength() {
        return this.length;
    }

    public short getFill() {
        return this.fill;
    }

    public int getDefaultsAddr() {
        return this.defaultsAddr;
    }

    public boolean usesDefaultLabels() {
        return this.defaultsAddr != 0;
    }

    public String getDefaultText(short[] data, int index) {
        int pos;
        if (this.defaultsAddr == 0) {
            return "";
        }
        int offset = this.defaultsAddr + this.length * index;
        char[] text = new char[this.length];
        for (int i = 0; i < this.length; ++i) {
            text[i] = (char)data[offset + i];
        }
        for (pos = this.length; pos > 0 && text[pos - 1] == this.fill; --pos) {
        }
        return new String(text, 0, pos);
    }

    public void setDefaultText(String text, int index, short[] data) {
        int i;
        if (this.defaultsAddr == 0) {
            return;
        }
        if (text == null) {
            text = "";
        }
        text = text.trim();
        int offset = this.defaultsAddr + this.length * index;
        int len = Math.min(this.length, text.length());
        for (i = 0; i < len; ++i) {
            data[offset + i] = (short)text.charAt(i);
        }
        while (i < this.length) {
            data[offset + i] = this.fill;
            ++i;
        }
    }

    public String getText(short[] data, int index) {
        int pos;
        if (this.addr == 0 || this.addr >= data.length) {
            return "";
        }
        int length = this.length;
        int offset = this.addr + length * index;
        if (length == 0) {
            length = data[this.addr - 1];
        }
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = (char)data[offset + i];
        }
        for (pos = length; pos > 0 && text[pos - 1] == this.fill; --pos) {
        }
        return new String(text, 0, pos);
    }

    public String getText2(short[] data, int n) {
        int offset = this.addr - 1;
        int length = 0;
        for (int i = 0; i < n; ++i) {
            if ((offset += length + 1) == 0 || offset >= data.length) {
                return null;
            }
            length = Math.min(data[offset - 1], data.length - offset);
        }
        char[] text = new char[length];
        for (int i = 0; i < length; ++i) {
            text[i] = (char)data[offset + i];
        }
        return length == 0 ? null : new String(text);
    }

    public void setText(String text, int index, short[] data) {
        if (text == null || text.equals("")) {
            text = this.getDefaultText(data, index);
        }
        text = text.trim();
        int length = this.length;
        boolean allowInvalidChars = false;
        if (length == 0 && this.addr <= data.length) {
            length = data[this.addr - 1];
            allowInvalidChars = true;
        } else {
            text = text.toUpperCase();
        }
        int offset = this.addr + length * index;
        int j = 0;
        int len = Math.min(length, text.length());
        boolean invalidChar = false;
        for (int i = 0; i < len; ++i) {
            Character ch = Character.valueOf(text.charAt(i));
            if (allowInvalidChars || Character.isLetterOrDigit(ch.charValue()) || ch.equals(Character.valueOf(' ')) || ch.equals(Character.valueOf('.'))) {
                data[offset + j++] = (short)text.charAt(i);
                continue;
            }
            invalidChar = true;
        }
        while (j < length) {
            data[offset + j++] = this.fill;
        }
        if (invalidChar) {
            String message = "One or more invalid characters have been\r\ndeleted.  The only allowed characters are\r\nletters, digits, space and full stop.";
            JOptionPane.showMessageDialog(null, message);
        }
    }

    public void setText2(String text, short[] data, int n) {
        int offset = this.addr - 1;
        int length = 0;
        for (int i = 0; i < n; ++i) {
            if ((offset += length + 1) == 0 || offset > data.length) {
                return;
            }
            length = Math.min(data[offset - 1], data.length - offset);
        }
        text = text.trim();
        data[offset - 1] = (short)text.length();
        Hex.put(new Hex(text, 8).getData(), data, offset);
    }
}

