/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.ImageMap;

public class DeviceType {
    private String name;
    public String abbreviation;
    private int map;
    private int type;
    private ButtonMap buttonMap = null;
    private ImageMap[][] imageMaps = new ImageMap[0][];

    DeviceType(String aName, int aMap, int aType) {
        this.name = aName;
        this.map = aMap;
        this.type = aType;
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.type & 0xFF;
    }

    public int getGroup() {
        return this.type >> 8;
    }

    public int getMap() {
        return this.map;
    }

    public int get_Type() {
        return this.type;
    }

    public DeviceType setButtonMap(ButtonMap buttonMap) {
        this.buttonMap = buttonMap;
        return this;
    }

    public ButtonMap getButtonMap() {
        return this.buttonMap;
    }

    public boolean isMapped(Button b) {
        return this.buttonMap.isPresent(b);
    }

    public void setAbbreviation(String text) {
        this.abbreviation = text;
    }

    public String getAbbreviation() {
        if (this.abbreviation != null) {
            return this.abbreviation;
        }
        return this.name;
    }

    public ImageMap[][] getImageMaps() {
        return this.imageMaps;
    }

    public void setImageMaps(ImageMap[][] maps) {
        this.imageMaps = maps;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof DeviceType)) {
            return false;
        }
        DeviceType aDeviceType = (DeviceType)anObject;
        return this.name.equals(aDeviceType.getName());
    }
}

