/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.ButtonAssignments;
import com.hifiremote.jp1.ButtonMap;
import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.CombinerDevice;
import com.hifiremote.jp1.DefaultValue;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceCombiner;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgradeExporter;
import com.hifiremote.jp1.DigitMaps;
import com.hifiremote.jp1.EFC;
import com.hifiremote.jp1.Executor;
import com.hifiremote.jp1.ExternalFunction;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.Highlight;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.LineTokenizer;
import com.hifiremote.jp1.Macro;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Preferences;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.ProcessorManager;
import com.hifiremote.jp1.Property;
import com.hifiremote.jp1.PropertyReader;
import com.hifiremote.jp1.PropertyWriter;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolFactory;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.SetupPanel;
import com.hifiremote.jp1.Value;
import com.hifiremote.jp1.translate.Translate;
import com.hifiremote.jp1.translate.Translator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.SwingPropertyChangeSupport;
import org.harctoolbox.irp.Decoder;
import org.harctoolbox.irp.NamedProtocol;

public class DeviceUpgrade
extends Highlight {
    private String baseline = "";
    private String description = null;
    private boolean inconsistent = false;
    protected int setupCode = 0;
    private Remote remote = null;
    private RemoteConfiguration remoteConfig = null;
    private DeviceUpgrade baseUpgrade = null;
    private String devTypeAliasName = null;
    private int selectedDeviceIndex = -1;
    private String selectedSetupCode = null;
    protected Protocol protocol = null;
    protected Protocol originalProtocol = null;
    private boolean skipProtocol = false;
    protected ManualProtocol convertedProtocol = null;
    private int sizeDevBytes = 0;
    private int sizeCmdBytes = 0;
    private Hex extraData = new Hex(24);
    private Value[] parmValues = new Value[0];
    private List<Function> functions = new ArrayList<Function>();
    private Button[] mappedButtons = null;
    private List<ExternalFunction> extFunctions = new ArrayList<ExternalFunction>();
    private File file = null;
    private DeviceButton buttonRestriction = DeviceButton.noButton;
    private List<Button> softButtons = null;
    private List<Button> hardButtons = null;
    private int currentSize = 0;
    private JP1Frame frame = null;
    private boolean usesSerial = false;
    private LinkedHashMap<Integer, Function> functionMap = null;
    private LinkedHashMap<Integer, Macro> macroMap = null;
    private LinkedHashMap<Integer, LearnedSignal> learnedMap = null;
    private LinkedHashMap<Integer, Function> keyGidMap = null;
    private LinkedHashMap<Integer, GeneralFunction> selectorMap = null;
    private LinkedHashMap<GeneralFunction, List<GeneralFunction.User>> restoreOnCancelReferences = null;
    private int dependentOffset = 0;
    private Boolean buttonIndependent = true;
    private SwingPropertyChangeSupport propertyChangeSupport = new SwingPropertyChangeSupport(this);
    private ButtonAssignments assignments = new ButtonAssignments();
    protected HashMap<Integer, Color[]> assignmentColors = new HashMap();
    private Color protocolHighlight = Color.WHITE;
    private int protocolMemoryUsage = 0;
    private static final String[] deviceTypeAliasNames = new String[]{"Cable", "TV", "VCR", "CD", "Tuner", "DVD", "SAT", "Tape", "Laserdisc", "DAT", "Home Auto", "Misc Audio", "Phono", "Video Acc", "Amp", "PVR", "OEM Mode"};
    private static String[] defaultNames = null;
    private static final String[] defaultFunctionNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "vol up", "vol down", "mute", "channel up", "channel down", "power", "enter", "tv/vcr", "last (prev ch)", "menu", "program guide", "up arrow", "down arrow", "left arrow", "right arrow", "select", "sleep", "pip on/off", "display", "pip swap", "pip move", "play", "pause", "rewind", "fast fwd", "stop", "record", "exit", "surround", "input toggle", "+100", "fav/scan", "device button", "next track", "prev track", "shift-left", "shift-right", "pip freeze", "slow", "eject", "slow+", "slow-", "X2", "center", "rear"};
    private static final String[] genericButtonNames = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "vol up", "vol down", "mute", "channel up", "channel down", "power", "enter", "tv/vcr", "prev ch", "menu", "guide", "up arrow", "down arrow", "left arrow", "right arrow", "select", "sleep", "pip on/off", "display", "pip swap", "pip move", "play", "pause", "rewind", "fast fwd", "stop", "record", "exit", "surround", "input", "+100", "fav/scan", "device button", "next track", "prev track", "shift-left", "shift-right", "pip freeze", "slow", "eject", "slow+", "slow-", "x2", "center", "rear", "phantom1", "phantom2", "phantom3", "phantom4", "phantom5", "phantom6", "phantom7", "phantom8", "phantom9", "phantom10", "setup", "light", "theater", "macro1", "macro2", "macro3", "macro4", "learn1", "learn2", "learn3", "learn4"};
    private boolean preserveOBC = true;
    private Segment softButtonSegment = null;
    private Segment softFunctionSegment = null;
    private boolean internal = false;
    private LinkedHashMap<Function, Function> swapList = null;
    public static Comparator<Button> ButtonSorter = new Comparator<Button>(){

        @Override
        public int compare(Button b1, Button b2) {
            return new Short(b1.getKeyCode()).compareTo(new Short(b2.getKeyCode()));
        }
    };
    public static final String[][] kmRemotesToRDF = new String[][]{{"15-100", "30603060 (RS 15-100).rdf"}, {"15-133", "30853085 (RS 15-133).rdf"}, {"15-134", "30853085 (RS 15-134).rdf"}, {"15-135", "30853085 (RS 15-135).rdf"}, {"15-1925 / 15-1918", "O80a (RS 15-1925_1918_1919).rdf"}, {"15-1994", "RSL6RSL0 (RS 15-1994 6-in-1 Smart).rdf"}, {"15-1995", "RS70RS70 (RS 15-1995 7-in-1 with More Memory).rdf"}, {"15-2103", "RS50RS50 (RS 15-2103 1K Version).rdf"}, {"15-2104", "R6H0R6H0 (RS 15-2104 6-In-One AV).rdf"}, {"15-2107", "RTS0RTS0 (RS 15-2107 8-In-One Touchscreen).rdf"}, {"15-2117 / 15-2116", "RSL1RSL1 (RS 15-2117_2116).rdf"}, {"15-2133 (RS Kameleon)", "RSFFRSF0 (RS 15-2133 Kameleon 0.5k).rdf"}, {"15-2138 (RS Kameleon 8-in-1)", "RS80RS80 (RS 15-2138 Kameleon).rdf"}, {"URC-4080", "HVC0HVC0 (URC-4080 Video Expert).rdf"}, {"URC-5650", "O5F0O5F1 (URC-7200 Cinema 7).rdf"}, {"URC-6131 PVR", "PVR0PVR0 (URC-6131(Old)_6131nwB00 PVR Remote 1K).rdf"}, {"URC-6690 (Hybrid Kameleon)", "10361036 (URC-6690_6692 Hybrid Kameleon).rdf"}, {"URC-6960 / 6962 Kameleon", "OK60OK60 (URC-6960_6962 Kameleon).rdf"}, {"URC-7070", "O80a (URC-7070 Pro Producer 7).rdf"}, {"URC-7200 / 5650", "O5F0O5F1 (URC-7200 Cinema 7).rdf"}, {"URC-7541 / 7544", "EO40EO40 (URC-7541_7544 1K Version).rdf"}, {"URC-7540 / 7542", "EMAIEMA0 (URC-7540_7542 One for All 4).rdf"}, {"URC-7555 / 7556", "10751075 (URC-7555 OFA5).rdf"}, {"URC-7560 / 7562", "EBV0EBV0 (URC-7550_7560-B00 One for All).rdf"}, {"URC-7562 b01", "EM60EM60 (URC-7562-B01 One for All).rdf"}, {"URC-7781", "11311131 (URC-7781 One For All Digital 12).rdf"}, {"URC-7800 / 6800", "C7L0C7L0 (URC-7800_6800 Cinema).rdf"}, {"URC-8060 (Euro Kameleon)", "KAMEKAM0 (URC-8060 Kameleon).rdf"}, {"URC-8090 b00/1", "HT80HT80 (URC-8080_8090-B00 Producer 8).rdf"}, {"URC-8090 b02", "HT80HT8C (URC-8080_8090-B02 Producer 8).rdf"}, {"URC-8206 (Euro Kameleon)", "10211021 (URC-8206 Kameleon).rdf"}, {"URC-8550 / 5550 (Topline)", "ET80ET80 (URC-8550_5550 Topline).rdf"}, {"URC-8780", "HUD0HUD0 (URC-9800_8800_8780 Producer 8).rdf"}, {"URC-881x / 801x / 601x", "6_806_80 (URC-881x_801x_601x 1k).rdf"}, {"URC-8820 / 10820 / 6820", "10631063 (URC-6820_8820_10820).rdf"}, {"URC-8820N / 10820N / 6820N", "11781178 (URC-6820N_8820N_10820N).rdf"}, {"URC-9800 / 8800", "HUD0HUD0 (URC-9800_8800_8780 Producer 8).rdf"}, {"URC-9910 / 8910 / UEI HTPro", "CPT0CPT0 (URC-8910(Old)_9910(Old)_8910(New)_9910(New)_HTPro).rdf"}, {"URC-9960 (OFA Kameleon)", "NAK0NAK0 (URC-9960 One For All Kameleon).rdf"}, {"URC-9960B01 (OFA Kameleon)", "KASAKAS0 (URC-9960 B01 One For All Kameleon).rdf"}, {"Atlas 4-Device", "ATL0ATL0 (Atlas 4-Device).rdf"}, {"Atlas 5 URC-1054", "SA_7SA_7 (Atlas 5 URC-1054).rdf"}, {"Atlas 5 Day URC-1055 JP1.2", "10251025 (Atlas 5 Day URC-1055_11055 JP1.2).rdf"}, {"Atlas 5 Day URC-1055 JP1.3 3000", "30003000 (Atlas 5 Day URC-1055_11055 JP1.3 3000).rdf"}, {"Atlas OCAP URC-1055/1056", "30333033 (Atlas OCAP URC-1056 JP1.3 (Black)_(Silver)).rdf"}, {"Balboa Dolphin", "BAL0BAL0 (Balboa Dolphin).rdf"}, {"Comcast URC-1058", "CS300103 (Comcast-URC-1058(old))).rdf"}, {"Comcast URC-1067A JP1.2", "CS301009 (Comcast-URC-1067).rdf"}, {"Comcast URC-1067B JP1.3", "30393039 (Comcast DVR URC-1067Bx3 JP1.3).rdf"}, {"DRC-400 Motorola", "GI2KG2K0 (DRC400 Motorola).rdf"}, {"DirecTV v1", "DTV0 (DirecTV Version 1).rdf"}, {"DirecTV v2", "DTV1 (DirecTV Version 2).rdf"}, {"Dreambox", "ETPSTPS0 (Dreambox - 1k version).rdf"}, {"Dreambox v2", "OLVAOLV0 (Dreambox V2).rdf"}, {"Intuitive", "INTU (Intuitive URC-31XXXB01).rdf"}, {"Maestro II", "GI97GI97 (Maestro II).rdf"}, {"Millennium 4", "MIL0MIL0 (Millennium 4-B00).rdf"}, {"Millennium 4 BJ8", "MIL0MIL0 (Millennium4-4MXXXBJ8XXX).rdf"}, {"Navigator URC-43000", "CA00 (Navigator URC-43000-B01).rdf"}, {"Navigator URC-44000B00", "CYC0 (Navigator URC-44000-B00).rdf"}, {"Navigator URC-44000B02/B04", "CYC1 (Navigator URC-44000-B02 Comcast).rdf"}, {"Outlaw Audio", "OEM4OEM0 (Outlaw Audio).rdf"}, {"RCA RCRP05B", "31793179 (RCA RCRP05B black).rdf"}, {"RCU810", "TCE0TCE0 (RCA RCU810).rdf"}, {"REM400 b00", "DSS0DSS0 (Philips REM400).rdf"}, {"REM400 b01", "n/a"}, {"Replay 5000", "SBPASBP0 (Replay 5000).rdf"}, {"ReplayTV (version 1)", "OEM3OEM (ReplayTV Version1).rdf"}, {"ReplayTV (version 2)", "OEM3OEM (ReplayTV Version2).rdf"}, {"Scientific-Atlanta AT2000", "SA40 (Scientific-Atlanta Explorer AT2000 BETA).rdf"}, {"Scientific-Atlanta ER1 3-Dev", "ER10 (Scientific-Atlanta ER1 (Explorer 3-device)).rdf"}, {"Scout", "SCOU (Scout 0.5K).rdf"}, {"Sky Digital 3", "BSKY (Sky Digital).rdf"}, {"Sony DirecTiVo RM-Y809", "STV2TV20 (Sony DirecTiVo RM-Y809).rdf"}, {"Sony TiVo RMT-V303", "TIVOTIV0 (Sony TiVo RMT-V303).rdf"}, {"Toshiba CT-90047", "T6D0T6D0 (Toshiba CT90047 128b).rdf"}};
    public static final String[][] kmButtonsToRDF = new String[][]{{"vol up", "Vol+"}, {"vol down", "Vol-"}, {"channel up", "Ch+"}, {"channel down", "Ch-"}, {"+100", "-/--"}, {"fav/scan", "Fav"}, {"tv/vcr", "Input"}, {"input", "Input"}, {"settings", "Settings"}, {"program / guide", "Guide"}, {"display", "Info"}, {"up arrow", "Up"}, {"down arrow", "Down"}, {"left arrow", "Left"}, {"right arrow", "Right"}, {"select", "OK"}, {"A/yellow", "Yellow"}, {"B/blue", "Blue"}, {"C/red", "Red"}, {"D/green", "Green"}, {"page up", "Page+"}, {"page down", "Page-"}, {"day+", "Day+"}, {"day-", "Day-"}, {"fast fwd", "FFwd"}, {"next track/skip+", "Skip+"}, {"prev track/skip-", "Skip-"}, {"list/PVR menu", "List"}, {"replay", "Replay"}, {"advance/jump", "Advance"}, {"live TV", "Live"}, {"thumbs up", "Thumbs_Up"}, {"thumbs down", "Thumbs_Down"}, {"eject/sp-lp", "Eject"}, {"pip", "PIP_On/Off"}, {"swap", "PIP_Swap"}, {"move", "PIP_Move"}, {"freeze", "PIP_Freeze"}, {"pip channel up", "PIP_Ch+"}, {"pip channel down", "PIP_Ch-"}, {"caption", "CC"}, {"aspect", "Format"}};

    public DeviceUpgrade() {
        Preferences preferences = RMIRSetup.getPreferences();
        String[] names = null;
        if (preferences.getUseCustomNames().equals("Empty")) {
            names = new String[]{};
        } else if (!preferences.getUseCustomNames().equals("Default")) {
            names = preferences.getCustomNames();
        }
        this.frame = RemoteMaster.getFrame();
        this.devTypeAliasName = deviceTypeAliasNames[0];
        this.initFunctions(names);
    }

    public DeviceUpgrade(String[] defaultNames) {
        this.devTypeAliasName = deviceTypeAliasNames[0];
        this.initFunctions(defaultNames);
        this.frame = RemoteMaster.getFrame();
    }

    public DeviceUpgrade(DeviceUpgrade base, DeviceButton newRestriction) {
        this.baseUpgrade = base;
        this.description = base.description;
        this.setupCode = base.setupCode;
        this.devTypeAliasName = base.devTypeAliasName;
        this.remote = base.remote;
        this.remoteConfig = base.remoteConfig;
        this.notes = base.notes;
        this.protocol = base.protocol;
        this.extraData = base.extraData;
        this.usesSerial = base.usesSerial;
        this.internal = base.internal;
        this.frame = base.frame;
        if (newRestriction == null || newRestriction == DeviceButton.noButton) {
            this.buttonIndependent = base.buttonIndependent;
            this.buttonRestriction = base.buttonRestriction;
        } else {
            this.buttonIndependent = false;
            this.buttonRestriction = newRestriction;
        }
        this.protocolHighlight = base.protocolHighlight;
        this.sizeCmdBytes = base.sizeCmdBytes;
        this.sizeDevBytes = base.sizeDevBytes;
        this.setHighlight(base);
        Iterator<Object> iterator = base.assignmentColors.keySet().iterator();
        while (iterator.hasNext()) {
            int index = iterator.next();
            this.assignmentColors.put(index, new Color[256]);
            for (int i = 0; i < 256; ++i) {
                this.assignmentColors.get((Object)Integer.valueOf((int)index))[i] = base.assignmentColors.get(index)[i];
            }
        }
        if (base.protocol != null) {
            this.protocol.setDeviceParms(base.parmValues);
            this.parmValues = this.protocol.getDeviceParmValues();
        }
        this.swapList = new LinkedHashMap();
        for (Function f : base.functions) {
            Function f2 = new Function(f);
            f2.setUpgrade(this);
            this.swapList.put(f, f2);
            this.functions.add(f2);
            for (GeneralFunction.User user : f.getUsers()) {
                if (user.db == null || user.db == DeviceButton.noButton) {
                    f2.addReference(user.button, user.state);
                    continue;
                }
                if (user.db.getUpgrade() != base) continue;
                f2.addReference(user.db, user.button);
            }
        }
        for (int i = 0; i < base.getAssignments().getAssignedFunctions().length; ++i) {
            Function f = null;
            f = base.getAssignments().getAssignedFunctions()[i];
            if (f == null) continue;
            this.assignments.getAssignedFunctions()[i] = this.swapList.get(f);
        }
        for (ExternalFunction f : base.extFunctions) {
            ExternalFunction f2 = new ExternalFunction(f);
            this.extFunctions.add(f2);
            for (GeneralFunction.User user : f.getUsers()) {
                this.assignments.assign(user.button, f2, user.state);
            }
        }
        if (this.remote.usesEZRC()) {
            if (base.getMacroMap() != null) {
                this.macroMap = new LinkedHashMap();
                this.macroMap.putAll(base.getMacroMap());
            }
            if (base.getLearnedMap() != null) {
                this.learnedMap = new LinkedHashMap();
                this.learnedMap.putAll(base.getLearnedMap());
            }
            if (base.getFunctionMap() != null) {
                this.functionMap = new LinkedHashMap();
                this.functionMap.putAll(base.getFunctionMap());
            }
            if (base.getSelectorMap() != null) {
                this.selectorMap = new LinkedHashMap();
                this.selectorMap.putAll(base.getSelectorMap());
            }
            if (base.getKeyGidMap() != null) {
                this.keyGidMap = new LinkedHashMap();
                this.keyGidMap.putAll(base.getKeyGidMap());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public DeviceUpgrade(GeneralSignal[] signals, RemoteConfiguration remoteConfig, Remote remote, LinkedHashMap<GeneralSignal, Executor> gsMap, DeviceUpgrade baseUpgrade, List<List<String>> failedToConvert) {
        LearnedSignalDecode lsd;
        void var13_21;
        this.remote = remote;
        this.remoteConfig = remoteConfig;
        this.frame = RemoteMaster.getFrame();
        for (GeneralSignal gs : signals) {
            if (gsMap.get(gs) == null) continue;
            this.protocol = gsMap.get((Object)gs).protocol;
            break;
        }
        List<Integer> deviceParmsUsed = null;
        if (baseUpgrade != null && baseUpgrade.getFunctionList().size() > 0) {
            DeviceUpgradeExporter exporter = new DeviceUpgradeExporter(baseUpgrade);
            exporter.getRemoteSet();
            deviceParmsUsed = exporter.getDeviceParmsUsed();
        }
        DeviceParameter[] protocolDevParms = this.protocol.getDeviceParameters();
        this.parmValues = new Value[protocolDevParms.length];
        Value[] baseValues = deviceParmsUsed == null ? null : baseUpgrade.getParmValues();
        for (int i = 0; i < this.parmValues.length; ++i) {
            this.parmValues[i] = baseValues == null ? new Value(null, this.protocol.devParms[i].getDefaultValue()) : (i >= baseValues.length ? null : new Value(!deviceParmsUsed.contains(i) ? null : baseValues[i].getUserValue(), baseValues[i].getDefaultValue()));
        }
        this.protocol.setDeviceParms(this.parmValues);
        ArrayList<GeneralSignal> validSignals = new ArrayList<GeneralSignal>();
        GeneralSignal[] generalSignalArray = signals;
        int n = generalSignalArray.length;
        boolean bl = false;
        while (var13_21 < n) {
            String string;
            GeneralSignal generalSignal = generalSignalArray[var13_21];
            String string2 = string = remote != null ? generalSignal.getSignalName(remote) : "Unknown name";
            if (generalSignal.getError() == null) {
                if (gsMap.get(generalSignal) == null) {
                    failedToConvert.add(Arrays.asList(string, "Not supported by this protocol"));
                } else {
                    generalSignal.setPreferredLSDecode(null);
                    if (generalSignal.getDecodes() == null || generalSignal.getDecodes().isEmpty()) {
                        failedToConvert.add(Arrays.asList(string, "Signal has no decodes"));
                    } else {
                        lsd = null;
                        for (LearnedSignalDecode learnedSignalDecode : generalSignal.getDecodes()) {
                            lsd = null;
                            NamedProtocol np = learnedSignalDecode.decode.getNamedProtocol();
                            List<Executor.ExecutorWrapper> wrappers = LearnedSignal.getExecutorWrappers(np);
                            for (Executor.ExecutorWrapper wrapper : wrappers) {
                                Executor e = LearnedSignalDecode.getExecutor(np, wrapper, null);
                                if (e == null || !e.wrapper.executorDescriptor.equals(gsMap.get((Object)generalSignal).wrapper.executorDescriptor)) continue;
                                lsd = learnedSignalDecode;
                                lsd.executor = e;
                                generalSignal.setPreferredLSDecode(lsd);
                                validSignals.add(generalSignal);
                                break;
                            }
                            if (lsd == null) continue;
                            break;
                        }
                        if (lsd == null) {
                            failedToConvert.add(Arrays.asList(string, "Unable to recover current decode"));
                        }
                    }
                }
            }
            ++var13_21;
        }
        List<String> persistentParamNames = DeviceUpgradeExporter.getPersistentParameterNames(this.protocol);
        if (persistentParamNames != null && !validSignals.isEmpty()) {
            HashMap<String, Long> persistentParams = new HashMap<String, Long>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (GeneralSignal generalSignal : validSignals) {
                lsd = generalSignal.getPreferredLSDecode();
                Map<String, Long> map = lsd.evaluate(lsd.decode.getMap(), 0, true);
                for (String name : persistentParamNames) {
                    Long val = map.get(name);
                    if (val == null) continue;
                    if (persistentParams.get(name) == null) {
                        persistentParams.put(name, val);
                        continue;
                    }
                    if (persistentParams.get(name) == val || arrayList.contains(name)) continue;
                    arrayList.add(name);
                }
            }
            if (!arrayList.isEmpty()) {
                for (GeneralSignal generalSignal : validSignals) {
                    try {
                        lsd = generalSignal.getPreferredLSDecode();
                        HashMap<String, Long> newMap = new HashMap<String, Long>(lsd.decode.getMap());
                        for (String name : arrayList) {
                            Long currentVal = newMap.get(name);
                            if (currentVal != null) {
                                newMap.put(name, -1L - newMap.get(name));
                                continue;
                            }
                            newMap.put(name, -1L);
                        }
                        NamedProtocol namedProtocol = lsd.decode.getNamedProtocol();
                        lsd = new LearnedSignalDecode(new Decoder.Decode(namedProtocol, newMap, -1, -1, 0));
                        generalSignal.setPreferredLSDecode(lsd);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        for (GeneralSignal generalSignal : validSignals) {
            void var14_33;
            String string = remote != null ? generalSignal.getSignalName(remote) : "Unknown name";
            LearnedSignalDecode learnedSignalDecode2 = generalSignal.getPreferredLSDecode();
            learnedSignalDecode2 = new LearnedSignalDecode(learnedSignalDecode2.decode, this.parmValues, gsMap.get(generalSignal));
            if (!learnedSignalDecode2.isValidDecode()) {
                failedToConvert.add(Arrays.asList(string, "Device parameters not consistent with executor"));
                continue;
            }
            if (!learnedSignalDecode2.isMatch()) {
                failedToConvert.add(Arrays.asList(string, "Device parameters not consistent with those already set"));
                continue;
            }
            this.protocol.setDeviceParms(this.parmValues);
            Remote.ButtonSplit split = new Remote.ButtonSplit(null, 0);
            if (remote != null && generalSignal.getIKeyCode() != null) {
                split = remote.getButtonSplit(generalSignal.getIKeyCode());
            }
            Button b = split.base;
            int n2 = split.state;
            ArrayList<String> error = new ArrayList<String>(2);
            Hex hex = learnedSignalDecode2.getProtocolHex(error);
            if (hex == null) {
                error.set(0, string);
                failedToConvert.add(error);
                continue;
            }
            if (remote == null) continue;
            if (this.getFunction(string) != null) {
                int i = 1;
                String newName = string;
                while (this.getFunction(newName) != null) {
                    newName = string + "_" + i++;
                }
                String string3 = newName;
            }
            Function f = new Function((String)var14_33, new Hex(hex), generalSignal.getNotes());
            f.setUpgrade(this);
            if (remote.isSSD()) {
                f.icon = new GeneralFunction.RMIcon(9);
            }
            if (remote.usesEZRC()) {
                if (this.keyGidMap == null) {
                    this.keyGidMap = new LinkedHashMap();
                }
                int gid = this.getGidForName((String)var14_33);
                f.setGid(gid);
            }
            this.functions.add(f);
            if (b == null) continue;
            this.assignments.assign(b, f, n2);
        }
        if (remote == null) {
            return;
        }
        this.description = "General Signal Upgrade";
        this.setupCode = 2000;
        if (remoteConfig != null) {
            boolean bl2;
            List<DeviceUpgrade> upgrades = remoteConfig.getDeviceUpgrades();
            boolean bl3 = true;
            block13: while (bl2) {
                bl2 = false;
                for (DeviceUpgrade deviceUpgrade : upgrades) {
                    if (!deviceUpgrade.getDeviceTypeAliasName().equals("Cable") || deviceUpgrade.getSetupCode() != this.setupCode) continue;
                    ++this.setupCode;
                    bl2 = true;
                    continue block13;
                }
            }
        }
        this.devTypeAliasName = "Cable";
        if (remote.usesEZRC() && this.macroMap == null) {
            this.macroMap = new LinkedHashMap();
            this.learnedMap = new LinkedHashMap();
            this.functionMap = new LinkedHashMap();
            this.selectorMap = new LinkedHashMap();
        }
        this.sizeCmdBytes = this.protocol.getDefaultCmdLength();
        this.sizeDevBytes = this.protocol.getFixedDataLength();
        this.setRemoteConfig(remoteConfig);
        if (!failedToConvert.isEmpty() && !LearnedSignalDecode.displayErrors(this.protocol.getName(), failedToConvert)) {
            this.protocol = null;
        }
    }

    public void reset() {
        this.reset(defaultNames);
    }

    public void reset(String[] defaultNames) {
        this.description = null;
        this.setupCode = 0;
        if (this.remote != null) {
            this.assignments.clear();
        }
        Collection<Remote> remotes = RemoteManager.getRemoteManager().getRemotes();
        if (this.remote == null) {
            this.remote = remotes.iterator().next();
        }
        this.devTypeAliasName = deviceTypeAliasNames[0];
        if (this.protocol != null) {
            this.protocol.reset();
        }
        if (!this.remote.usesEZRC()) {
            ProtocolManager pm = ProtocolManager.getProtocolManager();
            List<String> names = pm.getNames();
            for (String protocolName : names) {
                Protocol p = pm.findProtocolForRemote(this.remote, protocolName);
                if (p == null) continue;
                this.protocol = p;
                break;
            }
        } else {
            this.protocol = null;
        }
        if (this.protocol != null) {
            DeviceParameter[] devParms = this.protocol.getDeviceParameters();
            for (int i = 0; i < devParms.length; ++i) {
                devParms[i].setValue(null);
            }
            this.setProtocol(this.protocol, false);
        }
        this.notes = null;
        this.file = null;
        this.functions.clear();
        this.initFunctions(defaultNames);
        this.extFunctions.clear();
    }

    private void initFunctions(String[] names) {
        defaultNames = names;
        if (defaultNames == null) {
            defaultNames = defaultFunctionNames;
        }
        for (int i = 0; i < defaultNames.length; ++i) {
            Function f = new Function(defaultNames[i]);
            f.setUpgrade(this);
            this.functions.add(f);
        }
    }

    public void setDescription(String text) {
        this.description = text;
    }

    public String getDescription() {
        if ((this.description == null || this.description.trim().isEmpty()) && this.buttonRestriction != null && this.buttonRestriction != DeviceButton.noButton) {
            return this.buttonRestriction.getName();
        }
        return this.description;
    }

    public void setSetupCode(int setupCode) {
        int oldSetupCode = this.setupCode;
        this.setupCode = setupCode;
        this.propertyChangeSupport.firePropertyChange("setupCode", oldSetupCode, setupCode);
    }

    public int getSetupCode() {
        return this.setupCode;
    }

    public int getSizeDevBytes() {
        return this.sizeDevBytes;
    }

    public void setSizeDevBytes(int sizeDevBytes) {
        this.sizeDevBytes = sizeDevBytes;
    }

    public int getSizeCmdBytes() {
        return this.sizeCmdBytes;
    }

    public void setSizeCmdBytes(int sizeCmdBytes) {
        this.sizeCmdBytes = sizeCmdBytes;
    }

    public Hex getExtraData() {
        return this.isRfUpgrade() ? this.extraData : null;
    }

    public boolean hasDefinedFunctions() {
        for (Function function : this.functions) {
            if (function.getHex() == null) continue;
            return true;
        }
        for (Function function : this.extFunctions) {
            if (function.getHex() == null) continue;
            return true;
        }
        return false;
    }

    public void setRemote(Remote newRemote) {
        if (newRemote == this.remote) {
            return;
        }
        Protocol p = this.protocol;
        ProtocolManager pm = ProtocolManager.getProtocolManager();
        List<Protocol> protocols = pm.getProtocolsForRemote(newRemote, false);
        if (p == null) {
            if (!newRemote.usesEZRC()) {
                this.protocol = protocols.get(0);
            }
        } else if (!protocols.contains(p)) {
            System.err.println("DeviceUpgrade.setRemote(), protocol " + p.getDiagnosticName() + " is not built into remote " + newRemote.getName());
            Protocol newp = pm.findProtocolForRemote(newRemote, p.getName());
            if (newp != null) {
                if (newp != p) {
                    System.err.println("Testing if protocol " + newp.getDiagnosticName() + " can be used.");
                    System.err.println("\tChecking for matching dev. parms");
                    DeviceParameter[] parms = p.getDeviceParameters();
                    DeviceParameter[] parms2 = newp.getDeviceParameters();
                    int[] map = new int[parms.length];
                    boolean parmsMatch = true;
                    for (int i = 0; i < parms.length; ++i) {
                        String name = parms[i].getName();
                        System.err.print("\tchecking " + name);
                        boolean nameMatch = false;
                        for (int j = 0; j < parms2.length; ++j) {
                            if (!name.equals(parms2[j].getName())) continue;
                            map[i] = j;
                            nameMatch = true;
                            System.err.print(" has a match!");
                            break;
                        }
                        if (!nameMatch) {
                            Object v = parms[i].getValue();
                            Object d = parms[i].getDefaultValue();
                            if (d != null) {
                                d = ((DefaultValue)d).value();
                            }
                            System.err.print(" no match!");
                            if (v == null || v.equals(d)) {
                                nameMatch = true;
                                map[i] = -1;
                                System.err.print(" But there's no value anyway!  ");
                            }
                        }
                        System.err.println();
                        parmsMatch = nameMatch;
                        if (!parmsMatch) break;
                    }
                    if (parmsMatch) {
                        Value[] vals = new Value[parms2.length];
                        for (int i = 0; i < map.length; ++i) {
                            if (map[i] == -1) continue;
                            System.err.println("\tfrom index " + i + " (=" + parms[i].getValue() + ") to index " + map[i]);
                            parms2[map[i]].setValue(parms[i].getValue());
                            vals[map[i]] = new Value(parms[i].getValue());
                        }
                        newp.setDeviceParms(vals);
                        System.err.println();
                        System.err.println("Protocol " + newp.getDiagnosticName() + " will be used.");
                        p.convertFunctions(this.functions, newp, this.preserveOBC);
                        this.protocol = newp;
                        this.parmValues = vals;
                    }
                    if (p instanceof DeviceCombiner && newp instanceof DeviceCombiner) {
                        for (CombinerDevice dev : ((DeviceCombiner)p).getDevices()) {
                            ((DeviceCombiner)newp).add(dev);
                        }
                    }
                }
            } else if (this.description == null && this.file == null && this.assignments.isEmpty() && !this.hasDefinedFunctions()) {
                this.remote = newRemote;
                this.protocol = null;
                this.reset();
            } else {
                System.err.println("DeviceUpgrade.setRemote(), protocol " + p.getDiagnosticName() + "is not compatible with remote " + newRemote.getName());
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The selected protocol " + p.getDiagnosticName() + "\nis not compatible with the selected remote.\nThis upgrade will NOT function correctly.\nPlease choose a different protocol.", "Error", 0);
            }
        }
        if (this.remote != null && this.remote != newRemote) {
            SetupCode.setMax(this.remote);
            Button[] buttons = this.remote.getUpgradeButtons();
            ButtonAssignments newAssignments = new ButtonAssignments();
            ArrayList unassigned = new ArrayList();
            for (int i = 0; i < buttons.length; ++i) {
                Button b = buttons[i];
                for (int state = 0; state <= 2; ++state) {
                    Function f = this.assignments.getAssignment(b, state);
                    if (f == null) continue;
                    this.assignments.assign(b, null, state);
                    Button newB = newRemote.findByStandardName(b);
                    ArrayList<String> temp = null;
                    if (f == null) continue;
                    if (newB != null && newB.allowsKeyMove(state)) {
                        newAssignments.assign(newB, f, state);
                        continue;
                    }
                    temp = new ArrayList<String>();
                    temp.add(f.getName());
                    temp.add(b.getName());
                    unassigned.add(temp);
                }
            }
            if (!unassigned.isEmpty()) {
                String message = "<html>Some of the functions defined in the device upgrade were assigned to buttons<br>that do not match buttons on the newly selected remote.  The functions and the<br>corresponding button names from the original remote are listed below.<br><br>Use the Button or Layout panel to assign those functions properly.</html>";
                JPanel panel = new JPanel(new BorderLayout());
                JLabel text = new JLabel(message);
                text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                panel.add((Component)text, "North");
                ArrayList<String> titles = new ArrayList<String>();
                titles.add("Function name");
                titles.add("Button name");
                Object[][] unassignedArray = new Object[unassigned.size()][];
                int i = 0;
                for (List list : unassigned) {
                    unassignedArray[i++] = list.toArray();
                }
                JTableX table = new JTableX(unassignedArray, titles.toArray());
                Dimension dimension = table.getPreferredScrollableViewportSize();
                int showRows = 14;
                if (unassigned.size() < showRows) {
                    showRows = unassigned.size();
                }
                dimension.height = (table.getRowHeight() + table.getRowMargin()) * showRows;
                table.setPreferredScrollableViewportSize(dimension);
                panel.add((Component)new JScrollPane(table), "Center");
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), panel, "Lost Function Assignments", -1);
            }
            this.assignments = newAssignments;
        }
        this.remote = newRemote;
        if (this.remote.usesEZRC() && this.macroMap == null) {
            this.macroMap = new LinkedHashMap();
            this.learnedMap = new LinkedHashMap();
            this.keyGidMap = new LinkedHashMap();
            this.functionMap = new LinkedHashMap();
            this.selectorMap = new LinkedHashMap();
        }
    }

    public Remote getRemote() {
        return this.remote;
    }

    public void setNewRemote(Remote newRemote) {
        this.remote = newRemote;
    }

    public int getSelectedDeviceIndex() {
        return this.selectedDeviceIndex;
    }

    public void setSelectedDeviceIndex(int selectedDeviceIndex) {
        this.selectedDeviceIndex = selectedDeviceIndex;
    }

    public String getSelectedSetupCode() {
        return this.selectedSetupCode;
    }

    public void setSelectedSetupCode(String selectedSetupCode) {
        this.selectedSetupCode = selectedSetupCode;
    }

    public void setDeviceTypeAliasName(String name) {
        String oldName = this.devTypeAliasName;
        if (name != null) {
            if (this.remote.getDeviceTypeByAliasName(name) != null) {
                this.devTypeAliasName = name;
            } else {
                this.devTypeAliasName = deviceTypeAliasNames[0];
                System.err.println("Unable to find device type with alias name " + name);
            }
        }
        this.propertyChangeSupport.firePropertyChange("deviceTypeAliasName", oldName, this.devTypeAliasName);
    }

    public String getDeviceTypeAliasName() {
        return this.devTypeAliasName;
    }

    public DeviceType getDeviceType() {
        return this.remote.getDeviceTypeByAliasName(this.devTypeAliasName);
    }

    public boolean setProtocol(Protocol newProtocol) {
        return this.setProtocol(newProtocol, true);
    }

    private DeviceUpgrade protocolInUse() {
        if (this.remoteConfig != null) {
            for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                if (du == this || du.getProtocol() != this.protocol) continue;
                return du;
            }
        }
        return null;
    }

    public SetupPanel.AltPIDStatus testAltPID() {
        SetupPanel.AltPIDStatus status = new SetupPanel.AltPIDStatus();
        if (this.protocol == null) {
            return status;
        }
        int officialPID = this.protocol.getID(this.remote, false).get(0);
        if (this.remoteConfig != null) {
            for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                if (du == this.baseUpgrade || du.getProtocol() == null || this.baseUpgrade != null && du.getProtocol() == this.baseUpgrade.getProtocol()) continue;
                if (du.getProtocol() == this.protocol) {
                    status.value = du.getProtocol().getID(this.remote).get(0);
                    status.hasValue = true;
                    status.editable = false;
                    status.msgIndex = 256;
                    break;
                }
                if (!du.getProtocol().getID(this.remote).equals(this.protocol.getID(this.remote, false)) || this.getCode() == null || du.getCode() == null) continue;
                if (du.getCode().equals(this.getCode())) {
                    status.value = du.getProtocol().getID(this.remote).get(0);
                    status.hasValue = true;
                    status.editable = false;
                    status.msgIndex = 1024;
                    break;
                }
                status.required = true;
                status.msgIndex = 512;
            }
        }
        Hex currentAltPID = this.protocol.getRemoteAltPID().get(this.remote.getSignature());
        if (!status.hasValue && currentAltPID != null && currentAltPID.length() > 0) {
            status.hasValue = true;
            status.value = currentAltPID.get(0);
        }
        ProtocolUpgrade pu = this.protocol.getCustomUpgrade(this.remoteConfig, false);
        Hex puCode = null;
        List<Protocol> builtIn = ProtocolManager.getProtocolManager().getBuiltinProtocolsForRemote(this.remote, this.protocol.getID(this.remote, false));
        if (pu != null && (puCode = pu.getCode()) != null && puCode.length() != 0) {
            puCode = this.remote.getProcessor().translate(puCode, this.remote);
            this.translateCode(puCode);
        }
        if (status.msgIndex == 0 && puCode != null && !puCode.equals(this.getCode())) {
            status.msgIndex = 768;
        }
        if (officialPID > 511 && !this.remote.usesTwoBytePID()) {
            status.required = true;
            status.msgIndex |= 1;
        } else if (this.protocol instanceof ManualProtocol) {
            status.msgIndex |= 2;
        } else if (!builtIn.isEmpty() && !builtIn.contains(this.protocol)) {
            status.msgIndex |= 3;
        } else if (builtIn.contains(this.protocol) || status.msgIndex == 0 && !status.hasValue) {
            status.visible = false;
        } else if (status.msgIndex == 0 && status.hasValue && status.value != officialPID) {
            status.msgIndex = 5;
        }
        if (status.hasValue && status.value == officialPID) {
            if ((status.msgIndex & 0xFF) != 2) {
                if (status.visible) {
                    status.msgIndex |= 0x800;
                }
                status.hasValue = false;
                status.visible = false;
            } else {
                status.editable = true;
                if ((status.msgIndex & 0xF00) == 256) {
                    status.msgIndex |= 0x400;
                }
            }
        }
        if (this.protocol.getCustomCode(this.remote.getProcessor()) != null) {
            status.msgIndex |= 0x1000;
        }
        if (!status.visible) {
            status.msgIndex = status.required ? 4 : status.msgIndex & (0x1000 | ((status.msgIndex & 0x800) > 0 ? 3840 : 0));
        }
        return status;
    }

    public boolean isCustom() {
        return this.protocol.getCustomCode(this.remote.getProcessor()) != null;
    }

    public boolean isRfUpgrade() {
        return this.remote.hasRf4ceSupport() && DeviceUpgrade.isRfPid(this.protocol.getID());
    }

    public boolean setProtocol(Protocol newProtocol, boolean messages) {
        Protocol oldProtocol = this.protocol;
        if (this.protocol != null) {
            int i;
            if (this.protocol == newProtocol) {
                return false;
            }
            newProtocol.reset();
            if (newProtocol.getFixedDataLength() == this.protocol.getFixedDataLength()) {
                newProtocol.importFixedData(this.protocol.getFixedData(this.parmValues));
            }
            DeviceParameter[] parms = this.protocol.getDeviceParameters();
            DeviceParameter[] parms2 = newProtocol.getDeviceParameters();
            int[] map = new int[parms.length];
            for (int i2 = 0; i2 < map.length; ++i2) {
                map[i2] = -1;
            }
            boolean parmsMatch = true;
            for (i = 0; i < parms.length; ++i) {
                String name = DeviceUpgrade.getMatchName(parms[i].getName());
                boolean nameMatch = false;
                for (int j = 0; j < parms2.length; ++j) {
                    if (!name.equals(DeviceUpgrade.getMatchName(parms2[j].getName()))) continue;
                    map[i] = j;
                    nameMatch = true;
                    break;
                }
                if (!nameMatch) continue;
                parmsMatch = true;
            }
            if (parmsMatch) {
                for (i = 0; i < map.length; ++i) {
                    int mappedIndex = map[i];
                    if (mappedIndex == -1) continue;
                    System.err.println("\tfrom index " + i + " to index " + map[i]);
                    parms2[mappedIndex].setValue(parms[i].getValue());
                }
            }
            if (!this.protocol.convertFunctions(this.functions, newProtocol, this.preserveOBC)) {
                this.propertyChangeSupport.firePropertyChange("protocol", oldProtocol, oldProtocol);
                return false;
            }
        }
        this.protocol = newProtocol;
        if (this.protocol != null) {
            this.parmValues = this.protocol.getDeviceParmValues();
            this.propertyChangeSupport.firePropertyChange("protocol", oldProtocol, this.protocol);
        }
        return true;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public static String getMatchName(String name) {
        List<String> altDevNames = Arrays.asList("devicecode", "maindevice", "devicenumber");
        name = LearnedSignalDecode.getMatchName(name);
        if (Boolean.parseBoolean(JP1Frame.getProperties().getProperty("IgnoreFinal1", "false")) && name.endsWith("1")) {
            name = name.substring(0, name.length() - 1);
        }
        if (altDevNames.contains(name)) {
            name = "device";
        }
        return name;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }

    public Function getFunction(String name) {
        Function rc = this.getFunction(name, this.functions);
        if (rc == null) {
            rc = this.getFunction(name, this.extFunctions);
        }
        return rc;
    }

    public Function getFunction(String name, List<? extends Function> funcs) {
        for (Function function : funcs) {
            String funcName = function.getName();
            if (funcName == null || !funcName.equalsIgnoreCase(name)) continue;
            return function;
        }
        return null;
    }

    private Function getFunctionByRmirIndex(int rmirIndex) {
        for (Function f : this.functions) {
            if (f.getRmirIndex() != rmirIndex) continue;
            return f;
        }
        return null;
    }

    public Function getFunction(Hex hex) {
        if (hex == null) {
            return null;
        }
        for (Function f : this.functions) {
            if (f.getHex() == null || !hex.equals(f.getHex())) continue;
            return f;
        }
        return null;
    }

    public List<ExternalFunction> getExternalFunctions() {
        return this.extFunctions;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    private short findDigitMapIndex() {
        short[] digitMaps = this.remote.getDigitMaps();
        if (digitMaps == null || digitMaps.length == 0 || this.remote.usesEZRC() || this.remote.usesSimpleset()) {
            return -1;
        }
        if (this.remote.getZeroDigitMapByte()) {
            return -1;
        }
        int cmdLength = this.protocol.getDefaultCmdLength();
        short[] digitKeyCodes = new short[10 * cmdLength];
        Button[] buttons = this.remote.getUpgradeButtons();
        int offset = 0;
        int i = 0;
        while (i < 10) {
            Function f = this.assignments.getAssignment(buttons[i]);
            if (f != null && !f.isExternal()) {
                Hex.put(f.getHex(), digitKeyCodes, offset);
            }
            ++i;
            offset += cmdLength;
        }
        return DigitMaps.findDigitMapIndex(digitMaps, digitKeyCodes);
    }

    /*
     * WARNING - void declaration
     */
    public void importRawUpgrade(Hex hexCode, Remote newRemote, String newDeviceTypeAliasName, Hex pid, Hex pCode) throws ParseException {
        String variant;
        int extraIndex;
        this.reset();
        System.err.println("DeviceUpgrade.importRawUpgrade");
        System.err.println("  hexCode=" + hexCode.toString());
        System.err.println("  newRemote=" + newRemote);
        System.err.println("  newDeviceTypeAliasName=" + newDeviceTypeAliasName);
        System.err.println("  pid=" + pid.toString());
        System.err.println("  pCode=" + pCode);
        int index = 1;
        if (newRemote.usesTwoBytePID()) {
            ++index;
        }
        short[] code = hexCode.getData();
        this.remote = newRemote;
        this.functions.clear();
        this.devTypeAliasName = newDeviceTypeAliasName;
        DeviceType devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName);
        ButtonMap map = devType.getButtonMap();
        int digitMapIndex = -1;
        if (!this.remote.getOmitDigitMapByte() && index < code.length && (digitMapIndex = code[index++] - 1) >= this.remote.getDigitMaps().length) {
            digitMapIndex = -1;
        }
        List<Object> buttons = null;
        buttons = map != null && index < code.length ? map.parseBitMap(code, index, digitMapIndex != -1) : new ArrayList();
        if (this.inconsistent) {
            String devName = this.buttonRestriction.getName();
            String title = "Inconsistent upgrade";
            String message = "Upgrade " + devName + " has inconsistent command lengths.";
            JOptionPane.showMessageDialog(null, message, title, 2);
        }
        while (index < code.length && (code[index++] & 1) == 0) {
        }
        int fixedDataOffset = index;
        int fixedDataLength = 0;
        int cmdLength = 0;
        short[] fixedData = null;
        Hex fixedDataHex = null;
        if (this.remote.getSegmentTypes() != null) {
            fixedDataLength = this.sizeDevBytes;
            cmdLength = this.sizeCmdBytes;
        }
        if (cmdLength == 0 && pCode != null && pCode.length() > 2) {
            Processor proc = newRemote.getProcessor();
            fixedDataLength = Protocol.getFixedDataLengthFromCode(proc.getEquivalentName(), pCode);
            cmdLength = Protocol.getCmdLengthFromCode(proc.getEquivalentName(), pCode);
        }
        if (cmdLength > 0) {
            System.err.println("fixedDataLength=" + fixedDataLength + " and cmdLength=" + cmdLength);
            fixedData = new short[fixedDataLength];
            System.arraycopy(code, fixedDataOffset, fixedData, 0, fixedDataLength);
            fixedDataHex = new Hex(fixedData);
        }
        if (this.remote.hasRf4ceSupport() && DeviceUpgrade.isRfPid(pid) && fixedDataLength >= 2 && (extraIndex = fixedDataHex.get(0)) > 0 && hexCode.length() >= extraIndex + 24) {
            this.extraData = hexCode.subHex(extraIndex, 24);
        }
        Value[] vals = this.parmValues;
        List<Protocol> protocols = null;
        boolean isBuiltIn = true;
        if (pCode == null) {
            protocols = ProtocolManager.getProtocolManager().getBuiltinProtocolsForRemote(this.remote, pid);
        }
        if (pCode != null || this.remote.getSupportedVariantNames(pid) == null) {
            isBuiltIn = false;
            protocols = ProtocolManager.getProtocolManager().findByPID(pid);
            List<Protocol> pList = ProtocolManager.getProtocolManager().findByAlternatePID(this.remote, pid, true);
            if (pList != null) {
                protocols.addAll(pList);
            }
        }
        Protocol tentative = null;
        Value[] tentativeVals = null;
        Protocol p = null;
        int matchLenCount = -1;
        for (Protocol tryit : protocols) {
            Hex oldTentativeCode;
            Hex maskedImportedData;
            Protocol pOld = p;
            p = tryit;
            System.err.println("Checking protocol " + p.getDiagnosticName());
            if (!this.remote.supportsVariant(pid, p.getVariantName()) && !p.hasCode(this.remote)) {
                p = pOld;
                continue;
            }
            int n = fixedDataLength;
            if (cmdLength == 0) {
                n = p.getFixedDataLength();
                fixedData = new short[n];
                if (fixedDataOffset + n > code.length) {
                    System.err.println("Number of fixed bytes for protocol " + p.getDiagnosticName() + " is not compatible with upgrade data");
                    fixedDataHex = new Hex(fixedData);
                    continue;
                }
                System.arraycopy(code, fixedDataOffset, fixedData, 0, n);
                fixedDataHex = new Hex(fixedData);
            } else if (cmdLength != p.getDefaultCmdLength() || fixedDataLength != p.getFixedDataLength()) {
                if (isBuiltIn) {
                    if (matchLenCount < 0) {
                        matchLenCount = 0;
                        for (Protocol pTest : protocols) {
                            if (cmdLength != pTest.getDefaultCmdLength() || fixedDataLength != pTest.getFixedDataLength()) continue;
                            ++matchLenCount;
                        }
                    }
                    if (matchLenCount > 0) {
                        p = pOld;
                        continue;
                    }
                    if (!this.inconsistent) {
                        Value[] title = "Protocol Variant Error";
                        String message = "Error in RDF.  Wrong variant specified for PID = " + pid + ".  Number of fixed/command bytes\nshould be " + fixedDataLength + "/" + cmdLength + ", for specified variant it is " + p.getFixedDataLength() + "/" + p.getDefaultCmdLength() + ".";
                        JOptionPane.showMessageDialog(null, message, (String)title, 2);
                    }
                }
                System.err.println("Command or fixed data length doesn't match!");
                p = pOld;
                continue;
            }
            System.err.println("Imported fixedData is " + fixedDataHex);
            vals = p.importFixedData(fixedDataHex);
            System.err.print("Imported device parms are:");
            for (Value v : vals) {
                System.err.print(" " + v.getValue());
            }
            System.err.println();
            Hex calculatedFixedData = p.getFixedData(vals);
            System.err.println("Calculated fixedData is " + calculatedFixedData);
            Hex mask = p.getFixedDataMask();
            Hex maskedCalculatedData = calculatedFixedData.applyMask(mask);
            if (!maskedCalculatedData.equals(maskedImportedData = fixedDataHex.applyMask(mask))) continue;
            System.err.println("It's a match!");
            Hex tentativeCode = this.getCode(p);
            Hex hex = oldTentativeCode = tentative == null ? null : this.getCode(tentative);
            if (tentative == null || n > tentative.getFixedDataLength() || pCode != null && pCode.equals(tentativeCode) && !tentativeCode.equals(oldTentativeCode)) {
                if (tentative != null) {
                    if (n > tentative.getFixedDataLength()) {
                        System.err.println("And it matches on a longer set of fixed data!");
                    } else {
                        System.err.println("And its code matches the protocol upgrade code!");
                    }
                }
                tentative = p;
                tentativeVals = vals;
                continue;
            }
            if (tentative == null || tentativeCode == null || !tentativeCode.equals(oldTentativeCode) || p.getOEMParmVariance(vals) >= tentative.getOEMParmVariance(tentativeVals)) continue;
            System.err.println(String.format("And protocol code is identical but better match on OEM or Parm parameters (variance %d instead of %d)", p.getOEMParmVariance(vals), tentative.getOEMParmVariance(tentativeVals)));
            tentative = p;
            tentativeVals = vals;
        }
        if (cmdLength == 0) {
            System.err.println("Calculating default fixed data and command lengths");
            int dataLength = hexCode.length() - fixedDataOffset;
            cmdLength = buttons.size() > 0 ? dataLength / buttons.size() : 1;
            fixedDataLength = dataLength - cmdLength * buttons.size();
            System.err.println("Calculated: Fixed data length = " + fixedDataLength + ", Command length = " + cmdLength);
        }
        ManualProtocol mp = null;
        if (tentative != null) {
            int pLen;
            int n;
            p = tentative;
            System.err.println("Using " + p.getDiagnosticName());
            fixedDataLength = p.getFixedDataLength();
            cmdLength = p.getDefaultCmdLength();
            this.parmValues = tentativeVals;
            ProtocolUpgrade newProtocolUpgrade = null;
            isBuiltIn = ProtocolManager.getProtocolManager().getBuiltinProtocolsForRemote(this.remote, pid).contains(p);
            if (!isBuiltIn && !p.getID(this.remote, false).equals(pid)) {
                p.setAltPID(this.remote, pid);
            }
            if (pCode != null && this.remote.doForceEvenStarts() && this.getCode(p) != null && (n = (pLen = pCode.length()) - this.getCode(p).length()) > 0 && n < this.remote.getForceModulus() && pCode.subHex(0, pLen - n).equals(this.getCode(p))) {
                pCode = pCode.subHex(0, pLen - n);
            }
            if (pCode != null && (!pCode.equals(this.getCode(p)) || isBuiltIn)) {
                if (this.remoteConfig != null) {
                    if (!isBuiltIn) {
                        for (ProtocolUpgrade protocolUpgrade : this.remoteConfig.getProtocolUpgrades()) {
                            if (protocolUpgrade.getPid() != pid.get(0) || !protocolUpgrade.getCode().equals(this.getCode(p))) continue;
                            newProtocolUpgrade = protocolUpgrade;
                            this.remoteConfig.protocolUpgradeUsed = protocolUpgrade;
                            break;
                        }
                    }
                    if (newProtocolUpgrade == null) {
                        String proc = this.remote.getProcessor().getEquivalentName();
                        for (ProtocolUpgrade pu : this.remoteConfig.getProtocolUpgrades()) {
                            if (pu.getPid() != pid.get(0) || Protocol.getFixedDataLengthFromCode(proc, pu.getCode()) != p.getFixedDataLength() || Protocol.getCmdLengthFromCode(proc, pu.getCode()) != p.getDefaultCmdLength()) continue;
                            this.remoteConfig.protocolUpgradeUsed = pu;
                            pCode = pu.getCode();
                            break;
                        }
                    }
                }
                if (newProtocolUpgrade == null) {
                    System.err.println("Protocol code doesn't match or protocol is built-in. Setting custom code.");
                    p.addCustomCode(this.remote.getProcessor(), pCode);
                }
            } else if (pCode == null && !isBuiltIn) {
                p.addCustomCode(this.remote.getProcessor(), new Hex());
            }
        } else if (p != null && pCode == null) {
            System.err.println("Creating a derived protocol");
            Properties props = new Properties();
            for (Processor pr : ProcessorManager.getProcessors()) {
                Hex hCode = p.getCode(pr);
                if (hCode == null) continue;
                props.put("Code." + pr.getEquivalentName(), hCode.toString());
            }
            variant = p.getVariantName();
            if (variant != null && variant.length() > 0) {
                props.put("VariantName", variant);
            }
            p = ProtocolFactory.createProtocol("pid: " + pid.toString(), pid, "Protocol", props);
            ProtocolManager.getProtocolManager().add(p);
            fixedDataLength = p.getFixedDataLength();
            cmdLength = p.getDefaultCmdLength();
            this.parmValues = p.importFixedData(fixedDataHex);
        } else if (isBuiltIn) {
            List<String> variants = this.remote.getSupportedVariantNames(pid);
            variant = variants.get(0);
            if (!protocols.isEmpty()) {
                variants.remove(variant);
                variant = "???";
                variants.add(variant);
            }
            p = ProtocolManager.getProtocolManager().createMissingProtocol(pid, variant, fixedDataLength, cmdLength);
            fixedData = new short[fixedDataLength];
            System.arraycopy(code, fixedDataOffset, fixedData, 0, fixedDataLength);
            fixedDataHex = new Hex(fixedData);
            this.parmValues = p.importFixedData(fixedDataHex);
        } else {
            if (pCode == null) {
                pCode = new Hex();
            }
            System.err.println("Using a Manual Protocol");
            fixedData = new short[fixedDataLength];
            System.arraycopy(code, fixedDataOffset, fixedData, 0, fixedDataLength);
            int cmdType = 0;
            if (cmdLength == 2) {
                cmdType = 2;
            }
            if (cmdLength > 2) {
                cmdType = cmdLength << 4;
            }
            ArrayList<Value> parms = new ArrayList<Value>();
            for (short temp : fixedData) {
                parms.add(new Value(temp & 0xFF));
            }
            this.parmValues = parms.toArray(new Value[fixedDataLength]);
            String string = ManualProtocol.getDefaultName(pid);
            mp = new ManualProtocol(string, pid, cmdType, "MSB", 8, parms, new short[0], 8);
            mp.setCode(pCode, this.remote.getProcessor());
            ProtocolManager.getProtocolManager().add(mp);
            p = mp;
        }
        if (digitMapIndex != -1) {
            void var27_49;
            short mapNum = this.remote.getDigitMaps()[digitMapIndex];
            Hex[] hexCmds = DigitMaps.getHexCmds(mapNum, cmdLength);
            boolean bl = false;
            while (var27_49 < hexCmds.length) {
                Function f = new Function();
                String name = Integer.toString((int)var27_49);
                f.setName(name);
                f.setUpgrade(this);
                Hex hex = hexCmds[var27_49];
                if (cmdLength < hex.length()) {
                    hex = hex.subHex(0, cmdLength);
                }
                f.setHex(hex);
                Button b = map.get((int)var27_49);
                this.assignments.assign(b, f);
                this.functions.add(f);
                ++var27_49;
            }
        }
        int index2 = (index += fixedDataLength) + cmdLength * buttons.size();
        this.protocol = p;
        for (Button button : buttons) {
            int btnSerial;
            String name;
            if (index + cmdLength - 1 >= code.length) break;
            short[] cmd = new short[cmdLength];
            for (int i = 0; i < cmdLength; ++i) {
                cmd[i] = code[index++];
            }
            String string = name = this.remote.usesEZRC() ? this.buttonRestriction.getGeneralFunction(button).getName() : null;
            if (name == null) {
                name = button.getName();
            }
            Function f = null;
            int gid = -1;
            if (this.remote.usesEZRC() && index2 < code.length - 1) {
                gid = Hex.get(code, index2);
                index2 += 2;
                f = this.keyGidMap.get(gid);
                if (gid == 0 || f != null && Hex.equals(f.getHex().getData(), cmd)) {
                    int newGID;
                    gid = newGID = this.getGidForName(name);
                    f = null;
                }
            }
            if (f == null) {
                f = new Function(name);
                f.setHex(new Hex(cmd));
                f.setUpgrade(this);
                if (gid >= 0) {
                    f.setGid(gid);
                    this.keyGidMap.put(gid, f);
                    if (this.remoteConfig != null) {
                        this.remoteConfig.addGid(name, gid);
                    }
                }
            }
            int n = btnSerial = this.remote.getSystemButtons() != null ? this.remote.getSystemButtons().indexOf(button) : -1;
            if (btnSerial >= 0) {
                this.functionMap.put(btnSerial, f);
                f.setSerial(btnSerial);
            } else {
                this.assignments.assign(button, f);
            }
            if (this.functions.contains(f)) continue;
            this.functions.add(f);
        }
    }

    public short[] getHexSetupCode() {
        DeviceType devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName);
        short[] id = this.protocol.getID(this.remote).getData();
        short temp = (short)(devType.getNumber() * 4096 + this.setupCode - this.remote.getDeviceCodeOffset());
        if (!this.remote.usesTwoBytePID()) {
            temp = (short)(temp + (id[0] & 1) * 2048);
        }
        short[] rc = new short[]{(short)(temp >> 8 & 0xFF), (short)(temp & 0xFF)};
        return rc;
    }

    public int getHexSetupCodeValue() {
        short[] hexCode = this.getHexSetupCode();
        return (hexCode[0] << 8) + hexCode[1];
    }

    public List<KeyMove> getKeyMoves() {
        return this.getKeyMoves(-1);
    }

    public List<KeyMove> getKeyMoves(int deviceButtonIndex) {
        ArrayList<KeyMove> keyMoves = new ArrayList<KeyMove>();
        if (this.protocol == null) {
            return keyMoves;
        }
        DeviceType devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName);
        for (Button button : this.remote.getUpgradeButtons()) {
            Function f = this.assignments.getAssignment(button, 0);
            KeyMove keyMove = button.getKeyMove(f, 0, this.setupCode, devType, this.remote, this.protocol.getKeyMovesOnly());
            if (keyMove != null) {
                keyMoves.add(keyMove);
                keyMove.setNotes(f.getNotes());
                if (deviceButtonIndex >= 0) {
                    keyMove.setHighlight(this.getAssignmentColor(button.getKeyCode(0), deviceButtonIndex));
                }
            }
            f = this.assignments.getAssignment(button, 1);
            if (button.getShiftedButton() != null) {
                f = null;
            }
            if ((keyMove = button.getKeyMove(f, this.remote.getShiftMask(), this.setupCode, devType, this.remote, this.protocol.getKeyMovesOnly())) != null) {
                keyMoves.add(keyMove);
                keyMove.setNotes(f.getNotes());
                if (deviceButtonIndex >= 0) {
                    keyMove.setHighlight(this.getAssignmentColor(button.getKeyCode(1), deviceButtonIndex));
                }
            }
            f = this.assignments.getAssignment(button, 2);
            if (button.getXShiftedButton() != null) {
                f = null;
            }
            if ((keyMove = button.getKeyMove(f, this.remote.getXShiftMask(), this.setupCode, devType, this.remote, this.protocol.getKeyMovesOnly())) == null) continue;
            keyMoves.add(keyMove);
            keyMove.setNotes(f.getNotes());
            if (deviceButtonIndex < 0) continue;
            keyMove.setHighlight(this.getAssignmentColor(button.getKeyCode(2), deviceButtonIndex));
        }
        return keyMoves;
    }

    public String getUpgradeText() {
        int i;
        StringBuilder buff = new StringBuilder(400);
        if (this.remote.usesTwoBytePID()) {
            buff.append("Upgrade Code2 = ");
        } else {
            buff.append("Upgrade Code 0 = ");
        }
        short[] deviceCode = this.getHexSetupCode();
        buff.append(Hex.toString(deviceCode));
        buff.append(" (");
        buff.append(this.devTypeAliasName);
        buff.append('/');
        DecimalFormat df = new DecimalFormat("0000");
        buff.append(df.format(this.setupCode));
        buff.append(")");
        String descr = "";
        if (this.description != null) {
            descr = this.description.trim();
        }
        if (descr.length() != 0) {
            buff.append(' ');
            buff.append(descr);
        }
        buff.append(" (RMDU ");
        buff.append(RemoteMaster.getDisplayVersion());
        buff.append(')');
        try {
            BufferedReader rdr = new BufferedReader(new StringReader(Hex.toString(this.getUpgradeHex().getData(), 16)));
            String line = null;
            while ((line = rdr.readLine()) != null) {
                buff.append("\n ");
                buff.append(line);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        DeviceType devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName);
        ButtonMap map = devType.getButtonMap();
        Button[] buttons = this.remote.getUpgradeButtons();
        boolean hasKeyMoves = false;
        for (i = 0; i < buttons.length; ++i) {
            Button b = buttons[i];
            Function f = this.assignments.getAssignment(b, 0);
            Function sf = this.assignments.getAssignment(b, 1);
            if (b.getShiftedButton() != null) {
                sf = null;
            }
            Function xf = this.assignments.getAssignment(b, 2);
            if (b.getXShiftedButton() != null) {
                xf = null;
            }
            if ((f == null || map != null && !this.protocol.getKeyMovesOnly() && map.isPresent(b) && !f.isExternal()) && (sf == null || sf.getHex() == null) && (xf == null || xf.getHex() == null)) continue;
            hasKeyMoves = true;
            break;
        }
        if (hasKeyMoves && this.remote.hasKeyMoveSupport()) {
            deviceCode[0] = (short)(deviceCode[0] & 0xF7);
            buff.append("\nKeyMoves");
            boolean first = true;
            while (i < buttons.length) {
                Button button = buttons[i];
                Function f = this.assignments.getAssignment(button, 0);
                first = this.appendKeyMove(buff, button.getKeyMove(f, 0, deviceCode, devType, this.remote, this.protocol.getKeyMovesOnly()), f, first);
                f = this.assignments.getAssignment(button, 1);
                if (button.getShiftedButton() != null) {
                    f = null;
                }
                first = this.appendKeyMove(buff, button.getKeyMove(f, this.remote.getShiftMask(), deviceCode, devType, this.remote, this.protocol.getKeyMovesOnly()), f, first);
                f = this.assignments.getAssignment(button, 2);
                if (button.getXShiftedButton() != null) {
                    f = null;
                }
                first = this.appendKeyMove(buff, button.getKeyMove(f, this.remote.getXShiftMask(), deviceCode, devType, this.remote, this.protocol.getKeyMovesOnly()), f, first);
                ++i;
            }
        }
        buff.append("\nEnd");
        return buff.toString();
    }

    public int getUpgradeLength() {
        short[] data;
        DeviceType devType;
        ButtonMap map;
        int rc = 0;
        ++rc;
        if (this.remote.usesTwoBytePID()) {
            ++rc;
        }
        int digitMapIndex = -1;
        if (!this.remote.getOmitDigitMapByte()) {
            ++rc;
            digitMapIndex = this.findDigitMapIndex();
        }
        if ((map = (devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName)).getButtonMap()) != null) {
            rc += map.toBitMap(digitMapIndex != -1, this.protocol.getKeyMovesOnly(), this.assignments).length;
        }
        rc += this.protocol.getFixedData(this.parmValues).length();
        if (map != null && (data = map.toCommandList(digitMapIndex != -1, this.protocol.getKeyMovesOnly(), this.assignments)) != null) {
            rc += data.length;
            if (this.remote.usesEZRC()) {
                rc += map.getIndexList().length;
            }
        }
        return rc;
    }

    public Hex getUpgradeHex() {
        DeviceType devType;
        ButtonMap map;
        ArrayList<short[]> work = new ArrayList<short[]>();
        short[] data = null;
        data = this.remote.usesTwoBytePID() ? this.protocol.getID(this.remote).getData() : new short[]{this.protocol.getID(this.remote).getData()[1]};
        work.add(data);
        short digitMapIndex = -1;
        if (!this.remote.getOmitDigitMapByte()) {
            digitMapIndex = this.findDigitMapIndex();
            data = new short[]{digitMapIndex == -1 ? (short)0 : digitMapIndex};
            work.add(data);
        }
        if (this.remote.getSystemButtons() != null) {
            List<Button> sysBtns = this.remote.getSystemButtons();
            for (int i : this.functionMap.keySet()) {
                Function f = this.functionMap.get(i);
                Button b = sysBtns.get(i);
                this.assignments.getAssignedFunctions()[b.getKeyCode()] = f;
            }
        }
        if ((map = (devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName)).getButtonMap()) != null) {
            work.add(map.toBitMap(digitMapIndex != -1, this.protocol.getKeyMovesOnly(), this.assignments));
        }
        work.add(this.protocol.getFixedData(this.parmValues).getData());
        if (map != null) {
            data = map.toCommandList(digitMapIndex != -1, this.protocol.getKeyMovesOnly(), this.assignments);
            if (data != null && data.length != 0) {
                work.add(data);
                if (this.remote.usesEZRC()) {
                    work.add(map.getIndexList());
                }
            }
            this.mappedButtons = map.getButtonList();
        }
        int length = 0;
        for (short[] temp : work) {
            length += temp.length;
        }
        int offset = 0;
        short[] rc = new short[length];
        for (short[] source : work) {
            System.arraycopy(source, 0, rc, offset, source.length);
            offset += source.length;
        }
        if (this.remote.getSystemButtons() != null) {
            for (Button b : this.remote.getSystemButtons()) {
                this.assignments.getAssignedFunctions()[b.getKeyCode()] = null;
            }
        }
        return new Hex(rc);
    }

    private boolean appendKeyMove(StringBuilder buff, short[] keyMove, Function f, boolean first) {
        if (keyMove == null || keyMove.length == 0) {
            return first;
        }
        if (!first) {
            buff.append('\u00a6');
        }
        buff.append("\n ");
        buff.append(Hex.toString(keyMove));
        buff.append('\u00ab');
        buff.append(f.getName());
        String notes = f.getNotes();
        if (notes != null && notes.length() != 0) {
            buff.append(": ");
            buff.append(notes);
        }
        buff.append('\u00bb');
        return false;
    }

    public void store() throws IOException {
        this.store(this.file);
    }

    public static String valueArrayToString(Value[] parms) {
        StringBuilder buff = new StringBuilder(200);
        for (int i = 0; i < parms.length; ++i) {
            Value parm;
            if (i > 0) {
                buff.append(' ');
            }
            if ((parm = parms[i]) == null) {
                buff.append("null");
                continue;
            }
            buff.append(parms[i].getUserValue());
        }
        return buff.toString();
    }

    public static Value[] stringToValueArray(String str) {
        StringTokenizer st = new StringTokenizer(str);
        Value[] parms = new Value[st.countTokens()];
        for (int i = 0; i < parms.length; ++i) {
            String token = st.nextToken();
            Integer val = null;
            if (!token.equals("null")) {
                val = token.equals("true") ? new Integer(1) : (token.equals("false") ? new Integer(0) : Integer.valueOf(Integer.parseInt(token)));
            }
            parms[i] = new Value(val, null);
        }
        return parms;
    }

    public void store(File file) throws IOException {
        this.file = file;
        StringWriter sw = new StringWriter();
        PropertyWriter pw = new PropertyWriter(new PrintWriter(sw));
        this.store(pw, this.remote.usesEZRC());
        pw.close();
        this.baseline = sw.toString();
        FileWriter fw = new FileWriter(file);
        fw.write(this.baseline);
        fw.flush();
        fw.close();
    }

    @Override
    public void store(PropertyWriter out) {
        this.store(out, false);
    }

    public void store(PropertyWriter out, boolean dataOnly) {
        if (this.description != null) {
            out.print("Description", this.description);
        }
        out.print("Remote.name", this.remote.getName());
        out.print("Remote.signature", this.remote.getSignature());
        super.store(out);
        out.print("DeviceType", this.devTypeAliasName);
        DeviceType devType = this.remote.getDeviceTypeByAliasName(this.devTypeAliasName);
        out.print("DeviceIndex", Integer.toHexString(devType.getNumber()));
        if (this.usesSerial) {
            out.print("Serial", Integer.toString(this.setupCode));
        } else {
            out.print("SetupCode", Integer.toString(this.setupCode));
        }
        if (this.buttonRestriction != null && this.buttonRestriction != DeviceButton.noButton && this.buttonRestriction.getFavoriteWidth() > 0) {
            out.print("FavWidth", this.buttonRestriction.getFavoriteWidth());
            Button favFinalKey = this.buttonRestriction.getFavFinalKey();
            if (favFinalKey != null && favFinalKey != Button.noButton) {
                out.print("FinalKey", this.buttonRestriction.getFavFinalKey().getKeyCode());
            }
        }
        if (!this.buttonIndependent.booleanValue()) {
            out.print("ButtonIndependent", "false");
        }
        if (this.buttonRestriction.getButtonIndex() != -1) {
            out.print("ButtonIndex", this.buttonRestriction.getButtonIndex());
        }
        try {
            if (this.protocol != null) {
                this.protocol.store(out, this.parmValues, this.remote);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.isRfUpgrade() && this.extraData != null) {
            out.print("ExtraData", this.extraData);
        }
        int i = 0;
        for (Function function : this.functions) {
            if (dataOnly && function.getSerial() >= 0) continue;
            function.setRmirIndex(i);
            function.store(out, "Function." + i++);
        }
        i = 0;
        for (ExternalFunction externalFunction : this.extFunctions) {
            externalFunction.store(out, "ExtFunction." + i++);
        }
        ArrayList<Button> buttons = new ArrayList<Button>(Arrays.asList(this.remote.getUpgradeButtons()));
        if (this.remote.usesEZRC() && this.remote.getSystemButtons() != null) {
            buttons.addAll(this.remote.getSystemButtons());
        }
        String string = "\\|";
        String replace = "\\\\u007c";
        for (i = 0; i < buttons.size(); ++i) {
            int index;
            Button b = (Button)buttons.get(i);
            Function f = this.assignments.getAssignment(b, 0);
            String fstr = f == null ? "null" : (this.remote.usesEZRC() ? ((index = f.getRmirIndex()) >= 0 ? "Function." + index : "null") : f.getName().replaceAll(string, replace));
            Function sf = this.assignments.getAssignment(b, 1);
            String sstr = sf == null ? "null" : sf.getName().replaceAll(string, replace);
            Function xf = this.assignments.getAssignment(b, 2);
            String xstr = xf == null ? null : xf.getName().replaceAll(string, replace);
            String sName = null;
            String iconStr = null;
            GeneralFunction gf = null;
            if (this.buttonRestriction != null && (gf = this.buttonRestriction.getGeneralFunction(b)) != null) {
                Macro macro;
                String fName = null;
                if (this.macroMap != null && (macro = this.macroMap.get(b.getKeyCode())) != null && macro.isSystemMacro()) {
                    fName = macro.getItems().get(0).getGeneralFunction().getName();
                }
                if (fName == null && f != null) {
                    fName = f.getName();
                }
                String bName = gf.getName();
                GeneralFunction.RMIcon icon = gf.icon;
                if (bName != null && fName != null && !bName.equals(fName)) {
                    sName = bName.replaceAll(string, replace);
                }
                String string2 = iconStr = icon != null && icon.ref != 0 ? "Icon." + icon.ref : null;
            }
            if (f == null && sf == null && xf == null && sName == null && iconStr == null) continue;
            String val = null;
            if (this.remote.usesEZRC()) {
                val = fstr;
                if (sName != null) {
                    val = val + "|" + sName;
                }
                if (iconStr != null) {
                    val = val + (sName == null ? "|null|" + iconStr : "|" + iconStr);
                }
            } else {
                val = fstr + '|' + sstr + '|' + xstr;
            }
            if (val.equals("null")) continue;
            out.print("Button." + Integer.toHexString(b.getKeyCode()), val);
        }
        try {
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setBaseline() {
        if (this.skipProtocol) {
            return;
        }
        StringWriter sw = new StringWriter();
        this.store(new PropertyWriter(new PrintWriter(sw)));
        this.baseline = sw.toString();
    }

    public boolean hasChanged() throws IOException {
        StringWriter sw = new StringWriter();
        this.store(new PropertyWriter(new PrintWriter(sw)));
        String latest = sw.toString();
        BufferedReader baseReader = new BufferedReader(new StringReader(this.baseline));
        BufferedReader tempReader = new BufferedReader(new StringReader(latest));
        String baseLine = null;
        String tempLine = null;
        do {
            baseLine = baseReader.readLine();
            while (baseLine != null && baseLine.startsWith("#")) {
                baseLine = baseReader.readLine();
            }
            tempLine = tempReader.readLine();
            while (tempLine != null && tempLine.startsWith("#")) {
                tempLine = tempReader.readLine();
            }
            System.err.println("baseLine=" + baseLine);
            System.err.println("tempLine=" + tempLine);
        } while (baseLine != null && tempLine != null && baseLine.equals(tempLine));
        baseReader.close();
        tempReader.close();
        return baseLine != tempLine;
    }

    public void load(File file) throws Exception {
        this.load(file, true);
    }

    public void load(File file, boolean loadButtons) throws Exception {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        this.load(reader, loadButtons);
        if (file.getName().toLowerCase().endsWith(".rmdu")) {
            this.file = file;
        }
    }

    public void load(BufferedReader reader) throws Exception {
        this.load(reader, true);
    }

    public void load(BufferedReader reader, boolean loadButtons) throws Exception {
        reader.mark(160);
        String line = reader.readLine();
        reader.reset();
        if (line.startsWith("Name:")) {
            this.reset();
            this.importUpgrade(reader, loadButtons);
        } else {
            Properties props = new Properties();
            Property property = new Property();
            PropertyReader pr = new PropertyReader(reader);
            while ((property = pr.nextProperty()) != null) {
                props.put(property.name, property.value);
            }
            reader.close();
            this.load(props, loadButtons);
        }
        this.setBaseline();
    }

    public void load(Properties props, boolean loadButtons) {
        this.load(props, true, null, null);
    }

    public void load(Properties props, boolean loadButtons, Remote theRemote, LinkedHashMap<GeneralFunction, Integer> iconrefMap) {
        Function f;
        String temp;
        this.reset();
        String str = props.getProperty("Description");
        if (str != null) {
            this.description = str;
        }
        if ((str = props.getProperty("Remote.name")) == null) {
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The upgrade you are trying to import is not valid!  It does not contain a value for Remote.name", "Import Failure", 0);
            this.reset();
            return;
        }
        if (theRemote != null) {
            this.remote = theRemote;
        } else {
            Remote.prelimLoad = true;
            theRemote = RemoteManager.getRemoteManager().findRemoteByName(str);
            Remote.prelimLoad = false;
            if (theRemote == null) {
                this.reset();
                return;
            }
            this.remote = theRemote;
        }
        this.remote.load();
        if (this.remote.usesEZRC() && this.macroMap == null) {
            this.macroMap = new LinkedHashMap();
            this.learnedMap = new LinkedHashMap();
            this.functionMap = new LinkedHashMap();
            this.selectorMap = new LinkedHashMap();
            this.keyGidMap = new LinkedHashMap();
        }
        this.setSegmentFlags((str = props.getProperty("SegmentFlags")) == null ? 0 : Integer.parseInt(str));
        str = props.getProperty("DeviceIndex");
        if (str != null) {
            // empty if block
        }
        this.setDeviceTypeAliasName(props.getProperty("DeviceType"));
        str = props.getProperty("SetupCode");
        if (str != null) {
            this.setupCode = Integer.parseInt(str);
            this.usesSerial = false;
        }
        if ((str = props.getProperty("Serial")) != null) {
            this.setupCode = Integer.parseInt(str);
            this.usesSerial = true;
        }
        if (this.remoteConfig != null) {
            this.buttonIndependent = this.remote.hasDeviceDependentUpgrades() > 0 ? Boolean.valueOf((str = props.getProperty("ButtonIndependent")) != null ? Boolean.parseBoolean(str) : true) : Boolean.valueOf(true);
            this.buttonRestriction = DeviceButton.noButton;
            str = props.getProperty("ButtonIndex");
            if (str != null) {
                try {
                    int index = Integer.parseInt(str);
                    this.buttonRestriction = this.remote.getDeviceButton(index);
                    this.buttonRestriction.setUpgrade(this);
                    str = props.getProperty("FavWidth");
                    if (str != null) {
                        Button finalKey;
                        this.buttonRestriction.setFavoritewidth(Integer.parseInt(str));
                        str = props.getProperty("FinalKey");
                        if (str != null && (finalKey = this.remote.getButton(Integer.parseInt(str))) != null) {
                            this.buttonRestriction.setFavFinalKey(finalKey);
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace(System.err);
                }
            }
        } else {
            this.buttonIndependent = true;
            this.buttonRestriction = DeviceButton.noButton;
        }
        if (props.getProperty("Protocol") != null || !this.remote.usesEZRC()) {
            Hex pid = new Hex(props.getProperty("Protocol", "0200"));
            String name = props.getProperty("Protocol.name", "");
            String variantName = props.getProperty("Protocol.variantName", "");
            ProtocolManager pm = ProtocolManager.getProtocolManager();
            ProtocolManager.QualifiedID qid = pm.getCurrentQID(pid, variantName);
            pid = qid.pid;
            variantName = qid.variantName;
            if (name.startsWith("Manual Settings") || name.equals("Manual") || name.equalsIgnoreCase("PID " + pid.toString())) {
                ManualProtocol mp = new ManualProtocol(pid, props);
                mp.setName(name);
                this.protocol = this.testManualProtocol(mp);
                if (this.protocol == mp) {
                    pm.add(this.protocol);
                }
                str = props.getProperty("ProtocolParms");
                System.err.println("ProtocolParms='" + str + "'");
                if (str != null && str.length() != 0) {
                    this.protocol.setDeviceParms(DeviceUpgrade.stringToValueArray(str));
                    this.parmValues = this.protocol.getDeviceParmValues();
                }
            } else {
                this.protocol = pm.findNearestProtocol(this.remote, name, pid, variantName);
                if (this.protocol == null && this.remote.supportsVariant(pid, variantName)) {
                    int cmdLength = 0;
                    int fixedDataLength = 0;
                    String temp2 = props.getProperty("Function.0.hex");
                    if (temp2 != null && temp2.length() != 0) {
                        cmdLength = new Hex(temp2).length();
                    }
                    if ((temp2 = props.getProperty("FixedData")) != null && temp2.length() != 0) {
                        fixedDataLength = new Hex(temp2).length();
                    }
                    if (cmdLength > 0) {
                        this.protocol = pm.createMissingProtocol(pid, variantName, fixedDataLength, cmdLength);
                    }
                }
                if (this.protocol == null) {
                    JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "No protocol found with name=\"" + name + "\", ID=" + pid.toString() + ", and variantName=\"" + variantName + "\"", "File Load Error", 0);
                    this.reset();
                    return;
                }
                if (!this.skipProtocol) {
                    str = props.getProperty("ProtocolParms");
                    System.err.println("ProtocolParms='" + str + "'");
                    if (str != null && str.length() != 0) {
                        this.protocol.setDeviceParms(DeviceUpgrade.stringToValueArray(str));
                        this.parmValues = this.protocol.getDeviceParmValues();
                    }
                }
                if (this.protocolInUse() == null) {
                    Hex altPID = new Hex(props.getProperty("Protocol.altPID", ""));
                    this.protocol.setAltPID(this.remote, altPID);
                    this.protocol.setProperties(props, this.remote);
                } else {
                    Protocol p = this.testStandardProtocol(this.protocol, props);
                    if (p != null) {
                        this.protocol = p;
                    } else {
                        return;
                    }
                }
            }
            if (this.protocolInUse() == null && !this.protocol.getID(this.remote, false).equals(pid)) {
                this.protocol.setAltPID(this.remote, pid);
            }
            if (this.remote.getSegmentTypes() != null) {
                this.sizeCmdBytes = this.protocol.getDefaultCmdLength();
                this.sizeDevBytes = this.protocol.getFixedDataLength();
            }
        }
        if ((temp = props.getProperty("ExtraData")) != null && temp.length() > 0) {
            this.extraData = new Hex(temp);
        }
        this.notes = props.getProperty("Notes");
        System.err.println("Loading functions for device upgrade " + this.devTypeAliasName + "/" + new SetupCode(this.setupCode).toString());
        this.functions.clear();
        this.swapList = null;
        LinkedHashMap<Integer, Integer> macroXRef = new LinkedHashMap<Integer, Integer>();
        int i = 0;
        while (true) {
            Integer macroref;
            if ((macroref = (f = new Function()).load(props, "Function." + i)) != null) {
                macroXRef.put(i, macroref);
            }
            if (this.remote.usesEZRC()) {
                if (f.getGid() != null) {
                    Function ff = this.keyGidMap.get(f.getGid());
                    if (f.getGid() == 0 || ff != null && f.getHex() != null && !f.getHex().equals(ff.getHex())) {
                        int newGID = this.getGidForName(f.getName());
                        f.setGid(newGID);
                    } else {
                        this.keyGidMap.put(f.getGid(), f);
                        if (this.remoteConfig != null) {
                            this.remoteConfig.addGid(f.getName(), f.getGid());
                        }
                    }
                } else {
                    f.setGid(this.getGidForName(f.getName()));
                }
            }
            if (f.getSerial() >= 0) {
                if (this.remote.getSystemButtons() != null) {
                    Button b = null;
                    if (f.getSerial() >> 8 == 0) {
                        b = this.remote.getSystemButtons().get(f.getSerial());
                    } else {
                        b = this.remote.getButton(f.getSerial() & 0xFF);
                        f.setSerial(this.remote.getSystemButtons().indexOf(b));
                    }
                }
                this.functionMap.put(f.getSerial(), f);
            }
            if (f.getHex() != null) {
                if (this.currentSize == 0) {
                    this.currentSize = f.getHex().length();
                } else if (!this.inconsistent && this.currentSize != f.getHex().length()) {
                    this.inconsistent = true;
                }
            }
            temp = null;
            if (iconrefMap != null && (temp = props.getProperty("Function." + i + ".iconref")) != null) {
                iconrefMap.put(f, Integer.parseInt(temp));
            }
            if (f.isEmpty()) break;
            if (this.getFunction(f.getName(), this.functions) != null) {
                System.err.println("Warning:  multiple functions with name " + f.getName());
            }
            f.setRmirIndex(i);
            f.setUpgrade(this);
            this.functions.add(f);
            ++i;
        }
        if (this.inconsistent) {
            String devName = this.buttonRestriction.getName();
            String title = "Inconsistent upgrade";
            String message = "Upgrade " + devName + " has inconsistent command lengths.";
            JOptionPane.showMessageDialog(null, message, title, 2);
        }
        this.extFunctions.clear();
        i = 0;
        while (true) {
            f = new ExternalFunction();
            ((ExternalFunction)f).load(props, "ExtFunction." + i, this.remote);
            if (((ExternalFunction)f).isEmpty()) break;
            this.extFunctions.add((ExternalFunction)f);
            ++i;
        }
        if (loadButtons) {
            ArrayList<Button> buttons = new ArrayList<Button>(Arrays.asList(this.remote.getUpgradeButtons()));
            List<Button> sysBtns = null;
            if (this.remote.usesEZRC() && (sysBtns = this.remote.getSystemButtons()) != null) {
                buttons.addAll(sysBtns);
            }
            String regex = "\\\\u007c";
            String replace = "|";
            for (i = 0; i < buttons.size(); ++i) {
                Button b = (Button)buttons.get(i);
                str = props.getProperty("Button." + Integer.toHexString(b.getKeyCode()));
                if (str == null) continue;
                StringTokenizer st = new StringTokenizer(str, "|");
                str = st.nextToken();
                Function func = null;
                if (!str.equals("null")) {
                    if (this.remote.usesEZRC() && str.startsWith("Function.")) {
                        int rmirIndex = Integer.parseInt(str.substring(9));
                        func = this.getFunctionByRmirIndex(rmirIndex);
                        Integer macroref = (Integer)macroXRef.get(rmirIndex);
                        if (macroref != null) {
                            for (Macro macro : this.remoteConfig.getMacros()) {
                                if (macro.getSerial() != macroref.intValue()) continue;
                                if (macro.getUserItems() == null) {
                                    macro.setUserItems(new ArrayList<Integer>());
                                }
                                int dbi = this.buttonRestriction.getButtonIndex();
                                short keyCode = b.getKeyCode();
                                macro.getUserItems().add(dbi << 16 | keyCode);
                                break;
                            }
                        }
                    } else {
                        func = this.getFunction(str.replaceAll(regex, replace));
                    }
                    if (sysBtns != null && sysBtns.contains(b)) {
                        int index = sysBtns.indexOf(b);
                        func.setSerial(index);
                        this.functionMap.put(index, func);
                    } else if (func != null) {
                        this.assignments.assign(b, func, 0);
                        if (this.remote.usesEZRC() && this.remote.isSoftButton(b) && this.buttonRestriction != null && this.buttonRestriction != DeviceButton.noButton) {
                            this.buttonRestriction.getGeneralFunction(b).setName(func.getName());
                        }
                    }
                }
                if (st.hasMoreTokens()) {
                    str = st.nextToken();
                    if (this.frame instanceof RMIRSetup && this.remote.usesEZRC() && !str.equals("null")) {
                        this.buttonRestriction.getGeneralFunction(b).setName(str.replaceAll(regex, replace));
                    } else if (!str.equals("null") && this.remote.getShiftEnabled()) {
                        func = this.getFunction(str.replaceAll(regex, replace));
                        this.assignments.assign(b, func, 1);
                    }
                }
                if (!st.hasMoreTokens()) continue;
                str = st.nextToken();
                if (this.remote.usesEZRC() && str.startsWith("Icon.")) {
                    int iconref = Integer.parseInt(str.substring(5));
                    iconrefMap.put(this.buttonRestriction.getGeneralFunction(b), iconref);
                    continue;
                }
                if (str.equals("null") || !this.remote.getXShiftEnabled()) continue;
                func = this.getFunction(str.replaceAll(regex, replace));
                this.assignments.assign(b, func, 2);
            }
        }
        if (iconrefMap != null) {
            LinkedHashMap<GeneralFunction, Integer> map = new LinkedHashMap<GeneralFunction, Integer>();
            ArrayList<GeneralFunction> gfList = new ArrayList<GeneralFunction>();
            for (GeneralFunction gf : iconrefMap.keySet()) {
                if (!(gf instanceof Function)) continue;
                gfList.add(gf);
                for (GeneralFunction.User u : gf.getUsers()) {
                    if (u.db == null || u.button == null || u.db.getGeneralFunction(u.button) == null) continue;
                    map.put(u.db.getGeneralFunction(u.button), iconrefMap.get(gf));
                }
            }
            iconrefMap.putAll(map);
            for (GeneralFunction gf : gfList) {
                iconrefMap.remove(gf);
            }
        }
        this.setBaseline();
    }

    public void importUpgrade(BufferedReader in) throws Exception {
        this.importUpgrade(in, true);
    }

    private boolean useEquivalent(Protocol pNew, Protocol pOld) {
        String title = "Protocol Identification";
        String message = "The manual protocol being imported, with name \"" + pNew.getName() + "\" and PID = " + pNew.getID() + "\nhas same binary code and translators as the existing protocol with name " + pOld.getName() + "\nand PID = " + pOld.getID() + ".\n\nDo you want to use the existing protocol?  Unless there are special reasons not to do so,\nyou should answer Yes.";
        return JOptionPane.showConfirmDialog(null, message, title, 0, 3) == 0;
    }

    private Protocol testStandardProtocol(Protocol protocol, Properties props) {
        Processor processor = this.remote.getProcessor();
        String str = props == null ? null : props.getProperty("CustomCode." + processor.getEquivalentName());
        Hex newCustomCode = str == null ? null : new Hex(str);
        Hex oldCustomCode = protocol.getCustomCode(processor);
        String title = "Custom Code";
        if (newCustomCode == null && oldCustomCode != null) {
            String message = "The protocol of this upgrade is already in use with custom code\nby an existing upgrade, but this upgrade uses the standard version.\n\nTo load this upgrade you must first convert the protocol of that\nupgrade to a Manual Protocol and then change its PID.  If you open\nthat upgrade you will find a button that performs this conversion.";
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 1);
            this.reset();
            return null;
        }
        if (newCustomCode != null && !newCustomCode.equals(oldCustomCode)) {
            String message = "The protocol of this upgrade has custom code and is already in use\nby an existing upgrade with either no or different custom code.\n\nIf you load this upgrade, the protocol will be loaded as an\nequivalent Manual Protocol.  Do you want to proceed?";
            if (JOptionPane.showConfirmDialog(RemoteMaster.getFrame(), message, title, 0, 3) == 0) {
                this.originalProtocol = Protocol.blank;
                this.convertedProtocol = protocol.convertToManual(this.remote, this.parmValues, newCustomCode);
                protocol = this.convertedProtocol;
                ProtocolManager.getProtocolManager().add(protocol);
                this.parmValues = protocol.getDeviceParmValues();
            } else {
                this.reset();
                return null;
            }
        }
        return protocol;
    }

    private Protocol testManualProtocol(ManualProtocol mp) {
        ProtocolManager pm = ProtocolManager.getProtocolManager();
        Protocol equiv = null;
        boolean nameInUse = false;
        Hex pid = mp.getID();
        String name = mp.getName();
        for (Protocol p : pm.getProtocolsForRemote(this.remote)) {
            if (!(p instanceof ManualProtocol)) continue;
            if (((ManualProtocol)p).equivalentForRemoteTo(mp, this.remote)) {
                if (p.getName().equals(name) && p.getID().equals(pid)) {
                    return p;
                }
                if (equiv == null) {
                    equiv = p;
                }
            }
            if (!p.getName().equals(name)) continue;
            nameInUse = true;
        }
        if (equiv != null && this.useEquivalent(mp, equiv)) {
            return equiv;
        }
        if (nameInUse) {
            String newName = ManualProtocol.getDefaultName(pid);
            String title = "Protocol Identification";
            String message = "There is already a manual protocol with name \"" + name + "\" but with\ndifferent binary code or translators, so the protocol being imported\nis being renamed as \"" + newName + "\"";
            JOptionPane.showMessageDialog(null, message, title, 1);
            mp.setName(newName);
        }
        return mp;
    }

    private static int parseInt(String str) {
        int base = 10;
        if (str.charAt(0) == '$') {
            base = 16;
            str = str.substring(1);
        } else if (str.charAt(str.length() - 1) == 'h') {
            base = 16;
            str = str.substring(0, str.length() - 1);
        }
        return Integer.parseInt(str, base);
    }

    public static boolean isRfPid(Hex pid) {
        int val = pid.get(0);
        return val >= 3000 && val <= 3049;
    }

    private String cleanName(String name) {
        if (name != null && name.length() == 5 && name.toLowerCase().startsWith("num ") && Character.isDigit(name.charAt(4))) {
            return name.substring(4);
        }
        return name;
    }

    private boolean isExternalFunctionName(String name) {
        if (name == null) {
            return false;
        }
        char firstChar = name.charAt(0);
        int slash = name.indexOf(47);
        int space = name.indexOf(32);
        if (space == -1) {
            space = name.length();
        }
        if (firstChar == '=' && slash > 1 && space > slash) {
            String devName = name.substring(1, slash);
            String setupString = name.substring(slash + 1, space);
            if (setupString.length() == 4) {
                try {
                    int setupCode = Integer.parseInt(setupString);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void importUpgrade(BufferedReader in, boolean loadButtons) throws Exception {
        String notes;
        String assignedName;
        String byte2;
        String funcName;
        int i;
        Object code;
        int equals;
        String line = in.readLine();
        String token = line.substring(0, 5);
        if (!token.equals("Name:")) {
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The upgrade you are trying to import is not valid!", "Import Failure", 0);
            return;
        }
        String delim = line.substring(5, 6);
        List<String> fields = LineTokenizer.tokenize(line, delim);
        this.description = fields.get(1);
        String kmVersion = fields.get(5);
        System.err.println("KM version of imported file is '" + kmVersion + '\'');
        String protocolLine = in.readLine();
        String manualLine = in.readLine();
        line = in.readLine();
        List<String> setupFields = LineTokenizer.tokenize(line, delim);
        token = setupFields.get(1);
        this.setupCode = Integer.parseInt(token);
        token = setupFields.get(2);
        String str = token.substring(5);
        Remote.prelimLoad = true;
        String rdfName = this.getRdfNameByKmName(str);
        this.remote = rdfName != null ? RemoteManager.getRemoteManager().findRemoteByRDF(rdfName) : RemoteManager.getRemoteManager().findRemoteByName(str);
        Remote.prelimLoad = false;
        if (this.remote == null) {
            this.reset();
            return;
        }
        Hex pid = null;
        do {
            if ((line = in.readLine()) == null || line.length() <= 0 || line.charAt(0) != '\"') continue;
            line = line.substring(1);
        } while ((equals = line.indexOf(61)) == -1 || !line.substring(0, equals).toLowerCase().startsWith("upgrade code"));
        short[] id = new short[2];
        if (!this.remote.usesTwoBytePID()) {
            short temp = Short.parseShort(line.substring(equals + 2, equals + 4), 16);
            if ((temp & 8) != 0) {
                id[0] = 1;
            }
            line = in.readLine();
            id[1] = temp = Short.parseShort(line.substring(0, 2), 16);
            pid = new Hex(id);
        } else {
            line = in.readLine();
            pid = new Hex(line.substring(0, 5));
        }
        this.remote.load();
        token = setupFields.get(3);
        str = token.substring(5);
        if (this.remote.getDeviceTypeByAliasName(str) == null) {
            String rc = null;
            String msg = "Remote \"" + this.remote.getName() + "\" does not support the device type " + str + ".  Please select one of the supported device types below to use instead.\n";
            while (rc == null) {
                rc = (String)JOptionPane.showInputDialog(RemoteMaster.getFrame(), msg, "Unsupported Device Type", 0, null, this.remote.getDeviceTypeAliasNames(), null);
            }
            str = rc;
        }
        this.setDeviceTypeAliasName(str);
        String buttonStyle = setupFields.get(4);
        List<String> deviceFields = LineTokenizer.tokenize(protocolLine, delim);
        String protocolName = deviceFields.get(1);
        ProtocolManager protocolManager = ProtocolManager.getProtocolManager();
        if (protocolName.equals("Manual Settings")) {
            Protocol p;
            System.err.println("protocolName=" + protocolName);
            System.err.println("manualLine=" + manualLine);
            List<String> manualFields = LineTokenizer.tokenize(manualLine, delim);
            String pidStr = manualFields.get(1);
            System.err.println("pid=" + pidStr);
            if (pidStr != null) {
                int space = pidStr.indexOf(32);
                if (space != -1) {
                    pid = new Hex(pidStr);
                } else {
                    short pidInt = Short.parseShort(pidStr, 16);
                    short[] data = new short[]{(short)((pidInt & 0xFF00) >> 8), (short)(pidInt & 0xFF)};
                    pid = new Hex(data);
                }
            }
            int byte22 = Integer.parseInt(manualFields.get(2).substring(0, 1));
            System.err.println("byte2=" + byte22);
            String signalStyle = manualFields.get(3);
            System.err.println("SignalStyle=" + signalStyle);
            String bitsStr = manualFields.get(4);
            int devBits = 8;
            int cmdBits = 8;
            try {
                if (bitsStr != null) {
                    devBits = Integer.parseInt(bitsStr.substring(0, 1), 16);
                    cmdBits = Integer.parseInt(bitsStr.substring(1), 16);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            System.err.println("devBits=" + devBits + " and cmdBits=" + cmdBits);
            if (devBits == 0) {
                devBits = 8;
            }
            if (cmdBits == 0) {
                cmdBits = 8;
            }
            ArrayList<Value> values = new ArrayList<Value>();
            str = deviceFields.get(2);
            if (str != null) {
                values.add(new Value(DeviceUpgrade.parseInt(str)));
            }
            if ((str = deviceFields.get(3)) != null) {
                values.add(new Value(DeviceUpgrade.parseInt(str)));
            }
            if ((str = deviceFields.get(4)) != null) {
                values.add(new Value(DeviceUpgrade.parseInt(str)));
            }
            if ((str = deviceFields.get(5)) == null) {
                str = "";
            }
            short[] rawHex = Hex.parseHex(str);
            this.protocol = new ManualProtocol(protocolName, pid, byte22, signalStyle, devBits, values, rawHex, cmdBits);
            this.setParmValues(this.protocol.getDeviceParmValues());
            protocolManager.add(this.protocol);
            List<Protocol> v = protocolManager.findByPID(pid);
            ListIterator<Protocol> li = v.listIterator();
            while (li.hasNext()) {
                p = li.next();
                if (p.getFixedDataLength() == rawHex.length) continue;
                li.remove();
            }
            if (v.size() != 0 && (code = (p = v.get(0)).getCode(this.remote)) != null) {
                ((ManualProtocol)this.protocol).setCode((Hex)code, this.remote.getProcessor());
            }
        } else {
            Protocol p;
            Hex temp = protocolManager.getCurrentPID(protocolName, pid);
            if (temp != null) {
                pid = temp;
            }
            if ((p = protocolManager.findNearestProtocol(this.remote, protocolName, pid, null)) == null) {
                p = protocolManager.findProtocolByOldName(this.remote, protocolName, pid);
                if (p == null) {
                    JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "No protocol found with name=\"" + protocolName + "\" for remote \"" + this.remote.getName() + "\".", "Import Failure", 0);
                    this.reset();
                    return;
                }
            } else if ((p = this.testStandardProtocol(p, null)) == null) {
                this.reset();
                return;
            }
            this.protocol = p;
            Value[] importParms = new Value[8];
            for (int i2 = 0; i2 < importParms.length && i2 + 2 < deviceFields.size(); ++i2) {
                token = deviceFields.get(2 + i2);
                Object val = null;
                val = token == null ? null : (token.equals("true") ? new Integer(1) : (token.equals("false") ? new Integer(0) : token));
                importParms[i2] = new Value(val);
            }
            this.protocol.importDeviceParms(importParms);
            this.parmValues = this.protocol.getDeviceParmValues();
            if (!this.protocol.getID(this.remote, false).equals(pid)) {
                this.protocol.setAltPID(this.remote, pid);
            }
        }
        boolean useOBC = false;
        boolean useEFC = false;
        if (buttonStyle.equals("OBC")) {
            useOBC = true;
        } else if (buttonStyle.equals("EFC")) {
            useEFC = true;
        }
        int obcIndex = 0;
        CmdParameter[] cmdParms = this.protocol.getCommandParameters();
        for (int i3 = 0; i3 < cmdParms.length; ++i3) {
            if (!cmdParms[i3].getName().equals("OBC")) continue;
            obcIndex = i3;
            break;
        }
        String match1 = "fByte2" + delim + "bButtons" + delim + "bFunctions" + delim + "fNotes" + delim + "Device Combiner";
        String match2 = "byte2" + delim + "Buttons" + delim + "Functions" + delim;
        while ((line = in.readLine()) != null && line.indexOf(match1) == -1 && line.indexOf(match2) == -1) {
        }
        fields = LineTokenizer.tokenize(line, delim);
        int buttonCodeIndex = fields.indexOf("bBtnCd");
        this.functions.clear();
        DeviceCombiner combiner = null;
        if (this.protocol.getClass() == DeviceCombiner.class) {
            combiner = (DeviceCombiner)this.protocol;
        }
        String[] lines = new String[128];
        for (int i4 = 0; i4 < 128; ++i4) {
            lines[i4] = in.readLine();
        }
        while ((line = in.readLine()) != null) {
            fields = LineTokenizer.tokenize(line, delim);
            token = fields.get(0);
            if (token == null || !token.equals("Line Notes:") && !token.equals("Notes:")) continue;
            StringBuilder buff = new StringBuilder();
            boolean first = true;
            String tempDelim = null;
            while ((line = in.readLine()) != null) {
                tempDelim = line.length() > 0 && line.charAt(0) == '\"' ? "\"" : delim;
                StringTokenizer st = new StringTokenizer(line, tempDelim);
                if (st.hasMoreTokens()) {
                    token = st.nextToken();
                    if (token.startsWith("EOF Marker")) break;
                    if (first) {
                        first = false;
                    } else {
                        buff.append("\n");
                    }
                    buff.append(token.trim());
                    continue;
                }
                buff.append("\n");
            }
            this.notes = buff.toString().trim();
            if (this.protocol.getClass() != ManualProtocol.class) continue;
            this.protocol.importUpgradeCode(this.notes);
        }
        ArrayList unassigned = new ArrayList();
        for (i = 0; i < 128; ++i) {
            Hex newPid;
            Protocol p;
            line = lines[i];
            fields = LineTokenizer.tokenize(line, delim);
            funcName = this.cleanName(fields.get(0));
            code = fields.get(1);
            byte2 = fields.get(2);
            String buttonName = fields.get(3);
            assignedName = fields.get(4);
            notes = fields.size() > 5 ? fields.get(5) : null;
            String pidStr = fields.size() > 6 ? fields.get(6) : null;
            String string = fields.size() > 7 ? fields.get(7) : null;
            Function f = null;
            if (code != null || byte2 != null || notes != null) {
                System.err.println("Creating a new function, because:");
                System.err.println("code=" + (String)code);
                System.err.println("byte2=" + byte2);
                System.err.println("notes=" + notes);
                boolean isExternal = this.isExternalFunctionName(funcName);
                if (isExternal) {
                    f = new ExternalFunction();
                    this.extFunctions.add((ExternalFunction)f);
                } else {
                    f = new Function();
                    this.functions.add(f);
                }
                System.err.println("Creating function w/ name " + funcName);
                f.setName(funcName);
                f.setUpgrade(this);
                if (notes != null) {
                    f.setNotes(notes);
                }
                Hex hex = null;
                if (f.isExternal()) {
                    ExternalFunction ef = (ExternalFunction)f;
                    String name = ef.getName();
                    int slash = name.indexOf(47);
                    String devName = name.substring(1, slash);
                    String match = null;
                    Object[] names = this.remote.getDeviceTypeAliasNames();
                    for (int j = 0; j < names.length && match == null; ++j) {
                        if (!devName.equalsIgnoreCase(names[j])) continue;
                        match = names[j];
                        break;
                    }
                    if (match == null) {
                        String msg = "The Keymap Master device upgrade you are importing includes an\nexternal function that uses the unknown device type " + devName + ".\n\nPlease select one of the supported device types below to use instead.";
                        while (match == null) {
                            match = (String)JOptionPane.showInputDialog(RemoteMaster.getFrame(), msg, "Unsupported Device Type", 0, null, names, null);
                        }
                    }
                    ef.setDeviceTypeAliasName(match);
                    int space = name.indexOf(32, slash + 1);
                    String codeString = null;
                    codeString = space == -1 ? name.substring(slash + 1) : name.substring(slash + 1, space);
                    ef.setSetupCode(Integer.parseInt(codeString));
                    if (((String)code).indexOf(104) != -1 || ((String)code).indexOf(36) != -1 || ((String)code).indexOf(32) != -1) {
                        hex = new Hex((String)code);
                        ef.setType(1);
                    } else {
                        hex = new Hex(1);
                        EFC.toHex(Short.parseShort((String)code), hex, 0);
                        ef.setType(0);
                    }
                } else if (code != null) {
                    if (((String)code).indexOf(104) != -1 || ((String)code).indexOf(36) != -1 || ((String)code).indexOf(32) != -1) {
                        hex = new Hex((String)code);
                    } else {
                        hex = this.protocol.getDefaultCmd();
                        this.protocol.importCommand(hex, (String)code, useOBC, obcIndex, useEFC);
                    }
                    if (byte2 != null) {
                        this.protocol.importCommandParms(hex, byte2);
                    }
                }
                f.setHex(hex);
            }
            if (combiner == null || pidStr == null || pidStr.equals("Protocol ID")) continue;
            Hex fixedData = new Hex();
            if (string != null) {
                fixedData = new Hex(string);
            }
            if ((p = protocolManager.findProtocolForRemote(this.remote, newPid = new Hex(pidStr), fixedData)) != null) {
                CombinerDevice dev = new CombinerDevice(p, fixedData);
                combiner.add(dev);
                continue;
            }
            ManualProtocol mp = new ManualProtocol(newPid, new Properties());
            mp.setRawHex(fixedData);
            combiner.add(new CombinerDevice(mp, null, null));
        }
        for (i = 0; i < 128; ++i) {
            ArrayList<String> temp;
            Function func;
            int keyCode;
            void var36_66;
            Button b;
            String string;
            line = lines[i];
            fields = LineTokenizer.tokenize(line, delim);
            funcName = fields.get(0);
            code = fields.get(1);
            byte2 = fields.get(2);
            String actualName = this.cleanName(fields.get(3));
            System.err.println("actualName='" + actualName + "'");
            if (actualName == null) continue;
            assignedName = fields.size() > 4 ? fields.get(4) : null;
            notes = fields.size() > 5 ? fields.get(5) : null;
            String shiftAssignedName = fields.size() > 12 ? fields.get(12) : null;
            Object var36_63 = null;
            if (buttonCodeIndex != -1 && (string = fields.get(buttonCodeIndex)).length() < 2) {
                Object var36_65 = null;
            }
            String buttonName = null;
            if (actualName != null) {
                if (i < genericButtonNames.length) {
                    buttonName = genericButtonNames[i];
                    String temp2 = this.getRdfButtonByKmButton(buttonName);
                    if (temp2 != null) {
                        buttonName = temp2;
                    }
                } else {
                    System.err.println("No generic name available!");
                    b = this.remote.getButton(actualName);
                    if (b == null) {
                        b = this.remote.getButton(actualName.replace(' ', '_'));
                    }
                    if (b != null) {
                        buttonName = b.getStandardName();
                    }
                }
            }
            b = null;
            if (var36_66 != null && (b = this.remote.getButton(keyCode = Integer.parseInt((String)var36_66, 16))) != null) {
                System.err.println("Found button " + b + " for keyCode " + keyCode);
                buttonName = b.getStandardName();
            }
            if (b == null && buttonName != null) {
                System.err.println("Searching for button w/ name " + buttonName);
                b = this.remote.findByStandardName(new Button(buttonName, null, 0, this.remote));
                if (b == null) {
                    b = this.remote.getButton(actualName);
                }
                if (b != null) {
                    System.err.println("Found button " + b);
                }
            }
            if (b == null) {
                System.err.println("No buttonName for buttonName=" + buttonName + " and i=" + i);
            }
            if (buttonName != null && assignedName != null && Character.isDigit(assignedName.charAt(0)) && Character.isDigit(assignedName.charAt(1)) && assignedName.charAt(2) == ' ' && assignedName.charAt(3) == '-' && assignedName.charAt(4) == ' ') {
                String name = this.cleanName(assignedName.substring(5));
                if (name.length() == 5 && name.startsWith("num ") && Character.isDigit(name.charAt(4))) {
                    name = name.substring(4);
                }
                func = null;
                func = this.isExternalFunctionName(name) ? this.getFunction(name, this.extFunctions) : this.getFunction(name, this.functions);
                if (func == null) {
                    System.err.println("Could not find function " + name);
                    continue;
                }
                System.err.println("Found function " + name);
                if (b == null) {
                    temp = new ArrayList(2);
                    temp.add(name);
                    temp.add(actualName);
                    unassigned.add(temp);
                    System.err.println("Couldn't find button " + buttonName + " to assign function " + name);
                } else if (loadButtons && func.getHex() != null) {
                    System.err.println("Setting function " + name + " on button " + b);
                    this.assignments.assign(b, func, 0);
                }
            }
            if (shiftAssignedName != null) {
                System.err.println("shiftAssignedName=" + (String)shiftAssignedName);
            }
            if (shiftAssignedName == null || shiftAssignedName.equals("")) continue;
            String name = this.cleanName(shiftAssignedName.substring(5));
            func = null;
            func = this.isExternalFunctionName(name) ? this.getFunction(name, this.extFunctions) : this.getFunction(name, this.functions);
            if (b == null) {
                temp = new ArrayList<String>(2);
                temp.add(name);
                temp.add("shift-" + buttonName);
                unassigned.add(temp);
                continue;
            }
            if (!loadButtons || func == null || func.getHex() == null) continue;
            this.assignments.assign(b, func, 1);
        }
        if (!unassigned.isEmpty()) {
            String message = Integer.toString(unassigned.size()) + " functions defined in the imported device upgrade were assigned to buttons that could not be matched by name. The functions and the corresponding button names are listed below.\n\nPlease post this information in the \"JP1 - Software\" section of the JP1 Forums at www.hifi-remote.com\n\nUse the Button or Layout panel to assign those functions properly.";
            JFrame frame = new JFrame("Import Failure");
            frame.setDefaultCloseOperation(2);
            Container container = frame.getContentPane();
            JTextArea text = new JTextArea(message);
            text.setEditable(false);
            text.setLineWrap(true);
            text.setWrapStyleWord(true);
            text.setBackground(container.getBackground());
            text.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            container.add((Component)text, "North");
            ArrayList<String> titles = new ArrayList<String>();
            titles.add("Function name");
            titles.add("Button name");
            Object[][] unassignedArray = new Object[unassigned.size()][];
            int i5 = 0;
            for (List list : unassigned) {
                unassignedArray[i5++] = list.toArray();
            }
            JTableX table = new JTableX(unassignedArray, titles.toArray());
            container.add((Component)new JScrollPane(table), "Center");
            frame.pack();
            frame.setLocationRelativeTo(RemoteMaster.getFrame());
            frame.setVisible(true);
        }
        Button[] buttons = this.remote.getUpgradeButtons();
        System.err.println("Removing assigned functions with no hex!");
        for (int i6 = 0; i6 < buttons.length; ++i6) {
            Button b = buttons[i6];
            for (int state = 0; state <= 2; ++state) {
                Function f = this.assignments.getAssignment(b, state);
                if (f == null || f.getHex() != null) continue;
                this.assignments.assign(b, null, state);
            }
        }
        if (this.protocol instanceof ManualProtocol && this.protocol.hasCode(this.remote)) {
            protocolManager.remove(this.protocol);
            ManualProtocol mp = (ManualProtocol)this.protocol;
            this.protocol = this.testManualProtocol(mp);
            protocolManager.add(this.protocol);
        }
        System.err.println("Done!");
    }

    public Value[] getParmValues() {
        return (Value[])this.parmValues.clone();
    }

    public void setParmValues(Value[] parmValues) {
        this.parmValues = (Value[])parmValues.clone();
    }

    public static final String[] getDeviceTypeAliasNames() {
        return deviceTypeAliasNames;
    }

    public void autoAssignFunctions() {
        this.autoAssignFunctions(this.functions);
        this.autoAssignFunctions(this.extFunctions);
    }

    private void autoAssignFunctions(List<? extends Function> funcs) {
        Button[] buttons = this.remote.getUpgradeButtons();
        block0: for (Function function : funcs) {
            if (function.getHex() == null) continue;
            for (int i = 0; i < buttons.length; ++i) {
                Button b = buttons[i];
                if (this.assignments.getAssignment(b) != null || !function.matchingName(b)) continue;
                this.assignments.assign(b, function);
                continue block0;
            }
        }
    }

    public boolean checkSize() {
        Integer protocolLimit = this.remote.getMaxProtocolLength();
        Integer upgradeLimit = this.remote.getMaxUpgradeLength();
        Integer combinedLimit = this.remote.getMaxCombinedUpgradeLength();
        if (protocolLimit == null && upgradeLimit == null && combinedLimit == null) {
            return true;
        }
        int protocolLength = 0;
        Hex protocolCode = this.getCode();
        if (protocolCode != null) {
            protocolLength = protocolCode.length();
        }
        if (protocolLimit != null && protocolLength > protocolLimit) {
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The protocol upgrade exceeds the maximum allowed by the remote.", "Protocol Upgrade Limit Exceeded", 0);
            return false;
        }
        int upgradeLength = this.getUpgradeLength();
        if (upgradeLimit != null && upgradeLength > upgradeLimit) {
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The device upgrade exceeds the maximum allowed by the remote.", "Device Upgrade Limit Exceeded", 0);
            return false;
        }
        int combinedLength = upgradeLength + protocolLength;
        if (combinedLimit != null && combinedLength > combinedLimit) {
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), "The combined upgrade exceeds the maximum allowed by the remote.", "Combined Upgrade Limit Exceeded", 0);
            return false;
        }
        return true;
    }

    public boolean needsProtocolCode() {
        if (this.protocol == null) {
            return false;
        }
        if (this.protocol.needsCode(this.remote)) {
            return true;
        }
        Translate[] translators = this.protocol.getCodeTranslators(this.remote);
        if (translators != null) {
            for (Translate translate : translators) {
                Translator translator = (Translator)translate;
                int devParmIndex = translator.getIndex();
                Value parmVal = this.parmValues[devParmIndex];
                if (!parmVal.hasUserValue() || parmVal.getUserValue().equals(parmVal.getDefaultValue())) continue;
                return true;
            }
        }
        return false;
    }

    public Hex getCode() {
        return this.getCode(this.protocol);
    }

    public Hex getCode(Protocol p) {
        Hex code = p.getCode(this.remote);
        if (code != null) {
            if (code.length() != 0) {
                code = this.remote.getProcessor().translate(code, this.remote);
            }
            this.translateCode(code);
        }
        return code;
    }

    public String getStarredID() {
        if (this.protocol == null) {
            return null;
        }
        String starredID = this.protocol.getID(this.remote).toString();
        if (this.needsProtocolCode()) {
            Hex code = this.getCode();
            starredID = code == null || code.length() == 0 ? starredID + "-" : starredID + "*";
        }
        return starredID;
    }

    public void translateCode(Hex code) {
        if (this.protocol == null) {
            return;
        }
        Translate[] xlators = this.protocol.getCodeTranslators(this.remote);
        if (xlators != null) {
            Value[] values = this.getParmValues();
            for (int i = 0; i < xlators.length; ++i) {
                xlators[i].in(values, code, null, -1);
            }
        }
    }

    public void changeProtocol(Protocol oldProtocol, ManualProtocol newProtocol) {
        if (oldProtocol == null || this.getProtocol() != oldProtocol) {
            return;
        }
        short[] fixedData = oldProtocol.getFixedData(this.getParmValues()).getData();
        boolean preserve = this.preserveOBC;
        this.preserveOBC = false;
        this.setProtocol(newProtocol);
        this.preserveOBC = preserve;
        ArrayList<Value> parms = new ArrayList<Value>();
        for (int i = 0; i < fixedData.length; ++i) {
            parms.add(new Value(fixedData[i]));
        }
        this.setParmValues(parms.toArray(new Value[0]));
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    public void setInconsistent(boolean inconsistent) {
        this.inconsistent = inconsistent;
    }

    public boolean isInconsistent() {
        return this.inconsistent;
    }

    public void setRemoteConfig(RemoteConfiguration remoteConfig) {
        if (remoteConfig == null) {
            return;
        }
        Remote remote = remoteConfig.getRemote();
        if (remote != this.remote) {
            this.setRemote(remote);
        }
        this.remoteConfig = remoteConfig;
        if (remote != null && remote.usesEZRC()) {
            List<Button> selectors = null;
            if (remote.getButtonGroups() != null && (selectors = remote.getButtonGroups().get("LCD")) != null) {
                for (Button b : selectors) {
                    GeneralFunction gf = new GeneralFunction(b.getName());
                    gf.addReference(this.buttonRestriction, b);
                    this.selectorMap.put(Integer.valueOf(b.getKeyCode()), gf);
                }
            }
        }
    }

    public Button[] getMappedButtons() {
        return this.mappedButtons;
    }

    public boolean hasSerial() {
        return this.usesSerial;
    }

    public void setUsesSerial(boolean usesSerial) {
        this.usesSerial = usesSerial;
    }

    public List<Button> getSoftButtons() {
        return this.softButtons;
    }

    public List<Button> getHardButtons() {
        return this.hardButtons;
    }

    public void classifyButtons() {
        if (this.remote.getButtonGroups() == null) {
            return;
        }
        if (this.softButtons == null) {
            this.softButtons = new ArrayList<Button>();
        } else {
            this.softButtons.clear();
        }
        if (this.hardButtons == null) {
            this.hardButtons = new ArrayList<Button>();
        } else {
            this.hardButtons.clear();
        }
        for (Button b : this.remote.getButtons()) {
            GeneralFunction f = this.getGeneralFunction(b.getKeyCode(), true);
            if (f == null || f.getName() == null || f.getName().startsWith("__") || this.selectorMap != null && this.selectorMap.get(b.getKeyCode()) != null) continue;
            f = this.getGeneralFunction(b.getKeyCode(), false);
            if (this.remote.isSoftButton(b)) {
                this.softButtons.add(b);
                continue;
            }
            if (f == null || f instanceof LearnedSignal) continue;
            this.hardButtons.add(b);
        }
        Collections.sort(this.softButtons, ButtonSorter);
        Collections.sort(this.hardButtons, ButtonSorter);
    }

    public LinkedHashMap<Integer, Function> getFunctionMap() {
        return this.functionMap;
    }

    public LinkedHashMap<Integer, Macro> getMacroMap() {
        return this.macroMap;
    }

    public LinkedHashMap<Integer, LearnedSignal> getLearnedMap() {
        return this.learnedMap;
    }

    public LinkedHashMap<Integer, Function> getKeyGidMap() {
        return this.keyGidMap;
    }

    public LinkedHashMap<Integer, GeneralFunction> getSelectorMap() {
        return this.selectorMap;
    }

    public int getDependentOffset() {
        return this.dependentOffset;
    }

    public void setDependentOffset(int dependentOffset) {
        this.dependentOffset = dependentOffset;
    }

    public DeviceButton getButtonRestriction() {
        return this.buttonRestriction;
    }

    public void setButtonRestriction(DeviceButton buttonRestriction) {
        this.buttonRestriction = buttonRestriction;
    }

    public Boolean getButtonIndependent() {
        return this.buttonIndependent;
    }

    public void setButtonIndependent(Boolean buttonIndependent) {
        this.buttonIndependent = buttonIndependent;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public ButtonAssignments getAssignments() {
        return this.assignments;
    }

    public void setAssignmentColor(int keyCode, int deviceButtonIndex, Color color) {
        if (!this.assignmentColors.containsKey(deviceButtonIndex)) {
            Color[] allWhite = new Color[256];
            for (int i = 0; i < 256; ++i) {
                allWhite[i] = Color.WHITE;
            }
            this.assignmentColors.put(deviceButtonIndex, allWhite);
        }
        this.assignmentColors.get((Object)Integer.valueOf((int)deviceButtonIndex))[keyCode] = color;
    }

    public Color getAssignmentColor(int keyCode, int deviceButtonIndex) {
        Color[] colors = this.assignmentColors.get(deviceButtonIndex);
        if (colors != null) {
            return colors[keyCode];
        }
        return Color.WHITE;
    }

    public Color getProtocolHighlight() {
        return this.protocolHighlight;
    }

    public void setProtocolHighlight(Color color) {
        this.protocolHighlight = color;
    }

    public int getProtocolMemoryUsage() {
        return this.protocolMemoryUsage;
    }

    public void clearProtocolMemoryUsage() {
        this.protocolMemoryUsage = 0;
    }

    public void addProtocolMemoryUsage(int protocolMemoryUsage) {
        this.protocolMemoryUsage += protocolMemoryUsage;
    }

    public LearnedSignal getNewLearnedSignal(int keyCode, int deviceButtonIndex, int format, Hex data, String notes) {
        LearnedSignal ls = new LearnedSignal(keyCode, deviceButtonIndex, format, data, notes);
        if (this.learnedMap != null) {
            DeviceButton db = this.remote.getDeviceButton(deviceButtonIndex);
            Button b = this.remote.getButton(keyCode);
            this.learnedMap.put(keyCode, ls);
            ls.addReference(db, b);
        }
        return ls;
    }

    public void setFunction(Button b, GeneralFunction f, int state) {
        if (!this.remote.usesEZRC()) {
            if (f == null || f instanceof Function) {
                this.assignments.assign(b, (Function)f, state);
            }
            return;
        }
    }

    public void clearBackupReferences() {
        this.restoreOnCancelReferences = new LinkedHashMap();
    }

    public void backupReferences(GeneralFunction gf) {
        if (gf instanceof Function && gf.getUpgrade(this.remote) == this) {
            return;
        }
        if (this.restoreOnCancelReferences != null && this.restoreOnCancelReferences.get(gf) == null) {
            this.restoreOnCancelReferences.put(gf, new ArrayList<GeneralFunction.User>(gf.getUsers()));
        }
    }

    public int getNewFunctionSerial(Function fn, boolean systemOnly) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (this.remote.isSSD()) {
            for (DeviceUpgrade upg : this.remoteConfig.getDeviceUpgrades()) {
                for (Function f : upg.getFunctions()) {
                    if (f.getSerial() < 0) continue;
                    list.add(f.getSerial());
                }
            }
            int serial = 24;
            while (true) {
                if (!list.contains(serial)) {
                    return serial;
                }
                ++serial;
            }
        }
        for (Function f : this.functions) {
            if (f.getSerial() < 0) continue;
            list.add(f.getSerial());
        }
        List<Button> btnList = this.remote.getSystemButtons();
        if (btnList != null) {
            for (int i = 0; i < btnList.size(); ++i) {
                if (list.contains(i)) continue;
                return i;
            }
        }
        if (systemOnly) {
            return -1;
        }
        btnList = this.remote.getButtonGroups().get("Soft");
        String title = "Assignment of function to button";
        String message = "Functions used in macros or assists must also be assigned to a button.\nFunction \"" + fn + "\" is so used and is not currently so assigned.\n";
        for (Button b : btnList) {
            if (this.getGeneralFunction(b.getKeyCode(), true) != null) continue;
            message = message + "There is no hidden system button available so it will be assigned to\nthe soft button \"" + b + "\".  The Device Upgrade Editor may be used\nto change this assignment if required.";
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 1);
            this.assignments.assign(b, fn);
            fn.addReference(this.buttonRestriction, b);
            return -1;
        }
        message = message + "There is no unassigned system button or soft button available so this\nfunction will not send an IR signal.  To correct this, use the Device\nUpgrade Editor either to manually assign this function or free up a\nsoft button by deleting its current assignment.";
        JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 2);
        return -1;
    }

    private ButtonState getButtonState(int keyCode) {
        ButtonState bs = new ButtonState();
        bs.state = 0;
        bs.button = this.remote.getButton(keyCode);
        if (bs.button == null) {
            int baseCode = keyCode & 0x3F;
            if (baseCode != 0) {
                bs.button = this.remote.getButton(baseCode);
                if ((baseCode | this.remote.getShiftMask()) == keyCode) {
                    bs.state = 1;
                }
                if ((baseCode | this.remote.getXShiftMask()) == keyCode) {
                    bs.state = 2;
                }
            } else {
                baseCode = keyCode & ~this.remote.getShiftMask();
                bs.button = this.remote.getButton(baseCode);
                if (bs.button != null) {
                    bs.state = 1;
                } else {
                    baseCode = keyCode & ~this.remote.getXShiftMask();
                    bs.button = this.remote.getButton(baseCode);
                    if (bs.button != null) {
                        bs.state = 2;
                    }
                }
            }
        }
        return bs;
    }

    public void setFunction(int keyCode, Function f) {
        ButtonState bs = this.getButtonState(keyCode);
        this.setFunction(bs.button, f, bs.state);
    }

    public Function getFunction(Button b, int state) {
        return this.assignments.getAssignment(b, state);
    }

    public Function getFunction(int keyCode) {
        ButtonState bs = this.getButtonState(keyCode);
        return this.assignments.getAssignment(bs.button, bs.state);
    }

    public GeneralFunction getGeneralFunction(int keyCode, boolean includeMacros) {
        Button button = this.remote.getButton(keyCode);
        GeneralFunction gf = null;
        if (this.remote.usesEZRC()) {
            int serial;
            gf = this.selectorMap.get(keyCode);
            if (gf == null) {
                gf = this.learnedMap.get(keyCode);
            }
            if (includeMacros && gf == null && !this.remote.isSSD()) {
                gf = this.macroMap.get(keyCode);
            }
            if (this.remote.getSystemButtons() != null && gf == null && (serial = this.remote.getSystemButtons().indexOf(button)) >= 0) {
                gf = this.functionMap.get(serial);
            }
        }
        if (gf == null) {
            gf = this.getFunction(button, 0);
        }
        return gf;
    }

    public List<Function> getFunctionList() {
        ArrayList<Function> list = new ArrayList<Function>();
        for (Function function : this.functions) {
            if (!function.accept()) continue;
            list.add(function);
        }
        return list;
    }

    public List<GeneralFunction> getGeneralFunctionList() {
        ArrayList<GeneralFunction> list = new ArrayList<GeneralFunction>(this.getFunctionList());
        if (this.remote.usesEZRC()) {
            list.addAll(this.learnedMap.values());
            list.addAll(this.selectorMap.values());
        }
        return list;
    }

    public void doCancel(boolean isNewUpgrade) {
        Protocol p;
        Remote remote = this.remoteConfig.getRemote();
        if (remote.usesEZRC() && isNewUpgrade) {
            DeviceButton db = this.buttonRestriction;
            if (db != null && db != DeviceButton.noButton) {
                db.setUpgrade(null);
                db.setDefaultName();
                db.setConstructed(false);
            }
            if (db != null && remote.isSSD()) {
                db.setSegment(null);
            }
        }
        if ((p = this.convertedProtocol) != null) {
            ProtocolManager.getProtocolManager().remove(p);
        }
        if ((p = this.originalProtocol) instanceof ManualProtocol) {
            ProtocolManager.getProtocolManager().add(p);
        }
        for (GeneralFunction gf : this.restoreOnCancelReferences.keySet()) {
            GeneralFunction.User u = gf.getUsers().isEmpty() ? null : gf.getUsers().get(0);
            gf.removeReferences();
            for (GeneralFunction.User user : this.restoreOnCancelReferences.get(gf)) {
                gf.addReference(user.db, user.button);
            }
            if (gf instanceof Macro) {
                GeneralFunction gf0;
                Macro macro = (Macro)gf;
                if (macro.isSystemMacro() && !macro.getItems().isEmpty() && (gf0 = macro.getItems().get((int)0).fn) != null && u != null) {
                    gf0.removeReference(u.db, u.button);
                }
                List<Macro> macros = this.remoteConfig.getMacros();
                if (macro.getUsers().isEmpty()) {
                    macros.remove(macro);
                    continue;
                }
                if (macros.contains(macro)) continue;
                macros.add(macro);
                continue;
            }
            if (!(gf instanceof LearnedSignal)) continue;
            LearnedSignal ls = (LearnedSignal)gf;
            List<LearnedSignal> lsList = this.remoteConfig.getLearnedSignals();
            if (ls.getUsers().isEmpty()) {
                lsList.remove(ls);
                continue;
            }
            if (lsList.contains(ls)) continue;
            lsList.add(ls);
        }
        this.restoreOnCancelReferences = null;
    }

    public void filterFunctionMap() {
        if (!this.remote.usesEZRC()) {
            return;
        }
        ArrayList<Integer> fnkeys = new ArrayList<Integer>();
        int fnky = 0;
        HashMap<RemoteConfiguration.KeySpec, List<Highlight>> map = this.remoteConfig.getAllKeySpecs();
        for (RemoteConfiguration.KeySpec ks : map.keySet()) {
            boolean systemCondition;
            boolean inSystemMacro = false;
            boolean doSkip = true;
            for (Highlight hl : map.get(ks)) {
                if (hl.forUpload()) {
                    doSkip = false;
                }
                if (!(hl instanceof Macro) || !((Macro)hl).isSystemMacro()) continue;
                inSystemMacro = true;
            }
            if (doSkip) continue;
            if (ks.fn != null && ks.fn instanceof Function && ks.fn.getSerial() < 0 && ks.db.getUpgrade() == this && ks.getButton() == null) {
                int serial = this.getNewFunctionSerial((Function)ks.fn, false);
                ks.fn.setSerial(serial);
                if (serial >= 0) {
                    this.functionMap.put(serial, (Function)ks.fn);
                }
            }
            boolean bl = systemCondition = this.remote.getSystemButtons() != null ? this.remote.getSystemButtons().contains(ks.getButton()) : inSystemMacro;
            if (ks.getButton() != null && !systemCondition || ks.fn == null || (fnky = ks.fn.getSerial()) < 0 || ks.fn != this.functionMap.get(fnky) || fnkeys.contains(fnky)) continue;
            fnkeys.add(fnky);
        }
        Iterator<Integer> it = this.functionMap.keySet().iterator();
        while (it.hasNext()) {
            int key = it.next();
            if (fnkeys.contains(key)) continue;
            it.remove();
        }
    }

    public int getGidForName(String name) {
        Random random = new Random();
        if (this.remoteConfig != null) {
            List<Integer> list = this.remoteConfig.getGidRegister().get(name);
            if (list != null) {
                for (int gid : list) {
                    if (this.keyGidMap.containsKey(gid)) continue;
                    return gid;
                }
            }
            int gid = 0;
            do {
                gid = 29696 + random.nextInt(1280);
            } while (this.remoteConfig.getGidList().contains(gid));
            this.remoteConfig.addGid(name, gid);
            return gid;
        }
        int gid = 0;
        while (this.keyGidMap.containsKey(gid = 29696 + random.nextInt(1280))) {
        }
        return gid;
    }

    @Override
    public String toString() {
        return this.devTypeAliasName + '/' + this.setupCode + " (" + this.description + ')';
    }

    public void setPreserveOBC(boolean flag) {
        this.preserveOBC = flag;
    }

    public boolean getPreserveOBC() {
        return this.preserveOBC;
    }

    public DeviceUpgrade getBaseUpgrade() {
        return this.baseUpgrade;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public Segment getSoftButtonSegment() {
        return this.softButtonSegment;
    }

    public void setSoftButtonSegment(Segment softButtonSegment) {
        this.softButtonSegment = softButtonSegment;
    }

    public Segment getSoftFunctionSegment() {
        return this.softFunctionSegment;
    }

    public void setSoftFunctionSegment(Segment softFunctionSegment) {
        this.softFunctionSegment = softFunctionSegment;
    }

    public LinkedHashMap<Function, Function> getSwapList() {
        return this.swapList;
    }

    public void setSwapList(LinkedHashMap<Function, Function> swapList) {
        this.swapList = swapList;
    }

    public void setSkipProtocol(boolean skipProtocol) {
        this.skipProtocol = skipProtocol;
    }

    public String getRdfNameByKmName(String kmName) {
        for (String[] kmStr : kmRemotesToRDF) {
            if (!kmStr[0].equalsIgnoreCase(kmName)) continue;
            return kmStr[1];
        }
        return null;
    }

    public String getRdfButtonByKmButton(String kmButton) {
        for (String[] kmStr : kmButtonsToRDF) {
            if (!kmStr[0].equalsIgnoreCase(kmButton)) continue;
            return kmStr[1];
        }
        return null;
    }

    private class ButtonState {
        public Button button;
        public int state;

        private ButtonState() {
        }
    }

    public static enum HighlightType {
        MACRO,
        LEARN;

    }
}

