/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.Executor;
import com.hifiremote.jp1.ExternalSignal;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.LearnedSignalPanel;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteManager;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SetupCode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.harctoolbox.girr.Command;
import org.harctoolbox.ircore.InvalidArgumentException;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.NamedProtocol;

public class DeviceUpgradeConverter {
    private RemoteConfiguration remoteConfig = null;
    private Remote remote = null;
    private DeviceUpgrade baseUpgrade = null;
    private boolean suppressConfirmPrompts = false;
    private boolean suppressImportOptions = false;

    public DeviceUpgradeConverter(RemoteConfiguration remoteConfig, Remote remote) {
        this.remoteConfig = remoteConfig;
        this.remote = remoteConfig != null ? remoteConfig.getRemote() : remote;
        this.suppressConfirmPrompts = Boolean.parseBoolean(JP1Frame.getProperties().getProperty("SuppressConfirmPrompts", "false"));
        this.suppressImportOptions = Boolean.parseBoolean(JP1Frame.getProperties().getProperty("SuppressImportOptions", "true"));
    }

    public DeviceUpgrade convertToDeviceUpgrade(GeneralSignal[] signals, boolean sourceIsFile) {
        ExecutorData execData = this.getConsistentProtocols(signals);
        if (execData == null) {
            String message = "Only signals with a known executor can be imported into a device upgrade and no known\nexecutor can generate any of the " + (sourceIsFile ? "signals of this file" : "selected signals") + ", so the conversion is aborting.";
            if (sourceIsFile) {
                message = message + "\n\nAn IRScope ict file can be imported into a special-purpose remote as learned signals\nfor further analysis with the menu item \"Advanced > Import Ict as Learned\". This is\nmost useful when the timing analysis facility is activated.  If the Timing Summary button\nis not present on the Learned Signals tab, select the menu item \"Options > Advanced > Learned\nSignal Timing Analysis\" then close and re-open RMIR to activate it.";
            }
            DeviceUpgradeConverter.showMessage(message, 0);
            return null;
        }
        if (execData.protocols.isEmpty()) {
            DeviceUpgradeConverter.showMessage("The selected remote does not support any protocol that is compatible\nwith any of the " + (sourceIsFile ? "signals of the file" : "selected signals") + ".  Conversion aborting.", 0);
            return null;
        }
        Protocol protocol = execData.protocols.get(0);
        if (execData.protocols.size() > 1 && !this.suppressImportOptions) {
            String message = "There is more than one executor that is compatible both with your\nremote and with at least some of the signals " + (sourceIsFile ? "of the file.  The\n" : "you have selected.  The\n") + "compatible ones are listed below.  A * after the PID means that\nthe executor is not built in to the remote, so a new device upgrade\nwill include a protocol upgrade.  If the executor is not compatible\nwith all the signals, then the number of failures is also given.\nThe list is in increasing order of failure count.\n\nPlease choose an executor from the list and press Convert, or\npress Cancel to cancel the conversion.";
            Object[] options = new String[]{"Convert", "Cancel"};
            JList<Protocol> pList = this.getJList(execData.protocols, execData.failureCounts);
            int result = JOptionPane.showOptionDialog(null, this.getOptionPanel(message, pList), "Protocol chooser", 2, -1, null, options, options[0]);
            Protocol protocol2 = protocol = result == 0 ? (Protocol)pList.getSelectedValue() : null;
        }
        if (protocol == null) {
            return null;
        }
        ArrayList<List<String>> failedToConvert = new ArrayList<List<String>>();
        LinkedHashMap<GeneralSignal, Executor> gsMap = new LinkedHashMap<GeneralSignal, Executor>();
        for (GeneralSignal gs : signals) {
            if (gs.getError() != null) {
                failedToConvert.add(Arrays.asList(gs.getSignalName(null), gs.getError()));
            }
            gsMap.put(gs, execData.map.get(gs).get(protocol));
        }
        DeviceUpgrade upgrade = null;
        DeviceUpgrade appendUpgrade = null;
        boolean usingBaseUpgrade = false;
        if (this.remoteConfig != null) {
            System.err.println("Checking if we can append to an existing upgrade");
            ArrayList<DeviceUpgrade> upgrades = new ArrayList<DeviceUpgrade>();
            for (DeviceUpgrade du : this.remoteConfig.getDeviceUpgrades()) {
                if (du.protocol != protocol) continue;
                upgrades.add(du);
            }
            if (upgrades.size() > 0 && !this.suppressImportOptions) {
                String message = (sourceIsFile ? "The signals of the file " : "The selected learned signals ") + "can be appended to an existing\ndevice upgrade as the upgrades listed below use the same\nexecutor.  The compatible existing upgrades are listed below.\n\nIf you want to append the signals, select the required existing\nupgrade and press Append.  To create a new upgrade for the\nsignals, press New, or to cancel the conversion, press Cancel.\n\nIf appending, note that only those signals compatible with the\ndevice parameters of the existing upgrade can be appended, which\nmay be many fewer that can be imported into a new upgrade.";
                Object[] options = new String[]{"Append", "New", "Cancel"};
                JList pList = this.getJList(upgrades, null);
                int result = JOptionPane.showOptionDialog(null, this.getOptionPanel(message, pList), "Upgrade chooser", 2, -1, null, options, options[1]);
                if (result == 0) {
                    appendUpgrade = (DeviceUpgrade)pList.getSelectedValue();
                } else if (result != 1) {
                    return null;
                }
            }
        } else {
            appendUpgrade = this.baseUpgrade;
            if (appendUpgrade != null) {
                appendUpgrade.setProtocol(protocol);
                usingBaseUpgrade = true;
            }
        }
        if (appendUpgrade == null) {
            upgrade = new DeviceUpgrade(signals, this.remoteConfig, this.remote, gsMap, null, failedToConvert);
            if (this.remoteConfig == null) {
                return upgrade;
            }
            String msg = null;
            if (upgrade.protocol == null) {
                msg = (sourceIsFile ? "The import of the file as " : "The conversion of Learned Signals to ") + "a new device upgrade\nhas been aborted.";
            } else {
                DeviceButton defaultDev = null;
                if (this.remote.hasDeviceDependentUpgrades() == 1) {
                    for (DeviceButton db : this.remote.getDeviceButtons()) {
                        if (db.getSegment() != null && db.getDeviceSlot(db.getSegment().getHex().getData()) != 65535) continue;
                        String message = "The new upgrade that has been created will be assigned automatically\nto an unassigned device.  What name do you want to give to this\ndevice?";
                        String name = JOptionPane.showInputDialog(RemoteMaster.getFrame(), message, "New device");
                        if (name == null) {
                            protocol = null;
                            break;
                        }
                        defaultDev = db;
                        if (db.getSegment() == null) {
                            db.setSegment(new Segment(0, 255, new Hex(15)));
                        }
                        defaultDev.setName(name);
                        defaultDev.setUpgrade(upgrade);
                        upgrade.setButtonRestriction(defaultDev);
                        upgrade.setButtonIndependent(false);
                        short[] sArray = defaultDev.getSegment().getHex().getData();
                        DeviceType devType = this.remote.getDeviceTypeByAliasName(upgrade.getDeviceTypeAliasName());
                        defaultDev.setSetupCode((short)upgrade.getSetupCode(), sArray);
                        defaultDev.setDeviceTypeIndex((short)devType.getNumber(), sArray);
                        defaultDev.setDeviceGroup((short)devType.getGroup(), sArray);
                        if (this.remoteConfig.getDeviceButtonList().contains(defaultDev)) break;
                        this.remoteConfig.getDeviceButtonList().add(defaultDev);
                        break;
                    }
                    if (defaultDev == null && upgrade != null && protocol != null) {
                        msg = "You already have the maximum number of assigned devices.  You\ncannot add the new upgrade as there is no device to which it can\nbe assigned.  The conversion is aborted.";
                        upgrade = null;
                    }
                }
            }
            if (msg == null) {
                if (this.remote.usesEZRC()) {
                    Function[] assignments = upgrade.getAssignments().getAssignedFunctions();
                    for (int keyCode = 0; keyCode < assignments.length; ++keyCode) {
                        Function f = assignments[keyCode];
                        if (f == null) continue;
                        Button b = this.remote.getButton(keyCode);
                        f.removeReferences();
                        f.addReference(upgrade.getButtonRestriction(), b);
                    }
                }
                this.remoteConfig.getDeviceUpgrades().add(upgrade);
                this.remoteConfig.getOwner().getDeviceUpgradePanel().model.fireTableDataChanged();
                String source = sourceIsFile ? " signals of the file" : " selected Learned Signals";
                msg = signals.length == upgrade.getFunctions().size() ? "The " + signals.length + source : "Of the " + signals.length + source + ", " + upgrade.getFunctions().size();
                msg = msg + " have been converted\ninto a new Device Upgrade of type CBL\nwith the Setup Code " + upgrade.getSetupCode() + ".\n\nSwitch to the Devices tab to view/edit/etc this new Upgrade.";
            }
            this.remoteConfig.getOwner().setChanged(true);
            if (!this.suppressConfirmPrompts) {
                String title = (sourceIsFile ? "File imported as " : "Learned Signals converted to ") + "New Device Upgrade";
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), msg, title, -1);
            }
        } else {
            ArrayList<String> existingFunctions = new ArrayList<String>();
            ArrayList<String> renamedFunctions = new ArrayList<String>();
            ArrayList shiftedFunctions = new ArrayList();
            ArrayList<String> unassignedFunctions = new ArrayList<String>();
            upgrade = new DeviceUpgrade(signals, this.remoteConfig, this.remote, gsMap, appendUpgrade, failedToConvert);
            String msg = null;
            if (upgrade.protocol == null) {
                String source = sourceIsFile ? "the signals of the file" : "the Learned Signals";
                msg = "The appending of " + source + " to an existing device upgrade\nhas been aborted.";
            } else {
                appendUpgrade.protocol.setDeviceParms(upgrade.getParmValues());
                appendUpgrade.setParmValues(upgrade.getParmValues());
                for (Function fu : upgrade.getFunctions()) {
                    Iterator origName = fu.getName();
                    if (!usingBaseUpgrade) {
                        Function function = appendUpgrade.getFunction(fu.getHex());
                        if (function != null) {
                            existingFunctions.add((String)((Object)origName));
                            continue;
                        }
                        Function function2 = appendUpgrade.getFunction((String)((Object)origName));
                        if (function2 != null && function2.getHex() == null) {
                            function2.setHex(fu.getHex());
                            continue;
                        }
                        int i = 1;
                        String name = origName;
                        while (appendUpgrade.getFunction(name) != null) {
                            name = (String)((Object)origName) + "_" + i++;
                        }
                        if (i > 1) {
                            renamedFunctions.add((String)((Object)origName));
                            fu.setName(name);
                        }
                    }
                    fu.setUpgrade(appendUpgrade);
                    appendUpgrade.getFunctions().add(fu);
                    int n = Arrays.asList(upgrade.getAssignments().getAssignedFunctions()).indexOf(fu);
                    Remote.ButtonSplit split = new Remote.ButtonSplit(null, 0);
                    if (n > 0) {
                        split = this.remote.getButtonSplit(n);
                    }
                    Button b = split.base;
                    int btnState = split.state;
                    if (b != null && btnState == 0) {
                        if (appendUpgrade.getFunction(b, 0) == null) {
                            appendUpgrade.setFunction(b, fu, 0);
                            continue;
                        }
                        if (this.remote.getShiftEnabled() && b.allowsKeyMove(1) && appendUpgrade.getFunction(b, 1) == null) {
                            appendUpgrade.setFunction(b, fu, 1);
                            shiftedFunctions.add(origName);
                            continue;
                        }
                        unassignedFunctions.add((String)((Object)origName));
                        continue;
                    }
                    if (b == null || btnState != 1) continue;
                    if (appendUpgrade.getFunction(b, 1) == null) {
                        appendUpgrade.setFunction(b, fu, 1);
                        continue;
                    }
                    unassignedFunctions.add((String)((Object)origName));
                }
                String source = sourceIsFile ? " signals of the file" : " selected Learned Signals";
                msg = failedToConvert.isEmpty() ? "The " + signals.length + (String)source : "Of the " + signals.length + (String)source + ", " + (signals.length - failedToConvert.size());
                msg = usingBaseUpgrade ? msg + " have been imported as functions of this Device Upgrade" : msg + " were appended to existing\nDevice Upgrade (" + appendUpgrade.getDescription() + ") with protocol " + appendUpgrade.getProtocol().getName();
                msg = msg + ".\n";
                if (!existingFunctions.isEmpty()) {
                    msg = msg + "\nThe following functions were already present in the upgrade:\n   ";
                    boolean comma = false;
                    for (String string : existingFunctions) {
                        if (comma) {
                            msg = msg + ", " + string;
                            continue;
                        }
                        msg = msg + string;
                        comma = true;
                    }
                    msg = msg + "\n";
                }
                if (!renamedFunctions.isEmpty()) {
                    msg = msg + "The following Functions were renamed to prevent duplicates:\n   ";
                    boolean comma = false;
                    for (String string : renamedFunctions) {
                        if (comma) {
                            msg = msg + ", " + string;
                            continue;
                        }
                        msg = msg + string;
                        comma = true;
                    }
                    msg = msg + "\n";
                }
                if (!shiftedFunctions.isEmpty()) {
                    msg = msg + "\nThe following were assigned to shifted keys to prevent duplicates:\n   ";
                    boolean comma = false;
                    for (String string : shiftedFunctions) {
                        if (comma) {
                            msg = msg + ", " + string;
                            continue;
                        }
                        msg = msg + string;
                        comma = true;
                    }
                    msg = msg + "\n";
                }
                if (!unassignedFunctions.isEmpty()) {
                    msg = msg + "\nThe following could not be assigned to a key due to duplicates:\n   ";
                    boolean comma = false;
                    for (String string : unassignedFunctions) {
                        if (comma) {
                            msg = msg + ", " + string;
                            continue;
                        }
                        msg = msg + string;
                        comma = true;
                    }
                }
                if (this.remoteConfig != null) {
                    this.remoteConfig.getOwner().setChanged(true);
                }
                if (!this.suppressConfirmPrompts) {
                    String title = (sourceIsFile ? "File signals " : "Learned Signals ") + (usingBaseUpgrade ? "imported to Device Upgrade" : "appended to existing Device Upgrade");
                    JOptionPane.showMessageDialog(RemoteMaster.getFrame(), msg, title, -1);
                }
            }
            return appendUpgrade;
        }
        return upgrade;
    }

    private ExecutorData getConsistentProtocols(GeneralSignal[] signals) {
        if (signals == null || signals.length == 0) {
            return null;
        }
        final ExecutorData execData = new ExecutorData();
        for (GeneralSignal gs : signals) {
            LinkedHashMap<Protocol, Executor> map = this.getProtocolMap(gs);
            execData.map.put(gs, map);
            for (Protocol p : map.keySet()) {
                if (execData.protocols.contains(p)) continue;
                execData.protocols.add(p);
            }
        }
        ArrayList<List<String>> failedToConvert = new ArrayList<List<String>>();
        LinkedHashMap<GeneralSignal, Executor> gsMap = new LinkedHashMap<GeneralSignal, Executor>();
        ListIterator<Protocol> it = execData.protocols.listIterator();
        while (it.hasNext()) {
            Protocol p = (Protocol)it.next();
            failedToConvert.clear();
            gsMap.clear();
            for (GeneralSignal gs : signals) {
                if (gs.getError() != null) {
                    failedToConvert.add(Arrays.asList(gs.getSignalName(null), gs.getError()));
                }
                gsMap.put(gs, execData.map.get(gs).get(p));
            }
            new DeviceUpgrade(signals, null, null, gsMap, null, failedToConvert);
            int failureCount = failedToConvert.size();
            if (failureCount == signals.length) {
                it.remove();
                continue;
            }
            execData.failureCounts.put(p, failureCount);
        }
        Collections.sort(execData.protocols, new Comparator<Protocol>(){

            @Override
            public int compare(Protocol p1, Protocol p2) {
                int result = execData.failureCounts.get(p1).compareTo(execData.failureCounts.get(p2));
                if (result == 0) {
                    boolean needs1 = p1.needsCode(DeviceUpgradeConverter.this.remote);
                    boolean needs2 = p2.needsCode(DeviceUpgradeConverter.this.remote);
                    result = needs1 && !needs2 ? 1 : (needs2 && !needs1 ? -1 : 0);
                }
                return result;
            }
        });
        return execData;
    }

    private LinkedHashMap<Protocol, Executor> getProtocolMap(GeneralSignal gs) {
        IrpDatabase tmDatabase = LearnedSignal.getTmDatabase();
        LinkedHashMap<Protocol, Executor> pMap = new LinkedHashMap<Protocol, Executor>();
        if (tmDatabase == null || gs.getError() != null || gs.getDecodes() == null) {
            return pMap;
        }
        List<Protocol> protocols = ProtocolManager.getProtocolManager().getProtocolsForRemote(this.remote);
        for (LearnedSignalDecode lsd : gs.getDecodes()) {
            NamedProtocol np = lsd.decode.getNamedProtocol();
            List<Executor.ExecutorWrapper> wrappers = LearnedSignal.getExecutorWrappers(np);
            for (Executor.ExecutorWrapper wrapper : wrappers) {
                Protocol p;
                Executor e = LearnedSignalDecode.getExecutor(np, wrapper, null);
                if (e == null || (p = e.protocol) == null || !protocols.contains(p) || pMap.containsKey(p)) continue;
                pMap.put(p, e);
            }
        }
        return pMap;
    }

    private static void showMessage(String message, int msgType) {
        String title = "Conversion to Device Upgrade";
        JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, msgType);
    }

    public <E> JList<E> getJList(List<E> list, final LinkedHashMap<Protocol, Integer> map) {
        DefaultListModel<E> eModel = new DefaultListModel<E>();
        for (E item : list) {
            eModel.addElement(item);
        }
        JList<Object> eList = new JList<Object>(eModel);
        eList.setSelectedIndex(0);
        eList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String text = null;
                if (value instanceof Protocol) {
                    Protocol p = (Protocol)value;
                    String varName = p.getVariantName();
                    text = p.getName() + " (" + p.id.toString().replace(" ", "") + (varName == null || varName.isEmpty() ? "" : ":" + varName) + (p.needsCode(DeviceUpgradeConverter.this.remote) ? "*" : "") + ")";
                    int count = (Integer)map.get(p);
                    if (count > 0) {
                        text = text + ", fails on " + count;
                    }
                } else if (value instanceof DeviceUpgrade) {
                    DeviceUpgrade du = (DeviceUpgrade)value;
                    int setupInt = du.getSetupCode();
                    text = du.getDeviceTypeAliasName();
                    if (setupInt >= 0) {
                        text = text + "/" + new SetupCode(setupInt);
                    }
                } else {
                    text = value.toString();
                }
                return super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
            }
        });
        return eList;
    }

    private <E> JPanel getOptionPanel(String message, JList<?> optionList) {
        JPanel textPanel = new JPanel(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        JPanel protPanel = new JPanel(new BorderLayout());
        JTextArea txtArea = new JTextArea(message);
        txtArea.setFont(new JLabel().getFont());
        txtArea.setBackground(panel.getBackground());
        textPanel.add((Component)txtArea, "Center");
        textPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        protPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        protPanel.add(optionList, "Center");
        panel.add((Component)textPanel, "First");
        panel.add((Component)protPanel, "Center");
        return panel;
    }

    public void setBaseUpgrade(DeviceUpgrade baseUpgrade) {
        this.baseUpgrade = baseUpgrade;
    }

    public static Collection<Command> ictImporter(File file) {
        String error = null;
        try {
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = in.readLine().trim();
            if (!line.equals("irscope 0")) {
                String message = "This is not an IR Scope Capture Text file.";
                DeviceUpgradeConverter.showMessage(message, 0);
                in.close();
                return null;
            }
            Double frequency = null;
            int sampleCount = 0;
            int count = 0;
            String name = "<null>";
            ArrayList<Command> list = new ArrayList<Command>();
            ArrayList<Integer> durations = new ArrayList<Integer>();
            boolean noNotes = true;
            while ((line = in.readLine()) != null) {
                if (line.isEmpty()) continue;
                String origLine = line.trim();
                char first = (line = line.trim().toLowerCase()).charAt(0);
                if (first == '+' || first == '-' || Character.isDigit(first)) {
                    int comma = line.indexOf(44);
                    String numStr = comma < 0 ? line : line.substring(0, comma);
                    int val = Math.abs(Integer.parseInt(numStr.trim()));
                    durations.add(val);
                    if (++count == sampleCount) break;
                    if (!Boolean.parseBoolean(JP1Frame.getProperties().getProperty("ChopIctImports", "true")) || first != '-' || val <= 200000) continue;
                    Command cmd = DeviceUpgradeConverter.makeCommand(name, frequency, durations);
                    list.add(cmd);
                    name = "<null>";
                    durations.clear();
                    continue;
                }
                if (line.startsWith("carrier_frequency")) {
                    frequency = Integer.parseInt(line.substring(18));
                    continue;
                }
                if (line.startsWith("sample_count")) {
                    sampleCount = Integer.parseInt(line.substring(13));
                    continue;
                }
                if (!line.startsWith("note=")) continue;
                if (!durations.isEmpty()) {
                    Command cmd = DeviceUpgradeConverter.makeCommand(name, frequency, durations);
                    list.add(cmd);
                }
                name = origLine.substring(5);
                durations.clear();
                noNotes = false;
            }
            if (noNotes && !Boolean.parseBoolean(JP1Frame.getProperties().getProperty("SuppressConfirmPrompts", "false"))) {
                String msg = "IRScope allows you to attach a note to each signal.  These notes are used as\nfunction names on import to a Device Upgrade and also to separate the timing\ndata into separate signals.  This file has no notes so the separation has been\nmade by RMIR and signals numbered serially, preceded by an underscore.";
                DeviceUpgradeConverter.showMessage(msg, 2);
            }
            if (count < sampleCount) {
                error = "File ends prematurely.";
            } else if (!durations.isEmpty()) {
                Command cmd = DeviceUpgradeConverter.makeCommand(name, frequency, durations);
                list.add(cmd);
            }
            in.close();
            if (error == null) {
                return list;
            }
        }
        catch (IOException | NumberFormatException | InvalidArgumentException e) {
            error = "Error reading file.";
        }
        DeviceUpgradeConverter.showMessage(error, 0);
        return null;
    }

    private static Command makeCommand(String name, Double frequency, List<Integer> durations) throws InvalidArgumentException {
        int[] dur = new int[durations.size()];
        for (int i = 0; i < dur.length; ++i) {
            dur[i] = durations.get(i);
        }
        IrSignal signal = new IrSignal(dur, dur.length, 0, (double)frequency);
        return new Command(name, name, signal);
    }

    public static void importIctAsLearned(RMIRSetup RMIRSetup2) {
        try {
            RMIRSetup2.promptToSave();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        RMIRSetup2.getSaveAsAction().setEnabled(false);
        List<Remote> remotes = RemoteManager.getRemoteManager().findRemoteBySignature("200000");
        if (remotes.size() == 0) {
            return;
        }
        Remote remote = remotes.get(0);
        remote.load();
        RMIRSetup2.resetConfig(remote, null);
        File file = ExternalSignal.selectExternalFile(RemoteMaster.getFrame(), true);
        Collection<Command> commands = DeviceUpgradeConverter.ictImporter(file);
        ArrayList<LearnedSignal> learned = new ArrayList<LearnedSignal>();
        int keyCode = 1;
        for (Command command : commands) {
            LearnedSignal signal = null;
            try {
                signal = new LearnedSignal(keyCode++, command);
            }
            catch (IrCoreException | IrpException e) {
                continue;
            }
            learned.add(signal);
        }
        RemoteConfiguration config = RMIRSetup2.getRemoteConfiguration();
        config.setLearnedSignals(learned);
        config.updateImage();
        RMIRSetup2.setChanged(true);
        LearnedSignalPanel lsPanel = RMIRSetup2.getLearnedPanel();
        lsPanel.set(RMIRSetup2.getRemoteConfiguration());
        RMIRSetup2.getTabbedPane().setSelectedIndex(1);
    }

    private class ExecutorData {
        public List<Protocol> protocols = new ArrayList<Protocol>();
        public LinkedHashMap<GeneralSignal, LinkedHashMap<Protocol, Executor>> map = new LinkedHashMap();
        public LinkedHashMap<Protocol, Integer> failureCounts = new LinkedHashMap();

        private ExecutorData() {
        }
    }
}

