/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.Activity;
import com.hifiremote.jp1.Button;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceEditorPanel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeConverter;
import com.hifiremote.jp1.DeviceUpgradeExporter;
import com.hifiremote.jp1.DeviceUpgradePanel;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.ExternalSignal;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.GeneralFunction;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.ImportRawUpgradeDialog;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.JTableX;
import com.hifiremote.jp1.KeyMapMaster;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RMIRSetup;
import com.hifiremote.jp1.RMPanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.SetupCode;
import com.hifiremote.jp1.WrapLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DeviceUpgradeEditor
extends JFrame
implements ActionListener {
    private boolean cancelled = false;
    private DeviceEditorPanel editorPanel = null;
    private HashMap<Button, GeneralFunction> savedButtonGeneralFunctionMap = null;
    private JButton loadButton = new JButton("Open");
    private JButton importButton = new JButton("Import Raw");
    protected JButton saveAsButton = new JButton("Save as");
    protected JButton exportButton = new JButton("Export");
    protected JButton okButton = new JButton("OK");
    private JButton cancelButton = new JButton("Cancel");
    private RMIRSetup owner = null;
    private RMPanel panel = null;
    private WindowAdapter focusWindowAdapter = null;
    private Integer row = null;

    public DeviceUpgradeEditor(RMIRSetup owner, DeviceUpgrade deviceUpgrade, Collection<Remote> remotes, Integer row, RMPanel panel) {
        super("Device Upgrade Editor");
        this.owner = owner;
        this.row = row;
        this.panel = panel;
        deviceUpgrade.clearBackupReferences();
        HashMap<Button, GeneralFunction> map = null;
        if (deviceUpgrade.getButtonRestriction() != null && (map = deviceUpgrade.getButtonRestriction().getButtonGeneralFunctionMap()) != null) {
            this.savedButtonGeneralFunctionMap = new HashMap();
            for (Button b : map.keySet()) {
                GeneralFunction gf = new GeneralFunction();
                gf.name = map.get((Object)b).name;
                gf.icon = map.get((Object)b).icon;
                this.savedButtonGeneralFunctionMap.put(b, gf);
            }
        }
        this.focusWindowAdapter = new WindowAdapter(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                RMIRSetup rm = DeviceUpgradeEditor.this.owner;
                if (!rm.usesNonModalDeviceEditor()) {
                    DeviceUpgradeEditor.this.toFront();
                }
            }
        };
        Protocol p = deviceUpgrade.getProtocol();
        if (p != null) {
            Remote remote = deviceUpgrade.getRemote();
            String proc = remote.getProcessor().getEquivalentName();
            Hex pCode = p.getCode(remote);
            if (pCode != null && pCode.length() > 4 && (p.getFixedDataLength() != Protocol.getFixedDataLengthFromCode(proc, pCode) || p.getDefaultCmdLength() != Protocol.getCmdLengthFromCode(proc, pCode))) {
                String title = "Device Upgrade Editor";
                String message = "The code of the protocol for this device upgrade is not consistent\nwith the protocol default parameters, so the device upgrade cannot\nbe edited.  You need to edit the protocol code to correct this, before\nyou can edit the device upgrade";
                JOptionPane.showMessageDialog(this, message, title, 0);
                return;
            }
        }
        owner.addWindowFocusListener(this.focusWindowAdapter);
        this.addWindowStateListener(new WindowAdapter(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                boolean isIcon;
                RMIRSetup rm = DeviceUpgradeEditor.this.owner;
                boolean bl = isIcon = e.getNewState() == 1;
                if (!rm.usesNonModalDeviceEditor() && isIcon && rm.getState() != 1) {
                    rm.setState(1);
                    DeviceUpgradeEditor.this.toFront();
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DeviceUpgradeEditor.this.cancelButton.doClick();
                RMIRSetup rm = DeviceUpgradeEditor.this.owner;
                rm.removeWindowFocusListener(DeviceUpgradeEditor.this.focusWindowAdapter);
                rm.setNonModalWarning(false, DeviceUpgradeEditor.this);
                rm.setEnabled(true);
                rm.toFront();
            }
        });
        this.editorPanel = new DeviceEditorPanel(this, deviceUpgrade, remotes);
        this.add((Component)this.editorPanel, "Center");
        Box buttonBox = Box.createHorizontalBox();
        JPanel buttonPanelLeft = new JPanel(new WrapLayout(0));
        JPanel buttonPanelRight = new JPanel(new WrapLayout(2));
        this.add((Component)buttonBox, "South");
        buttonPanelLeft.add(this.loadButton);
        buttonPanelLeft.add(Box.createHorizontalStrut(5));
        buttonPanelLeft.add(this.importButton);
        buttonPanelLeft.add(Box.createHorizontalStrut(5));
        buttonPanelLeft.add(this.saveAsButton);
        buttonPanelLeft.add(Box.createHorizontalStrut(5));
        buttonPanelLeft.add(this.exportButton);
        buttonPanelRight.add(this.okButton);
        buttonPanelRight.add(Box.createHorizontalStrut(5));
        buttonPanelRight.add(this.cancelButton);
        buttonBox.add(buttonPanelLeft);
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(buttonPanelRight);
        this.loadButton.setToolTipText(JTableX.getHtmlToolTip("Open a (RM or KM) device upgrade file or<br/>import a Girr (.girr) or IRScope (.ict) file."));
        this.importButton.setToolTipText("Import a Raw (or IR-formatted) device upgrade from the clipboard.");
        this.saveAsButton.setToolTipText("Save the device upgrade to a file.");
        this.exportButton.setToolTipText("Export the device upgrade as a .girr or .ict file.");
        this.okButton.setToolTipText("Commit any changes and dismiss the dialog.");
        this.cancelButton.setToolTipText("Dismiss the dialog without commiting changes.");
        this.loadButton.addActionListener(this);
        this.importButton.addActionListener(this);
        this.saveAsButton.addActionListener(this);
        this.exportButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        String temp = JP1Frame.getProperties().getProperty("DUEditorBounds");
        if (temp != null) {
            Rectangle bounds = new Rectangle();
            StringTokenizer st = new StringTokenizer(temp, ",");
            bounds.x = Integer.parseInt(st.nextToken());
            bounds.y = Integer.parseInt(st.nextToken());
            bounds.width = Integer.parseInt(st.nextToken());
            bounds.height = Integer.parseInt(st.nextToken());
            this.setBounds(bounds);
        } else {
            Rectangle bounds = RemoteMaster.getFrame().getBounds();
            bounds.x += 10;
            bounds.y += 10;
            bounds.width -= 20;
            bounds.height -= 20;
            this.pack();
            this.setBounds(bounds);
        }
        if (p != null) {
            this.editorPanel.setAltPIDReason();
        }
        this.setLocationRelativeTo(owner);
        owner.setNonModalWarning(owner.usesNonModalDeviceEditor(), this);
        owner.setEnabled(owner.usesNonModalDeviceEditor());
        this.setVisible(true);
    }

    public DeviceUpgrade getDeviceUpgrade() {
        if (this.cancelled) {
            return null;
        }
        return this.editorPanel.getDeviceUpgrade();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.okButton || source == this.cancelButton) {
                int state = this.getExtendedState();
                if (state != 0) {
                    this.setExtendedState(0);
                }
                Rectangle bounds = this.getBounds();
                JP1Frame.getProperties().setProperty("DUEditorBounds", "" + bounds.x + ',' + bounds.y + ',' + bounds.width + ',' + bounds.height);
                DeviceUpgrade upgrade = this.editorPanel.getDeviceUpgrade();
                RemoteConfiguration remoteConfig = upgrade.getRemoteConfig();
                if (source == this.cancelButton) {
                    this.cancelled = true;
                    if (this.savedButtonGeneralFunctionMap != null) {
                        HashMap<Button, GeneralFunction> map = upgrade.getButtonRestriction().getButtonGeneralFunctionMap();
                        ArrayList notInSaved = new ArrayList();
                        for (Button b : map.keySet()) {
                            if (!this.savedButtonGeneralFunctionMap.containsKey(b)) {
                                notInSaved.add(b);
                                continue;
                            }
                            GeneralFunction gf = map.get(b);
                            gf.name = this.savedButtonGeneralFunctionMap.get((Object)b).name;
                            gf.icon = this.savedButtonGeneralFunctionMap.get((Object)b).icon;
                        }
                        Iterator<Button> iterator = notInSaved.iterator();
                        while (iterator.hasNext()) {
                            Button b;
                            b = iterator.next();
                            map.remove(b);
                        }
                    }
                    upgrade.doCancel(this.row == null);
                } else if (this.panel instanceof DeviceUpgradePanel && upgrade.getSetupCode() >= 0) {
                    this.editorPanel.commit();
                    DeviceUpgradePanel dup = (DeviceUpgradePanel)this.panel;
                    for (DeviceUpgrade du : remoteConfig.getDeviceUpgrades()) {
                        if (du == dup.getOldUpgrade()) continue;
                        DeviceType type = upgrade.getDeviceType();
                        int code = upgrade.getSetupCode();
                        if (du.getDeviceType() != type || du.getSetupCode() != code) continue;
                        String title = "Setup Code Conflict";
                        String message = "Setup code " + new SetupCode(code) + " has already been used in another upgrade for device type " + type.getName() + ".\nPlease change it to a unique value.";
                        JOptionPane.showMessageDialog(this, message, title, 0);
                        return;
                    }
                }
                Remote remote = remoteConfig.getRemote();
                if (!this.cancelled && remote.usesEZRC()) {
                    upgrade.classifyButtons();
                    DeviceButton db = null;
                    db = upgrade.getButtonRestriction();
                    if (db != null && db != DeviceButton.noButton) {
                        db.setConstructed(upgrade.getSetupCode() < 0);
                        if (!remoteConfig.getDeviceButtonList().contains(db)) {
                            remoteConfig.getDeviceButtonList().add(db);
                        }
                    }
                }
                this.owner.setNonModalWarning(false, this);
                this.setVisible(false);
                this.dispose();
                this.owner.setEnabled(true);
                this.owner.toFront();
                this.editorPanel.releasePanels();
                if (this.panel instanceof DeviceUpgradePanel) {
                    DeviceUpgradePanel dup = (DeviceUpgradePanel)this.panel;
                    if (!this.cancelled) {
                        Protocol pOrig = upgrade.originalProtocol;
                        ManualProtocol pConv = upgrade.convertedProtocol;
                        for (DeviceUpgrade du : remoteConfig.getDeviceUpgrades()) {
                            du.changeProtocol(pOrig, pConv);
                        }
                        if (pOrig != null && !(pOrig instanceof ManualProtocol)) {
                            pOrig.customCode.remove(remoteConfig.getRemote().getProcessor().getEquivalentName());
                        }
                        remoteConfig.getUpgradeKeyMoves().clear();
                    }
                    dup.endEdit(this, this.row);
                }
                if (!this.cancelled && remote.usesEZRC()) {
                    for (Activity a : remoteConfig.getActivities().values()) {
                        Activity.Assister.setFunctions(a.getAssists(), remote);
                    }
                }
            } else if (source == this.loadButton) {
                this.load();
            } else if (source == this.importButton) {
                this.importFromClipboard();
            } else if (source == this.saveAsButton) {
                this.save();
            } else if (source == this.exportButton) {
                DeviceUpgrade upgrade = this.editorPanel.getDeviceUpgrade();
                if (upgrade.getFunctionList().size() == 0) {
                    String message = "There are no functions in this upgrade, so export aborting.";
                    String title = "Export as Girr file";
                    JOptionPane.showMessageDialog(this, message, title, 0);
                    return;
                }
                DeviceUpgradeExporter exporter = new DeviceUpgradeExporter(upgrade);
                exporter.exportToFile();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void load() throws Exception {
        System.err.println("DeviceUpgradeEditor.load()");
        File dir = JP1Frame.getPreferences().getUpgradePath();
        File file = KeyMapMaster.getUpgradeFile(dir, this);
        if (RemoteMaster.hasEnding(file.getName(), new String[][]{RemoteMaster.upgradeImportEndings})) {
            DeviceUpgrade deviceUpgrade = this.editorPanel.getDeviceUpgrade();
            GeneralSignal[] signals = ExternalSignal.loadExternalFile(file, this);
            ProtocolManager.getProtocolManager().reset();
            deviceUpgrade.reset();
            if (signals != null) {
                Remote remote = deviceUpgrade.getRemote();
                DeviceUpgradeConverter converter = new DeviceUpgradeConverter(null, remote);
                deviceUpgrade.getFunctions().clear();
                converter.setBaseUpgrade(deviceUpgrade);
                DeviceUpgrade newUpgrade = converter.convertToDeviceUpgrade(signals, true);
                if (newUpgrade == null) {
                    System.err.println("Import from file " + file.getName() + " failed");
                    return;
                }
                String description = ExternalSignal.remote != null ? ExternalSignal.remote.getName() : "Import from IRScope file";
                String notes = "Imported from ";
                notes = notes + (ExternalSignal.remote != null ? "Girr file " : "IRScope file ");
                notes = notes + file.getAbsolutePath();
                newUpgrade.setDescription(description);
                newUpgrade.setNotes(notes);
            }
            this.editorPanel.refresh();
            return;
        }
        System.err.println("Opening " + file.getCanonicalPath() + ", last modified " + DateFormat.getInstance().format(new Date(file.lastModified())));
        DeviceUpgrade deviceUpgrade = this.editorPanel.getDeviceUpgrade();
        Remote remote = deviceUpgrade.getRemote();
        boolean btnInd = deviceUpgrade.getButtonIndependent();
        DeviceButton btnRes = deviceUpgrade.getButtonRestriction();
        DeviceUpgrade resUpg = btnRes != null && btnRes != DeviceButton.noButton ? btnRes.getUpgrade() : null;
        deviceUpgrade.reset();
        deviceUpgrade.load(file);
        JP1Frame.getPreferences().setUpgradePath(file.getParentFile());
        if (deviceUpgrade.getRemote() != remote) {
            deviceUpgrade.setRemote(remote);
        }
        deviceUpgrade.setButtonIndependent(btnInd);
        deviceUpgrade.setButtonRestriction(btnRes);
        if (btnRes != null && btnRes != DeviceButton.noButton) {
            btnRes.setUpgrade(resUpg);
            for (Function f : deviceUpgrade.getFunctions()) {
                for (GeneralFunction.User u : f.getUsers()) {
                    if (u.db != DeviceButton.noButton) continue;
                    u.db = btnRes;
                }
            }
        }
        this.editorPanel.refresh();
    }

    public void importFromClipboard() {
        DeviceUpgrade deviceUpgrade = this.editorPanel.getDeviceUpgrade();
        ImportRawUpgradeDialog dialog = new ImportRawUpgradeDialog(this, deviceUpgrade, true);
        dialog.setVisible(true);
        this.editorPanel.refresh();
    }

    public void save() throws IOException {
        System.err.println("DeviceUpgradeEditor.save()");
        DeviceUpgrade deviceUpgrade = this.editorPanel.getDeviceUpgrade();
        RMFileChooser chooser = new RMFileChooser();
        String[] endings = new String[]{".rmdu"};
        chooser.setFileFilter(new EndingFileFilter("RemoteMaster device upgrade files (*.rmdu)", endings));
        RMIRSetup rm = (RMIRSetup)SwingUtilities.getAncestorOfClass(RMIRSetup.class, this);
        File f = deviceUpgrade.getFile();
        if (f != null) {
            if (JP1Frame.getPreferences().getSeparateSaveFolder()) {
                chooser.setSelectedFile(new File(JP1Frame.getPreferences().getUpgradeSavePath(), f.getName()));
            } else {
                chooser.setSelectedFile(f);
            }
        } else {
            File path = JP1Frame.getPreferences().getUpgradeSavePath();
            if (path != null) {
                chooser.setCurrentDirectory(path);
            }
        }
        int returnVal = chooser.showSaveDialog(rm);
        if (returnVal == 0) {
            String name = chooser.getSelectedFile().getAbsolutePath();
            if (!name.toLowerCase().endsWith(".rmdu")) {
                name = name + ".rmdu";
            }
            File file = new File(name);
            JP1Frame.getPreferences().setUpgradeSavePath(file.getParentFile());
            int rc = 0;
            if (file.exists()) {
                rc = JOptionPane.showConfirmDialog(rm, file.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
            }
            if (rc == 0) {
                deviceUpgrade.store(file);
            }
        }
    }

    public DeviceEditorPanel getEditorPanel() {
        return this.editorPanel;
    }

    @Override
    public RMIRSetup getOwner() {
        return this.owner;
    }
}

