/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CmdParameter;
import com.hifiremote.jp1.DeviceParameter;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.EndingFileFilter;
import com.hifiremote.jp1.Executor;
import com.hifiremote.jp1.ExternalSignal;
import com.hifiremote.jp1.Function;
import com.hifiremote.jp1.JP1Frame;
import com.hifiremote.jp1.LearnedSignal;
import com.hifiremote.jp1.LearnedSignalDecode;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.RMEquation;
import com.hifiremote.jp1.RMFileChooser;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Value;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.antlr.v4.runtime.tree.ParseTree;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.CommandSet;
import org.harctoolbox.girr.GirrException;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.RemoteSet;
import org.harctoolbox.ircore.IrCoreException;
import org.harctoolbox.ircore.IrSignal;
import org.harctoolbox.irp.BitwiseParameter;
import org.harctoolbox.irp.Expression;
import org.harctoolbox.irp.InvalidNameException;
import org.harctoolbox.irp.IrpDatabase;
import org.harctoolbox.irp.IrpException;
import org.harctoolbox.irp.IrpInvalidArgumentException;
import org.harctoolbox.irp.NameEngine;
import org.harctoolbox.irp.NameUnassignedException;
import org.harctoolbox.irp.NamedProtocol;
import org.harctoolbox.irp.ParameterCollector;
import org.harctoolbox.irp.ParameterInconsistencyException;
import org.harctoolbox.irp.RecognizeData;
import org.harctoolbox.irp.UnknownProtocolException;
import org.harctoolbox.irp.UnsupportedRepeatException;
import org.harctoolbox.xml.XmlUtils;
import org.w3c.dom.Document;

public class DeviceUpgradeExporter {
    private static Comparator<NamedProtocolExport> npeSort = new Comparator<NamedProtocolExport>(){

        @Override
        public int compare(NamedProtocolExport npe1, NamedProtocolExport npe2) {
            String s1 = npe1.np.getName();
            String s2 = npe2.np.getName();
            boolean preferNpe1 = npe1.np.getPreferOverNames().contains(s2);
            boolean preferNpe2 = npe2.np.getPreferOverNames().contains(s1);
            return preferNpe1 && !preferNpe2 ? -1 : (preferNpe2 && !preferNpe1 ? 1 : 0);
        }
    };
    private static HashMap<Protocol, List<NamedProtocolExport>> exportMap = null;
    private DeviceUpgrade upgrade = null;
    private Value[] devParmValues = null;
    private Value[] cmdParmValues = null;
    private List<List<String>> failureMessages = null;
    private int failureCount = 0;
    private String message = null;
    private List<Integer> deviceParmsUsed = null;

    public DeviceUpgradeExporter(DeviceUpgrade upgrade) {
        this.upgrade = upgrade;
    }

    public static HashMap<Protocol, List<NamedProtocolExport>> getExecutorProtocolMap() {
        if (exportMap == null) {
            exportMap = new HashMap();
            IrpDatabase irpDb = LearnedSignal.getTmDatabase();
            List<String> names = irpDb.getNames();
            for (String name : names) {
                try {
                    NamedProtocol np = irpDb.getNamedProtocol(name);
                    if (!np.isDecodeable()) continue;
                    List<Executor.ExecutorWrapper> ewList = LearnedSignal.getExecutorWrappers(np);
                    for (Executor.ExecutorWrapper ew : ewList) {
                        List<String> cmdParms;
                        Executor exec = LearnedSignalDecode.getExecutor(np, ew, null);
                        if (exec == null) continue;
                        Protocol proc = exec.protocol;
                        if (!exportMap.containsKey(proc)) {
                            exportMap.put(proc, new ArrayList());
                        }
                        List<NamedProtocolExport> npeList = exportMap.get(proc);
                        List<String> devParms = exec.parms.devParms;
                        List<Integer> devIndices = exec.parms.devIndices;
                        if (devParms == null || devParms.isEmpty()) {
                            devParms = DeviceUpgradeExporter.getDefaultDevParms(proc);
                            devIndices = new ArrayList<Integer>();
                            for (int i = 0; i < devParms.size(); ++i) {
                                devIndices.add(i);
                            }
                        }
                        if ((cmdParms = exec.parms.cmdParms) == null || cmdParms.isEmpty()) {
                            cmdParms = DeviceUpgradeExporter.getDefaultCmdParms(proc);
                        }
                        NamedProtocolExport npe = new NamedProtocolExport(np, exec);
                        npe.paramStrings = new ArrayList<String>();
                        npe.paramStrings.addAll(devParms);
                        npe.paramStrings.addAll(cmdParms);
                        npe.paramIndices = new ArrayList<Integer>();
                        npe.paramIndices.addAll(devIndices);
                        for (int i = 0; i < cmdParms.size(); ++i) {
                            npe.paramIndices.add(100 + i);
                        }
                        npeList.add(npe);
                    }
                }
                catch (InvalidNameException | IrpInvalidArgumentException | NameUnassignedException | UnknownProtocolException | UnsupportedRepeatException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Protocol p : exportMap.keySet()) {
            try {
                Collections.sort(exportMap.get(p), npeSort);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Sorting error: Inconsistent preferOver entries for protocol " + p);
            }
        }
        return exportMap;
    }

    private static List<String> getDefaultDevParms(Protocol p) {
        int devPos = -1;
        int subPos = -1;
        String devMatch = LearnedSignalDecode.getMatchName("Device");
        String subMatch = LearnedSignalDecode.getMatchName("Subdevice");
        for (int i = 0; i < p.getDeviceParameters().length; ++i) {
            DeviceParameter dp = p.getDeviceParameters()[i];
            String parmMatch = LearnedSignalDecode.getMatchName(dp.getName());
            if (parmMatch.equals(devMatch)) {
                devPos = i;
                continue;
            }
            if (!parmMatch.equals(subMatch)) continue;
            subPos = i;
        }
        ArrayList<String> devParms = new ArrayList<String>();
        for (int i = 0; i <= Math.max(devPos, subPos); ++i) {
            devParms.add(i == devPos ? "D" : (i == subPos ? "S" : ""));
        }
        return devParms;
    }

    private static List<String> getDefaultCmdParms(Protocol p) {
        int fnPos = -1;
        String fnMatch = LearnedSignalDecode.getMatchName("OBC");
        for (int i = 0; i < p.getCommandParameters().length; ++i) {
            CmdParameter cp = p.getCommandParameters()[i];
            String parmMatch = LearnedSignalDecode.getMatchName(cp.getName());
            if (!parmMatch.equals(fnMatch)) continue;
            fnPos = i;
            break;
        }
        ArrayList<String> cmdParms = new ArrayList<String>();
        for (int i = 0; i <= fnPos; ++i) {
            cmdParms.add(i == fnPos ? "F" : "");
        }
        return cmdParms;
    }

    /*
     * Could not resolve type clashes
     */
    public RemoteSet getRemoteSet() {
        this.failureMessages = new ArrayList<List<String>>();
        this.failureCount = 0;
        this.deviceParmsUsed = new ArrayList<Integer>();
        Protocol prot = this.upgrade.getProtocol();
        if (prot == null) {
            this.message = "There is no executor in this upgrade, so nothing to export.";
            return null;
        }
        this.devParmValues = this.upgrade.getParmValues();
        LinkedHashMap<String, Command> commands = new LinkedHashMap<String, Command>();
        HashMap<Protocol, List<NamedProtocolExport>> epm = DeviceUpgradeExporter.getExecutorProtocolMap();
        List<NamedProtocolExport> npeList = epm.get(prot);
        if (npeList == null || npeList.isEmpty()) {
            this.message = "<html>This executor is not supported, as there are no uei-executor entries<br/>for it in irpProtocols.xml.</html>";
            return null;
        }
        this.upgrade.getProtocol().setDeviceParms(this.devParmValues);
        ArrayList<Integer> processed = null;
        for (Function f : this.upgrade.getFunctionList()) {
            ArrayList<String> functionMessages = new ArrayList<String>();
            this.setFunction(f);
            processed = new ArrayList<Integer>();
            boolean matched = false;
            for (NamedProtocolExport npe : npeList) {
                int i;
                processed.clear();
                if (!this.checkParmMatch(npe, processed)) {
                    String message = "Tried protocol " + npe.np.getName() + ", parameters do not match";
                    functionMessages.add(message);
                    continue;
                }
                Executor exec = npe.exec;
                List<String> outParams = npe.paramStrings;
                List<String> nameList = exec.nameList;
                if (!nameList.isEmpty()) {
                    int[] choice = new int[nameList.size()];
                    for (i = 0; i < nameList.size(); ++i) {
                        String sn = nameList.get(i);
                        int ndx = npe.paramStrings.indexOf("??" + sn);
                        if (ndx < 0) {
                            String message = "Selector ??" + sn + " missing in protocol " + npe.np.getName();
                            functionMessages.add(message);
                            System.err.println(f.getName() + ": " + message);
                            continue;
                        }
                        processed.add(ndx);
                        int fnVal = this.getParmValue(ndx, npe);
                        choice[i] = exec.selectorList.get(sn).indexOf(fnVal);
                    }
                    int selNdx = -1;
                    for (int i2 = 0; i2 < exec.choiceList.size(); ++i2) {
                        if (!Arrays.equals(exec.choiceList.get(i2), choice)) continue;
                        selNdx = i2;
                        break;
                    }
                    if (selNdx < 0) {
                        String message = "Unable to match selector values in choice list of protocol " + npe.np.getName();
                        functionMessages.add(message);
                        System.err.println(f.getName() + ": " + message);
                        continue;
                    }
                    ArrayList<String> newParamNames = new ArrayList<String>();
                    for (String pn : npe.paramStrings) {
                        newParamNames.add(exec.preprocess(pn, selNdx));
                    }
                    outParams = newParamNames;
                }
                RecognizeData rd = new RecognizeData();
                try {
                    Object parm3;
                    String message;
                    boolean changed = true;
                    while (changed) {
                        changed = false;
                        for (int i3 = 0; i3 < outParams.size(); ++i3) {
                            int fnVal;
                            BitwiseParameter bp;
                            String parm2 = outParams.get(i3);
                            if (processed.contains(i3)) continue;
                            if (parm2.isEmpty()) {
                                processed.add(i3);
                                continue;
                            }
                            RMEquation eq = new RMEquation(parm2 = RMEquation.removeParens(parm2), bp = new BitwiseParameter(fnVal = this.getParmValue(i3, npe).intValue()), rd);
                            if (!eq.solve()) continue;
                            processed.add(i3);
                            changed = true;
                        }
                    }
                    boolean solved = true;
                    for (int i4 = 0; i4 < outParams.size(); ++i4) {
                        if (processed.contains(i4)) continue;
                        String message2 = "Parameters in protocol " + npe.np.getName() + " could not all be processed";
                        functionMessages.add(message2);
                        solved = false;
                        break;
                    }
                    if (!solved) continue;
                    if (exec.qualifier != null) {
                        ArrayList<String> conditions = new ArrayList<String>();
                        String q = exec.qualifier;
                        int ndx = -1;
                        while ((ndx = q.indexOf("&&")) >= 0) {
                            conditions.add(q.substring(0, ndx).trim());
                            q = q.substring(ndx + 2).trim();
                        }
                        conditions.add(q.trim());
                        boolean valid = true;
                        for (int i5 = conditions.size() - 1; i5 >= 0; --i5) {
                            String condition = (String)conditions.get(i5);
                            Expression qExp = Expression.newExpression(RMEquation.removeParens(condition));
                            try {
                                long qVal = this.getValue(qExp, rd);
                                if (qVal != 0L) continue;
                                valid = false;
                            }
                            catch (NameUnassignedException e) {
                                ndx = -1;
                                ndx = condition.indexOf("==");
                                if (ndx < 0) continue;
                                RMEquation qrme = null;
                                String leftStr = condition.substring(0, ndx);
                                String rightStr = condition.substring(ndx + 2);
                                Expression leftExp = Expression.newExpression(leftStr);
                                Expression rightExp = Expression.newExpression(rightStr);
                                try {
                                    long lVal = this.getValue(leftExp, rd);
                                    qrme = new RMEquation(rightStr, new BitwiseParameter(lVal), rd);
                                }
                                catch (NameUnassignedException qle) {
                                    try {
                                        long rVal = this.getValue(rightExp, rd);
                                        qrme = new RMEquation(leftStr, new BitwiseParameter(rVal), rd);
                                    }
                                    catch (NameUnassignedException qre) {
                                        String message3 = "Unable to evaluate condition " + condition + " for protocol " + npe.np.getName();
                                        System.err.println(f.getName() + ": " + message3);
                                        functionMessages.add(message3);
                                        valid = false;
                                        break;
                                    }
                                }
                                if (qrme.solve()) continue;
                                valid = false;
                            }
                            break;
                        }
                        if (!valid) {
                            String message4 = "Conditions not satisfied for protocol " + npe.np.getName();
                            System.err.println(f.getName() + ": " + message4);
                            functionMessages.add(message4);
                            continue;
                        }
                    }
                    ArrayList<RMEquation.ProtoEquation> newParmsList = new ArrayList<RMEquation.ProtoEquation>();
                    List<List<String>> paramNames = DeviceUpgradeExporter.getParamNames(npe.np);
                    NameEngine engine = null;
                    if (exec.parms.newParms != null && !exec.parms.newParms.isEmpty()) {
                        boolean valid = true;
                        StringTokenizer st = new StringTokenizer(exec.parms.newParms, "{,}");
                        while (st.hasMoreTokens()) {
                            String s = st.nextToken();
                            int ndx = s.indexOf("=");
                            if (ndx < 0) continue;
                            RMEquation.ProtoEquation pe = new RMEquation.ProtoEquation(s.substring(0, ndx), s.substring(ndx + 1));
                            newParmsList.add(pe);
                        }
                        RMEquation.ProtoEquation pe = null;
                        for (int i6 = newParmsList.size() - 1; i6 >= 0; --i6) {
                            pe = (RMEquation.ProtoEquation)newParmsList.get(i6);
                            Expression exp = Expression.newExpression(pe.rightString);
                            if (rd.getParameterCollector().contains(pe.leftString)) {
                                if (!this.canEvaluate(exp, rd)) {
                                    RMEquation rme = new RMEquation(pe.rightString, rd.toBitwiseParameter(pe.leftString), rd);
                                    if (!rme.solve()) continue;
                                    if (rd.getParameterCollector().getValue(pe.leftString) != this.getValue(exp, rd).longValue()) {
                                        message = "Invalid solution to " + pe + " in protocol " + npe.np.getName();
                                        functionMessages.add(message);
                                        valid = false;
                                        break;
                                    }
                                }
                                rd.remove(pe.leftString);
                                continue;
                            }
                            if (!this.canEvaluate(exp, rd) || paramNames.size() != 2 || !paramNames.get(1).contains(pe.leftString)) continue;
                            rd.add(pe.leftString, exp.toBitwiseParameter(rd));
                        }
                        if (!valid) {
                            String message5 = "Invalid solution for equation " + pe + " in protocol " + npe.np.getName();
                            System.err.println(f.getName() + ": " + message5);
                            functionMessages.add(message5);
                            continue;
                        }
                    }
                    ArrayList undeterminedParams = new ArrayList();
                    undeterminedParams.addAll(DeviceUpgradeExporter.getParamNames(npe.np).get(0));
                    for (Object name : rd.getParameterCollector().getNames()) {
                        undeterminedParams.remove(name);
                    }
                    if (!undeterminedParams.isEmpty()) {
                        Object name;
                        String missing = "The following parameters are undetermined for protocol " + npe.np.getName() + ":";
                        name = undeterminedParams.iterator();
                        while (name.hasNext()) {
                            String s = (String)name.next();
                            missing = missing + s + ",";
                        }
                        missing = missing.substring(0, missing.length() - 1);
                        System.err.println(f.getName() + ": " + missing);
                        functionMessages.add(missing);
                        continue;
                    }
                    ParameterCollector pc = rd.getParameterCollector();
                    LinkedHashMap<String, Long> valueMap = new LinkedHashMap<String, Long>();
                    for (String name : paramNames.get(0)) {
                        valueMap.put(name, pc.getValue(name));
                    }
                    if (paramNames.size() == 2) {
                        for (String name : paramNames.get(1)) {
                            if (!pc.getNames().contains(name)) continue;
                            valueMap.put(name, pc.getValue(name));
                        }
                    }
                    ArrayList prevMaps = new ArrayList();
                    ArrayList maps = new ArrayList();
                    prevMaps.add(new HashMap(valueMap));
                    if (paramNames.size() == 2) {
                        for (Object parm3 : paramNames.get(1)) {
                            if (valueMap.containsKey(parm3)) continue;
                            for (HashMap map : prevMaps) {
                                for (long val = npe.np.getParameterMin((String)parm3); val <= npe.np.getParameterMax((String)parm3); ++val) {
                                    HashMap<Object, Long> newMap = new HashMap<Object, Long>(map);
                                    newMap.put(parm3, val);
                                    maps.add(newMap);
                                }
                            }
                            prevMaps = maps;
                            maps = new ArrayList();
                        }
                    }
                    maps = prevMaps;
                    int n = 0;
                    parm3 = maps.iterator();
                    while (parm3.hasNext()) {
                        Expression exp;
                        HashMap testMap = (HashMap)parm3.next();
                        engine = new NameEngine(testMap);
                        for (RMEquation.ProtoEquation pe : newParmsList) {
                            Expression exp2 = Expression.newExpression(pe.rightString);
                            long val = exp2.toLong(engine);
                            testMap.put(pe.leftString, val);
                            engine = new NameEngine(testMap);
                        }
                        if (npe.exec.qualifier != null && (exp = Expression.newExpression(npe.exec.qualifier)).toLong(engine) == 0L) {
                            ++n;
                            continue;
                        }
                        boolean valid = true;
                        for (int i7 = 0; i7 < outParams.size(); ++i7) {
                            int fnVal;
                            Expression exp3;
                            long evaluated;
                            String parm4 = outParams.get(i7);
                            if (parm4.isEmpty() || (evaluated = (exp3 = Expression.newExpression(parm4)).toLong(engine)) < 0L || (long)(fnVal = this.getParmValue(i7, npe).intValue()) == evaluated) continue;
                            valid = false;
                            break;
                        }
                        if (valid) break;
                        ++n;
                    }
                    if (n >= maps.size()) {
                        message = "Executor parameters do not match for protocol " + npe.np.getName();
                        functionMessages.add(message);
                        continue;
                    }
                    for (Map.Entry item : ((HashMap)valueMap).entrySet()) {
                        if ((Long)item.getValue() >= 0L) continue;
                        valueMap.remove(item.getKey());
                    }
                    Command command = new Command(f.getName(), f.getNotes(), npe.np.getName(), valueMap);
                    commands.put(f.getName(), command);
                }
                catch (GirrException | NameUnassignedException | ParameterInconsistencyException e) {
                    this.message = "Fatal error in Girr export";
                    return null;
                }
                matched = true;
                for (i = 0; i < outParams.size(); ++i) {
                    int upgradeIndex;
                    String parm = outParams.get(i);
                    if (parm.isEmpty() || (upgradeIndex = npe.paramIndices.get(i).intValue()) >= 100 || this.deviceParmsUsed.contains(upgradeIndex)) continue;
                    this.deviceParmsUsed.add(upgradeIndex);
                }
            }
            if (matched) continue;
            ++this.failureCount;
            for (String message : functionMessages) {
                this.failureMessages.add(Arrays.asList(f.getName(), message));
            }
        }
        Remote.MetaData metaData = new Remote.MetaData(this.upgrade.getDescription(), null, null, null, this.upgrade.getDeviceTypeAliasName(), null);
        HashMap<String, String> notes = new HashMap<String, String>(1);
        notes.put("en", this.upgrade.getNotes());
        LinkedHashMap<String, Map<String, String>> applicationParameters = new LinkedHashMap<String, Map<String, String>>(1);
        LinkedHashMap<String, String> jp1Parameters = new LinkedHashMap<String, String>(8);
        applicationParameters.put("jp1", jp1Parameters);
        jp1Parameters.put("SetupCode", String.format("%04d", this.upgrade.getSetupCode()));
        jp1Parameters.put("Remote.name", this.upgrade.getRemote().getName());
        jp1Parameters.put("Remote.signature", this.upgrade.getRemote().getSignature());
        Protocol p = this.upgrade.getProtocol();
        ProtocolManager.QualifiedID qid = new ProtocolManager.QualifiedID(p.getID(), p.getVariantName());
        jp1Parameters.put("Protocol", qid.toReference());
        jp1Parameters.put("Protocol.name", this.upgrade.getProtocol().getName());
        Remote remote = new Remote(metaData, null, notes, commands, applicationParameters);
        remote.setName(this.upgrade.getDescription() != null ? this.upgrade.getDescription() : "SetupCode_" + Integer.toString(this.upgrade.getSetupCode()));
        RemoteConfiguration config = null;
        File file = this.upgrade.getFile() != null ? this.upgrade.getFile() : ((config = this.upgrade.getRemoteConfig()) != null ? config.getOwner().file : null);
        String source = file != null ? file.getPath() : "RemoteMaster " + RemoteMaster.getDisplayVersion();
        RemoteSet remoteSet = new RemoteSet(System.getProperty("user.name"), source, new Date().toString(), RemoteMaster.class.getSimpleName(), RemoteMaster.getFullVersion(), null, null, null, remote);
        return remoteSet;
    }

    private Long getValue(Expression exp, RecognizeData rd) throws NameUnassignedException {
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        for (String name : rd.getParameterCollector().getNames()) {
            valueMap.put(name, rd.toBitwiseParameter(name).getValue());
        }
        return exp.toLong(new NameEngine(valueMap));
    }

    private boolean canEvaluate(Expression exp, RecognizeData rd) {
        ParseTree pt = exp != null ? exp.getParseTree() : null;
        BitwiseParameter bw = null;
        if (pt == null) {
            return true;
        }
        String[] children = new String[5];
        int childCount = pt.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            children[i] = RMEquation.removeParens(pt.getChild(i).getText());
        }
        if (pt.getChildCount() == 3) {
            String op = children[1];
            Expression exp0 = Expression.newExpression(children[0]);
            Expression exp2 = Expression.newExpression(children[2]);
            try {
                if (op.equals("&") && exp0.getParseTree() == null) {
                    bw = exp2.toBitwiseParameter(rd).restrict(this.getValue(exp0, rd));
                } else if (op.equals("&") && exp2.getParseTree() == null) {
                    bw = exp0.toBitwiseParameter(rd).restrict(this.getValue(exp2, rd));
                }
            }
            catch (NullPointerException | NameUnassignedException exception) {
                // empty catch block
            }
            if (bw != null) {
                return bw != null && bw.getBitmask() != 0L;
            }
            return this.canEvaluate(exp0, rd) && this.canEvaluate(exp2, rd);
        }
        if (pt.getChildCount() == 1) {
            bw = exp.toBitwiseParameter(rd);
            return bw != null && bw.getBitmask() != 0L;
        }
        if (pt.getChildCount() == 5) {
            if (children[1].equals("?") && children[3].equals(":")) {
                Expression exp0 = Expression.newExpression(children[0]);
                Expression exp2 = Expression.newExpression(children[2]);
                Expression exp4 = Expression.newExpression(children[4]);
                return this.canEvaluate(exp0, rd) && this.canEvaluate(exp2, rd) && this.canEvaluate(exp4, rd);
            }
        } else if (pt.getChildCount() == 2) {
            Expression exp1 = Expression.newExpression(children[1]);
            return this.canEvaluate(exp1, rd);
        }
        return false;
    }

    public void exportToFile() {
        RemoteSet rSet = this.getRemoteSet();
        if (rSet == null) {
            String title = "Upgrade export failure";
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), this.message, title, 0);
            return;
        }
        File file = DeviceUpgradeExporter.getFileToSave(false);
        if (file == null) {
            return;
        }
        int functionCount = this.upgrade.getFunctionList().size();
        int failureCount = this.getFailureCount();
        if (failureCount == functionCount) {
            String message = "Export aborting as no functions could be matched with protocols.";
            String title = "Upgrade export failure";
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 0);
            return;
        }
        if (failureCount > 0 && !this.displayErrors()) {
            return;
        }
        int dot = file.getName().lastIndexOf(".");
        String ending = file.getName().substring(dot);
        String type = null;
        if (ending.equals(RemoteMaster.girrEndings[0])) {
            DeviceUpgradeExporter.exportGirrFile(rSet, file);
            type = "Girr";
        } else if (ending.equals(RemoteMaster.ictEndings[0])) {
            DeviceUpgradeExporter.exportIctFile(rSet, file);
            type = "Ict";
        }
        String message = "<html>";
        message = message + (failureCount == 0 ? "All " : "" + (functionCount - failureCount) + " of ") + functionCount;
        message = message + " functions have been exported to the file<br/>" + file.getAbsolutePath();
        String title = "Export to " + type + " file";
        JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, -1);
    }

    public static void exportGirrFile(RemoteSet rSet, File file) {
        try {
            FileOutputStream ostr = new FileOutputStream(file, false);
            Document doc = rSet.toDocument("RemoteMaster Girr Export", false, true, true, true);
            XmlUtils.printDOM(ostr, doc, "UTF-8", null);
            ostr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void exportIctFile(RemoteSet rSet, File file) {
        try {
            IrpDatabase irpDatabase = LearnedSignal.getTmDatabase();
            Remote remote = rSet.getRemotes().toArray(new Remote[0])[0];
            ArrayList<String> data = new ArrayList<String>();
            int count = 0;
            boolean gotFrequency = false;
            Double frequency = null;
            for (CommandSet commandSet : remote) {
                for (Command cmd : commandSet) {
                    data.add("note=" + cmd.getName());
                    String protocolName = cmd.getProtocolName();
                    NamedProtocol np = irpDatabase.getNamedProtocol(protocolName);
                    NameEngine engine = new NameEngine(cmd.getParameters());
                    IrSignal signal = np.render(engine).toOneShot(3);
                    if (!gotFrequency) {
                        frequency = signal.getFrequency();
                        gotFrequency = true;
                    }
                    int[] durations = signal.getIntroInts();
                    int[] pulses = signal.getIntroPulses();
                    int size = durations.length;
                    if (durations[size - 1] > 500000) {
                        durations[size - 1] = 500000;
                    }
                    count += size;
                    for (int i = 0; i < size; i += 2) {
                        data.add("+" + durations[i] + "," + pulses[i]);
                        data.add("-" + durations[i + 1]);
                    }
                }
            }
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println("irscope 0");
            pw.println("carrier_frequency " + frequency.intValue());
            pw.println("sample_count " + count);
            for (String s : data) {
                pw.println(s);
            }
            pw.close();
        }
        catch (IOException | IrCoreException | IrpException e) {
            e.printStackTrace();
        }
    }

    public static File getFileToSave(boolean girrOnly) {
        RMFileChooser chooser = ExternalSignal.getExternalFileChooser(false, girrOnly, false);
        int returnVal = chooser.showSaveDialog(RemoteMaster.getFrame());
        if (returnVal != 0) {
            return null;
        }
        String ending = ((EndingFileFilter)chooser.getFileFilter()).getEndings()[0];
        String fileName = chooser.getSelectedFile().getAbsolutePath();
        if (!fileName.toLowerCase().endsWith(ending)) {
            fileName = fileName + ending;
        }
        File newFile = new File(fileName);
        int rc = 0;
        if (newFile.exists()) {
            rc = JOptionPane.showConfirmDialog(RemoteMaster.getFrame(), newFile.getName() + " already exists.  Do you want to replace it?", "Replace existing file?", 0);
        }
        if (rc != 0) {
            return null;
        }
        JP1Frame.getPreferences().setExternalFilePath(newFile.getParentFile());
        return newFile;
    }

    private boolean checkParmMatch(NamedProtocolExport npe, List<Integer> processed) {
        int n = -1;
        for (String pn : npe.paramStrings) {
            ++n;
            try {
                int npeVal = Integer.parseInt(pn);
                processed.add(n);
                int fnVal = this.getParmValue(n, npe);
                if (npeVal == fnVal) continue;
                return false;
            }
            catch (NumberFormatException e) {
            }
        }
        return true;
    }

    public static List<List<String>> getParamNames(NamedProtocol np) {
        ArrayList<List<String>> lists = new ArrayList<List<String>>();
        lists.add(new ArrayList());
        try {
            String irp = LearnedSignal.getTmDatabase().getIrp(np.getName());
            if (irp != null) {
                int start = irp.lastIndexOf("[");
                int end = irp.lastIndexOf("]");
                String defString = irp.substring(start + 1, end).replaceAll("\\s", "");
                StringTokenizer st = new StringTokenizer(defString, ",");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int ndx = -1;
                    int list = 0;
                    ndx = token.indexOf("@:");
                    if (ndx > 0) {
                        if (lists.size() == 1) {
                            lists.add(new ArrayList());
                        }
                        list = 1;
                    } else {
                        ndx = token.indexOf(":");
                    }
                    if (ndx < 0) continue;
                    lists.get(list).add(token.substring(0, ndx));
                }
            }
        }
        catch (UnknownProtocolException e) {
            return null;
        }
        return lists;
    }

    private Integer getParmValue(int ndx, NamedProtocolExport npe) {
        Value fnObj = (ndx = npe.paramIndices.get(ndx).intValue()) < 100 ? this.devParmValues[ndx] : this.cmdParmValues[ndx - 100];
        return (Integer)fnObj.getValue();
    }

    private void setFunction(Function f) {
        this.cmdParmValues = this.upgrade.getProtocol().getValues(f.getHex());
    }

    public List<List<String>> getFailureMessages() {
        return this.failureMessages;
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public boolean displayErrors() {
        int functionCount = this.upgrade.getFunctionList().size();
        String message = "<html>" + this.failureCount + " of " + functionCount + " functions could not be exported to the Girr file,<br/>due to the following errors:</html>";
        JPanel panel = Protocol.getErrorPanel(message, this.failureMessages);
        Object[] buttonText = new String[]{"Continue export", "Abort export"};
        int rc = JOptionPane.showOptionDialog(null, panel, "Girr Export Error", 0, 2, null, buttonText, buttonText[0]);
        return rc == 0;
    }

    public List<Integer> getDeviceParmsUsed() {
        return this.deviceParmsUsed;
    }

    public static List<String> getPersistentParameterNames(Protocol protocol) {
        NamedProtocol np;
        List<List<String>> paramNames;
        List<String> persistentParamNames = null;
        List<NamedProtocolExport> epm = DeviceUpgradeExporter.getExecutorProtocolMap().get(protocol);
        if (epm != null && epm.size() > 0 && (paramNames = DeviceUpgradeExporter.getParamNames(np = epm.get((int)0).np)).size() == 2) {
            persistentParamNames = paramNames.get(1);
        }
        return persistentParamNames;
    }

    public static void test() {
        HashMap<Protocol, List<NamedProtocolExport>> epm = DeviceUpgradeExporter.getExecutorProtocolMap();
        for (Protocol prot : epm.keySet()) {
            List<String> ppNames = DeviceUpgradeExporter.getPersistentParameterNames(prot);
            if (ppNames == null) continue;
            System.err.println();
            System.err.print(prot.name + ":");
            for (String ppName : ppNames) {
                System.err.print(" " + ppName);
            }
            System.err.println();
            for (NamedProtocolExport npe : epm.get(prot)) {
                System.err.println("  " + npe.np.getName() + ": " + npe.exec.wrapper.executorDescriptor);
            }
        }
        System.err.println();
    }

    public static class NamedProtocolExport {
        public NamedProtocol np = null;
        public Executor exec = null;
        public List<String> paramStrings = null;
        public List<Integer> paramIndices = null;

        public NamedProtocolExport(NamedProtocol np, Executor exec) {
            this.np = np;
            this.exec = exec;
        }
    }
}

