/*
 * Decompiled with CFR 0.152.
 */
package com.hifiremote.jp1;

import com.hifiremote.jp1.CodeSelectorDialog;
import com.hifiremote.jp1.DeviceButton;
import com.hifiremote.jp1.DeviceButtonTableModel;
import com.hifiremote.jp1.DeviceType;
import com.hifiremote.jp1.DeviceUpgrade;
import com.hifiremote.jp1.DeviceUpgradeConverter;
import com.hifiremote.jp1.DeviceUpgradeEditor;
import com.hifiremote.jp1.DeviceUpgradeExporter;
import com.hifiremote.jp1.DeviceUpgradeTableModel;
import com.hifiremote.jp1.ExternalSignal;
import com.hifiremote.jp1.GeneralSignal;
import com.hifiremote.jp1.Hex;
import com.hifiremote.jp1.KeyMove;
import com.hifiremote.jp1.KeyMovePanel;
import com.hifiremote.jp1.ManualProtocol;
import com.hifiremote.jp1.Processor;
import com.hifiremote.jp1.Protocol;
import com.hifiremote.jp1.ProtocolManager;
import com.hifiremote.jp1.ProtocolUpgrade;
import com.hifiremote.jp1.RMTablePanel;
import com.hifiremote.jp1.Remote;
import com.hifiremote.jp1.RemoteConfiguration;
import com.hifiremote.jp1.RemoteMaster;
import com.hifiremote.jp1.Segment;
import com.hifiremote.jp1.SetupCode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;

public class DeviceUpgradePanel
extends RMTablePanel<DeviceUpgrade> {
    private Integer rowOut = null;
    private Integer rowBound = null;
    private Integer rowNew = null;
    private Integer rowModel = null;
    private Boolean select = null;
    private DeviceUpgrade oldUpgrade = null;
    private DeviceUpgradeEditor editor = null;
    private RemoteConfiguration remoteConfig;
    private String processorName = null;
    private JTextPane upgradeBugPane = new JTextPane();

    public DeviceUpgradePanel() {
        super(new DeviceUpgradeTableModel());
        this.footerPanel.add((Component)this.upgradeBugPane, "First");
        Font font = this.upgradeBugPane.getFont();
        Font font2 = font.deriveFont(1, 12.0f);
        this.upgradeBugPane.setFont(font2);
        this.upgradeBugPane.setEditable(false);
        this.upgradeBugPane.setVisible(false);
        this.editProtocolItem.setVisible(true);
        this.editProtocolButton.setVisible(true);
        this.importButton.setVisible(true);
        this.importButton.setToolTipText("Import a .girr or .ict file as Device Upgrade functions");
        this.builtInButton.setVisible(true);
        this.builtInButton.setEnabled(false);
        this.builtInButton.setToolTipText("Import a built-in setup");
        this.builtInItem.setVisible(true);
        this.builtInItem.setToolTipText(this.builtInButton.getToolTipText());
        this.importItem.setVisible(true);
        this.importItem.setToolTipText(this.importButton.getToolTipText());
        this.exportButton.setVisible(true);
        this.exportButton.setToolTipText("Export a Device Upgrade as a .girr or .ict file");
        this.exportItem.setVisible(true);
        this.exportItem.setToolTipText(this.exportButton.getToolTipText());
    }

    @Override
    public void set(RemoteConfiguration remoteConfig) {
        ((DeviceUpgradeTableModel)this.model).set(remoteConfig);
        this.remoteConfig = remoteConfig;
        this.table.initColumns(this.model);
        Remote remote = remoteConfig.getRemote();
        remote.setExtract();
        if (remoteConfig.getNoSetup() != null) {
            remoteConfig.resetDeviceUpgrades();
        }
        this.builtInButton.setEnabled(remote.getExtract() != null && !remote.usesEZRC());
        this.builtInItem.setEnabled(remote.getExtract() != null && !remote.usesEZRC());
        if (remoteConfig != null && remoteConfig.getRemote().hasUpgradeBug()) {
            String bugText = "NOTE:  This remote contains a bug that prevents device upgrades from working if they use upgraded protocols.\nWorkaround:  Set up devices that use upgraded protocols as \"Device Button Restricted\"";
            this.upgradeBugPane.setBackground(Color.RED);
            this.upgradeBugPane.setForeground(Color.YELLOW);
            this.upgradeBugPane.setText(bugText);
            this.upgradeBugPane.setVisible(true);
        } else if (remoteConfig != null && !remoteConfig.getRemote().hasKeyMoveSupport()) {
            String bugText = "NOTE:  This remote does not support Key Moves, so any External Functions in a Device Upgrade will not work as they are implemented as Key Moves.";
            this.upgradeBugPane.setBackground(this.getBackground());
            this.upgradeBugPane.setForeground(Color.BLACK);
            this.upgradeBugPane.setText(bugText);
            this.upgradeBugPane.setVisible(true);
        } else {
            this.upgradeBugPane.setVisible(false);
        }
    }

    public int getRow(DeviceUpgrade upg) {
        int row = -1;
        if (this.remoteConfig != null) {
            row = this.remoteConfig.getDeviceUpgrades().indexOf(upg);
            row = this.sorter.viewIndex(row);
        }
        return row;
    }

    @Override
    public DeviceUpgrade createRowObject(DeviceUpgrade baseUpgrade) {
        return null;
    }

    public void createRowObjectA(DeviceUpgrade baseUpgrade) {
        String msg;
        System.err.println("DeviceUpgradePanel.createRowObject()");
        if (this.remoteConfig == null) {
            String msg2 = "Cannot create upgrade: No remote selected.";
            JOptionPane.showMessageDialog(RemoteMaster.getFrame(), msg2, "Upgrade error", 0);
            return;
        }
        Remote remote = this.remoteConfig.getRemote();
        DeviceButton defaultDev = null;
        DeviceUpgrade upgrade = null;
        if (this.rowOut == null && remote.hasDeviceDependentUpgrades() == 1) {
            for (DeviceButton db : remote.getDeviceButtons()) {
                if (db.getSegment() != null && db.getDeviceSlot(db.getSegment().getHex().getData()) != 65535) continue;
                String message = "The new upgrade being created will be assigned automatically\nto an unassigned device.  What name do you want to give to\nthis device?";
                String name = JOptionPane.showInputDialog(RemoteMaster.getFrame(), message, "New device");
                if (name == null) {
                    return;
                }
                defaultDev = db;
                if (db.getSegment() == null) {
                    db.setSegment(new Segment(0, 255, new Hex(15)));
                }
                defaultDev.setName(name);
                break;
            }
            if (defaultDev == null) {
                msg = "You already have the maximum number of assigned devices.  You\ncannot add a new upgrade as there is no device to which it can\nbe assigned.";
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), msg, "New device", 2);
                return;
            }
        }
        if (baseUpgrade == null) {
            upgrade = new DeviceUpgrade();
            upgrade.setRemote(remote);
            if (remote.hasDeviceDependentUpgrades() == 2) {
                defaultDev = DeviceButton.noButton;
                msg = "<html>This remote has device upgrades that are available on<br>all device buttons and ones that are only available on a<br>specified button.  The same upgrade can even be in both<br>categories.  This new upgrade will be created as being in<br>neither category.  After pressing OK, edit the new table<br>entry to set the availability as required.</html>";
                JOptionPane.showMessageDialog(RemoteMaster.getFrame(), msg, "Creating a new device upgrade", -1);
            }
        } else {
            upgrade = new DeviceUpgrade(baseUpgrade, defaultDev);
            this.processorName = this.remoteConfig.getRemote().getProcessor().getEquivalentName();
            Protocol baseProtocol = baseUpgrade.getProtocol();
            if (baseProtocol != null) {
                baseProtocol.oldCustomCode = baseProtocol.customCode.get(this.processorName);
                baseProtocol.newCustomCode = null;
            }
        }
        this.oldUpgrade = baseUpgrade;
        if (defaultDev != null) {
            if (upgrade.getSetupCode() < 0) {
                upgrade.setSetupCode(0);
            }
            if (defaultDev != DeviceButton.noButton) {
                defaultDev.setUpgrade(upgrade);
                upgrade.setButtonRestriction(defaultDev);
                upgrade.setButtonIndependent(false);
            }
        }
        ArrayList<Remote> remotes = new ArrayList<Remote>(1);
        remotes.add(this.remoteConfig.getRemote());
        upgrade.setRemoteConfig(this.remoteConfig);
        upgrade.setInternal(false);
        upgrade.setUsesSerial(false);
        this.editor = new DeviceUpgradeEditor(this.remoteConfig.getOwner(), upgrade, remotes, this.rowOut, this);
    }

    private DeviceUpgrade createRowObjectB(DeviceUpgradeEditor editor) {
        this.editor = null;
        Remote remote = this.remoteConfig.getRemote();
        DeviceUpgrade newUpgrade = editor.getDeviceUpgrade();
        if (remote.getSegmentTypes() != null && !remote.isSSD() && !remote.getSegmentTypes().contains(16) && !remote.getSegmentTypes().contains(15) && newUpgrade != null && newUpgrade.needsProtocolCode()) {
            newUpgrade.doCancel(this.rowOut == null);
            newUpgrade = null;
            String message = "This device upgrade needs a protocol upgrade and protocol upgrades\nare not supported by this remote, so unfortunately this edit is\nbeing cancelled.";
            String title = "Forced Cancellation of Edit";
            JOptionPane.showMessageDialog(null, message, title, 1);
        }
        if (this.remoteConfig.hasSegments() && newUpgrade != null && newUpgrade.getProtocol() != null) {
            Protocol p = newUpgrade.getProtocol();
            newUpgrade.setSizeCmdBytes(p.getDefaultCmdLength());
            newUpgrade.setSizeDevBytes(p.getFixedDataLength());
            newUpgrade.setSegmentFlags(255);
        }
        if (newUpgrade == null || this.oldUpgrade == null) {
            return newUpgrade;
        }
        int boundDeviceButtonIndex = this.remoteConfig.findBoundDeviceButtonIndex(this.oldUpgrade);
        this.rowBound = boundDeviceButtonIndex;
        if (this.rowBound == -1) {
            this.rowBound = null;
            return newUpgrade;
        }
        List<KeyMove> upgradeKeyMoves = newUpgrade.getKeyMoves();
        List<KeyMove> keyMoves = this.remoteConfig.getKeyMoves();
        block0: for (KeyMove upgradeKeyMove : upgradeKeyMoves) {
            ListIterator<KeyMove> li = keyMoves.listIterator();
            while (li.hasNext()) {
                KeyMove keyMove = li.next();
                if (keyMove.getDeviceButtonIndex() != boundDeviceButtonIndex || keyMove.getKeyCode() != upgradeKeyMove.getKeyCode()) continue;
                li.remove();
                System.err.println("Removed keyMove assigned to " + remote.getDeviceButtons()[boundDeviceButtonIndex] + ':' + remote.getButtonName(keyMove.getKeyCode()) + " since there is one assigned in the device upgrade");
                continue block0;
            }
        }
        return newUpgrade;
    }

    @Override
    public void editRowObject(int row) {
        this.rowOut = row;
        this.createRowObjectA((DeviceUpgrade)this.getRowObject(row));
    }

    @Override
    protected DeviceUpgrade newRowObject(DeviceUpgrade baseUpgrade, int row, int modelRow, boolean select) {
        this.rowOut = null;
        this.rowNew = row == -1 ? null : Integer.valueOf(row);
        this.rowModel = modelRow == -1 ? null : Integer.valueOf(modelRow);
        this.select = select;
        this.createRowObjectA(baseUpgrade);
        return null;
    }

    @Override
    public void editRowProtocol(int row) {
        DeviceUpgrade du = (DeviceUpgrade)this.model.getRow(row);
        Protocol p = du.getProtocol();
        Protocol result = p.editProtocol(this.remoteConfig.getRemote(), this);
        if (result != null) {
            if (p.getClass() == ManualProtocol.class) {
                p = result;
            }
            this.model.setValueAt(p, row, 5);
        }
    }

    public void endEdit(DeviceUpgradeEditor editor, Integer row) {
        DeviceUpgrade newUpgrade = this.createRowObjectB(editor);
        Remote remote = this.remoteConfig.getRemote();
        if (newUpgrade == null) {
            if (this.oldUpgrade != null && this.oldUpgrade.getProtocol() != null) {
                Protocol baseProtocol = this.oldUpgrade.getProtocol();
                if (baseProtocol.oldCustomCode == null) {
                    baseProtocol.customCode.remove(this.processorName);
                } else {
                    baseProtocol.customCode.put(this.processorName, baseProtocol.oldCustomCode);
                    this.remoteConfig.getProtocolUpgrades().remove(baseProtocol.newCustomCode);
                }
            }
            return;
        }
        if (remote.usesEZRC() && newUpgrade.getButtonRestriction() != DeviceButton.noButton) {
            newUpgrade.getButtonRestriction().setUpgrade(newUpgrade);
            this.remoteConfig.swapFunctions(newUpgrade);
        }
        newUpgrade.setSwapList(null);
        if (row != null) {
            KeyMovePanel kmp;
            this.model.setRow(this.sorter.modelIndex(row), newUpgrade);
            Protocol pOld = this.oldUpgrade.getProtocol();
            Protocol pNew = newUpgrade.getProtocol();
            if (pOld != null && pOld == pNew && pOld.newCustomCode != null && pOld.oldCustomCode != null && !pOld.newCustomCode.equals(pOld.oldCustomCode)) {
                ProtocolManager.getProtocolManager().remove(pOld.newCustomCode.getProtocol());
                this.remoteConfig.getProtocolUpgrades().remove(pOld.newCustomCode);
                pOld.saveCode(this.remoteConfig, pOld.oldCustomCode);
            }
            if (pOld != pNew) {
                ((DeviceUpgradeTableModel)this.getModel()).checkProtocolRemoval(this.oldUpgrade, false);
            }
            DeviceButtonTableModel deviceModel = this.remoteConfig.getOwner().getGeneralPanel().getDeviceButtonTableModel();
            if (this.rowBound != null) {
                deviceModel.setValueAt(newUpgrade.getDeviceType(), this.rowBound, 2);
                deviceModel.setValueAt(new SetupCode(newUpgrade.getSetupCode()), this.rowBound, 3);
                deviceModel.fireTableDataChanged();
            }
            if ((kmp = this.remoteConfig.getOwner().getKeyMovePanel()) != null) {
                kmp.endEditUpgrade();
            }
        } else {
            int dbi = 0;
            DeviceButton devButton = null;
            dbi = this.remoteConfig.findBoundDeviceButtonIndex(newUpgrade);
            if (dbi == -1 || remote.hasDeviceDependentUpgrades() == 1) {
                if (dbi == -1) {
                    Object[] devButtons = remote.getDeviceButtons();
                    devButton = (DeviceButton)JOptionPane.showInputDialog(RemoteMaster.getFrame(), "The device upgrade \"" + newUpgrade.toString() + "\" is not assigned to a device button.\nDo you want to assign it now?\nTo do so, select the desired device button and press OK.\nOtherwise please press Cancel.\n", "Unassigned Device Upgrade", 3, null, devButtons, null);
                } else {
                    devButton = newUpgrade.getButtonRestriction();
                }
                if (devButton == null && remote.usesEZRC()) {
                    newUpgrade.doCancel(true);
                    return;
                }
            }
            Processor processor = remote.getProcessor();
            Protocol p = newUpgrade.getProtocol();
            ProtocolUpgrade pu = p.getCustomUpgrade(this.remoteConfig, true);
            if (p.getCustomCode(processor) == null && pu != null && p.matched() && !p.getCode(remote).equals(pu.getCode())) {
                p.addCustomCode(processor, pu.getCode());
                if (this.remoteConfig.getProtocolUpgrades().contains(pu)) {
                    this.remoteConfig.getProtocolUpgrades().remove(pu);
                    ProtocolManager.getProtocolManager().remove(pu.getManualProtocol(remote));
                }
            }
            if (this.rowNew == null) {
                this.model.addRow(newUpgrade);
                row = this.model.getRowCount();
            } else {
                this.model.insertRow(this.rowModel, newUpgrade);
            }
            if (devButton != null) {
                DeviceType devType = remote.getDeviceTypeByAliasName(newUpgrade.getDeviceTypeAliasName());
                SetupCode setupCode = new SetupCode(newUpgrade.getSetupCode());
                boolean valid = true;
                if (!remote.usesEZRC()) {
                    DeviceButtonTableModel dum = this.remoteConfig.getOwner().getGeneralPanel().getDeviceButtonTableModel();
                    int dbRow = Arrays.asList(remote.getDeviceButtons()).indexOf(devButton);
                    valid = dum.isValidDevice(dbRow, devType, setupCode);
                }
                if (valid) {
                    short[] data = this.remoteConfig.getData();
                    if (this.remoteConfig.hasSegments()) {
                        data = devButton.getSegment().getHex().getData();
                    }
                    devButton.setSetupCode((short)newUpgrade.getSetupCode(), data);
                    devButton.setDeviceTypeIndex((short)devType.getNumber(), data);
                    devButton.setDeviceGroup((short)devType.getGroup(), data);
                    if (remote.hasDeviceDependentUpgrades() == 2) {
                        String message = "Remember to set the button-dependent and/or button-independent\n settings in a manner consistent with your choice of button\n assignment.";
                        String title = "Creating a new device upgrade";
                        JOptionPane.showMessageDialog(RemoteMaster.getFrame(), message, title, 1);
                    }
                    this.remoteConfig.getOwner().getGeneralPanel().getDeviceButtonTableModel().propertyChangeSupport.firePropertyChange("value", null, null);
                }
            }
            if (this.select.booleanValue()) {
                this.table.setRowSelectionInterval(this.rowNew, this.rowNew);
            }
        }
        ProtocolUpgrade puUsed = null;
        for (ProtocolUpgrade pu : this.remoteConfig.getProtocolUpgrades()) {
            if (pu.getProtocol() != newUpgrade.getProtocol()) continue;
            puUsed = pu;
            break;
        }
        if (puUsed != null) {
            this.remoteConfig.getProtocolUpgrades().remove(puUsed);
        }
    }

    @Override
    public void importFromFile() {
        File file = ExternalSignal.selectExternalFile(this, false);
        GeneralSignal[] esa = ExternalSignal.loadExternalFile(file, this);
        if (esa != null) {
            DeviceUpgradeConverter converter = new DeviceUpgradeConverter(this.remoteConfig, null);
            DeviceUpgrade upgrade = converter.convertToDeviceUpgrade(esa, true);
            if (upgrade == null) {
                System.err.println("Import from file " + file.getName() + " failed");
                return;
            }
            String description = ExternalSignal.remote != null ? ExternalSignal.remote.getName() : "Import from IRScope file";
            String notes = "Imported from ";
            notes = notes + (ExternalSignal.remote != null ? "Girr file " : "IRScope file ");
            notes = notes + file.getAbsolutePath();
            upgrade.setDescription(description);
            upgrade.setNotes(notes);
            this.repaint();
        }
    }

    @Override
    public void importBuiltIn() {
        this.remoteConfig.getRemote().setExtractSetupCodes(null);
        CodeSelectorDialog.showDialog(this.remoteConfig.getOwner(), true);
    }

    @Override
    public void exportToFile(DeviceUpgrade devUpg) {
        DeviceUpgradeExporter exporter = new DeviceUpgradeExporter(devUpg);
        exporter.exportToFile();
    }

    public DeviceUpgradeEditor getDeviceUpgradeEditor() {
        return this.editor;
    }

    public RemoteConfiguration getRemoteConfig() {
        return this.remoteConfig;
    }

    public DeviceUpgrade getOldUpgrade() {
        return this.oldUpgrade;
    }
}

